/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetSchemaAnalysisRuleRequest extends CleanRoomsRequest implements
        ToCopyableBuilder<BatchGetSchemaAnalysisRuleRequest.Builder, BatchGetSchemaAnalysisRuleRequest> {
    private static final SdkField<String> COLLABORATION_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("collaborationIdentifier").getter(getter(BatchGetSchemaAnalysisRuleRequest::collaborationIdentifier))
            .setter(setter(Builder::collaborationIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("collaborationIdentifier").build())
            .build();

    private static final SdkField<List<SchemaAnalysisRuleRequest>> SCHEMA_ANALYSIS_RULE_REQUESTS_FIELD = SdkField
            .<List<SchemaAnalysisRuleRequest>> builder(MarshallingType.LIST)
            .memberName("schemaAnalysisRuleRequests")
            .getter(getter(BatchGetSchemaAnalysisRuleRequest::schemaAnalysisRuleRequests))
            .setter(setter(Builder::schemaAnalysisRuleRequests))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schemaAnalysisRuleRequests").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SchemaAnalysisRuleRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(SchemaAnalysisRuleRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            COLLABORATION_IDENTIFIER_FIELD, SCHEMA_ANALYSIS_RULE_REQUESTS_FIELD));

    private final String collaborationIdentifier;

    private final List<SchemaAnalysisRuleRequest> schemaAnalysisRuleRequests;

    private BatchGetSchemaAnalysisRuleRequest(BuilderImpl builder) {
        super(builder);
        this.collaborationIdentifier = builder.collaborationIdentifier;
        this.schemaAnalysisRuleRequests = builder.schemaAnalysisRuleRequests;
    }

    /**
     * <p>
     * The unique identifier of the collaboration that contains the schema analysis rule.
     * </p>
     * 
     * @return The unique identifier of the collaboration that contains the schema analysis rule.
     */
    public final String collaborationIdentifier() {
        return collaborationIdentifier;
    }

    /**
     * For responses, this returns true if the service returned a value for the SchemaAnalysisRuleRequests property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSchemaAnalysisRuleRequests() {
        return schemaAnalysisRuleRequests != null && !(schemaAnalysisRuleRequests instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The information that's necessary to retrieve a schema analysis rule.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSchemaAnalysisRuleRequests} method.
     * </p>
     * 
     * @return The information that's necessary to retrieve a schema analysis rule.
     */
    public final List<SchemaAnalysisRuleRequest> schemaAnalysisRuleRequests() {
        return schemaAnalysisRuleRequests;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(collaborationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(hasSchemaAnalysisRuleRequests() ? schemaAnalysisRuleRequests() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetSchemaAnalysisRuleRequest)) {
            return false;
        }
        BatchGetSchemaAnalysisRuleRequest other = (BatchGetSchemaAnalysisRuleRequest) obj;
        return Objects.equals(collaborationIdentifier(), other.collaborationIdentifier())
                && hasSchemaAnalysisRuleRequests() == other.hasSchemaAnalysisRuleRequests()
                && Objects.equals(schemaAnalysisRuleRequests(), other.schemaAnalysisRuleRequests());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetSchemaAnalysisRuleRequest").add("CollaborationIdentifier", collaborationIdentifier())
                .add("SchemaAnalysisRuleRequests", hasSchemaAnalysisRuleRequests() ? schemaAnalysisRuleRequests() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "collaborationIdentifier":
            return Optional.ofNullable(clazz.cast(collaborationIdentifier()));
        case "schemaAnalysisRuleRequests":
            return Optional.ofNullable(clazz.cast(schemaAnalysisRuleRequests()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetSchemaAnalysisRuleRequest, T> g) {
        return obj -> g.apply((BatchGetSchemaAnalysisRuleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CleanRoomsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchGetSchemaAnalysisRuleRequest> {
        /**
         * <p>
         * The unique identifier of the collaboration that contains the schema analysis rule.
         * </p>
         * 
         * @param collaborationIdentifier
         *        The unique identifier of the collaboration that contains the schema analysis rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaborationIdentifier(String collaborationIdentifier);

        /**
         * <p>
         * The information that's necessary to retrieve a schema analysis rule.
         * </p>
         * 
         * @param schemaAnalysisRuleRequests
         *        The information that's necessary to retrieve a schema analysis rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaAnalysisRuleRequests(Collection<SchemaAnalysisRuleRequest> schemaAnalysisRuleRequests);

        /**
         * <p>
         * The information that's necessary to retrieve a schema analysis rule.
         * </p>
         * 
         * @param schemaAnalysisRuleRequests
         *        The information that's necessary to retrieve a schema analysis rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaAnalysisRuleRequests(SchemaAnalysisRuleRequest... schemaAnalysisRuleRequests);

        /**
         * <p>
         * The information that's necessary to retrieve a schema analysis rule.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cleanrooms.model.SchemaAnalysisRuleRequest.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.cleanrooms.model.SchemaAnalysisRuleRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cleanrooms.model.SchemaAnalysisRuleRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #schemaAnalysisRuleRequests(List<SchemaAnalysisRuleRequest>)}.
         * 
         * @param schemaAnalysisRuleRequests
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cleanrooms.model.SchemaAnalysisRuleRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schemaAnalysisRuleRequests(java.util.Collection<SchemaAnalysisRuleRequest>)
         */
        Builder schemaAnalysisRuleRequests(Consumer<SchemaAnalysisRuleRequest.Builder>... schemaAnalysisRuleRequests);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CleanRoomsRequest.BuilderImpl implements Builder {
        private String collaborationIdentifier;

        private List<SchemaAnalysisRuleRequest> schemaAnalysisRuleRequests = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetSchemaAnalysisRuleRequest model) {
            super(model);
            collaborationIdentifier(model.collaborationIdentifier);
            schemaAnalysisRuleRequests(model.schemaAnalysisRuleRequests);
        }

        public final String getCollaborationIdentifier() {
            return collaborationIdentifier;
        }

        public final void setCollaborationIdentifier(String collaborationIdentifier) {
            this.collaborationIdentifier = collaborationIdentifier;
        }

        @Override
        public final Builder collaborationIdentifier(String collaborationIdentifier) {
            this.collaborationIdentifier = collaborationIdentifier;
            return this;
        }

        public final List<SchemaAnalysisRuleRequest.Builder> getSchemaAnalysisRuleRequests() {
            List<SchemaAnalysisRuleRequest.Builder> result = SchemaAnalysisRuleRequestListCopier
                    .copyToBuilder(this.schemaAnalysisRuleRequests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSchemaAnalysisRuleRequests(
                Collection<SchemaAnalysisRuleRequest.BuilderImpl> schemaAnalysisRuleRequests) {
            this.schemaAnalysisRuleRequests = SchemaAnalysisRuleRequestListCopier.copyFromBuilder(schemaAnalysisRuleRequests);
        }

        @Override
        public final Builder schemaAnalysisRuleRequests(Collection<SchemaAnalysisRuleRequest> schemaAnalysisRuleRequests) {
            this.schemaAnalysisRuleRequests = SchemaAnalysisRuleRequestListCopier.copy(schemaAnalysisRuleRequests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schemaAnalysisRuleRequests(SchemaAnalysisRuleRequest... schemaAnalysisRuleRequests) {
            schemaAnalysisRuleRequests(Arrays.asList(schemaAnalysisRuleRequests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schemaAnalysisRuleRequests(Consumer<SchemaAnalysisRuleRequest.Builder>... schemaAnalysisRuleRequests) {
            schemaAnalysisRuleRequests(Stream.of(schemaAnalysisRuleRequests)
                    .map(c -> SchemaAnalysisRuleRequest.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetSchemaAnalysisRuleRequest build() {
            return new BatchGetSchemaAnalysisRuleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
