/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the number of aggregation functions that the member who can query can run given the epsilon and
 * noise parameters.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DifferentialPrivacyPrivacyImpact implements SdkPojo, Serializable,
        ToCopyableBuilder<DifferentialPrivacyPrivacyImpact.Builder, DifferentialPrivacyPrivacyImpact> {
    private static final SdkField<List<DifferentialPrivacyPreviewAggregation>> AGGREGATIONS_FIELD = SdkField
            .<List<DifferentialPrivacyPreviewAggregation>> builder(MarshallingType.LIST)
            .memberName("aggregations")
            .getter(getter(DifferentialPrivacyPrivacyImpact::aggregations))
            .setter(setter(Builder::aggregations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DifferentialPrivacyPreviewAggregation> builder(MarshallingType.SDK_POJO)
                                            .constructor(DifferentialPrivacyPreviewAggregation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGGREGATIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<DifferentialPrivacyPreviewAggregation> aggregations;

    private DifferentialPrivacyPrivacyImpact(BuilderImpl builder) {
        this.aggregations = builder.aggregations;
    }

    /**
     * For responses, this returns true if the service returned a value for the Aggregations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAggregations() {
        return aggregations != null && !(aggregations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The number of aggregation functions that you can perform.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAggregations} method.
     * </p>
     * 
     * @return The number of aggregation functions that you can perform.
     */
    public final List<DifferentialPrivacyPreviewAggregation> aggregations() {
        return aggregations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAggregations() ? aggregations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DifferentialPrivacyPrivacyImpact)) {
            return false;
        }
        DifferentialPrivacyPrivacyImpact other = (DifferentialPrivacyPrivacyImpact) obj;
        return hasAggregations() == other.hasAggregations() && Objects.equals(aggregations(), other.aggregations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DifferentialPrivacyPrivacyImpact")
                .add("Aggregations", hasAggregations() ? aggregations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "aggregations":
            return Optional.ofNullable(clazz.cast(aggregations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DifferentialPrivacyPrivacyImpact, T> g) {
        return obj -> g.apply((DifferentialPrivacyPrivacyImpact) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DifferentialPrivacyPrivacyImpact> {
        /**
         * <p>
         * The number of aggregation functions that you can perform.
         * </p>
         * 
         * @param aggregations
         *        The number of aggregation functions that you can perform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregations(Collection<DifferentialPrivacyPreviewAggregation> aggregations);

        /**
         * <p>
         * The number of aggregation functions that you can perform.
         * </p>
         * 
         * @param aggregations
         *        The number of aggregation functions that you can perform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregations(DifferentialPrivacyPreviewAggregation... aggregations);

        /**
         * <p>
         * The number of aggregation functions that you can perform.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cleanrooms.model.DifferentialPrivacyPreviewAggregation.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.cleanrooms.model.DifferentialPrivacyPreviewAggregation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cleanrooms.model.DifferentialPrivacyPreviewAggregation.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #aggregations(List<DifferentialPrivacyPreviewAggregation>)}.
         * 
         * @param aggregations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cleanrooms.model.DifferentialPrivacyPreviewAggregation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aggregations(java.util.Collection<DifferentialPrivacyPreviewAggregation>)
         */
        Builder aggregations(Consumer<DifferentialPrivacyPreviewAggregation.Builder>... aggregations);
    }

    static final class BuilderImpl implements Builder {
        private List<DifferentialPrivacyPreviewAggregation> aggregations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DifferentialPrivacyPrivacyImpact model) {
            aggregations(model.aggregations);
        }

        public final List<DifferentialPrivacyPreviewAggregation.Builder> getAggregations() {
            List<DifferentialPrivacyPreviewAggregation.Builder> result = DifferentialPrivacyPreviewAggregationListCopier
                    .copyToBuilder(this.aggregations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAggregations(Collection<DifferentialPrivacyPreviewAggregation.BuilderImpl> aggregations) {
            this.aggregations = DifferentialPrivacyPreviewAggregationListCopier.copyFromBuilder(aggregations);
        }

        @Override
        public final Builder aggregations(Collection<DifferentialPrivacyPreviewAggregation> aggregations) {
            this.aggregations = DifferentialPrivacyPreviewAggregationListCopier.copy(aggregations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregations(DifferentialPrivacyPreviewAggregation... aggregations) {
            aggregations(Arrays.asList(aggregations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregations(Consumer<DifferentialPrivacyPreviewAggregation.Builder>... aggregations) {
            aggregations(Stream.of(aggregations)
                    .map(c -> DifferentialPrivacyPreviewAggregation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DifferentialPrivacyPrivacyImpact build() {
            return new DifferentialPrivacyPrivacyImpact(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
