/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCollaborationAnalysisTemplateResponse extends CleanRoomsResponse implements
        ToCopyableBuilder<GetCollaborationAnalysisTemplateResponse.Builder, GetCollaborationAnalysisTemplateResponse> {
    private static final SdkField<CollaborationAnalysisTemplate> COLLABORATION_ANALYSIS_TEMPLATE_FIELD = SdkField
            .<CollaborationAnalysisTemplate> builder(MarshallingType.SDK_POJO)
            .memberName("collaborationAnalysisTemplate")
            .getter(getter(GetCollaborationAnalysisTemplateResponse::collaborationAnalysisTemplate))
            .setter(setter(Builder::collaborationAnalysisTemplate))
            .constructor(CollaborationAnalysisTemplate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationAnalysisTemplate")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(COLLABORATION_ANALYSIS_TEMPLATE_FIELD));

    private final CollaborationAnalysisTemplate collaborationAnalysisTemplate;

    private GetCollaborationAnalysisTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.collaborationAnalysisTemplate = builder.collaborationAnalysisTemplate;
    }

    /**
     * <p>
     * The analysis template within a collaboration.
     * </p>
     * 
     * @return The analysis template within a collaboration.
     */
    public final CollaborationAnalysisTemplate collaborationAnalysisTemplate() {
        return collaborationAnalysisTemplate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(collaborationAnalysisTemplate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCollaborationAnalysisTemplateResponse)) {
            return false;
        }
        GetCollaborationAnalysisTemplateResponse other = (GetCollaborationAnalysisTemplateResponse) obj;
        return Objects.equals(collaborationAnalysisTemplate(), other.collaborationAnalysisTemplate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCollaborationAnalysisTemplateResponse")
                .add("CollaborationAnalysisTemplate", collaborationAnalysisTemplate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "collaborationAnalysisTemplate":
            return Optional.ofNullable(clazz.cast(collaborationAnalysisTemplate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetCollaborationAnalysisTemplateResponse, T> g) {
        return obj -> g.apply((GetCollaborationAnalysisTemplateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CleanRoomsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetCollaborationAnalysisTemplateResponse> {
        /**
         * <p>
         * The analysis template within a collaboration.
         * </p>
         * 
         * @param collaborationAnalysisTemplate
         *        The analysis template within a collaboration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaborationAnalysisTemplate(CollaborationAnalysisTemplate collaborationAnalysisTemplate);

        /**
         * <p>
         * The analysis template within a collaboration.
         * </p>
         * This is a convenience method that creates an instance of the {@link CollaborationAnalysisTemplate.Builder}
         * avoiding the need to create one manually via {@link CollaborationAnalysisTemplate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CollaborationAnalysisTemplate.Builder#build()} is called
         * immediately and its result is passed to {@link #collaborationAnalysisTemplate(CollaborationAnalysisTemplate)}.
         * 
         * @param collaborationAnalysisTemplate
         *        a consumer that will call methods on {@link CollaborationAnalysisTemplate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #collaborationAnalysisTemplate(CollaborationAnalysisTemplate)
         */
        default Builder collaborationAnalysisTemplate(
                Consumer<CollaborationAnalysisTemplate.Builder> collaborationAnalysisTemplate) {
            return collaborationAnalysisTemplate(CollaborationAnalysisTemplate.builder()
                    .applyMutation(collaborationAnalysisTemplate).build());
        }
    }

    static final class BuilderImpl extends CleanRoomsResponse.BuilderImpl implements Builder {
        private CollaborationAnalysisTemplate collaborationAnalysisTemplate;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCollaborationAnalysisTemplateResponse model) {
            super(model);
            collaborationAnalysisTemplate(model.collaborationAnalysisTemplate);
        }

        public final CollaborationAnalysisTemplate.Builder getCollaborationAnalysisTemplate() {
            return collaborationAnalysisTemplate != null ? collaborationAnalysisTemplate.toBuilder() : null;
        }

        public final void setCollaborationAnalysisTemplate(CollaborationAnalysisTemplate.BuilderImpl collaborationAnalysisTemplate) {
            this.collaborationAnalysisTemplate = collaborationAnalysisTemplate != null ? collaborationAnalysisTemplate.build()
                    : null;
        }

        @Override
        public final Builder collaborationAnalysisTemplate(CollaborationAnalysisTemplate collaborationAnalysisTemplate) {
            this.collaborationAnalysisTemplate = collaborationAnalysisTemplate;
            return this;
        }

        @Override
        public GetCollaborationAnalysisTemplateResponse build() {
            return new GetCollaborationAnalysisTemplateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
