/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetConfiguredAudienceModelAssociationRequest extends CleanRoomsRequest implements
        ToCopyableBuilder<GetConfiguredAudienceModelAssociationRequest.Builder, GetConfiguredAudienceModelAssociationRequest> {
    private static final SdkField<String> CONFIGURED_AUDIENCE_MODEL_ASSOCIATION_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("configuredAudienceModelAssociationIdentifier")
            .getter(getter(GetConfiguredAudienceModelAssociationRequest::configuredAudienceModelAssociationIdentifier))
            .setter(setter(Builder::configuredAudienceModelAssociationIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH)
                    .locationName("configuredAudienceModelAssociationIdentifier").build()).build();

    private static final SdkField<String> MEMBERSHIP_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("membershipIdentifier")
            .getter(getter(GetConfiguredAudienceModelAssociationRequest::membershipIdentifier))
            .setter(setter(Builder::membershipIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("membershipIdentifier").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CONFIGURED_AUDIENCE_MODEL_ASSOCIATION_IDENTIFIER_FIELD, MEMBERSHIP_IDENTIFIER_FIELD));

    private final String configuredAudienceModelAssociationIdentifier;

    private final String membershipIdentifier;

    private GetConfiguredAudienceModelAssociationRequest(BuilderImpl builder) {
        super(builder);
        this.configuredAudienceModelAssociationIdentifier = builder.configuredAudienceModelAssociationIdentifier;
        this.membershipIdentifier = builder.membershipIdentifier;
    }

    /**
     * <p>
     * A unique identifier for the configured audience model association that you want to retrieve.
     * </p>
     * 
     * @return A unique identifier for the configured audience model association that you want to retrieve.
     */
    public final String configuredAudienceModelAssociationIdentifier() {
        return configuredAudienceModelAssociationIdentifier;
    }

    /**
     * <p>
     * A unique identifier for the membership that contains the configured audience model association that you want to
     * retrieve.
     * </p>
     * 
     * @return A unique identifier for the membership that contains the configured audience model association that you
     *         want to retrieve.
     */
    public final String membershipIdentifier() {
        return membershipIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(configuredAudienceModelAssociationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(membershipIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConfiguredAudienceModelAssociationRequest)) {
            return false;
        }
        GetConfiguredAudienceModelAssociationRequest other = (GetConfiguredAudienceModelAssociationRequest) obj;
        return Objects.equals(configuredAudienceModelAssociationIdentifier(),
                other.configuredAudienceModelAssociationIdentifier())
                && Objects.equals(membershipIdentifier(), other.membershipIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetConfiguredAudienceModelAssociationRequest")
                .add("ConfiguredAudienceModelAssociationIdentifier", configuredAudienceModelAssociationIdentifier())
                .add("MembershipIdentifier", membershipIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "configuredAudienceModelAssociationIdentifier":
            return Optional.ofNullable(clazz.cast(configuredAudienceModelAssociationIdentifier()));
        case "membershipIdentifier":
            return Optional.ofNullable(clazz.cast(membershipIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetConfiguredAudienceModelAssociationRequest, T> g) {
        return obj -> g.apply((GetConfiguredAudienceModelAssociationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CleanRoomsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetConfiguredAudienceModelAssociationRequest> {
        /**
         * <p>
         * A unique identifier for the configured audience model association that you want to retrieve.
         * </p>
         * 
         * @param configuredAudienceModelAssociationIdentifier
         *        A unique identifier for the configured audience model association that you want to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuredAudienceModelAssociationIdentifier(String configuredAudienceModelAssociationIdentifier);

        /**
         * <p>
         * A unique identifier for the membership that contains the configured audience model association that you want
         * to retrieve.
         * </p>
         * 
         * @param membershipIdentifier
         *        A unique identifier for the membership that contains the configured audience model association that
         *        you want to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder membershipIdentifier(String membershipIdentifier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CleanRoomsRequest.BuilderImpl implements Builder {
        private String configuredAudienceModelAssociationIdentifier;

        private String membershipIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(GetConfiguredAudienceModelAssociationRequest model) {
            super(model);
            configuredAudienceModelAssociationIdentifier(model.configuredAudienceModelAssociationIdentifier);
            membershipIdentifier(model.membershipIdentifier);
        }

        public final String getConfiguredAudienceModelAssociationIdentifier() {
            return configuredAudienceModelAssociationIdentifier;
        }

        public final void setConfiguredAudienceModelAssociationIdentifier(String configuredAudienceModelAssociationIdentifier) {
            this.configuredAudienceModelAssociationIdentifier = configuredAudienceModelAssociationIdentifier;
        }

        @Override
        public final Builder configuredAudienceModelAssociationIdentifier(String configuredAudienceModelAssociationIdentifier) {
            this.configuredAudienceModelAssociationIdentifier = configuredAudienceModelAssociationIdentifier;
            return this;
        }

        public final String getMembershipIdentifier() {
            return membershipIdentifier;
        }

        public final void setMembershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
        }

        @Override
        public final Builder membershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetConfiguredAudienceModelAssociationRequest build() {
            return new GetConfiguredAudienceModelAssociationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
