/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCollaborationConfiguredAudienceModelAssociationsResponse extends CleanRoomsResponse
        implements
        ToCopyableBuilder<ListCollaborationConfiguredAudienceModelAssociationsResponse.Builder, ListCollaborationConfiguredAudienceModelAssociationsResponse> {
    private static final SdkField<List<CollaborationConfiguredAudienceModelAssociationSummary>> COLLABORATION_CONFIGURED_AUDIENCE_MODEL_ASSOCIATION_SUMMARIES_FIELD = SdkField
            .<List<CollaborationConfiguredAudienceModelAssociationSummary>> builder(MarshallingType.LIST)
            .memberName("collaborationConfiguredAudienceModelAssociationSummaries")
            .getter(getter(ListCollaborationConfiguredAudienceModelAssociationsResponse::collaborationConfiguredAudienceModelAssociationSummaries))
            .setter(setter(Builder::collaborationConfiguredAudienceModelAssociationSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("collaborationConfiguredAudienceModelAssociationSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CollaborationConfiguredAudienceModelAssociationSummary> builder(
                                            MarshallingType.SDK_POJO)
                                            .constructor(CollaborationConfiguredAudienceModelAssociationSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListCollaborationConfiguredAudienceModelAssociationsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            COLLABORATION_CONFIGURED_AUDIENCE_MODEL_ASSOCIATION_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));

    private final List<CollaborationConfiguredAudienceModelAssociationSummary> collaborationConfiguredAudienceModelAssociationSummaries;

    private final String nextToken;

    private ListCollaborationConfiguredAudienceModelAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.collaborationConfiguredAudienceModelAssociationSummaries = builder.collaborationConfiguredAudienceModelAssociationSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the
     * CollaborationConfiguredAudienceModelAssociationSummaries property. This DOES NOT check that the value is
     * non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful because the
     * SDK will never return a null collection or map, but you may need to differentiate between the service returning
     * nothing (or null) and the service returning an empty collection or map. For requests, this returns true if a
     * value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasCollaborationConfiguredAudienceModelAssociationSummaries() {
        return collaborationConfiguredAudienceModelAssociationSummaries != null
                && !(collaborationConfiguredAudienceModelAssociationSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The metadata of the configured audience model association within a collaboration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the
     * {@link #hasCollaborationConfiguredAudienceModelAssociationSummaries} method.
     * </p>
     * 
     * @return The metadata of the configured audience model association within a collaboration.
     */
    public final List<CollaborationConfiguredAudienceModelAssociationSummary> collaborationConfiguredAudienceModelAssociationSummaries() {
        return collaborationConfiguredAudienceModelAssociationSummaries;
    }

    /**
     * <p>
     * The token value retrieved from a previous call to access the next page of results.
     * </p>
     * 
     * @return The token value retrieved from a previous call to access the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31
                * hashCode
                + Objects
                        .hashCode(hasCollaborationConfiguredAudienceModelAssociationSummaries() ? collaborationConfiguredAudienceModelAssociationSummaries()
                                : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCollaborationConfiguredAudienceModelAssociationsResponse)) {
            return false;
        }
        ListCollaborationConfiguredAudienceModelAssociationsResponse other = (ListCollaborationConfiguredAudienceModelAssociationsResponse) obj;
        return hasCollaborationConfiguredAudienceModelAssociationSummaries() == other
                .hasCollaborationConfiguredAudienceModelAssociationSummaries()
                && Objects.equals(collaborationConfiguredAudienceModelAssociationSummaries(),
                        other.collaborationConfiguredAudienceModelAssociationSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ListCollaborationConfiguredAudienceModelAssociationsResponse")
                .add("CollaborationConfiguredAudienceModelAssociationSummaries",
                        hasCollaborationConfiguredAudienceModelAssociationSummaries() ? collaborationConfiguredAudienceModelAssociationSummaries()
                                : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "collaborationConfiguredAudienceModelAssociationSummaries":
            return Optional.ofNullable(clazz.cast(collaborationConfiguredAudienceModelAssociationSummaries()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCollaborationConfiguredAudienceModelAssociationsResponse, T> g) {
        return obj -> g.apply((ListCollaborationConfiguredAudienceModelAssociationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CleanRoomsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListCollaborationConfiguredAudienceModelAssociationsResponse> {
        /**
         * <p>
         * The metadata of the configured audience model association within a collaboration.
         * </p>
         * 
         * @param collaborationConfiguredAudienceModelAssociationSummaries
         *        The metadata of the configured audience model association within a collaboration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaborationConfiguredAudienceModelAssociationSummaries(
                Collection<CollaborationConfiguredAudienceModelAssociationSummary> collaborationConfiguredAudienceModelAssociationSummaries);

        /**
         * <p>
         * The metadata of the configured audience model association within a collaboration.
         * </p>
         * 
         * @param collaborationConfiguredAudienceModelAssociationSummaries
         *        The metadata of the configured audience model association within a collaboration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaborationConfiguredAudienceModelAssociationSummaries(
                CollaborationConfiguredAudienceModelAssociationSummary... collaborationConfiguredAudienceModelAssociationSummaries);

        /**
         * <p>
         * The metadata of the configured audience model association within a collaboration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cleanrooms.model.CollaborationConfiguredAudienceModelAssociationSummary.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.cleanrooms.model.CollaborationConfiguredAudienceModelAssociationSummary#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cleanrooms.model.CollaborationConfiguredAudienceModelAssociationSummary.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #collaborationConfiguredAudienceModelAssociationSummaries(List<
         * CollaborationConfiguredAudienceModelAssociationSummary>)}.
         * 
         * @param collaborationConfiguredAudienceModelAssociationSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cleanrooms.model.CollaborationConfiguredAudienceModelAssociationSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #collaborationConfiguredAudienceModelAssociationSummaries(java.util.Collection<
         *      CollaborationConfiguredAudienceModelAssociationSummary>)
         */
        Builder collaborationConfiguredAudienceModelAssociationSummaries(
                Consumer<CollaborationConfiguredAudienceModelAssociationSummary.Builder>... collaborationConfiguredAudienceModelAssociationSummaries);

        /**
         * <p>
         * The token value retrieved from a previous call to access the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token value retrieved from a previous call to access the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CleanRoomsResponse.BuilderImpl implements Builder {
        private List<CollaborationConfiguredAudienceModelAssociationSummary> collaborationConfiguredAudienceModelAssociationSummaries = DefaultSdkAutoConstructList
                .getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCollaborationConfiguredAudienceModelAssociationsResponse model) {
            super(model);
            collaborationConfiguredAudienceModelAssociationSummaries(model.collaborationConfiguredAudienceModelAssociationSummaries);
            nextToken(model.nextToken);
        }

        public final List<CollaborationConfiguredAudienceModelAssociationSummary.Builder> getCollaborationConfiguredAudienceModelAssociationSummaries() {
            List<CollaborationConfiguredAudienceModelAssociationSummary.Builder> result = CollaborationConfiguredAudienceModelAssociationSummaryListCopier
                    .copyToBuilder(this.collaborationConfiguredAudienceModelAssociationSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCollaborationConfiguredAudienceModelAssociationSummaries(
                Collection<CollaborationConfiguredAudienceModelAssociationSummary.BuilderImpl> collaborationConfiguredAudienceModelAssociationSummaries) {
            this.collaborationConfiguredAudienceModelAssociationSummaries = CollaborationConfiguredAudienceModelAssociationSummaryListCopier
                    .copyFromBuilder(collaborationConfiguredAudienceModelAssociationSummaries);
        }

        @Override
        public final Builder collaborationConfiguredAudienceModelAssociationSummaries(
                Collection<CollaborationConfiguredAudienceModelAssociationSummary> collaborationConfiguredAudienceModelAssociationSummaries) {
            this.collaborationConfiguredAudienceModelAssociationSummaries = CollaborationConfiguredAudienceModelAssociationSummaryListCopier
                    .copy(collaborationConfiguredAudienceModelAssociationSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder collaborationConfiguredAudienceModelAssociationSummaries(
                CollaborationConfiguredAudienceModelAssociationSummary... collaborationConfiguredAudienceModelAssociationSummaries) {
            collaborationConfiguredAudienceModelAssociationSummaries(Arrays
                    .asList(collaborationConfiguredAudienceModelAssociationSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder collaborationConfiguredAudienceModelAssociationSummaries(
                Consumer<CollaborationConfiguredAudienceModelAssociationSummary.Builder>... collaborationConfiguredAudienceModelAssociationSummaries) {
            collaborationConfiguredAudienceModelAssociationSummaries(Stream
                    .of(collaborationConfiguredAudienceModelAssociationSummaries)
                    .map(c -> CollaborationConfiguredAudienceModelAssociationSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListCollaborationConfiguredAudienceModelAssociationsResponse build() {
            return new ListCollaborationConfiguredAudienceModelAssociationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
