/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The epsilon and noise parameters that were used in the privacy budget template.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PrivacyBudgetTemplateParametersOutput implements SdkPojo, Serializable,
        ToCopyableBuilder<PrivacyBudgetTemplateParametersOutput.Builder, PrivacyBudgetTemplateParametersOutput> {
    private static final SdkField<DifferentialPrivacyTemplateParametersOutput> DIFFERENTIAL_PRIVACY_FIELD = SdkField
            .<DifferentialPrivacyTemplateParametersOutput> builder(MarshallingType.SDK_POJO).memberName("differentialPrivacy")
            .getter(getter(PrivacyBudgetTemplateParametersOutput::differentialPrivacy))
            .setter(setter(Builder::differentialPrivacy)).constructor(DifferentialPrivacyTemplateParametersOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("differentialPrivacy").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIFFERENTIAL_PRIVACY_FIELD));

    private static final long serialVersionUID = 1L;

    private final DifferentialPrivacyTemplateParametersOutput differentialPrivacy;

    private final Type type;

    private PrivacyBudgetTemplateParametersOutput(BuilderImpl builder) {
        this.differentialPrivacy = builder.differentialPrivacy;
        this.type = builder.type;
    }

    /**
     * <p>
     * The epsilon and noise parameters.
     * </p>
     * 
     * @return The epsilon and noise parameters.
     */
    public final DifferentialPrivacyTemplateParametersOutput differentialPrivacy() {
        return differentialPrivacy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(differentialPrivacy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PrivacyBudgetTemplateParametersOutput)) {
            return false;
        }
        PrivacyBudgetTemplateParametersOutput other = (PrivacyBudgetTemplateParametersOutput) obj;
        return Objects.equals(differentialPrivacy(), other.differentialPrivacy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PrivacyBudgetTemplateParametersOutput").add("DifferentialPrivacy", differentialPrivacy())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "differentialPrivacy":
            return Optional.ofNullable(clazz.cast(differentialPrivacy()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #differentialPrivacy()} initialized to the given value.
     *
     * <p>
     * The epsilon and noise parameters.
     * </p>
     * 
     * @param differentialPrivacy
     *        The epsilon and noise parameters.
     */
    public static PrivacyBudgetTemplateParametersOutput fromDifferentialPrivacy(
            DifferentialPrivacyTemplateParametersOutput differentialPrivacy) {
        return builder().differentialPrivacy(differentialPrivacy).build();
    }

    /**
     * Create an instance of this class with {@link #differentialPrivacy()} initialized to the given value.
     *
     * <p>
     * The epsilon and noise parameters.
     * </p>
     * 
     * @param differentialPrivacy
     *        The epsilon and noise parameters.
     */
    public static PrivacyBudgetTemplateParametersOutput fromDifferentialPrivacy(
            Consumer<DifferentialPrivacyTemplateParametersOutput.Builder> differentialPrivacy) {
        DifferentialPrivacyTemplateParametersOutput.Builder builder = DifferentialPrivacyTemplateParametersOutput.builder();
        differentialPrivacy.accept(builder);
        return fromDifferentialPrivacy(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PrivacyBudgetTemplateParametersOutput, T> g) {
        return obj -> g.apply((PrivacyBudgetTemplateParametersOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PrivacyBudgetTemplateParametersOutput> {
        /**
         * <p>
         * The epsilon and noise parameters.
         * </p>
         * 
         * @param differentialPrivacy
         *        The epsilon and noise parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder differentialPrivacy(DifferentialPrivacyTemplateParametersOutput differentialPrivacy);

        /**
         * <p>
         * The epsilon and noise parameters.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DifferentialPrivacyTemplateParametersOutput.Builder} avoiding the need to create one manually via
         * {@link DifferentialPrivacyTemplateParametersOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DifferentialPrivacyTemplateParametersOutput.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #differentialPrivacy(DifferentialPrivacyTemplateParametersOutput)}.
         * 
         * @param differentialPrivacy
         *        a consumer that will call methods on {@link DifferentialPrivacyTemplateParametersOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #differentialPrivacy(DifferentialPrivacyTemplateParametersOutput)
         */
        default Builder differentialPrivacy(Consumer<DifferentialPrivacyTemplateParametersOutput.Builder> differentialPrivacy) {
            return differentialPrivacy(DifferentialPrivacyTemplateParametersOutput.builder().applyMutation(differentialPrivacy)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DifferentialPrivacyTemplateParametersOutput differentialPrivacy;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(PrivacyBudgetTemplateParametersOutput model) {
            differentialPrivacy(model.differentialPrivacy);
        }

        public final DifferentialPrivacyTemplateParametersOutput.Builder getDifferentialPrivacy() {
            return differentialPrivacy != null ? differentialPrivacy.toBuilder() : null;
        }

        public final void setDifferentialPrivacy(DifferentialPrivacyTemplateParametersOutput.BuilderImpl differentialPrivacy) {
            Object oldValue = this.differentialPrivacy;
            this.differentialPrivacy = differentialPrivacy != null ? differentialPrivacy.build() : null;
            handleUnionValueChange(Type.DIFFERENTIAL_PRIVACY, oldValue, this.differentialPrivacy);
        }

        @Override
        public final Builder differentialPrivacy(DifferentialPrivacyTemplateParametersOutput differentialPrivacy) {
            Object oldValue = this.differentialPrivacy;
            this.differentialPrivacy = differentialPrivacy;
            handleUnionValueChange(Type.DIFFERENTIAL_PRIVACY, oldValue, this.differentialPrivacy);
            return this;
        }

        @Override
        public PrivacyBudgetTemplateParametersOutput build() {
            return new PrivacyBudgetTemplateParametersOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see PrivacyBudgetTemplateParametersOutput#type()
     */
    public enum Type {
        DIFFERENTIAL_PRIVACY,

        UNKNOWN_TO_SDK_VERSION
    }
}
