/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cleanrooms.CleanRoomsAsyncClient;
import software.amazon.awssdk.services.cleanrooms.internal.UserAgentUtils;
import software.amazon.awssdk.services.cleanrooms.model.CollaborationSummary;
import software.amazon.awssdk.services.cleanrooms.model.ListCollaborationsRequest;
import software.amazon.awssdk.services.cleanrooms.model.ListCollaborationsResponse;

public class ListCollaborationsPublisher
implements SdkPublisher<ListCollaborationsResponse> {
    private final CleanRoomsAsyncClient client;
    private final ListCollaborationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCollaborationsPublisher(CleanRoomsAsyncClient client, ListCollaborationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCollaborationsPublisher(CleanRoomsAsyncClient client, ListCollaborationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCollaborationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCollaborationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CollaborationSummary> collaborationList() {
        Function<ListCollaborationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.collaborationList() != null) {
                return response.collaborationList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListCollaborationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListCollaborationsResponseFetcher
    implements AsyncPageFetcher<ListCollaborationsResponse> {
        private ListCollaborationsResponseFetcher() {
        }

        public boolean hasNextPage(ListCollaborationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCollaborationsResponse> nextPage(ListCollaborationsResponse previousPage) {
            if (previousPage == null) {
                return ListCollaborationsPublisher.this.client.listCollaborations(ListCollaborationsPublisher.this.firstRequest);
            }
            return ListCollaborationsPublisher.this.client.listCollaborations((ListCollaborationsRequest)((Object)ListCollaborationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

