/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cleanrooms.model.ProtectedQueryStatus;
import software.amazon.awssdk.services.cleanrooms.model.ReceiverConfiguration;
import software.amazon.awssdk.services.cleanrooms.model.ReceiverConfigurationsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProtectedQuerySummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProtectedQuerySummary> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(ProtectedQuerySummary.getter(ProtectedQuerySummary::id)).setter(ProtectedQuerySummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> MEMBERSHIP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("membershipId").getter(ProtectedQuerySummary.getter(ProtectedQuerySummary::membershipId)).setter(ProtectedQuerySummary.setter(Builder::membershipId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipId").build()}).build();
    private static final SdkField<String> MEMBERSHIP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("membershipArn").getter(ProtectedQuerySummary.getter(ProtectedQuerySummary::membershipArn)).setter(ProtectedQuerySummary.setter(Builder::membershipArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipArn").build()}).build();
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createTime").getter(ProtectedQuerySummary.getter(ProtectedQuerySummary::createTime)).setter(ProtectedQuerySummary.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(ProtectedQuerySummary.getter(ProtectedQuerySummary::statusAsString)).setter(ProtectedQuerySummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<List<ReceiverConfiguration>> RECEIVER_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("receiverConfigurations").getter(ProtectedQuerySummary.getter(ProtectedQuerySummary::receiverConfigurations)).setter(ProtectedQuerySummary.setter(Builder::receiverConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("receiverConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReceiverConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, MEMBERSHIP_ID_FIELD, MEMBERSHIP_ARN_FIELD, CREATE_TIME_FIELD, STATUS_FIELD, RECEIVER_CONFIGURATIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String membershipId;
    private final String membershipArn;
    private final Instant createTime;
    private final String status;
    private final List<ReceiverConfiguration> receiverConfigurations;

    private ProtectedQuerySummary(BuilderImpl builder) {
        this.id = builder.id;
        this.membershipId = builder.membershipId;
        this.membershipArn = builder.membershipArn;
        this.createTime = builder.createTime;
        this.status = builder.status;
        this.receiverConfigurations = builder.receiverConfigurations;
    }

    public final String id() {
        return this.id;
    }

    public final String membershipId() {
        return this.membershipId;
    }

    public final String membershipArn() {
        return this.membershipArn;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public final ProtectedQueryStatus status() {
        return ProtectedQueryStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasReceiverConfigurations() {
        return this.receiverConfigurations != null && !(this.receiverConfigurations instanceof SdkAutoConstructList);
    }

    public final List<ReceiverConfiguration> receiverConfigurations() {
        return this.receiverConfigurations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.membershipId());
        hashCode = 31 * hashCode + Objects.hashCode(this.membershipArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReceiverConfigurations() ? this.receiverConfigurations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProtectedQuerySummary)) {
            return false;
        }
        ProtectedQuerySummary other = (ProtectedQuerySummary)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.membershipId(), other.membershipId()) && Objects.equals(this.membershipArn(), other.membershipArn()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasReceiverConfigurations() == other.hasReceiverConfigurations() && Objects.equals(this.receiverConfigurations(), other.receiverConfigurations());
    }

    public final String toString() {
        return ToString.builder((String)"ProtectedQuerySummary").add("Id", (Object)this.id()).add("MembershipId", (Object)this.membershipId()).add("MembershipArn", (Object)this.membershipArn()).add("CreateTime", (Object)this.createTime()).add("Status", (Object)this.statusAsString()).add("ReceiverConfigurations", this.hasReceiverConfigurations() ? this.receiverConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "membershipId": {
                return Optional.ofNullable(clazz.cast(this.membershipId()));
            }
            case "membershipArn": {
                return Optional.ofNullable(clazz.cast(this.membershipArn()));
            }
            case "createTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "receiverConfigurations": {
                return Optional.ofNullable(clazz.cast(this.receiverConfigurations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProtectedQuerySummary, T> g) {
        return obj -> g.apply((ProtectedQuerySummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String membershipId;
        private String membershipArn;
        private Instant createTime;
        private String status;
        private List<ReceiverConfiguration> receiverConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ProtectedQuerySummary model) {
            this.id(model.id);
            this.membershipId(model.membershipId);
            this.membershipArn(model.membershipArn);
            this.createTime(model.createTime);
            this.status(model.status);
            this.receiverConfigurations(model.receiverConfigurations);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getMembershipId() {
            return this.membershipId;
        }

        public final void setMembershipId(String membershipId) {
            this.membershipId = membershipId;
        }

        @Override
        public final Builder membershipId(String membershipId) {
            this.membershipId = membershipId;
            return this;
        }

        public final String getMembershipArn() {
            return this.membershipArn;
        }

        public final void setMembershipArn(String membershipArn) {
            this.membershipArn = membershipArn;
        }

        @Override
        public final Builder membershipArn(String membershipArn) {
            this.membershipArn = membershipArn;
            return this;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ProtectedQueryStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final List<ReceiverConfiguration.Builder> getReceiverConfigurations() {
            List<ReceiverConfiguration.Builder> result = ReceiverConfigurationsListCopier.copyToBuilder(this.receiverConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReceiverConfigurations(Collection<ReceiverConfiguration.BuilderImpl> receiverConfigurations) {
            this.receiverConfigurations = ReceiverConfigurationsListCopier.copyFromBuilder(receiverConfigurations);
        }

        @Override
        public final Builder receiverConfigurations(Collection<ReceiverConfiguration> receiverConfigurations) {
            this.receiverConfigurations = ReceiverConfigurationsListCopier.copy(receiverConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder receiverConfigurations(ReceiverConfiguration ... receiverConfigurations) {
            this.receiverConfigurations(Arrays.asList(receiverConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder receiverConfigurations(Consumer<ReceiverConfiguration.Builder> ... receiverConfigurations) {
            this.receiverConfigurations(Stream.of(receiverConfigurations).map(c -> (ReceiverConfiguration)((ReceiverConfiguration.Builder)ReceiverConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ProtectedQuerySummary build() {
            return new ProtectedQuerySummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProtectedQuerySummary> {
        public Builder id(String var1);

        public Builder membershipId(String var1);

        public Builder membershipArn(String var1);

        public Builder createTime(Instant var1);

        public Builder status(String var1);

        public Builder status(ProtectedQueryStatus var1);

        public Builder receiverConfigurations(Collection<ReceiverConfiguration> var1);

        public Builder receiverConfigurations(ReceiverConfiguration ... var1);

        public Builder receiverConfigurations(Consumer<ReceiverConfiguration.Builder> ... var1);
    }
}

