/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cleanrooms.model.CleanRoomsResponse;
import software.amazon.awssdk.services.cleanrooms.model.ConfiguredTableSummary;
import software.amazon.awssdk.services.cleanrooms.model.ConfiguredTableSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListConfiguredTablesResponse
extends CleanRoomsResponse
implements ToCopyableBuilder<Builder, ListConfiguredTablesResponse> {
    private static final SdkField<List<ConfiguredTableSummary>> CONFIGURED_TABLE_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("configuredTableSummaries").getter(ListConfiguredTablesResponse.getter(ListConfiguredTablesResponse::configuredTableSummaries)).setter(ListConfiguredTablesResponse.setter(Builder::configuredTableSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuredTableSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConfiguredTableSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListConfiguredTablesResponse.getter(ListConfiguredTablesResponse::nextToken)).setter(ListConfiguredTablesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURED_TABLE_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("configuredTableSummaries", CONFIGURED_TABLE_SUMMARIES_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<ConfiguredTableSummary> configuredTableSummaries;
    private final String nextToken;

    private ListConfiguredTablesResponse(BuilderImpl builder) {
        super(builder);
        this.configuredTableSummaries = builder.configuredTableSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasConfiguredTableSummaries() {
        return this.configuredTableSummaries != null && !(this.configuredTableSummaries instanceof SdkAutoConstructList);
    }

    public final List<ConfiguredTableSummary> configuredTableSummaries() {
        return this.configuredTableSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConfiguredTableSummaries() ? this.configuredTableSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConfiguredTablesResponse)) {
            return false;
        }
        ListConfiguredTablesResponse other = (ListConfiguredTablesResponse)((Object)obj);
        return this.hasConfiguredTableSummaries() == other.hasConfiguredTableSummaries() && Objects.equals(this.configuredTableSummaries(), other.configuredTableSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListConfiguredTablesResponse").add("ConfiguredTableSummaries", this.hasConfiguredTableSummaries() ? this.configuredTableSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "configuredTableSummaries": {
                return Optional.ofNullable(clazz.cast(this.configuredTableSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListConfiguredTablesResponse, T> g) {
        return obj -> g.apply((ListConfiguredTablesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CleanRoomsResponse.BuilderImpl
    implements Builder {
        private List<ConfiguredTableSummary> configuredTableSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListConfiguredTablesResponse model) {
            super(model);
            this.configuredTableSummaries(model.configuredTableSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<ConfiguredTableSummary.Builder> getConfiguredTableSummaries() {
            List<ConfiguredTableSummary.Builder> result = ConfiguredTableSummaryListCopier.copyToBuilder(this.configuredTableSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConfiguredTableSummaries(Collection<ConfiguredTableSummary.BuilderImpl> configuredTableSummaries) {
            this.configuredTableSummaries = ConfiguredTableSummaryListCopier.copyFromBuilder(configuredTableSummaries);
        }

        @Override
        public final Builder configuredTableSummaries(Collection<ConfiguredTableSummary> configuredTableSummaries) {
            this.configuredTableSummaries = ConfiguredTableSummaryListCopier.copy(configuredTableSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configuredTableSummaries(ConfiguredTableSummary ... configuredTableSummaries) {
            this.configuredTableSummaries(Arrays.asList(configuredTableSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configuredTableSummaries(Consumer<ConfiguredTableSummary.Builder> ... configuredTableSummaries) {
            this.configuredTableSummaries(Stream.of(configuredTableSummaries).map(c -> (ConfiguredTableSummary)((ConfiguredTableSummary.Builder)ConfiguredTableSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListConfiguredTablesResponse build() {
            return new ListConfiguredTablesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CleanRoomsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListConfiguredTablesResponse> {
        public Builder configuredTableSummaries(Collection<ConfiguredTableSummary> var1);

        public Builder configuredTableSummaries(ConfiguredTableSummary ... var1);

        public Builder configuredTableSummaries(Consumer<ConfiguredTableSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

