/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.cleanrooms.internal.CleanRoomsServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.cleanrooms.model.AccessDeniedException;
import software.amazon.awssdk.services.cleanrooms.model.BatchGetCollaborationAnalysisTemplateRequest;
import software.amazon.awssdk.services.cleanrooms.model.BatchGetCollaborationAnalysisTemplateResponse;
import software.amazon.awssdk.services.cleanrooms.model.BatchGetSchemaAnalysisRuleRequest;
import software.amazon.awssdk.services.cleanrooms.model.BatchGetSchemaAnalysisRuleResponse;
import software.amazon.awssdk.services.cleanrooms.model.BatchGetSchemaRequest;
import software.amazon.awssdk.services.cleanrooms.model.BatchGetSchemaResponse;
import software.amazon.awssdk.services.cleanrooms.model.CleanRoomsException;
import software.amazon.awssdk.services.cleanrooms.model.ConflictException;
import software.amazon.awssdk.services.cleanrooms.model.CreateAnalysisTemplateRequest;
import software.amazon.awssdk.services.cleanrooms.model.CreateAnalysisTemplateResponse;
import software.amazon.awssdk.services.cleanrooms.model.CreateCollaborationRequest;
import software.amazon.awssdk.services.cleanrooms.model.CreateCollaborationResponse;
import software.amazon.awssdk.services.cleanrooms.model.CreateConfiguredAudienceModelAssociationRequest;
import software.amazon.awssdk.services.cleanrooms.model.CreateConfiguredAudienceModelAssociationResponse;
import software.amazon.awssdk.services.cleanrooms.model.CreateConfiguredTableAnalysisRuleRequest;
import software.amazon.awssdk.services.cleanrooms.model.CreateConfiguredTableAnalysisRuleResponse;
import software.amazon.awssdk.services.cleanrooms.model.CreateConfiguredTableAssociationAnalysisRuleRequest;
import software.amazon.awssdk.services.cleanrooms.model.CreateConfiguredTableAssociationAnalysisRuleResponse;
import software.amazon.awssdk.services.cleanrooms.model.CreateConfiguredTableAssociationRequest;
import software.amazon.awssdk.services.cleanrooms.model.CreateConfiguredTableAssociationResponse;
import software.amazon.awssdk.services.cleanrooms.model.CreateConfiguredTableRequest;
import software.amazon.awssdk.services.cleanrooms.model.CreateConfiguredTableResponse;
import software.amazon.awssdk.services.cleanrooms.model.CreateIdMappingTableRequest;
import software.amazon.awssdk.services.cleanrooms.model.CreateIdMappingTableResponse;
import software.amazon.awssdk.services.cleanrooms.model.CreateIdNamespaceAssociationRequest;
import software.amazon.awssdk.services.cleanrooms.model.CreateIdNamespaceAssociationResponse;
import software.amazon.awssdk.services.cleanrooms.model.CreateMembershipRequest;
import software.amazon.awssdk.services.cleanrooms.model.CreateMembershipResponse;
import software.amazon.awssdk.services.cleanrooms.model.CreatePrivacyBudgetTemplateRequest;
import software.amazon.awssdk.services.cleanrooms.model.CreatePrivacyBudgetTemplateResponse;
import software.amazon.awssdk.services.cleanrooms.model.DeleteAnalysisTemplateRequest;
import software.amazon.awssdk.services.cleanrooms.model.DeleteAnalysisTemplateResponse;
import software.amazon.awssdk.services.cleanrooms.model.DeleteCollaborationRequest;
import software.amazon.awssdk.services.cleanrooms.model.DeleteCollaborationResponse;
import software.amazon.awssdk.services.cleanrooms.model.DeleteConfiguredAudienceModelAssociationRequest;
import software.amazon.awssdk.services.cleanrooms.model.DeleteConfiguredAudienceModelAssociationResponse;
import software.amazon.awssdk.services.cleanrooms.model.DeleteConfiguredTableAnalysisRuleRequest;
import software.amazon.awssdk.services.cleanrooms.model.DeleteConfiguredTableAnalysisRuleResponse;
import software.amazon.awssdk.services.cleanrooms.model.DeleteConfiguredTableAssociationAnalysisRuleRequest;
import software.amazon.awssdk.services.cleanrooms.model.DeleteConfiguredTableAssociationAnalysisRuleResponse;
import software.amazon.awssdk.services.cleanrooms.model.DeleteConfiguredTableAssociationRequest;
import software.amazon.awssdk.services.cleanrooms.model.DeleteConfiguredTableAssociationResponse;
import software.amazon.awssdk.services.cleanrooms.model.DeleteConfiguredTableRequest;
import software.amazon.awssdk.services.cleanrooms.model.DeleteConfiguredTableResponse;
import software.amazon.awssdk.services.cleanrooms.model.DeleteIdMappingTableRequest;
import software.amazon.awssdk.services.cleanrooms.model.DeleteIdMappingTableResponse;
import software.amazon.awssdk.services.cleanrooms.model.DeleteIdNamespaceAssociationRequest;
import software.amazon.awssdk.services.cleanrooms.model.DeleteIdNamespaceAssociationResponse;
import software.amazon.awssdk.services.cleanrooms.model.DeleteMemberRequest;
import software.amazon.awssdk.services.cleanrooms.model.DeleteMemberResponse;
import software.amazon.awssdk.services.cleanrooms.model.DeleteMembershipRequest;
import software.amazon.awssdk.services.cleanrooms.model.DeleteMembershipResponse;
import software.amazon.awssdk.services.cleanrooms.model.DeletePrivacyBudgetTemplateRequest;
import software.amazon.awssdk.services.cleanrooms.model.DeletePrivacyBudgetTemplateResponse;
import software.amazon.awssdk.services.cleanrooms.model.GetAnalysisTemplateRequest;
import software.amazon.awssdk.services.cleanrooms.model.GetAnalysisTemplateResponse;
import software.amazon.awssdk.services.cleanrooms.model.GetCollaborationAnalysisTemplateRequest;
import software.amazon.awssdk.services.cleanrooms.model.GetCollaborationAnalysisTemplateResponse;
import software.amazon.awssdk.services.cleanrooms.model.GetCollaborationConfiguredAudienceModelAssociationRequest;
import software.amazon.awssdk.services.cleanrooms.model.GetCollaborationConfiguredAudienceModelAssociationResponse;
import software.amazon.awssdk.services.cleanrooms.model.GetCollaborationIdNamespaceAssociationRequest;
import software.amazon.awssdk.services.cleanrooms.model.GetCollaborationIdNamespaceAssociationResponse;
import software.amazon.awssdk.services.cleanrooms.model.GetCollaborationPrivacyBudgetTemplateRequest;
import software.amazon.awssdk.services.cleanrooms.model.GetCollaborationPrivacyBudgetTemplateResponse;
import software.amazon.awssdk.services.cleanrooms.model.GetCollaborationRequest;
import software.amazon.awssdk.services.cleanrooms.model.GetCollaborationResponse;
import software.amazon.awssdk.services.cleanrooms.model.GetConfiguredAudienceModelAssociationRequest;
import software.amazon.awssdk.services.cleanrooms.model.GetConfiguredAudienceModelAssociationResponse;
import software.amazon.awssdk.services.cleanrooms.model.GetConfiguredTableAnalysisRuleRequest;
import software.amazon.awssdk.services.cleanrooms.model.GetConfiguredTableAnalysisRuleResponse;
import software.amazon.awssdk.services.cleanrooms.model.GetConfiguredTableAssociationAnalysisRuleRequest;
import software.amazon.awssdk.services.cleanrooms.model.GetConfiguredTableAssociationAnalysisRuleResponse;
import software.amazon.awssdk.services.cleanrooms.model.GetConfiguredTableAssociationRequest;
import software.amazon.awssdk.services.cleanrooms.model.GetConfiguredTableAssociationResponse;
import software.amazon.awssdk.services.cleanrooms.model.GetConfiguredTableRequest;
import software.amazon.awssdk.services.cleanrooms.model.GetConfiguredTableResponse;
import software.amazon.awssdk.services.cleanrooms.model.GetIdMappingTableRequest;
import software.amazon.awssdk.services.cleanrooms.model.GetIdMappingTableResponse;
import software.amazon.awssdk.services.cleanrooms.model.GetIdNamespaceAssociationRequest;
import software.amazon.awssdk.services.cleanrooms.model.GetIdNamespaceAssociationResponse;
import software.amazon.awssdk.services.cleanrooms.model.GetMembershipRequest;
import software.amazon.awssdk.services.cleanrooms.model.GetMembershipResponse;
import software.amazon.awssdk.services.cleanrooms.model.GetPrivacyBudgetTemplateRequest;
import software.amazon.awssdk.services.cleanrooms.model.GetPrivacyBudgetTemplateResponse;
import software.amazon.awssdk.services.cleanrooms.model.GetProtectedQueryRequest;
import software.amazon.awssdk.services.cleanrooms.model.GetProtectedQueryResponse;
import software.amazon.awssdk.services.cleanrooms.model.GetSchemaAnalysisRuleRequest;
import software.amazon.awssdk.services.cleanrooms.model.GetSchemaAnalysisRuleResponse;
import software.amazon.awssdk.services.cleanrooms.model.GetSchemaRequest;
import software.amazon.awssdk.services.cleanrooms.model.GetSchemaResponse;
import software.amazon.awssdk.services.cleanrooms.model.InternalServerException;
import software.amazon.awssdk.services.cleanrooms.model.ListAnalysisTemplatesRequest;
import software.amazon.awssdk.services.cleanrooms.model.ListAnalysisTemplatesResponse;
import software.amazon.awssdk.services.cleanrooms.model.ListCollaborationAnalysisTemplatesRequest;
import software.amazon.awssdk.services.cleanrooms.model.ListCollaborationAnalysisTemplatesResponse;
import software.amazon.awssdk.services.cleanrooms.model.ListCollaborationConfiguredAudienceModelAssociationsRequest;
import software.amazon.awssdk.services.cleanrooms.model.ListCollaborationConfiguredAudienceModelAssociationsResponse;
import software.amazon.awssdk.services.cleanrooms.model.ListCollaborationIdNamespaceAssociationsRequest;
import software.amazon.awssdk.services.cleanrooms.model.ListCollaborationIdNamespaceAssociationsResponse;
import software.amazon.awssdk.services.cleanrooms.model.ListCollaborationPrivacyBudgetTemplatesRequest;
import software.amazon.awssdk.services.cleanrooms.model.ListCollaborationPrivacyBudgetTemplatesResponse;
import software.amazon.awssdk.services.cleanrooms.model.ListCollaborationPrivacyBudgetsRequest;
import software.amazon.awssdk.services.cleanrooms.model.ListCollaborationPrivacyBudgetsResponse;
import software.amazon.awssdk.services.cleanrooms.model.ListCollaborationsRequest;
import software.amazon.awssdk.services.cleanrooms.model.ListCollaborationsResponse;
import software.amazon.awssdk.services.cleanrooms.model.ListConfiguredAudienceModelAssociationsRequest;
import software.amazon.awssdk.services.cleanrooms.model.ListConfiguredAudienceModelAssociationsResponse;
import software.amazon.awssdk.services.cleanrooms.model.ListConfiguredTableAssociationsRequest;
import software.amazon.awssdk.services.cleanrooms.model.ListConfiguredTableAssociationsResponse;
import software.amazon.awssdk.services.cleanrooms.model.ListConfiguredTablesRequest;
import software.amazon.awssdk.services.cleanrooms.model.ListConfiguredTablesResponse;
import software.amazon.awssdk.services.cleanrooms.model.ListIdMappingTablesRequest;
import software.amazon.awssdk.services.cleanrooms.model.ListIdMappingTablesResponse;
import software.amazon.awssdk.services.cleanrooms.model.ListIdNamespaceAssociationsRequest;
import software.amazon.awssdk.services.cleanrooms.model.ListIdNamespaceAssociationsResponse;
import software.amazon.awssdk.services.cleanrooms.model.ListMembersRequest;
import software.amazon.awssdk.services.cleanrooms.model.ListMembersResponse;
import software.amazon.awssdk.services.cleanrooms.model.ListMembershipsRequest;
import software.amazon.awssdk.services.cleanrooms.model.ListMembershipsResponse;
import software.amazon.awssdk.services.cleanrooms.model.ListPrivacyBudgetTemplatesRequest;
import software.amazon.awssdk.services.cleanrooms.model.ListPrivacyBudgetTemplatesResponse;
import software.amazon.awssdk.services.cleanrooms.model.ListPrivacyBudgetsRequest;
import software.amazon.awssdk.services.cleanrooms.model.ListPrivacyBudgetsResponse;
import software.amazon.awssdk.services.cleanrooms.model.ListProtectedQueriesRequest;
import software.amazon.awssdk.services.cleanrooms.model.ListProtectedQueriesResponse;
import software.amazon.awssdk.services.cleanrooms.model.ListSchemasRequest;
import software.amazon.awssdk.services.cleanrooms.model.ListSchemasResponse;
import software.amazon.awssdk.services.cleanrooms.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.cleanrooms.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.cleanrooms.model.PopulateIdMappingTableRequest;
import software.amazon.awssdk.services.cleanrooms.model.PopulateIdMappingTableResponse;
import software.amazon.awssdk.services.cleanrooms.model.PreviewPrivacyImpactRequest;
import software.amazon.awssdk.services.cleanrooms.model.PreviewPrivacyImpactResponse;
import software.amazon.awssdk.services.cleanrooms.model.ResourceNotFoundException;
import software.amazon.awssdk.services.cleanrooms.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.cleanrooms.model.StartProtectedQueryRequest;
import software.amazon.awssdk.services.cleanrooms.model.StartProtectedQueryResponse;
import software.amazon.awssdk.services.cleanrooms.model.TagResourceRequest;
import software.amazon.awssdk.services.cleanrooms.model.TagResourceResponse;
import software.amazon.awssdk.services.cleanrooms.model.ThrottlingException;
import software.amazon.awssdk.services.cleanrooms.model.UntagResourceRequest;
import software.amazon.awssdk.services.cleanrooms.model.UntagResourceResponse;
import software.amazon.awssdk.services.cleanrooms.model.UpdateAnalysisTemplateRequest;
import software.amazon.awssdk.services.cleanrooms.model.UpdateAnalysisTemplateResponse;
import software.amazon.awssdk.services.cleanrooms.model.UpdateCollaborationRequest;
import software.amazon.awssdk.services.cleanrooms.model.UpdateCollaborationResponse;
import software.amazon.awssdk.services.cleanrooms.model.UpdateConfiguredAudienceModelAssociationRequest;
import software.amazon.awssdk.services.cleanrooms.model.UpdateConfiguredAudienceModelAssociationResponse;
import software.amazon.awssdk.services.cleanrooms.model.UpdateConfiguredTableAnalysisRuleRequest;
import software.amazon.awssdk.services.cleanrooms.model.UpdateConfiguredTableAnalysisRuleResponse;
import software.amazon.awssdk.services.cleanrooms.model.UpdateConfiguredTableAssociationAnalysisRuleRequest;
import software.amazon.awssdk.services.cleanrooms.model.UpdateConfiguredTableAssociationAnalysisRuleResponse;
import software.amazon.awssdk.services.cleanrooms.model.UpdateConfiguredTableAssociationRequest;
import software.amazon.awssdk.services.cleanrooms.model.UpdateConfiguredTableAssociationResponse;
import software.amazon.awssdk.services.cleanrooms.model.UpdateConfiguredTableRequest;
import software.amazon.awssdk.services.cleanrooms.model.UpdateConfiguredTableResponse;
import software.amazon.awssdk.services.cleanrooms.model.UpdateIdMappingTableRequest;
import software.amazon.awssdk.services.cleanrooms.model.UpdateIdMappingTableResponse;
import software.amazon.awssdk.services.cleanrooms.model.UpdateIdNamespaceAssociationRequest;
import software.amazon.awssdk.services.cleanrooms.model.UpdateIdNamespaceAssociationResponse;
import software.amazon.awssdk.services.cleanrooms.model.UpdateMembershipRequest;
import software.amazon.awssdk.services.cleanrooms.model.UpdateMembershipResponse;
import software.amazon.awssdk.services.cleanrooms.model.UpdatePrivacyBudgetTemplateRequest;
import software.amazon.awssdk.services.cleanrooms.model.UpdatePrivacyBudgetTemplateResponse;
import software.amazon.awssdk.services.cleanrooms.model.UpdateProtectedQueryRequest;
import software.amazon.awssdk.services.cleanrooms.model.UpdateProtectedQueryResponse;
import software.amazon.awssdk.services.cleanrooms.model.ValidationException;
import software.amazon.awssdk.services.cleanrooms.transform.BatchGetCollaborationAnalysisTemplateRequestMarshaller;
import software.amazon.awssdk.services.cleanrooms.transform.BatchGetSchemaAnalysisRuleRequestMarshaller;
import software.amazon.awssdk.services.cleanrooms.transform.BatchGetSchemaRequestMarshaller;
import software.amazon.awssdk.services.cleanrooms.transform.CreateAnalysisTemplateRequestMarshaller;
import software.amazon.awssdk.services.cleanrooms.transform.CreateCollaborationRequestMarshaller;
import software.amazon.awssdk.services.cleanrooms.transform.CreateConfiguredAudienceModelAssociationRequestMarshaller;
import software.amazon.awssdk.services.cleanrooms.transform.CreateConfiguredTableAnalysisRuleRequestMarshaller;
import software.amazon.awssdk.services.cleanrooms.transform.CreateConfiguredTableAssociationAnalysisRuleRequestMarshaller;
import software.amazon.awssdk.services.cleanrooms.transform.CreateConfiguredTableAssociationRequestMarshaller;
import software.amazon.awssdk.services.cleanrooms.transform.CreateConfiguredTableRequestMarshaller;
import software.amazon.awssdk.services.cleanrooms.transform.CreateIdMappingTableRequestMarshaller;
import software.amazon.awssdk.services.cleanrooms.transform.CreateIdNamespaceAssociationRequestMarshaller;
import software.amazon.awssdk.services.cleanrooms.transform.CreateMembershipRequestMarshaller;
import software.amazon.awssdk.services.cleanrooms.transform.CreatePrivacyBudgetTemplateRequestMarshaller;
import software.amazon.awssdk.services.cleanrooms.transform.DeleteAnalysisTemplateRequestMarshaller;
import software.amazon.awssdk.services.cleanrooms.transform.DeleteCollaborationRequestMarshaller;
import software.amazon.awssdk.services.cleanrooms.transform.DeleteConfiguredAudienceModelAssociationRequestMarshaller;
import software.amazon.awssdk.services.cleanrooms.transform.DeleteConfiguredTableAnalysisRuleRequestMarshaller;
import software.amazon.awssdk.services.cleanrooms.transform.DeleteConfiguredTableAssociationAnalysisRuleRequestMarshaller;
import software.amazon.awssdk.services.cleanrooms.transform.DeleteConfiguredTableAssociationRequestMarshaller;
import software.amazon.awssdk.services.cleanrooms.transform.DeleteConfiguredTableRequestMarshaller;
import software.amazon.awssdk.services.cleanrooms.transform.DeleteIdMappingTableRequestMarshaller;
import software.amazon.awssdk.services.cleanrooms.transform.DeleteIdNamespaceAssociationRequestMarshaller;
import software.amazon.awssdk.services.cleanrooms.transform.DeleteMemberRequestMarshaller;
import software.amazon.awssdk.services.cleanrooms.transform.DeleteMembershipRequestMarshaller;
import software.amazon.awssdk.services.cleanrooms.transform.DeletePrivacyBudgetTemplateRequestMarshaller;
import software.amazon.awssdk.services.cleanrooms.transform.GetAnalysisTemplateRequestMarshaller;
import software.amazon.awssdk.services.cleanrooms.transform.GetCollaborationAnalysisTemplateRequestMarshaller;
import software.amazon.awssdk.services.cleanrooms.transform.GetCollaborationConfiguredAudienceModelAssociationRequestMarshaller;
import software.amazon.awssdk.services.cleanrooms.transform.GetCollaborationIdNamespaceAssociationRequestMarshaller;
import software.amazon.awssdk.services.cleanrooms.transform.GetCollaborationPrivacyBudgetTemplateRequestMarshaller;
import software.amazon.awssdk.services.cleanrooms.transform.GetCollaborationRequestMarshaller;
import software.amazon.awssdk.services.cleanrooms.transform.GetConfiguredAudienceModelAssociationRequestMarshaller;
import software.amazon.awssdk.services.cleanrooms.transform.GetConfiguredTableAnalysisRuleRequestMarshaller;
import software.amazon.awssdk.services.cleanrooms.transform.GetConfiguredTableAssociationAnalysisRuleRequestMarshaller;
import software.amazon.awssdk.services.cleanrooms.transform.GetConfiguredTableAssociationRequestMarshaller;
import software.amazon.awssdk.services.cleanrooms.transform.GetConfiguredTableRequestMarshaller;
import software.amazon.awssdk.services.cleanrooms.transform.GetIdMappingTableRequestMarshaller;
import software.amazon.awssdk.services.cleanrooms.transform.GetIdNamespaceAssociationRequestMarshaller;
import software.amazon.awssdk.services.cleanrooms.transform.GetMembershipRequestMarshaller;
import software.amazon.awssdk.services.cleanrooms.transform.GetPrivacyBudgetTemplateRequestMarshaller;
import software.amazon.awssdk.services.cleanrooms.transform.GetProtectedQueryRequestMarshaller;
import software.amazon.awssdk.services.cleanrooms.transform.GetSchemaAnalysisRuleRequestMarshaller;
import software.amazon.awssdk.services.cleanrooms.transform.GetSchemaRequestMarshaller;
import software.amazon.awssdk.services.cleanrooms.transform.ListAnalysisTemplatesRequestMarshaller;
import software.amazon.awssdk.services.cleanrooms.transform.ListCollaborationAnalysisTemplatesRequestMarshaller;
import software.amazon.awssdk.services.cleanrooms.transform.ListCollaborationConfiguredAudienceModelAssociationsRequestMarshaller;
import software.amazon.awssdk.services.cleanrooms.transform.ListCollaborationIdNamespaceAssociationsRequestMarshaller;
import software.amazon.awssdk.services.cleanrooms.transform.ListCollaborationPrivacyBudgetTemplatesRequestMarshaller;
import software.amazon.awssdk.services.cleanrooms.transform.ListCollaborationPrivacyBudgetsRequestMarshaller;
import software.amazon.awssdk.services.cleanrooms.transform.ListCollaborationsRequestMarshaller;
import software.amazon.awssdk.services.cleanrooms.transform.ListConfiguredAudienceModelAssociationsRequestMarshaller;
import software.amazon.awssdk.services.cleanrooms.transform.ListConfiguredTableAssociationsRequestMarshaller;
import software.amazon.awssdk.services.cleanrooms.transform.ListConfiguredTablesRequestMarshaller;
import software.amazon.awssdk.services.cleanrooms.transform.ListIdMappingTablesRequestMarshaller;
import software.amazon.awssdk.services.cleanrooms.transform.ListIdNamespaceAssociationsRequestMarshaller;
import software.amazon.awssdk.services.cleanrooms.transform.ListMembersRequestMarshaller;
import software.amazon.awssdk.services.cleanrooms.transform.ListMembershipsRequestMarshaller;
import software.amazon.awssdk.services.cleanrooms.transform.ListPrivacyBudgetTemplatesRequestMarshaller;
import software.amazon.awssdk.services.cleanrooms.transform.ListPrivacyBudgetsRequestMarshaller;
import software.amazon.awssdk.services.cleanrooms.transform.ListProtectedQueriesRequestMarshaller;
import software.amazon.awssdk.services.cleanrooms.transform.ListSchemasRequestMarshaller;
import software.amazon.awssdk.services.cleanrooms.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.cleanrooms.transform.PopulateIdMappingTableRequestMarshaller;
import software.amazon.awssdk.services.cleanrooms.transform.PreviewPrivacyImpactRequestMarshaller;
import software.amazon.awssdk.services.cleanrooms.transform.StartProtectedQueryRequestMarshaller;
import software.amazon.awssdk.services.cleanrooms.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.cleanrooms.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.cleanrooms.transform.UpdateAnalysisTemplateRequestMarshaller;
import software.amazon.awssdk.services.cleanrooms.transform.UpdateCollaborationRequestMarshaller;
import software.amazon.awssdk.services.cleanrooms.transform.UpdateConfiguredAudienceModelAssociationRequestMarshaller;
import software.amazon.awssdk.services.cleanrooms.transform.UpdateConfiguredTableAnalysisRuleRequestMarshaller;
import software.amazon.awssdk.services.cleanrooms.transform.UpdateConfiguredTableAssociationAnalysisRuleRequestMarshaller;
import software.amazon.awssdk.services.cleanrooms.transform.UpdateConfiguredTableAssociationRequestMarshaller;
import software.amazon.awssdk.services.cleanrooms.transform.UpdateConfiguredTableRequestMarshaller;
import software.amazon.awssdk.services.cleanrooms.transform.UpdateIdMappingTableRequestMarshaller;
import software.amazon.awssdk.services.cleanrooms.transform.UpdateIdNamespaceAssociationRequestMarshaller;
import software.amazon.awssdk.services.cleanrooms.transform.UpdateMembershipRequestMarshaller;
import software.amazon.awssdk.services.cleanrooms.transform.UpdatePrivacyBudgetTemplateRequestMarshaller;
import software.amazon.awssdk.services.cleanrooms.transform.UpdateProtectedQueryRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link CleanRoomsAsyncClient}.
 *
 * @see CleanRoomsAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultCleanRoomsAsyncClient implements CleanRoomsAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultCleanRoomsAsyncClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.REST_JSON).build();

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultCleanRoomsAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Retrieves multiple analysis templates within a collaboration by their Amazon Resource Names (ARNs).
     * </p>
     *
     * @param batchGetCollaborationAnalysisTemplateRequest
     * @return A Java Future containing the result of the BatchGetCollaborationAnalysisTemplate operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the specified constraints.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException Caller does not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsAsyncClient.BatchGetCollaborationAnalysisTemplate
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/BatchGetCollaborationAnalysisTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchGetCollaborationAnalysisTemplateResponse> batchGetCollaborationAnalysisTemplate(
            BatchGetCollaborationAnalysisTemplateRequest batchGetCollaborationAnalysisTemplateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchGetCollaborationAnalysisTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                batchGetCollaborationAnalysisTemplateRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRooms");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetCollaborationAnalysisTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchGetCollaborationAnalysisTemplateResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, BatchGetCollaborationAnalysisTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<BatchGetCollaborationAnalysisTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchGetCollaborationAnalysisTemplateRequest, BatchGetCollaborationAnalysisTemplateResponse>()
                            .withOperationName("BatchGetCollaborationAnalysisTemplate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchGetCollaborationAnalysisTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(batchGetCollaborationAnalysisTemplateRequest));
            CompletableFuture<BatchGetCollaborationAnalysisTemplateResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves multiple schemas by their identifiers.
     * </p>
     *
     * @param batchGetSchemaRequest
     * @return A Java Future containing the result of the BatchGetSchema operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the specified constraints.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException Caller does not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsAsyncClient.BatchGetSchema
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/BatchGetSchema" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<BatchGetSchemaResponse> batchGetSchema(BatchGetSchemaRequest batchGetSchemaRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchGetSchemaRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchGetSchemaRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRooms");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetSchema");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchGetSchemaResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchGetSchemaResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<BatchGetSchemaResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchGetSchemaRequest, BatchGetSchemaResponse>()
                            .withOperationName("BatchGetSchema").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchGetSchemaRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(batchGetSchemaRequest));
            CompletableFuture<BatchGetSchemaResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves multiple analysis rule schemas.
     * </p>
     *
     * @param batchGetSchemaAnalysisRuleRequest
     * @return A Java Future containing the result of the BatchGetSchemaAnalysisRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the specified constraints.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException Caller does not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsAsyncClient.BatchGetSchemaAnalysisRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/BatchGetSchemaAnalysisRule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchGetSchemaAnalysisRuleResponse> batchGetSchemaAnalysisRule(
            BatchGetSchemaAnalysisRuleRequest batchGetSchemaAnalysisRuleRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchGetSchemaAnalysisRuleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchGetSchemaAnalysisRuleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRooms");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetSchemaAnalysisRule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchGetSchemaAnalysisRuleResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchGetSchemaAnalysisRuleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<BatchGetSchemaAnalysisRuleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchGetSchemaAnalysisRuleRequest, BatchGetSchemaAnalysisRuleResponse>()
                            .withOperationName("BatchGetSchemaAnalysisRule").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchGetSchemaAnalysisRuleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(batchGetSchemaAnalysisRuleRequest));
            CompletableFuture<BatchGetSchemaAnalysisRuleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new analysis template.
     * </p>
     *
     * @param createAnalysisTemplateRequest
     * @return A Java Future containing the result of the CreateAnalysisTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ServiceQuotaExceededException Request denied because service quota has been exceeded.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the specified constraints.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException Caller does not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsAsyncClient.CreateAnalysisTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/CreateAnalysisTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateAnalysisTemplateResponse> createAnalysisTemplate(
            CreateAnalysisTemplateRequest createAnalysisTemplateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAnalysisTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAnalysisTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRooms");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAnalysisTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateAnalysisTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateAnalysisTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateAnalysisTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateAnalysisTemplateRequest, CreateAnalysisTemplateResponse>()
                            .withOperationName("CreateAnalysisTemplate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateAnalysisTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createAnalysisTemplateRequest));
            CompletableFuture<CreateAnalysisTemplateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new collaboration.
     * </p>
     *
     * @param createCollaborationRequest
     * @return A Java Future containing the result of the CreateCollaboration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request denied because service quota has been exceeded.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the specified constraints.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException Caller does not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsAsyncClient.CreateCollaboration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/CreateCollaboration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateCollaborationResponse> createCollaboration(
            CreateCollaborationRequest createCollaborationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createCollaborationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createCollaborationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRooms");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCollaboration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateCollaborationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateCollaborationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateCollaborationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateCollaborationRequest, CreateCollaborationResponse>()
                            .withOperationName("CreateCollaboration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateCollaborationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createCollaborationRequest));
            CompletableFuture<CreateCollaborationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides the details necessary to create a configured audience model association.
     * </p>
     *
     * @param createConfiguredAudienceModelAssociationRequest
     * @return A Java Future containing the result of the CreateConfiguredAudienceModelAssociation operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ServiceQuotaExceededException Request denied because service quota has been exceeded.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the specified constraints.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException Caller does not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsAsyncClient.CreateConfiguredAudienceModelAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/CreateConfiguredAudienceModelAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateConfiguredAudienceModelAssociationResponse> createConfiguredAudienceModelAssociation(
            CreateConfiguredAudienceModelAssociationRequest createConfiguredAudienceModelAssociationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                createConfiguredAudienceModelAssociationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createConfiguredAudienceModelAssociationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRooms");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateConfiguredAudienceModelAssociation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateConfiguredAudienceModelAssociationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, CreateConfiguredAudienceModelAssociationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateConfiguredAudienceModelAssociationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateConfiguredAudienceModelAssociationRequest, CreateConfiguredAudienceModelAssociationResponse>()
                            .withOperationName("CreateConfiguredAudienceModelAssociation").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateConfiguredAudienceModelAssociationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createConfiguredAudienceModelAssociationRequest));
            CompletableFuture<CreateConfiguredAudienceModelAssociationResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new configured table resource.
     * </p>
     *
     * @param createConfiguredTableRequest
     * @return A Java Future containing the result of the CreateConfiguredTable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ServiceQuotaExceededException Request denied because service quota has been exceeded.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the specified constraints.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException Caller does not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsAsyncClient.CreateConfiguredTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/CreateConfiguredTable"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateConfiguredTableResponse> createConfiguredTable(
            CreateConfiguredTableRequest createConfiguredTableRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createConfiguredTableRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createConfiguredTableRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRooms");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateConfiguredTable");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateConfiguredTableResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateConfiguredTableResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateConfiguredTableResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateConfiguredTableRequest, CreateConfiguredTableResponse>()
                            .withOperationName("CreateConfiguredTable").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateConfiguredTableRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createConfiguredTableRequest));
            CompletableFuture<CreateConfiguredTableResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new analysis rule for a configured table. Currently, only one analysis rule can be created for a given
     * configured table.
     * </p>
     *
     * @param createConfiguredTableAnalysisRuleRequest
     * @return A Java Future containing the result of the CreateConfiguredTableAnalysisRule operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the specified constraints.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException Caller does not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsAsyncClient.CreateConfiguredTableAnalysisRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/CreateConfiguredTableAnalysisRule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateConfiguredTableAnalysisRuleResponse> createConfiguredTableAnalysisRule(
            CreateConfiguredTableAnalysisRuleRequest createConfiguredTableAnalysisRuleRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createConfiguredTableAnalysisRuleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createConfiguredTableAnalysisRuleRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRooms");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateConfiguredTableAnalysisRule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateConfiguredTableAnalysisRuleResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, CreateConfiguredTableAnalysisRuleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateConfiguredTableAnalysisRuleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateConfiguredTableAnalysisRuleRequest, CreateConfiguredTableAnalysisRuleResponse>()
                            .withOperationName("CreateConfiguredTableAnalysisRule").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateConfiguredTableAnalysisRuleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createConfiguredTableAnalysisRuleRequest));
            CompletableFuture<CreateConfiguredTableAnalysisRuleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a configured table association. A configured table association links a configured table with a
     * collaboration.
     * </p>
     *
     * @param createConfiguredTableAssociationRequest
     * @return A Java Future containing the result of the CreateConfiguredTableAssociation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ServiceQuotaExceededException Request denied because service quota has been exceeded.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the specified constraints.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException Caller does not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsAsyncClient.CreateConfiguredTableAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/CreateConfiguredTableAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateConfiguredTableAssociationResponse> createConfiguredTableAssociation(
            CreateConfiguredTableAssociationRequest createConfiguredTableAssociationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createConfiguredTableAssociationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createConfiguredTableAssociationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRooms");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateConfiguredTableAssociation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateConfiguredTableAssociationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, CreateConfiguredTableAssociationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateConfiguredTableAssociationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateConfiguredTableAssociationRequest, CreateConfiguredTableAssociationResponse>()
                            .withOperationName("CreateConfiguredTableAssociation").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateConfiguredTableAssociationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createConfiguredTableAssociationRequest));
            CompletableFuture<CreateConfiguredTableAssociationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new analysis rule for an associated configured table.
     * </p>
     *
     * @param createConfiguredTableAssociationAnalysisRuleRequest
     * @return A Java Future containing the result of the CreateConfiguredTableAssociationAnalysisRule operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the specified constraints.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException Caller does not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsAsyncClient.CreateConfiguredTableAssociationAnalysisRule
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/CreateConfiguredTableAssociationAnalysisRule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateConfiguredTableAssociationAnalysisRuleResponse> createConfiguredTableAssociationAnalysisRule(
            CreateConfiguredTableAssociationAnalysisRuleRequest createConfiguredTableAssociationAnalysisRuleRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                createConfiguredTableAssociationAnalysisRuleRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createConfiguredTableAssociationAnalysisRuleRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRooms");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateConfiguredTableAssociationAnalysisRule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateConfiguredTableAssociationAnalysisRuleResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, CreateConfiguredTableAssociationAnalysisRuleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateConfiguredTableAssociationAnalysisRuleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateConfiguredTableAssociationAnalysisRuleRequest, CreateConfiguredTableAssociationAnalysisRuleResponse>()
                            .withOperationName("CreateConfiguredTableAssociationAnalysisRule")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateConfiguredTableAssociationAnalysisRuleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createConfiguredTableAssociationAnalysisRuleRequest));
            CompletableFuture<CreateConfiguredTableAssociationAnalysisRuleResponse> whenCompleted = executeFuture.whenComplete((
                    r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an ID mapping table.
     * </p>
     *
     * @param createIdMappingTableRequest
     * @return A Java Future containing the result of the CreateIdMappingTable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ServiceQuotaExceededException Request denied because service quota has been exceeded.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the specified constraints.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException Caller does not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsAsyncClient.CreateIdMappingTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/CreateIdMappingTable"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateIdMappingTableResponse> createIdMappingTable(
            CreateIdMappingTableRequest createIdMappingTableRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createIdMappingTableRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createIdMappingTableRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRooms");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateIdMappingTable");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateIdMappingTableResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateIdMappingTableResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateIdMappingTableResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateIdMappingTableRequest, CreateIdMappingTableResponse>()
                            .withOperationName("CreateIdMappingTable").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateIdMappingTableRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createIdMappingTableRequest));
            CompletableFuture<CreateIdMappingTableResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an ID namespace association.
     * </p>
     *
     * @param createIdNamespaceAssociationRequest
     * @return A Java Future containing the result of the CreateIdNamespaceAssociation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ServiceQuotaExceededException Request denied because service quota has been exceeded.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the specified constraints.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException Caller does not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsAsyncClient.CreateIdNamespaceAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/CreateIdNamespaceAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateIdNamespaceAssociationResponse> createIdNamespaceAssociation(
            CreateIdNamespaceAssociationRequest createIdNamespaceAssociationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createIdNamespaceAssociationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createIdNamespaceAssociationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRooms");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateIdNamespaceAssociation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateIdNamespaceAssociationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateIdNamespaceAssociationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateIdNamespaceAssociationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateIdNamespaceAssociationRequest, CreateIdNamespaceAssociationResponse>()
                            .withOperationName("CreateIdNamespaceAssociation").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateIdNamespaceAssociationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createIdNamespaceAssociationRequest));
            CompletableFuture<CreateIdNamespaceAssociationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a membership for a specific collaboration identifier and joins the collaboration.
     * </p>
     *
     * @param createMembershipRequest
     * @return A Java Future containing the result of the CreateMembership operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ServiceQuotaExceededException Request denied because service quota has been exceeded.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the specified constraints.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException Caller does not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsAsyncClient.CreateMembership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/CreateMembership" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateMembershipResponse> createMembership(CreateMembershipRequest createMembershipRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createMembershipRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createMembershipRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRooms");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateMembership");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateMembershipResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateMembershipResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateMembershipResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateMembershipRequest, CreateMembershipResponse>()
                            .withOperationName("CreateMembership").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateMembershipRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createMembershipRequest));
            CompletableFuture<CreateMembershipResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a privacy budget template for a specified membership. Each membership can have only one privacy budget
     * template, but it can be deleted and recreated. If you need to change the privacy budget template for a
     * membership, use the <a>UpdatePrivacyBudgetTemplate</a> operation.
     * </p>
     *
     * @param createPrivacyBudgetTemplateRequest
     * @return A Java Future containing the result of the CreatePrivacyBudgetTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the specified constraints.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException Caller does not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsAsyncClient.CreatePrivacyBudgetTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/CreatePrivacyBudgetTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreatePrivacyBudgetTemplateResponse> createPrivacyBudgetTemplate(
            CreatePrivacyBudgetTemplateRequest createPrivacyBudgetTemplateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createPrivacyBudgetTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createPrivacyBudgetTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRooms");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreatePrivacyBudgetTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreatePrivacyBudgetTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreatePrivacyBudgetTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreatePrivacyBudgetTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreatePrivacyBudgetTemplateRequest, CreatePrivacyBudgetTemplateResponse>()
                            .withOperationName("CreatePrivacyBudgetTemplate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreatePrivacyBudgetTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createPrivacyBudgetTemplateRequest));
            CompletableFuture<CreatePrivacyBudgetTemplateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an analysis template.
     * </p>
     *
     * @param deleteAnalysisTemplateRequest
     * @return A Java Future containing the result of the DeleteAnalysisTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the specified constraints.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException Caller does not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsAsyncClient.DeleteAnalysisTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/DeleteAnalysisTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteAnalysisTemplateResponse> deleteAnalysisTemplate(
            DeleteAnalysisTemplateRequest deleteAnalysisTemplateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAnalysisTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAnalysisTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRooms");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAnalysisTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteAnalysisTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteAnalysisTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteAnalysisTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteAnalysisTemplateRequest, DeleteAnalysisTemplateResponse>()
                            .withOperationName("DeleteAnalysisTemplate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteAnalysisTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteAnalysisTemplateRequest));
            CompletableFuture<DeleteAnalysisTemplateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a collaboration. It can only be called by the collaboration owner.
     * </p>
     *
     * @param deleteCollaborationRequest
     * @return A Java Future containing the result of the DeleteCollaboration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the specified constraints.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException Caller does not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsAsyncClient.DeleteCollaboration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/DeleteCollaboration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteCollaborationResponse> deleteCollaboration(
            DeleteCollaborationRequest deleteCollaborationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteCollaborationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteCollaborationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRooms");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCollaboration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteCollaborationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteCollaborationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteCollaborationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteCollaborationRequest, DeleteCollaborationResponse>()
                            .withOperationName("DeleteCollaboration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteCollaborationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteCollaborationRequest));
            CompletableFuture<DeleteCollaborationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides the information necessary to delete a configured audience model association.
     * </p>
     *
     * @param deleteConfiguredAudienceModelAssociationRequest
     * @return A Java Future containing the result of the DeleteConfiguredAudienceModelAssociation operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the specified constraints.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException Caller does not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsAsyncClient.DeleteConfiguredAudienceModelAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/DeleteConfiguredAudienceModelAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteConfiguredAudienceModelAssociationResponse> deleteConfiguredAudienceModelAssociation(
            DeleteConfiguredAudienceModelAssociationRequest deleteConfiguredAudienceModelAssociationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                deleteConfiguredAudienceModelAssociationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteConfiguredAudienceModelAssociationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRooms");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteConfiguredAudienceModelAssociation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteConfiguredAudienceModelAssociationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DeleteConfiguredAudienceModelAssociationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteConfiguredAudienceModelAssociationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteConfiguredAudienceModelAssociationRequest, DeleteConfiguredAudienceModelAssociationResponse>()
                            .withOperationName("DeleteConfiguredAudienceModelAssociation").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteConfiguredAudienceModelAssociationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteConfiguredAudienceModelAssociationRequest));
            CompletableFuture<DeleteConfiguredAudienceModelAssociationResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a configured table.
     * </p>
     *
     * @param deleteConfiguredTableRequest
     * @return A Java Future containing the result of the DeleteConfiguredTable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the specified constraints.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException Caller does not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsAsyncClient.DeleteConfiguredTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/DeleteConfiguredTable"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteConfiguredTableResponse> deleteConfiguredTable(
            DeleteConfiguredTableRequest deleteConfiguredTableRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteConfiguredTableRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteConfiguredTableRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRooms");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteConfiguredTable");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteConfiguredTableResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteConfiguredTableResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteConfiguredTableResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteConfiguredTableRequest, DeleteConfiguredTableResponse>()
                            .withOperationName("DeleteConfiguredTable").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteConfiguredTableRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteConfiguredTableRequest));
            CompletableFuture<DeleteConfiguredTableResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a configured table analysis rule.
     * </p>
     *
     * @param deleteConfiguredTableAnalysisRuleRequest
     * @return A Java Future containing the result of the DeleteConfiguredTableAnalysisRule operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the specified constraints.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException Caller does not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsAsyncClient.DeleteConfiguredTableAnalysisRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/DeleteConfiguredTableAnalysisRule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteConfiguredTableAnalysisRuleResponse> deleteConfiguredTableAnalysisRule(
            DeleteConfiguredTableAnalysisRuleRequest deleteConfiguredTableAnalysisRuleRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteConfiguredTableAnalysisRuleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteConfiguredTableAnalysisRuleRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRooms");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteConfiguredTableAnalysisRule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteConfiguredTableAnalysisRuleResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DeleteConfiguredTableAnalysisRuleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteConfiguredTableAnalysisRuleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteConfiguredTableAnalysisRuleRequest, DeleteConfiguredTableAnalysisRuleResponse>()
                            .withOperationName("DeleteConfiguredTableAnalysisRule").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteConfiguredTableAnalysisRuleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteConfiguredTableAnalysisRuleRequest));
            CompletableFuture<DeleteConfiguredTableAnalysisRuleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a configured table association.
     * </p>
     *
     * @param deleteConfiguredTableAssociationRequest
     * @return A Java Future containing the result of the DeleteConfiguredTableAssociation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the specified constraints.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException Caller does not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsAsyncClient.DeleteConfiguredTableAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/DeleteConfiguredTableAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteConfiguredTableAssociationResponse> deleteConfiguredTableAssociation(
            DeleteConfiguredTableAssociationRequest deleteConfiguredTableAssociationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteConfiguredTableAssociationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteConfiguredTableAssociationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRooms");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteConfiguredTableAssociation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteConfiguredTableAssociationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DeleteConfiguredTableAssociationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteConfiguredTableAssociationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteConfiguredTableAssociationRequest, DeleteConfiguredTableAssociationResponse>()
                            .withOperationName("DeleteConfiguredTableAssociation").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteConfiguredTableAssociationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteConfiguredTableAssociationRequest));
            CompletableFuture<DeleteConfiguredTableAssociationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an analysis rule for a configured table association.
     * </p>
     *
     * @param deleteConfiguredTableAssociationAnalysisRuleRequest
     * @return A Java Future containing the result of the DeleteConfiguredTableAssociationAnalysisRule operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the specified constraints.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException Caller does not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsAsyncClient.DeleteConfiguredTableAssociationAnalysisRule
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/DeleteConfiguredTableAssociationAnalysisRule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteConfiguredTableAssociationAnalysisRuleResponse> deleteConfiguredTableAssociationAnalysisRule(
            DeleteConfiguredTableAssociationAnalysisRuleRequest deleteConfiguredTableAssociationAnalysisRuleRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                deleteConfiguredTableAssociationAnalysisRuleRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteConfiguredTableAssociationAnalysisRuleRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRooms");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteConfiguredTableAssociationAnalysisRule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteConfiguredTableAssociationAnalysisRuleResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DeleteConfiguredTableAssociationAnalysisRuleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteConfiguredTableAssociationAnalysisRuleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteConfiguredTableAssociationAnalysisRuleRequest, DeleteConfiguredTableAssociationAnalysisRuleResponse>()
                            .withOperationName("DeleteConfiguredTableAssociationAnalysisRule")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteConfiguredTableAssociationAnalysisRuleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteConfiguredTableAssociationAnalysisRuleRequest));
            CompletableFuture<DeleteConfiguredTableAssociationAnalysisRuleResponse> whenCompleted = executeFuture.whenComplete((
                    r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an ID mapping table.
     * </p>
     *
     * @param deleteIdMappingTableRequest
     * @return A Java Future containing the result of the DeleteIdMappingTable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the specified constraints.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException Caller does not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsAsyncClient.DeleteIdMappingTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/DeleteIdMappingTable"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteIdMappingTableResponse> deleteIdMappingTable(
            DeleteIdMappingTableRequest deleteIdMappingTableRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteIdMappingTableRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteIdMappingTableRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRooms");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteIdMappingTable");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteIdMappingTableResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteIdMappingTableResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteIdMappingTableResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteIdMappingTableRequest, DeleteIdMappingTableResponse>()
                            .withOperationName("DeleteIdMappingTable").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteIdMappingTableRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteIdMappingTableRequest));
            CompletableFuture<DeleteIdMappingTableResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an ID namespace association.
     * </p>
     *
     * @param deleteIdNamespaceAssociationRequest
     * @return A Java Future containing the result of the DeleteIdNamespaceAssociation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the specified constraints.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException Caller does not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsAsyncClient.DeleteIdNamespaceAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/DeleteIdNamespaceAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteIdNamespaceAssociationResponse> deleteIdNamespaceAssociation(
            DeleteIdNamespaceAssociationRequest deleteIdNamespaceAssociationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteIdNamespaceAssociationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteIdNamespaceAssociationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRooms");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteIdNamespaceAssociation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteIdNamespaceAssociationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteIdNamespaceAssociationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteIdNamespaceAssociationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteIdNamespaceAssociationRequest, DeleteIdNamespaceAssociationResponse>()
                            .withOperationName("DeleteIdNamespaceAssociation").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteIdNamespaceAssociationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteIdNamespaceAssociationRequest));
            CompletableFuture<DeleteIdNamespaceAssociationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes the specified member from a collaboration. The removed member is placed in the Removed status and can't
     * interact with the collaboration. The removed member's data is inaccessible to active members of the
     * collaboration.
     * </p>
     *
     * @param deleteMemberRequest
     * @return A Java Future containing the result of the DeleteMember operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the specified constraints.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException Caller does not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsAsyncClient.DeleteMember
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/DeleteMember" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteMemberResponse> deleteMember(DeleteMemberRequest deleteMemberRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteMemberRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteMemberRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRooms");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteMember");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteMemberResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteMemberResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteMemberResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteMemberRequest, DeleteMemberResponse>()
                            .withOperationName("DeleteMember").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteMemberRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteMemberRequest));
            CompletableFuture<DeleteMemberResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a specified membership. All resources under a membership must be deleted.
     * </p>
     *
     * @param deleteMembershipRequest
     * @return A Java Future containing the result of the DeleteMembership operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the specified constraints.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException Caller does not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsAsyncClient.DeleteMembership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/DeleteMembership" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteMembershipResponse> deleteMembership(DeleteMembershipRequest deleteMembershipRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteMembershipRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteMembershipRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRooms");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteMembership");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteMembershipResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteMembershipResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteMembershipResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteMembershipRequest, DeleteMembershipResponse>()
                            .withOperationName("DeleteMembership").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteMembershipRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteMembershipRequest));
            CompletableFuture<DeleteMembershipResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a privacy budget template for a specified membership.
     * </p>
     *
     * @param deletePrivacyBudgetTemplateRequest
     * @return A Java Future containing the result of the DeletePrivacyBudgetTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the specified constraints.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException Caller does not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsAsyncClient.DeletePrivacyBudgetTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/DeletePrivacyBudgetTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeletePrivacyBudgetTemplateResponse> deletePrivacyBudgetTemplate(
            DeletePrivacyBudgetTemplateRequest deletePrivacyBudgetTemplateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deletePrivacyBudgetTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deletePrivacyBudgetTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRooms");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeletePrivacyBudgetTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeletePrivacyBudgetTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeletePrivacyBudgetTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeletePrivacyBudgetTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeletePrivacyBudgetTemplateRequest, DeletePrivacyBudgetTemplateResponse>()
                            .withOperationName("DeletePrivacyBudgetTemplate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeletePrivacyBudgetTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deletePrivacyBudgetTemplateRequest));
            CompletableFuture<DeletePrivacyBudgetTemplateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves an analysis template.
     * </p>
     *
     * @param getAnalysisTemplateRequest
     * @return A Java Future containing the result of the GetAnalysisTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the specified constraints.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException Caller does not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsAsyncClient.GetAnalysisTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/GetAnalysisTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetAnalysisTemplateResponse> getAnalysisTemplate(
            GetAnalysisTemplateRequest getAnalysisTemplateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getAnalysisTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAnalysisTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRooms");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAnalysisTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetAnalysisTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetAnalysisTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetAnalysisTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetAnalysisTemplateRequest, GetAnalysisTemplateResponse>()
                            .withOperationName("GetAnalysisTemplate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetAnalysisTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getAnalysisTemplateRequest));
            CompletableFuture<GetAnalysisTemplateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns metadata about a collaboration.
     * </p>
     *
     * @param getCollaborationRequest
     * @return A Java Future containing the result of the GetCollaboration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the specified constraints.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException Caller does not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsAsyncClient.GetCollaboration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/GetCollaboration" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetCollaborationResponse> getCollaboration(GetCollaborationRequest getCollaborationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getCollaborationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getCollaborationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRooms");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCollaboration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetCollaborationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetCollaborationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetCollaborationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetCollaborationRequest, GetCollaborationResponse>()
                            .withOperationName("GetCollaboration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetCollaborationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getCollaborationRequest));
            CompletableFuture<GetCollaborationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves an analysis template within a collaboration.
     * </p>
     *
     * @param getCollaborationAnalysisTemplateRequest
     * @return A Java Future containing the result of the GetCollaborationAnalysisTemplate operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the specified constraints.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException Caller does not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsAsyncClient.GetCollaborationAnalysisTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/GetCollaborationAnalysisTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetCollaborationAnalysisTemplateResponse> getCollaborationAnalysisTemplate(
            GetCollaborationAnalysisTemplateRequest getCollaborationAnalysisTemplateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getCollaborationAnalysisTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getCollaborationAnalysisTemplateRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRooms");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCollaborationAnalysisTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetCollaborationAnalysisTemplateResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, GetCollaborationAnalysisTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetCollaborationAnalysisTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetCollaborationAnalysisTemplateRequest, GetCollaborationAnalysisTemplateResponse>()
                            .withOperationName("GetCollaborationAnalysisTemplate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetCollaborationAnalysisTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getCollaborationAnalysisTemplateRequest));
            CompletableFuture<GetCollaborationAnalysisTemplateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves a configured audience model association within a collaboration.
     * </p>
     *
     * @param getCollaborationConfiguredAudienceModelAssociationRequest
     * @return A Java Future containing the result of the GetCollaborationConfiguredAudienceModelAssociation operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the specified constraints.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException Caller does not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsAsyncClient.GetCollaborationConfiguredAudienceModelAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/GetCollaborationConfiguredAudienceModelAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetCollaborationConfiguredAudienceModelAssociationResponse> getCollaborationConfiguredAudienceModelAssociation(
            GetCollaborationConfiguredAudienceModelAssociationRequest getCollaborationConfiguredAudienceModelAssociationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                getCollaborationConfiguredAudienceModelAssociationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getCollaborationConfiguredAudienceModelAssociationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRooms");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCollaborationConfiguredAudienceModelAssociation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetCollaborationConfiguredAudienceModelAssociationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, GetCollaborationConfiguredAudienceModelAssociationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetCollaborationConfiguredAudienceModelAssociationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetCollaborationConfiguredAudienceModelAssociationRequest, GetCollaborationConfiguredAudienceModelAssociationResponse>()
                            .withOperationName("GetCollaborationConfiguredAudienceModelAssociation")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(
                                    new GetCollaborationConfiguredAudienceModelAssociationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getCollaborationConfiguredAudienceModelAssociationRequest));
            CompletableFuture<GetCollaborationConfiguredAudienceModelAssociationResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves an ID namespace association from a specific collaboration.
     * </p>
     *
     * @param getCollaborationIdNamespaceAssociationRequest
     * @return A Java Future containing the result of the GetCollaborationIdNamespaceAssociation operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the specified constraints.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException Caller does not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsAsyncClient.GetCollaborationIdNamespaceAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/GetCollaborationIdNamespaceAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetCollaborationIdNamespaceAssociationResponse> getCollaborationIdNamespaceAssociation(
            GetCollaborationIdNamespaceAssociationRequest getCollaborationIdNamespaceAssociationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getCollaborationIdNamespaceAssociationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getCollaborationIdNamespaceAssociationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRooms");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCollaborationIdNamespaceAssociation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetCollaborationIdNamespaceAssociationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, GetCollaborationIdNamespaceAssociationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetCollaborationIdNamespaceAssociationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetCollaborationIdNamespaceAssociationRequest, GetCollaborationIdNamespaceAssociationResponse>()
                            .withOperationName("GetCollaborationIdNamespaceAssociation").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetCollaborationIdNamespaceAssociationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getCollaborationIdNamespaceAssociationRequest));
            CompletableFuture<GetCollaborationIdNamespaceAssociationResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns details about a specified privacy budget template.
     * </p>
     *
     * @param getCollaborationPrivacyBudgetTemplateRequest
     * @return A Java Future containing the result of the GetCollaborationPrivacyBudgetTemplate operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the specified constraints.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException Caller does not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsAsyncClient.GetCollaborationPrivacyBudgetTemplate
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/GetCollaborationPrivacyBudgetTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetCollaborationPrivacyBudgetTemplateResponse> getCollaborationPrivacyBudgetTemplate(
            GetCollaborationPrivacyBudgetTemplateRequest getCollaborationPrivacyBudgetTemplateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getCollaborationPrivacyBudgetTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getCollaborationPrivacyBudgetTemplateRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRooms");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCollaborationPrivacyBudgetTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetCollaborationPrivacyBudgetTemplateResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, GetCollaborationPrivacyBudgetTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetCollaborationPrivacyBudgetTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetCollaborationPrivacyBudgetTemplateRequest, GetCollaborationPrivacyBudgetTemplateResponse>()
                            .withOperationName("GetCollaborationPrivacyBudgetTemplate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetCollaborationPrivacyBudgetTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getCollaborationPrivacyBudgetTemplateRequest));
            CompletableFuture<GetCollaborationPrivacyBudgetTemplateResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about a configured audience model association.
     * </p>
     *
     * @param getConfiguredAudienceModelAssociationRequest
     * @return A Java Future containing the result of the GetConfiguredAudienceModelAssociation operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the specified constraints.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException Caller does not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsAsyncClient.GetConfiguredAudienceModelAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/GetConfiguredAudienceModelAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetConfiguredAudienceModelAssociationResponse> getConfiguredAudienceModelAssociation(
            GetConfiguredAudienceModelAssociationRequest getConfiguredAudienceModelAssociationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getConfiguredAudienceModelAssociationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getConfiguredAudienceModelAssociationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRooms");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetConfiguredAudienceModelAssociation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetConfiguredAudienceModelAssociationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, GetConfiguredAudienceModelAssociationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetConfiguredAudienceModelAssociationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetConfiguredAudienceModelAssociationRequest, GetConfiguredAudienceModelAssociationResponse>()
                            .withOperationName("GetConfiguredAudienceModelAssociation").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetConfiguredAudienceModelAssociationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getConfiguredAudienceModelAssociationRequest));
            CompletableFuture<GetConfiguredAudienceModelAssociationResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves a configured table.
     * </p>
     *
     * @param getConfiguredTableRequest
     * @return A Java Future containing the result of the GetConfiguredTable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the specified constraints.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException Caller does not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsAsyncClient.GetConfiguredTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/GetConfiguredTable" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetConfiguredTableResponse> getConfiguredTable(GetConfiguredTableRequest getConfiguredTableRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getConfiguredTableRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getConfiguredTableRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRooms");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetConfiguredTable");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetConfiguredTableResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetConfiguredTableResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetConfiguredTableResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetConfiguredTableRequest, GetConfiguredTableResponse>()
                            .withOperationName("GetConfiguredTable").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetConfiguredTableRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getConfiguredTableRequest));
            CompletableFuture<GetConfiguredTableResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves a configured table analysis rule.
     * </p>
     *
     * @param getConfiguredTableAnalysisRuleRequest
     * @return A Java Future containing the result of the GetConfiguredTableAnalysisRule operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the specified constraints.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException Caller does not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsAsyncClient.GetConfiguredTableAnalysisRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/GetConfiguredTableAnalysisRule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetConfiguredTableAnalysisRuleResponse> getConfiguredTableAnalysisRule(
            GetConfiguredTableAnalysisRuleRequest getConfiguredTableAnalysisRuleRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getConfiguredTableAnalysisRuleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getConfiguredTableAnalysisRuleRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRooms");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetConfiguredTableAnalysisRule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetConfiguredTableAnalysisRuleResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetConfiguredTableAnalysisRuleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetConfiguredTableAnalysisRuleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetConfiguredTableAnalysisRuleRequest, GetConfiguredTableAnalysisRuleResponse>()
                            .withOperationName("GetConfiguredTableAnalysisRule").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetConfiguredTableAnalysisRuleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getConfiguredTableAnalysisRuleRequest));
            CompletableFuture<GetConfiguredTableAnalysisRuleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves a configured table association.
     * </p>
     *
     * @param getConfiguredTableAssociationRequest
     * @return A Java Future containing the result of the GetConfiguredTableAssociation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the specified constraints.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException Caller does not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsAsyncClient.GetConfiguredTableAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/GetConfiguredTableAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetConfiguredTableAssociationResponse> getConfiguredTableAssociation(
            GetConfiguredTableAssociationRequest getConfiguredTableAssociationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getConfiguredTableAssociationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getConfiguredTableAssociationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRooms");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetConfiguredTableAssociation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetConfiguredTableAssociationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetConfiguredTableAssociationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetConfiguredTableAssociationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetConfiguredTableAssociationRequest, GetConfiguredTableAssociationResponse>()
                            .withOperationName("GetConfiguredTableAssociation").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetConfiguredTableAssociationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getConfiguredTableAssociationRequest));
            CompletableFuture<GetConfiguredTableAssociationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the analysis rule for a configured table association.
     * </p>
     *
     * @param getConfiguredTableAssociationAnalysisRuleRequest
     * @return A Java Future containing the result of the GetConfiguredTableAssociationAnalysisRule operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the specified constraints.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException Caller does not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsAsyncClient.GetConfiguredTableAssociationAnalysisRule
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/GetConfiguredTableAssociationAnalysisRule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetConfiguredTableAssociationAnalysisRuleResponse> getConfiguredTableAssociationAnalysisRule(
            GetConfiguredTableAssociationAnalysisRuleRequest getConfiguredTableAssociationAnalysisRuleRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                getConfiguredTableAssociationAnalysisRuleRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getConfiguredTableAssociationAnalysisRuleRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRooms");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetConfiguredTableAssociationAnalysisRule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetConfiguredTableAssociationAnalysisRuleResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, GetConfiguredTableAssociationAnalysisRuleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetConfiguredTableAssociationAnalysisRuleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetConfiguredTableAssociationAnalysisRuleRequest, GetConfiguredTableAssociationAnalysisRuleResponse>()
                            .withOperationName("GetConfiguredTableAssociationAnalysisRule")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetConfiguredTableAssociationAnalysisRuleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getConfiguredTableAssociationAnalysisRuleRequest));
            CompletableFuture<GetConfiguredTableAssociationAnalysisRuleResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves an ID mapping table.
     * </p>
     *
     * @param getIdMappingTableRequest
     * @return A Java Future containing the result of the GetIdMappingTable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the specified constraints.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException Caller does not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsAsyncClient.GetIdMappingTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/GetIdMappingTable" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetIdMappingTableResponse> getIdMappingTable(GetIdMappingTableRequest getIdMappingTableRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getIdMappingTableRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getIdMappingTableRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRooms");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetIdMappingTable");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetIdMappingTableResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetIdMappingTableResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetIdMappingTableResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetIdMappingTableRequest, GetIdMappingTableResponse>()
                            .withOperationName("GetIdMappingTable").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetIdMappingTableRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getIdMappingTableRequest));
            CompletableFuture<GetIdMappingTableResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves an ID namespace association.
     * </p>
     *
     * @param getIdNamespaceAssociationRequest
     * @return A Java Future containing the result of the GetIdNamespaceAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the specified constraints.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException Caller does not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsAsyncClient.GetIdNamespaceAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/GetIdNamespaceAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetIdNamespaceAssociationResponse> getIdNamespaceAssociation(
            GetIdNamespaceAssociationRequest getIdNamespaceAssociationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getIdNamespaceAssociationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getIdNamespaceAssociationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRooms");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetIdNamespaceAssociation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetIdNamespaceAssociationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetIdNamespaceAssociationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetIdNamespaceAssociationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetIdNamespaceAssociationRequest, GetIdNamespaceAssociationResponse>()
                            .withOperationName("GetIdNamespaceAssociation").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetIdNamespaceAssociationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getIdNamespaceAssociationRequest));
            CompletableFuture<GetIdNamespaceAssociationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves a specified membership for an identifier.
     * </p>
     *
     * @param getMembershipRequest
     * @return A Java Future containing the result of the GetMembership operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the specified constraints.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException Caller does not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsAsyncClient.GetMembership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/GetMembership" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetMembershipResponse> getMembership(GetMembershipRequest getMembershipRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getMembershipRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getMembershipRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRooms");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetMembership");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetMembershipResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetMembershipResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetMembershipResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetMembershipRequest, GetMembershipResponse>()
                            .withOperationName("GetMembership").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetMembershipRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getMembershipRequest));
            CompletableFuture<GetMembershipResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns details for a specified privacy budget template.
     * </p>
     *
     * @param getPrivacyBudgetTemplateRequest
     * @return A Java Future containing the result of the GetPrivacyBudgetTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the specified constraints.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException Caller does not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsAsyncClient.GetPrivacyBudgetTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/GetPrivacyBudgetTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetPrivacyBudgetTemplateResponse> getPrivacyBudgetTemplate(
            GetPrivacyBudgetTemplateRequest getPrivacyBudgetTemplateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getPrivacyBudgetTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getPrivacyBudgetTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRooms");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetPrivacyBudgetTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetPrivacyBudgetTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetPrivacyBudgetTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetPrivacyBudgetTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetPrivacyBudgetTemplateRequest, GetPrivacyBudgetTemplateResponse>()
                            .withOperationName("GetPrivacyBudgetTemplate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetPrivacyBudgetTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getPrivacyBudgetTemplateRequest));
            CompletableFuture<GetPrivacyBudgetTemplateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns query processing metadata.
     * </p>
     *
     * @param getProtectedQueryRequest
     * @return A Java Future containing the result of the GetProtectedQuery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the specified constraints.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException Caller does not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsAsyncClient.GetProtectedQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/GetProtectedQuery" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetProtectedQueryResponse> getProtectedQuery(GetProtectedQueryRequest getProtectedQueryRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getProtectedQueryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getProtectedQueryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRooms");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetProtectedQuery");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetProtectedQueryResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetProtectedQueryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetProtectedQueryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetProtectedQueryRequest, GetProtectedQueryResponse>()
                            .withOperationName("GetProtectedQuery").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetProtectedQueryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getProtectedQueryRequest));
            CompletableFuture<GetProtectedQueryResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the schema for a relation within a collaboration.
     * </p>
     *
     * @param getSchemaRequest
     * @return A Java Future containing the result of the GetSchema operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the specified constraints.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException Caller does not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsAsyncClient.GetSchema
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/GetSchema" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetSchemaResponse> getSchema(GetSchemaRequest getSchemaRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getSchemaRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSchemaRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRooms");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSchema");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetSchemaResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetSchemaResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetSchemaResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetSchemaRequest, GetSchemaResponse>().withOperationName("GetSchema")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetSchemaRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(getSchemaRequest));
            CompletableFuture<GetSchemaResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves a schema analysis rule.
     * </p>
     *
     * @param getSchemaAnalysisRuleRequest
     * @return A Java Future containing the result of the GetSchemaAnalysisRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the specified constraints.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException Caller does not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsAsyncClient.GetSchemaAnalysisRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/GetSchemaAnalysisRule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetSchemaAnalysisRuleResponse> getSchemaAnalysisRule(
            GetSchemaAnalysisRuleRequest getSchemaAnalysisRuleRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getSchemaAnalysisRuleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSchemaAnalysisRuleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRooms");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSchemaAnalysisRule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetSchemaAnalysisRuleResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetSchemaAnalysisRuleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetSchemaAnalysisRuleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetSchemaAnalysisRuleRequest, GetSchemaAnalysisRuleResponse>()
                            .withOperationName("GetSchemaAnalysisRule").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetSchemaAnalysisRuleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getSchemaAnalysisRuleRequest));
            CompletableFuture<GetSchemaAnalysisRuleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists analysis templates that the caller owns.
     * </p>
     *
     * @param listAnalysisTemplatesRequest
     * @return A Java Future containing the result of the ListAnalysisTemplates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the specified constraints.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException Caller does not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsAsyncClient.ListAnalysisTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListAnalysisTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListAnalysisTemplatesResponse> listAnalysisTemplates(
            ListAnalysisTemplatesRequest listAnalysisTemplatesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAnalysisTemplatesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAnalysisTemplatesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRooms");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAnalysisTemplates");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListAnalysisTemplatesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListAnalysisTemplatesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListAnalysisTemplatesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAnalysisTemplatesRequest, ListAnalysisTemplatesResponse>()
                            .withOperationName("ListAnalysisTemplates").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListAnalysisTemplatesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listAnalysisTemplatesRequest));
            CompletableFuture<ListAnalysisTemplatesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists analysis templates within a collaboration.
     * </p>
     *
     * @param listCollaborationAnalysisTemplatesRequest
     * @return A Java Future containing the result of the ListCollaborationAnalysisTemplates operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the specified constraints.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException Caller does not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsAsyncClient.ListCollaborationAnalysisTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListCollaborationAnalysisTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListCollaborationAnalysisTemplatesResponse> listCollaborationAnalysisTemplates(
            ListCollaborationAnalysisTemplatesRequest listCollaborationAnalysisTemplatesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listCollaborationAnalysisTemplatesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listCollaborationAnalysisTemplatesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRooms");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCollaborationAnalysisTemplates");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListCollaborationAnalysisTemplatesResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, ListCollaborationAnalysisTemplatesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListCollaborationAnalysisTemplatesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListCollaborationAnalysisTemplatesRequest, ListCollaborationAnalysisTemplatesResponse>()
                            .withOperationName("ListCollaborationAnalysisTemplates").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListCollaborationAnalysisTemplatesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listCollaborationAnalysisTemplatesRequest));
            CompletableFuture<ListCollaborationAnalysisTemplatesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists configured audience model associations within a collaboration.
     * </p>
     *
     * @param listCollaborationConfiguredAudienceModelAssociationsRequest
     * @return A Java Future containing the result of the ListCollaborationConfiguredAudienceModelAssociations operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the specified constraints.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException Caller does not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsAsyncClient.ListCollaborationConfiguredAudienceModelAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListCollaborationConfiguredAudienceModelAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListCollaborationConfiguredAudienceModelAssociationsResponse> listCollaborationConfiguredAudienceModelAssociations(
            ListCollaborationConfiguredAudienceModelAssociationsRequest listCollaborationConfiguredAudienceModelAssociationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                listCollaborationConfiguredAudienceModelAssociationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listCollaborationConfiguredAudienceModelAssociationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRooms");
            apiCallMetricCollector
                    .reportMetric(CoreMetric.OPERATION_NAME, "ListCollaborationConfiguredAudienceModelAssociations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListCollaborationConfiguredAudienceModelAssociationsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata,
                            ListCollaborationConfiguredAudienceModelAssociationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListCollaborationConfiguredAudienceModelAssociationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListCollaborationConfiguredAudienceModelAssociationsRequest, ListCollaborationConfiguredAudienceModelAssociationsResponse>()
                            .withOperationName("ListCollaborationConfiguredAudienceModelAssociations")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(
                                    new ListCollaborationConfiguredAudienceModelAssociationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listCollaborationConfiguredAudienceModelAssociationsRequest));
            CompletableFuture<ListCollaborationConfiguredAudienceModelAssociationsResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of the ID namespace associations in a collaboration.
     * </p>
     *
     * @param listCollaborationIdNamespaceAssociationsRequest
     * @return A Java Future containing the result of the ListCollaborationIdNamespaceAssociations operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the specified constraints.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException Caller does not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsAsyncClient.ListCollaborationIdNamespaceAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListCollaborationIdNamespaceAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListCollaborationIdNamespaceAssociationsResponse> listCollaborationIdNamespaceAssociations(
            ListCollaborationIdNamespaceAssociationsRequest listCollaborationIdNamespaceAssociationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                listCollaborationIdNamespaceAssociationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listCollaborationIdNamespaceAssociationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRooms");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCollaborationIdNamespaceAssociations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListCollaborationIdNamespaceAssociationsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, ListCollaborationIdNamespaceAssociationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListCollaborationIdNamespaceAssociationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListCollaborationIdNamespaceAssociationsRequest, ListCollaborationIdNamespaceAssociationsResponse>()
                            .withOperationName("ListCollaborationIdNamespaceAssociations").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListCollaborationIdNamespaceAssociationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listCollaborationIdNamespaceAssociationsRequest));
            CompletableFuture<ListCollaborationIdNamespaceAssociationsResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns an array that summarizes each privacy budget template in a specified collaboration.
     * </p>
     *
     * @param listCollaborationPrivacyBudgetTemplatesRequest
     * @return A Java Future containing the result of the ListCollaborationPrivacyBudgetTemplates operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the specified constraints.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException Caller does not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsAsyncClient.ListCollaborationPrivacyBudgetTemplates
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListCollaborationPrivacyBudgetTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListCollaborationPrivacyBudgetTemplatesResponse> listCollaborationPrivacyBudgetTemplates(
            ListCollaborationPrivacyBudgetTemplatesRequest listCollaborationPrivacyBudgetTemplatesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listCollaborationPrivacyBudgetTemplatesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listCollaborationPrivacyBudgetTemplatesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRooms");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCollaborationPrivacyBudgetTemplates");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListCollaborationPrivacyBudgetTemplatesResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, ListCollaborationPrivacyBudgetTemplatesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListCollaborationPrivacyBudgetTemplatesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListCollaborationPrivacyBudgetTemplatesRequest, ListCollaborationPrivacyBudgetTemplatesResponse>()
                            .withOperationName("ListCollaborationPrivacyBudgetTemplates").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListCollaborationPrivacyBudgetTemplatesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listCollaborationPrivacyBudgetTemplatesRequest));
            CompletableFuture<ListCollaborationPrivacyBudgetTemplatesResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns an array that summarizes each privacy budget in a specified collaboration. The summary includes the
     * collaboration ARN, creation time, creating account, and privacy budget details.
     * </p>
     *
     * @param listCollaborationPrivacyBudgetsRequest
     * @return A Java Future containing the result of the ListCollaborationPrivacyBudgets operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the specified constraints.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException Caller does not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsAsyncClient.ListCollaborationPrivacyBudgets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListCollaborationPrivacyBudgets"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListCollaborationPrivacyBudgetsResponse> listCollaborationPrivacyBudgets(
            ListCollaborationPrivacyBudgetsRequest listCollaborationPrivacyBudgetsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listCollaborationPrivacyBudgetsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listCollaborationPrivacyBudgetsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRooms");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCollaborationPrivacyBudgets");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListCollaborationPrivacyBudgetsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListCollaborationPrivacyBudgetsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListCollaborationPrivacyBudgetsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListCollaborationPrivacyBudgetsRequest, ListCollaborationPrivacyBudgetsResponse>()
                            .withOperationName("ListCollaborationPrivacyBudgets").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListCollaborationPrivacyBudgetsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listCollaborationPrivacyBudgetsRequest));
            CompletableFuture<ListCollaborationPrivacyBudgetsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists collaborations the caller owns, is active in, or has been invited to.
     * </p>
     *
     * @param listCollaborationsRequest
     * @return A Java Future containing the result of the ListCollaborations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the specified constraints.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException Caller does not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsAsyncClient.ListCollaborations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListCollaborations" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListCollaborationsResponse> listCollaborations(ListCollaborationsRequest listCollaborationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listCollaborationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listCollaborationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRooms");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCollaborations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListCollaborationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListCollaborationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListCollaborationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListCollaborationsRequest, ListCollaborationsResponse>()
                            .withOperationName("ListCollaborations").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListCollaborationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listCollaborationsRequest));
            CompletableFuture<ListCollaborationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists information about requested configured audience model associations.
     * </p>
     *
     * @param listConfiguredAudienceModelAssociationsRequest
     * @return A Java Future containing the result of the ListConfiguredAudienceModelAssociations operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the specified constraints.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException Caller does not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsAsyncClient.ListConfiguredAudienceModelAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListConfiguredAudienceModelAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListConfiguredAudienceModelAssociationsResponse> listConfiguredAudienceModelAssociations(
            ListConfiguredAudienceModelAssociationsRequest listConfiguredAudienceModelAssociationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listConfiguredAudienceModelAssociationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listConfiguredAudienceModelAssociationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRooms");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListConfiguredAudienceModelAssociations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListConfiguredAudienceModelAssociationsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, ListConfiguredAudienceModelAssociationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListConfiguredAudienceModelAssociationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListConfiguredAudienceModelAssociationsRequest, ListConfiguredAudienceModelAssociationsResponse>()
                            .withOperationName("ListConfiguredAudienceModelAssociations").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListConfiguredAudienceModelAssociationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listConfiguredAudienceModelAssociationsRequest));
            CompletableFuture<ListConfiguredAudienceModelAssociationsResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists configured table associations for a membership.
     * </p>
     *
     * @param listConfiguredTableAssociationsRequest
     * @return A Java Future containing the result of the ListConfiguredTableAssociations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the specified constraints.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException Caller does not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsAsyncClient.ListConfiguredTableAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListConfiguredTableAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListConfiguredTableAssociationsResponse> listConfiguredTableAssociations(
            ListConfiguredTableAssociationsRequest listConfiguredTableAssociationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listConfiguredTableAssociationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listConfiguredTableAssociationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRooms");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListConfiguredTableAssociations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListConfiguredTableAssociationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListConfiguredTableAssociationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListConfiguredTableAssociationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListConfiguredTableAssociationsRequest, ListConfiguredTableAssociationsResponse>()
                            .withOperationName("ListConfiguredTableAssociations").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListConfiguredTableAssociationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listConfiguredTableAssociationsRequest));
            CompletableFuture<ListConfiguredTableAssociationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists configured tables.
     * </p>
     *
     * @param listConfiguredTablesRequest
     * @return A Java Future containing the result of the ListConfiguredTables operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the specified constraints.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException Caller does not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsAsyncClient.ListConfiguredTables
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListConfiguredTables"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListConfiguredTablesResponse> listConfiguredTables(
            ListConfiguredTablesRequest listConfiguredTablesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listConfiguredTablesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listConfiguredTablesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRooms");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListConfiguredTables");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListConfiguredTablesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListConfiguredTablesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListConfiguredTablesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListConfiguredTablesRequest, ListConfiguredTablesResponse>()
                            .withOperationName("ListConfiguredTables").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListConfiguredTablesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listConfiguredTablesRequest));
            CompletableFuture<ListConfiguredTablesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of ID mapping tables.
     * </p>
     *
     * @param listIdMappingTablesRequest
     * @return A Java Future containing the result of the ListIdMappingTables operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the specified constraints.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException Caller does not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsAsyncClient.ListIdMappingTables
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListIdMappingTables"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListIdMappingTablesResponse> listIdMappingTables(
            ListIdMappingTablesRequest listIdMappingTablesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listIdMappingTablesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listIdMappingTablesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRooms");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListIdMappingTables");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListIdMappingTablesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListIdMappingTablesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListIdMappingTablesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListIdMappingTablesRequest, ListIdMappingTablesResponse>()
                            .withOperationName("ListIdMappingTables").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListIdMappingTablesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listIdMappingTablesRequest));
            CompletableFuture<ListIdMappingTablesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of ID namespace associations.
     * </p>
     *
     * @param listIdNamespaceAssociationsRequest
     * @return A Java Future containing the result of the ListIdNamespaceAssociations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the specified constraints.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException Caller does not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsAsyncClient.ListIdNamespaceAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListIdNamespaceAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListIdNamespaceAssociationsResponse> listIdNamespaceAssociations(
            ListIdNamespaceAssociationsRequest listIdNamespaceAssociationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listIdNamespaceAssociationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listIdNamespaceAssociationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRooms");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListIdNamespaceAssociations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListIdNamespaceAssociationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListIdNamespaceAssociationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListIdNamespaceAssociationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListIdNamespaceAssociationsRequest, ListIdNamespaceAssociationsResponse>()
                            .withOperationName("ListIdNamespaceAssociations").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListIdNamespaceAssociationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listIdNamespaceAssociationsRequest));
            CompletableFuture<ListIdNamespaceAssociationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all members within a collaboration.
     * </p>
     *
     * @param listMembersRequest
     * @return A Java Future containing the result of the ListMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the specified constraints.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException Caller does not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsAsyncClient.ListMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListMembers" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListMembersResponse> listMembers(ListMembersRequest listMembersRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listMembersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listMembersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRooms");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListMembers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListMembersResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListMembersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListMembersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListMembersRequest, ListMembersResponse>()
                            .withOperationName("ListMembers").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListMembersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listMembersRequest));
            CompletableFuture<ListMembersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all memberships resources within the caller's account.
     * </p>
     *
     * @param listMembershipsRequest
     * @return A Java Future containing the result of the ListMemberships operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the specified constraints.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException Caller does not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsAsyncClient.ListMemberships
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListMemberships" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListMembershipsResponse> listMemberships(ListMembershipsRequest listMembershipsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listMembershipsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listMembershipsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRooms");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListMemberships");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListMembershipsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListMembershipsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListMembershipsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListMembershipsRequest, ListMembershipsResponse>()
                            .withOperationName("ListMemberships").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListMembershipsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listMembershipsRequest));
            CompletableFuture<ListMembershipsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns detailed information about the privacy budget templates in a specified membership.
     * </p>
     *
     * @param listPrivacyBudgetTemplatesRequest
     * @return A Java Future containing the result of the ListPrivacyBudgetTemplates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the specified constraints.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException Caller does not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsAsyncClient.ListPrivacyBudgetTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListPrivacyBudgetTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListPrivacyBudgetTemplatesResponse> listPrivacyBudgetTemplates(
            ListPrivacyBudgetTemplatesRequest listPrivacyBudgetTemplatesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listPrivacyBudgetTemplatesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listPrivacyBudgetTemplatesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRooms");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListPrivacyBudgetTemplates");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListPrivacyBudgetTemplatesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListPrivacyBudgetTemplatesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListPrivacyBudgetTemplatesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListPrivacyBudgetTemplatesRequest, ListPrivacyBudgetTemplatesResponse>()
                            .withOperationName("ListPrivacyBudgetTemplates").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListPrivacyBudgetTemplatesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listPrivacyBudgetTemplatesRequest));
            CompletableFuture<ListPrivacyBudgetTemplatesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns detailed information about the privacy budgets in a specified membership.
     * </p>
     *
     * @param listPrivacyBudgetsRequest
     * @return A Java Future containing the result of the ListPrivacyBudgets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the specified constraints.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException Caller does not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsAsyncClient.ListPrivacyBudgets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListPrivacyBudgets" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListPrivacyBudgetsResponse> listPrivacyBudgets(ListPrivacyBudgetsRequest listPrivacyBudgetsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listPrivacyBudgetsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listPrivacyBudgetsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRooms");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListPrivacyBudgets");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListPrivacyBudgetsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListPrivacyBudgetsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListPrivacyBudgetsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListPrivacyBudgetsRequest, ListPrivacyBudgetsResponse>()
                            .withOperationName("ListPrivacyBudgets").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListPrivacyBudgetsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listPrivacyBudgetsRequest));
            CompletableFuture<ListPrivacyBudgetsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists protected queries, sorted by the most recent query.
     * </p>
     *
     * @param listProtectedQueriesRequest
     * @return A Java Future containing the result of the ListProtectedQueries operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the specified constraints.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException Caller does not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsAsyncClient.ListProtectedQueries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListProtectedQueries"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListProtectedQueriesResponse> listProtectedQueries(
            ListProtectedQueriesRequest listProtectedQueriesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listProtectedQueriesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listProtectedQueriesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRooms");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListProtectedQueries");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListProtectedQueriesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListProtectedQueriesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListProtectedQueriesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListProtectedQueriesRequest, ListProtectedQueriesResponse>()
                            .withOperationName("ListProtectedQueries").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListProtectedQueriesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listProtectedQueriesRequest));
            CompletableFuture<ListProtectedQueriesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the schemas for relations within a collaboration.
     * </p>
     *
     * @param listSchemasRequest
     * @return A Java Future containing the result of the ListSchemas operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the specified constraints.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException Caller does not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsAsyncClient.ListSchemas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListSchemas" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListSchemasResponse> listSchemas(ListSchemasRequest listSchemasRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listSchemasRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listSchemasRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRooms");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSchemas");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListSchemasResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListSchemasResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListSchemasResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListSchemasRequest, ListSchemasResponse>()
                            .withOperationName("ListSchemas").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListSchemasRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listSchemasRequest));
            CompletableFuture<ListSchemasResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all of the tags that have been added to a resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ValidationException The input fails to satisfy the specified constraints.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRooms");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTagsForResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTagsForResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                            .withOperationName("ListTagsForResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listTagsForResourceRequest));
            CompletableFuture<ListTagsForResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Defines the information that's necessary to populate an ID mapping table.
     * </p>
     *
     * @param populateIdMappingTableRequest
     * @return A Java Future containing the result of the PopulateIdMappingTable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ServiceQuotaExceededException Request denied because service quota has been exceeded.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the specified constraints.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException Caller does not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsAsyncClient.PopulateIdMappingTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/PopulateIdMappingTable"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PopulateIdMappingTableResponse> populateIdMappingTable(
            PopulateIdMappingTableRequest populateIdMappingTableRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(populateIdMappingTableRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, populateIdMappingTableRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRooms");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PopulateIdMappingTable");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PopulateIdMappingTableResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PopulateIdMappingTableResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PopulateIdMappingTableResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PopulateIdMappingTableRequest, PopulateIdMappingTableResponse>()
                            .withOperationName("PopulateIdMappingTable").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PopulateIdMappingTableRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(populateIdMappingTableRequest));
            CompletableFuture<PopulateIdMappingTableResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * An estimate of the number of aggregation functions that the member who can query can run given epsilon and noise
     * parameters.
     * </p>
     *
     * @param previewPrivacyImpactRequest
     * @return A Java Future containing the result of the PreviewPrivacyImpact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the specified constraints.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException Caller does not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsAsyncClient.PreviewPrivacyImpact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/PreviewPrivacyImpact"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PreviewPrivacyImpactResponse> previewPrivacyImpact(
            PreviewPrivacyImpactRequest previewPrivacyImpactRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(previewPrivacyImpactRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, previewPrivacyImpactRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRooms");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PreviewPrivacyImpact");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PreviewPrivacyImpactResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PreviewPrivacyImpactResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PreviewPrivacyImpactResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PreviewPrivacyImpactRequest, PreviewPrivacyImpactResponse>()
                            .withOperationName("PreviewPrivacyImpact").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PreviewPrivacyImpactRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(previewPrivacyImpactRequest));
            CompletableFuture<PreviewPrivacyImpactResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a protected query that is started by Clean Rooms.
     * </p>
     *
     * @param startProtectedQueryRequest
     * @return A Java Future containing the result of the StartProtectedQuery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request denied because service quota has been exceeded.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the specified constraints.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException Caller does not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsAsyncClient.StartProtectedQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/StartProtectedQuery"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartProtectedQueryResponse> startProtectedQuery(
            StartProtectedQueryRequest startProtectedQueryRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startProtectedQueryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startProtectedQueryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRooms");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartProtectedQuery");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartProtectedQueryResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartProtectedQueryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartProtectedQueryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartProtectedQueryRequest, StartProtectedQueryResponse>()
                            .withOperationName("StartProtectedQuery").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartProtectedQueryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startProtectedQueryRequest));
            CompletableFuture<StartProtectedQueryResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Tags a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ValidationException The input fails to satisfy the specified constraints.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRooms");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    TagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<TagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                            .withOperationName("TagResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new TagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(tagResourceRequest));
            CompletableFuture<TagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes a tag or list of tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ValidationException The input fails to satisfy the specified constraints.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRooms");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UntagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UntagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                            .withOperationName("UntagResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(untagResourceRequest));
            CompletableFuture<UntagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the analysis template metadata.
     * </p>
     *
     * @param updateAnalysisTemplateRequest
     * @return A Java Future containing the result of the UpdateAnalysisTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the specified constraints.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException Caller does not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsAsyncClient.UpdateAnalysisTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/UpdateAnalysisTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateAnalysisTemplateResponse> updateAnalysisTemplate(
            UpdateAnalysisTemplateRequest updateAnalysisTemplateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateAnalysisTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAnalysisTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRooms");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAnalysisTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateAnalysisTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateAnalysisTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateAnalysisTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateAnalysisTemplateRequest, UpdateAnalysisTemplateResponse>()
                            .withOperationName("UpdateAnalysisTemplate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateAnalysisTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateAnalysisTemplateRequest));
            CompletableFuture<UpdateAnalysisTemplateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates collaboration metadata and can only be called by the collaboration owner.
     * </p>
     *
     * @param updateCollaborationRequest
     * @return A Java Future containing the result of the UpdateCollaboration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the specified constraints.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException Caller does not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsAsyncClient.UpdateCollaboration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/UpdateCollaboration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateCollaborationResponse> updateCollaboration(
            UpdateCollaborationRequest updateCollaborationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateCollaborationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateCollaborationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRooms");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateCollaboration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateCollaborationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateCollaborationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateCollaborationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateCollaborationRequest, UpdateCollaborationResponse>()
                            .withOperationName("UpdateCollaboration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateCollaborationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateCollaborationRequest));
            CompletableFuture<UpdateCollaborationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides the details necessary to update a configured audience model association.
     * </p>
     *
     * @param updateConfiguredAudienceModelAssociationRequest
     * @return A Java Future containing the result of the UpdateConfiguredAudienceModelAssociation operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the specified constraints.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException Caller does not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsAsyncClient.UpdateConfiguredAudienceModelAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/UpdateConfiguredAudienceModelAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateConfiguredAudienceModelAssociationResponse> updateConfiguredAudienceModelAssociation(
            UpdateConfiguredAudienceModelAssociationRequest updateConfiguredAudienceModelAssociationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                updateConfiguredAudienceModelAssociationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateConfiguredAudienceModelAssociationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRooms");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateConfiguredAudienceModelAssociation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateConfiguredAudienceModelAssociationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, UpdateConfiguredAudienceModelAssociationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateConfiguredAudienceModelAssociationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateConfiguredAudienceModelAssociationRequest, UpdateConfiguredAudienceModelAssociationResponse>()
                            .withOperationName("UpdateConfiguredAudienceModelAssociation").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateConfiguredAudienceModelAssociationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateConfiguredAudienceModelAssociationRequest));
            CompletableFuture<UpdateConfiguredAudienceModelAssociationResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a configured table.
     * </p>
     *
     * @param updateConfiguredTableRequest
     * @return A Java Future containing the result of the UpdateConfiguredTable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the specified constraints.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException Caller does not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsAsyncClient.UpdateConfiguredTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/UpdateConfiguredTable"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateConfiguredTableResponse> updateConfiguredTable(
            UpdateConfiguredTableRequest updateConfiguredTableRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateConfiguredTableRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateConfiguredTableRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRooms");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateConfiguredTable");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateConfiguredTableResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateConfiguredTableResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateConfiguredTableResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateConfiguredTableRequest, UpdateConfiguredTableResponse>()
                            .withOperationName("UpdateConfiguredTable").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateConfiguredTableRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateConfiguredTableRequest));
            CompletableFuture<UpdateConfiguredTableResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a configured table analysis rule.
     * </p>
     *
     * @param updateConfiguredTableAnalysisRuleRequest
     * @return A Java Future containing the result of the UpdateConfiguredTableAnalysisRule operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the specified constraints.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException Caller does not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsAsyncClient.UpdateConfiguredTableAnalysisRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/UpdateConfiguredTableAnalysisRule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateConfiguredTableAnalysisRuleResponse> updateConfiguredTableAnalysisRule(
            UpdateConfiguredTableAnalysisRuleRequest updateConfiguredTableAnalysisRuleRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateConfiguredTableAnalysisRuleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateConfiguredTableAnalysisRuleRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRooms");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateConfiguredTableAnalysisRule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateConfiguredTableAnalysisRuleResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, UpdateConfiguredTableAnalysisRuleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateConfiguredTableAnalysisRuleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateConfiguredTableAnalysisRuleRequest, UpdateConfiguredTableAnalysisRuleResponse>()
                            .withOperationName("UpdateConfiguredTableAnalysisRule").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateConfiguredTableAnalysisRuleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateConfiguredTableAnalysisRuleRequest));
            CompletableFuture<UpdateConfiguredTableAnalysisRuleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a configured table association.
     * </p>
     *
     * @param updateConfiguredTableAssociationRequest
     * @return A Java Future containing the result of the UpdateConfiguredTableAssociation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the specified constraints.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException Caller does not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsAsyncClient.UpdateConfiguredTableAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/UpdateConfiguredTableAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateConfiguredTableAssociationResponse> updateConfiguredTableAssociation(
            UpdateConfiguredTableAssociationRequest updateConfiguredTableAssociationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateConfiguredTableAssociationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateConfiguredTableAssociationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRooms");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateConfiguredTableAssociation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateConfiguredTableAssociationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, UpdateConfiguredTableAssociationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateConfiguredTableAssociationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateConfiguredTableAssociationRequest, UpdateConfiguredTableAssociationResponse>()
                            .withOperationName("UpdateConfiguredTableAssociation").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateConfiguredTableAssociationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateConfiguredTableAssociationRequest));
            CompletableFuture<UpdateConfiguredTableAssociationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the analysis rule for a configured table association.
     * </p>
     *
     * @param updateConfiguredTableAssociationAnalysisRuleRequest
     * @return A Java Future containing the result of the UpdateConfiguredTableAssociationAnalysisRule operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the specified constraints.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException Caller does not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsAsyncClient.UpdateConfiguredTableAssociationAnalysisRule
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/UpdateConfiguredTableAssociationAnalysisRule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateConfiguredTableAssociationAnalysisRuleResponse> updateConfiguredTableAssociationAnalysisRule(
            UpdateConfiguredTableAssociationAnalysisRuleRequest updateConfiguredTableAssociationAnalysisRuleRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                updateConfiguredTableAssociationAnalysisRuleRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateConfiguredTableAssociationAnalysisRuleRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRooms");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateConfiguredTableAssociationAnalysisRule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateConfiguredTableAssociationAnalysisRuleResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, UpdateConfiguredTableAssociationAnalysisRuleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateConfiguredTableAssociationAnalysisRuleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateConfiguredTableAssociationAnalysisRuleRequest, UpdateConfiguredTableAssociationAnalysisRuleResponse>()
                            .withOperationName("UpdateConfiguredTableAssociationAnalysisRule")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateConfiguredTableAssociationAnalysisRuleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateConfiguredTableAssociationAnalysisRuleRequest));
            CompletableFuture<UpdateConfiguredTableAssociationAnalysisRuleResponse> whenCompleted = executeFuture.whenComplete((
                    r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides the details that are necessary to update an ID mapping table.
     * </p>
     *
     * @param updateIdMappingTableRequest
     * @return A Java Future containing the result of the UpdateIdMappingTable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the specified constraints.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException Caller does not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsAsyncClient.UpdateIdMappingTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/UpdateIdMappingTable"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateIdMappingTableResponse> updateIdMappingTable(
            UpdateIdMappingTableRequest updateIdMappingTableRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateIdMappingTableRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateIdMappingTableRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRooms");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateIdMappingTable");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateIdMappingTableResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateIdMappingTableResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateIdMappingTableResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateIdMappingTableRequest, UpdateIdMappingTableResponse>()
                            .withOperationName("UpdateIdMappingTable").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateIdMappingTableRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateIdMappingTableRequest));
            CompletableFuture<UpdateIdMappingTableResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides the details that are necessary to update an ID namespace association.
     * </p>
     *
     * @param updateIdNamespaceAssociationRequest
     * @return A Java Future containing the result of the UpdateIdNamespaceAssociation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the specified constraints.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException Caller does not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsAsyncClient.UpdateIdNamespaceAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/UpdateIdNamespaceAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateIdNamespaceAssociationResponse> updateIdNamespaceAssociation(
            UpdateIdNamespaceAssociationRequest updateIdNamespaceAssociationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateIdNamespaceAssociationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateIdNamespaceAssociationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRooms");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateIdNamespaceAssociation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateIdNamespaceAssociationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateIdNamespaceAssociationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateIdNamespaceAssociationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateIdNamespaceAssociationRequest, UpdateIdNamespaceAssociationResponse>()
                            .withOperationName("UpdateIdNamespaceAssociation").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateIdNamespaceAssociationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateIdNamespaceAssociationRequest));
            CompletableFuture<UpdateIdNamespaceAssociationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a membership.
     * </p>
     *
     * @param updateMembershipRequest
     * @return A Java Future containing the result of the UpdateMembership operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the specified constraints.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException Caller does not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsAsyncClient.UpdateMembership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/UpdateMembership" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateMembershipResponse> updateMembership(UpdateMembershipRequest updateMembershipRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateMembershipRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateMembershipRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRooms");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateMembership");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateMembershipResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateMembershipResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateMembershipResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateMembershipRequest, UpdateMembershipResponse>()
                            .withOperationName("UpdateMembership").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateMembershipRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateMembershipRequest));
            CompletableFuture<UpdateMembershipResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the privacy budget template for the specified membership.
     * </p>
     *
     * @param updatePrivacyBudgetTemplateRequest
     * @return A Java Future containing the result of the UpdatePrivacyBudgetTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the specified constraints.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException Caller does not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsAsyncClient.UpdatePrivacyBudgetTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/UpdatePrivacyBudgetTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdatePrivacyBudgetTemplateResponse> updatePrivacyBudgetTemplate(
            UpdatePrivacyBudgetTemplateRequest updatePrivacyBudgetTemplateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updatePrivacyBudgetTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updatePrivacyBudgetTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRooms");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdatePrivacyBudgetTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdatePrivacyBudgetTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdatePrivacyBudgetTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdatePrivacyBudgetTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdatePrivacyBudgetTemplateRequest, UpdatePrivacyBudgetTemplateResponse>()
                            .withOperationName("UpdatePrivacyBudgetTemplate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdatePrivacyBudgetTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updatePrivacyBudgetTemplateRequest));
            CompletableFuture<UpdatePrivacyBudgetTemplateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the processing of a currently running query.
     * </p>
     *
     * @param updateProtectedQueryRequest
     * @return A Java Future containing the result of the UpdateProtectedQuery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the specified constraints.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>AccessDeniedException Caller does not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsAsyncClient.UpdateProtectedQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/UpdateProtectedQuery"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateProtectedQueryResponse> updateProtectedQuery(
            UpdateProtectedQueryRequest updateProtectedQueryRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateProtectedQueryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateProtectedQueryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CleanRooms");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateProtectedQuery");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateProtectedQueryResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateProtectedQueryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateProtectedQueryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateProtectedQueryRequest, UpdateProtectedQueryResponse>()
                            .withOperationName("UpdateProtectedQuery").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateProtectedQueryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateProtectedQueryRequest));
            CompletableFuture<UpdateProtectedQueryResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public final CleanRoomsServiceClientConfiguration serviceClientConfiguration() {
        return new CleanRoomsServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(CleanRoomsException::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException")
                                .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(402).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalServerException")
                                .exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ValidationException")
                                .exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ThrottlingException")
                                .exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(429).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AccessDeniedException")
                                .exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(403).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConflictException")
                                .exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(409).build());
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option(SdkClientOption.RETRY_STRATEGY, AwsRetryStrategy.forRetryMode(retryMode));
        } else {
            Consumer<RetryStrategy.Builder<?, ?>> configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder<?, ?> defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option(SdkClientOption.RETRY_STRATEGY, defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option(SdkClientOption.RETRY_STRATEGY, retryStrategy);
                }
            }
        }
        configuration.option(SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        CleanRoomsServiceClientConfigurationBuilder serviceConfigBuilder = new CleanRoomsServiceClientConfigurationBuilder(
                configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
