/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The status details of the analysis template validation. Clean Rooms Differential Privacy uses a general-purpose query
 * structure to support complex SQL queries and validates whether an analysis template fits that general-purpose query
 * structure. Validation is performed when analysis templates are created and fetched. Because analysis templates are
 * immutable by design, we recommend that you create analysis templates after you associate the configured tables with
 * their analysis rule to your collaboration.
 * </p>
 * <p>
 * For more information, see <a
 * href="https://docs.aws.amazon.com/clean-rooms/latest/userguide/analysis-rules-custom.html#custom-diff-privacy"
 * >https://docs.aws.amazon.com/clean-rooms/latest/userguide/analysis-rules-custom.html#custom-diff-privacy</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnalysisTemplateValidationStatusDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<AnalysisTemplateValidationStatusDetail.Builder, AnalysisTemplateValidationStatusDetail> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(AnalysisTemplateValidationStatusDetail::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(AnalysisTemplateValidationStatusDetail::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<List<AnalysisTemplateValidationStatusReason>> REASONS_FIELD = SdkField
            .<List<AnalysisTemplateValidationStatusReason>> builder(MarshallingType.LIST)
            .memberName("reasons")
            .getter(getter(AnalysisTemplateValidationStatusDetail::reasons))
            .setter(setter(Builder::reasons))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reasons").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AnalysisTemplateValidationStatusReason> builder(MarshallingType.SDK_POJO)
                                            .constructor(AnalysisTemplateValidationStatusReason::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, STATUS_FIELD,
            REASONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String status;

    private final List<AnalysisTemplateValidationStatusReason> reasons;

    private AnalysisTemplateValidationStatusDetail(BuilderImpl builder) {
        this.type = builder.type;
        this.status = builder.status;
        this.reasons = builder.reasons;
    }

    /**
     * <p>
     * The type of validation that was performed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link AnalysisTemplateValidationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeAsString}.
     * </p>
     * 
     * @return The type of validation that was performed.
     * @see AnalysisTemplateValidationType
     */
    public final AnalysisTemplateValidationType type() {
        return AnalysisTemplateValidationType.fromValue(type);
    }

    /**
     * <p>
     * The type of validation that was performed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link AnalysisTemplateValidationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeAsString}.
     * </p>
     * 
     * @return The type of validation that was performed.
     * @see AnalysisTemplateValidationType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The status of the validation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AnalysisTemplateValidationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the validation.
     * @see AnalysisTemplateValidationStatus
     */
    public final AnalysisTemplateValidationStatus status() {
        return AnalysisTemplateValidationStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the validation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AnalysisTemplateValidationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the validation.
     * @see AnalysisTemplateValidationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the Reasons property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasReasons() {
        return reasons != null && !(reasons instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The reasons for the validation results.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReasons} method.
     * </p>
     * 
     * @return The reasons for the validation results.
     */
    public final List<AnalysisTemplateValidationStatusReason> reasons() {
        return reasons;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasReasons() ? reasons() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalysisTemplateValidationStatusDetail)) {
            return false;
        }
        AnalysisTemplateValidationStatusDetail other = (AnalysisTemplateValidationStatusDetail) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(statusAsString(), other.statusAsString())
                && hasReasons() == other.hasReasons() && Objects.equals(reasons(), other.reasons());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AnalysisTemplateValidationStatusDetail").add("Type", typeAsString())
                .add("Status", statusAsString()).add("Reasons", hasReasons() ? reasons() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "reasons":
            return Optional.ofNullable(clazz.cast(reasons()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("type", TYPE_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("reasons", REASONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AnalysisTemplateValidationStatusDetail, T> g) {
        return obj -> g.apply((AnalysisTemplateValidationStatusDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnalysisTemplateValidationStatusDetail> {
        /**
         * <p>
         * The type of validation that was performed.
         * </p>
         * 
         * @param type
         *        The type of validation that was performed.
         * @see AnalysisTemplateValidationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnalysisTemplateValidationType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of validation that was performed.
         * </p>
         * 
         * @param type
         *        The type of validation that was performed.
         * @see AnalysisTemplateValidationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnalysisTemplateValidationType
         */
        Builder type(AnalysisTemplateValidationType type);

        /**
         * <p>
         * The status of the validation.
         * </p>
         * 
         * @param status
         *        The status of the validation.
         * @see AnalysisTemplateValidationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnalysisTemplateValidationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the validation.
         * </p>
         * 
         * @param status
         *        The status of the validation.
         * @see AnalysisTemplateValidationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnalysisTemplateValidationStatus
         */
        Builder status(AnalysisTemplateValidationStatus status);

        /**
         * <p>
         * The reasons for the validation results.
         * </p>
         * 
         * @param reasons
         *        The reasons for the validation results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reasons(Collection<AnalysisTemplateValidationStatusReason> reasons);

        /**
         * <p>
         * The reasons for the validation results.
         * </p>
         * 
         * @param reasons
         *        The reasons for the validation results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reasons(AnalysisTemplateValidationStatusReason... reasons);

        /**
         * <p>
         * The reasons for the validation results.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cleanrooms.model.AnalysisTemplateValidationStatusReason.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.cleanrooms.model.AnalysisTemplateValidationStatusReason#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cleanrooms.model.AnalysisTemplateValidationStatusReason.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #reasons(List<AnalysisTemplateValidationStatusReason>)}.
         * 
         * @param reasons
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cleanrooms.model.AnalysisTemplateValidationStatusReason.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reasons(java.util.Collection<AnalysisTemplateValidationStatusReason>)
         */
        Builder reasons(Consumer<AnalysisTemplateValidationStatusReason.Builder>... reasons);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String status;

        private List<AnalysisTemplateValidationStatusReason> reasons = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AnalysisTemplateValidationStatusDetail model) {
            type(model.type);
            status(model.status);
            reasons(model.reasons);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(AnalysisTemplateValidationType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AnalysisTemplateValidationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final List<AnalysisTemplateValidationStatusReason.Builder> getReasons() {
            List<AnalysisTemplateValidationStatusReason.Builder> result = AnalysisTemplateValidationStatusReasonListCopier
                    .copyToBuilder(this.reasons);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReasons(Collection<AnalysisTemplateValidationStatusReason.BuilderImpl> reasons) {
            this.reasons = AnalysisTemplateValidationStatusReasonListCopier.copyFromBuilder(reasons);
        }

        @Override
        public final Builder reasons(Collection<AnalysisTemplateValidationStatusReason> reasons) {
            this.reasons = AnalysisTemplateValidationStatusReasonListCopier.copy(reasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reasons(AnalysisTemplateValidationStatusReason... reasons) {
            reasons(Arrays.asList(reasons));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reasons(Consumer<AnalysisTemplateValidationStatusReason.Builder>... reasons) {
            reasons(Stream.of(reasons).map(c -> AnalysisTemplateValidationStatusReason.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AnalysisTemplateValidationStatusDetail build() {
            return new AnalysisTemplateValidationStatusDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
