/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetCollaborationAnalysisTemplateResponse extends CleanRoomsResponse implements
        ToCopyableBuilder<BatchGetCollaborationAnalysisTemplateResponse.Builder, BatchGetCollaborationAnalysisTemplateResponse> {
    private static final SdkField<List<CollaborationAnalysisTemplate>> COLLABORATION_ANALYSIS_TEMPLATES_FIELD = SdkField
            .<List<CollaborationAnalysisTemplate>> builder(MarshallingType.LIST)
            .memberName("collaborationAnalysisTemplates")
            .getter(getter(BatchGetCollaborationAnalysisTemplateResponse::collaborationAnalysisTemplates))
            .setter(setter(Builder::collaborationAnalysisTemplates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationAnalysisTemplates")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CollaborationAnalysisTemplate> builder(MarshallingType.SDK_POJO)
                                            .constructor(CollaborationAnalysisTemplate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<BatchGetCollaborationAnalysisTemplateError>> ERRORS_FIELD = SdkField
            .<List<BatchGetCollaborationAnalysisTemplateError>> builder(MarshallingType.LIST)
            .memberName("errors")
            .getter(getter(BatchGetCollaborationAnalysisTemplateResponse::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchGetCollaborationAnalysisTemplateError> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchGetCollaborationAnalysisTemplateError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            COLLABORATION_ANALYSIS_TEMPLATES_FIELD, ERRORS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<CollaborationAnalysisTemplate> collaborationAnalysisTemplates;

    private final List<BatchGetCollaborationAnalysisTemplateError> errors;

    private BatchGetCollaborationAnalysisTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.collaborationAnalysisTemplates = builder.collaborationAnalysisTemplates;
        this.errors = builder.errors;
    }

    /**
     * For responses, this returns true if the service returned a value for the CollaborationAnalysisTemplates property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCollaborationAnalysisTemplates() {
        return collaborationAnalysisTemplates != null && !(collaborationAnalysisTemplates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The retrieved list of analysis templates within a collaboration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCollaborationAnalysisTemplates} method.
     * </p>
     * 
     * @return The retrieved list of analysis templates within a collaboration.
     */
    public final List<CollaborationAnalysisTemplate> collaborationAnalysisTemplates() {
        return collaborationAnalysisTemplates;
    }

    /**
     * For responses, this returns true if the service returned a value for the Errors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasErrors() {
        return errors != null && !(errors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Error reasons for collaboration analysis templates that could not be retrieved. One error is returned for every
     * collaboration analysis template that could not be retrieved.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasErrors} method.
     * </p>
     * 
     * @return Error reasons for collaboration analysis templates that could not be retrieved. One error is returned for
     *         every collaboration analysis template that could not be retrieved.
     */
    public final List<BatchGetCollaborationAnalysisTemplateError> errors() {
        return errors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode
                + Objects.hashCode(hasCollaborationAnalysisTemplates() ? collaborationAnalysisTemplates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasErrors() ? errors() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetCollaborationAnalysisTemplateResponse)) {
            return false;
        }
        BatchGetCollaborationAnalysisTemplateResponse other = (BatchGetCollaborationAnalysisTemplateResponse) obj;
        return hasCollaborationAnalysisTemplates() == other.hasCollaborationAnalysisTemplates()
                && Objects.equals(collaborationAnalysisTemplates(), other.collaborationAnalysisTemplates())
                && hasErrors() == other.hasErrors() && Objects.equals(errors(), other.errors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("BatchGetCollaborationAnalysisTemplateResponse")
                .add("CollaborationAnalysisTemplates",
                        hasCollaborationAnalysisTemplates() ? collaborationAnalysisTemplates() : null)
                .add("Errors", hasErrors() ? errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "collaborationAnalysisTemplates":
            return Optional.ofNullable(clazz.cast(collaborationAnalysisTemplates()));
        case "errors":
            return Optional.ofNullable(clazz.cast(errors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("collaborationAnalysisTemplates", COLLABORATION_ANALYSIS_TEMPLATES_FIELD);
        map.put("errors", ERRORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetCollaborationAnalysisTemplateResponse, T> g) {
        return obj -> g.apply((BatchGetCollaborationAnalysisTemplateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CleanRoomsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchGetCollaborationAnalysisTemplateResponse> {
        /**
         * <p>
         * The retrieved list of analysis templates within a collaboration.
         * </p>
         * 
         * @param collaborationAnalysisTemplates
         *        The retrieved list of analysis templates within a collaboration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaborationAnalysisTemplates(Collection<CollaborationAnalysisTemplate> collaborationAnalysisTemplates);

        /**
         * <p>
         * The retrieved list of analysis templates within a collaboration.
         * </p>
         * 
         * @param collaborationAnalysisTemplates
         *        The retrieved list of analysis templates within a collaboration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaborationAnalysisTemplates(CollaborationAnalysisTemplate... collaborationAnalysisTemplates);

        /**
         * <p>
         * The retrieved list of analysis templates within a collaboration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cleanrooms.model.CollaborationAnalysisTemplate.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.cleanrooms.model.CollaborationAnalysisTemplate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cleanrooms.model.CollaborationAnalysisTemplate.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #collaborationAnalysisTemplates(List<CollaborationAnalysisTemplate>)}.
         * 
         * @param collaborationAnalysisTemplates
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cleanrooms.model.CollaborationAnalysisTemplate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #collaborationAnalysisTemplates(java.util.Collection<CollaborationAnalysisTemplate>)
         */
        Builder collaborationAnalysisTemplates(Consumer<CollaborationAnalysisTemplate.Builder>... collaborationAnalysisTemplates);

        /**
         * <p>
         * Error reasons for collaboration analysis templates that could not be retrieved. One error is returned for
         * every collaboration analysis template that could not be retrieved.
         * </p>
         * 
         * @param errors
         *        Error reasons for collaboration analysis templates that could not be retrieved. One error is returned
         *        for every collaboration analysis template that could not be retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<BatchGetCollaborationAnalysisTemplateError> errors);

        /**
         * <p>
         * Error reasons for collaboration analysis templates that could not be retrieved. One error is returned for
         * every collaboration analysis template that could not be retrieved.
         * </p>
         * 
         * @param errors
         *        Error reasons for collaboration analysis templates that could not be retrieved. One error is returned
         *        for every collaboration analysis template that could not be retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(BatchGetCollaborationAnalysisTemplateError... errors);

        /**
         * <p>
         * Error reasons for collaboration analysis templates that could not be retrieved. One error is returned for
         * every collaboration analysis template that could not be retrieved.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cleanrooms.model.BatchGetCollaborationAnalysisTemplateError.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.cleanrooms.model.BatchGetCollaborationAnalysisTemplateError#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cleanrooms.model.BatchGetCollaborationAnalysisTemplateError.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #errors(List<BatchGetCollaborationAnalysisTemplateError>)}.
         * 
         * @param errors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cleanrooms.model.BatchGetCollaborationAnalysisTemplateError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errors(java.util.Collection<BatchGetCollaborationAnalysisTemplateError>)
         */
        Builder errors(Consumer<BatchGetCollaborationAnalysisTemplateError.Builder>... errors);
    }

    static final class BuilderImpl extends CleanRoomsResponse.BuilderImpl implements Builder {
        private List<CollaborationAnalysisTemplate> collaborationAnalysisTemplates = DefaultSdkAutoConstructList.getInstance();

        private List<BatchGetCollaborationAnalysisTemplateError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetCollaborationAnalysisTemplateResponse model) {
            super(model);
            collaborationAnalysisTemplates(model.collaborationAnalysisTemplates);
            errors(model.errors);
        }

        public final List<CollaborationAnalysisTemplate.Builder> getCollaborationAnalysisTemplates() {
            List<CollaborationAnalysisTemplate.Builder> result = CollaborationAnalysisTemplateListCopier
                    .copyToBuilder(this.collaborationAnalysisTemplates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCollaborationAnalysisTemplates(
                Collection<CollaborationAnalysisTemplate.BuilderImpl> collaborationAnalysisTemplates) {
            this.collaborationAnalysisTemplates = CollaborationAnalysisTemplateListCopier
                    .copyFromBuilder(collaborationAnalysisTemplates);
        }

        @Override
        public final Builder collaborationAnalysisTemplates(
                Collection<CollaborationAnalysisTemplate> collaborationAnalysisTemplates) {
            this.collaborationAnalysisTemplates = CollaborationAnalysisTemplateListCopier.copy(collaborationAnalysisTemplates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder collaborationAnalysisTemplates(CollaborationAnalysisTemplate... collaborationAnalysisTemplates) {
            collaborationAnalysisTemplates(Arrays.asList(collaborationAnalysisTemplates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder collaborationAnalysisTemplates(
                Consumer<CollaborationAnalysisTemplate.Builder>... collaborationAnalysisTemplates) {
            collaborationAnalysisTemplates(Stream.of(collaborationAnalysisTemplates)
                    .map(c -> CollaborationAnalysisTemplate.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<BatchGetCollaborationAnalysisTemplateError.Builder> getErrors() {
            List<BatchGetCollaborationAnalysisTemplateError.Builder> result = BatchGetCollaborationAnalysisTemplateErrorListCopier
                    .copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<BatchGetCollaborationAnalysisTemplateError.BuilderImpl> errors) {
            this.errors = BatchGetCollaborationAnalysisTemplateErrorListCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<BatchGetCollaborationAnalysisTemplateError> errors) {
            this.errors = BatchGetCollaborationAnalysisTemplateErrorListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(BatchGetCollaborationAnalysisTemplateError... errors) {
            errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<BatchGetCollaborationAnalysisTemplateError.Builder>... errors) {
            errors(Stream.of(errors).map(c -> BatchGetCollaborationAnalysisTemplateError.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetCollaborationAnalysisTemplateResponse build() {
            return new BatchGetCollaborationAnalysisTemplateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
