/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetSchemaAnalysisRuleResponse extends CleanRoomsResponse implements
        ToCopyableBuilder<BatchGetSchemaAnalysisRuleResponse.Builder, BatchGetSchemaAnalysisRuleResponse> {
    private static final SdkField<List<AnalysisRule>> ANALYSIS_RULES_FIELD = SdkField
            .<List<AnalysisRule>> builder(MarshallingType.LIST)
            .memberName("analysisRules")
            .getter(getter(BatchGetSchemaAnalysisRuleResponse::analysisRules))
            .setter(setter(Builder::analysisRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("analysisRules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AnalysisRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(AnalysisRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<BatchGetSchemaAnalysisRuleError>> ERRORS_FIELD = SdkField
            .<List<BatchGetSchemaAnalysisRuleError>> builder(MarshallingType.LIST)
            .memberName("errors")
            .getter(getter(BatchGetSchemaAnalysisRuleResponse::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchGetSchemaAnalysisRuleError> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchGetSchemaAnalysisRuleError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANALYSIS_RULES_FIELD,
            ERRORS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<AnalysisRule> analysisRules;

    private final List<BatchGetSchemaAnalysisRuleError> errors;

    private BatchGetSchemaAnalysisRuleResponse(BuilderImpl builder) {
        super(builder);
        this.analysisRules = builder.analysisRules;
        this.errors = builder.errors;
    }

    /**
     * For responses, this returns true if the service returned a value for the AnalysisRules property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAnalysisRules() {
        return analysisRules != null && !(analysisRules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The retrieved list of analysis rules.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAnalysisRules} method.
     * </p>
     * 
     * @return The retrieved list of analysis rules.
     */
    public final List<AnalysisRule> analysisRules() {
        return analysisRules;
    }

    /**
     * For responses, this returns true if the service returned a value for the Errors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasErrors() {
        return errors != null && !(errors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Error reasons for schemas that could not be retrieved. One error is returned for every schema that could not be
     * retrieved.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasErrors} method.
     * </p>
     * 
     * @return Error reasons for schemas that could not be retrieved. One error is returned for every schema that could
     *         not be retrieved.
     */
    public final List<BatchGetSchemaAnalysisRuleError> errors() {
        return errors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAnalysisRules() ? analysisRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasErrors() ? errors() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetSchemaAnalysisRuleResponse)) {
            return false;
        }
        BatchGetSchemaAnalysisRuleResponse other = (BatchGetSchemaAnalysisRuleResponse) obj;
        return hasAnalysisRules() == other.hasAnalysisRules() && Objects.equals(analysisRules(), other.analysisRules())
                && hasErrors() == other.hasErrors() && Objects.equals(errors(), other.errors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetSchemaAnalysisRuleResponse")
                .add("AnalysisRules", hasAnalysisRules() ? analysisRules() : null).add("Errors", hasErrors() ? errors() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "analysisRules":
            return Optional.ofNullable(clazz.cast(analysisRules()));
        case "errors":
            return Optional.ofNullable(clazz.cast(errors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("analysisRules", ANALYSIS_RULES_FIELD);
        map.put("errors", ERRORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetSchemaAnalysisRuleResponse, T> g) {
        return obj -> g.apply((BatchGetSchemaAnalysisRuleResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CleanRoomsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchGetSchemaAnalysisRuleResponse> {
        /**
         * <p>
         * The retrieved list of analysis rules.
         * </p>
         * 
         * @param analysisRules
         *        The retrieved list of analysis rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analysisRules(Collection<AnalysisRule> analysisRules);

        /**
         * <p>
         * The retrieved list of analysis rules.
         * </p>
         * 
         * @param analysisRules
         *        The retrieved list of analysis rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analysisRules(AnalysisRule... analysisRules);

        /**
         * <p>
         * The retrieved list of analysis rules.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cleanrooms.model.AnalysisRule.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.cleanrooms.model.AnalysisRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cleanrooms.model.AnalysisRule.Builder#build()} is called immediately
         * and its result is passed to {@link #analysisRules(List<AnalysisRule>)}.
         * 
         * @param analysisRules
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cleanrooms.model.AnalysisRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #analysisRules(java.util.Collection<AnalysisRule>)
         */
        Builder analysisRules(Consumer<AnalysisRule.Builder>... analysisRules);

        /**
         * <p>
         * Error reasons for schemas that could not be retrieved. One error is returned for every schema that could not
         * be retrieved.
         * </p>
         * 
         * @param errors
         *        Error reasons for schemas that could not be retrieved. One error is returned for every schema that
         *        could not be retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<BatchGetSchemaAnalysisRuleError> errors);

        /**
         * <p>
         * Error reasons for schemas that could not be retrieved. One error is returned for every schema that could not
         * be retrieved.
         * </p>
         * 
         * @param errors
         *        Error reasons for schemas that could not be retrieved. One error is returned for every schema that
         *        could not be retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(BatchGetSchemaAnalysisRuleError... errors);

        /**
         * <p>
         * Error reasons for schemas that could not be retrieved. One error is returned for every schema that could not
         * be retrieved.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cleanrooms.model.BatchGetSchemaAnalysisRuleError.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.cleanrooms.model.BatchGetSchemaAnalysisRuleError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cleanrooms.model.BatchGetSchemaAnalysisRuleError.Builder#build()} is
         * called immediately and its result is passed to {@link #errors(List<BatchGetSchemaAnalysisRuleError>)}.
         * 
         * @param errors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cleanrooms.model.BatchGetSchemaAnalysisRuleError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errors(java.util.Collection<BatchGetSchemaAnalysisRuleError>)
         */
        Builder errors(Consumer<BatchGetSchemaAnalysisRuleError.Builder>... errors);
    }

    static final class BuilderImpl extends CleanRoomsResponse.BuilderImpl implements Builder {
        private List<AnalysisRule> analysisRules = DefaultSdkAutoConstructList.getInstance();

        private List<BatchGetSchemaAnalysisRuleError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetSchemaAnalysisRuleResponse model) {
            super(model);
            analysisRules(model.analysisRules);
            errors(model.errors);
        }

        public final List<AnalysisRule.Builder> getAnalysisRules() {
            List<AnalysisRule.Builder> result = SchemaAnalysisRuleListCopier.copyToBuilder(this.analysisRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAnalysisRules(Collection<AnalysisRule.BuilderImpl> analysisRules) {
            this.analysisRules = SchemaAnalysisRuleListCopier.copyFromBuilder(analysisRules);
        }

        @Override
        public final Builder analysisRules(Collection<AnalysisRule> analysisRules) {
            this.analysisRules = SchemaAnalysisRuleListCopier.copy(analysisRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analysisRules(AnalysisRule... analysisRules) {
            analysisRules(Arrays.asList(analysisRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analysisRules(Consumer<AnalysisRule.Builder>... analysisRules) {
            analysisRules(Stream.of(analysisRules).map(c -> AnalysisRule.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<BatchGetSchemaAnalysisRuleError.Builder> getErrors() {
            List<BatchGetSchemaAnalysisRuleError.Builder> result = BatchGetSchemaAnalysisRuleErrorListCopier
                    .copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<BatchGetSchemaAnalysisRuleError.BuilderImpl> errors) {
            this.errors = BatchGetSchemaAnalysisRuleErrorListCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<BatchGetSchemaAnalysisRuleError> errors) {
            this.errors = BatchGetSchemaAnalysisRuleErrorListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(BatchGetSchemaAnalysisRuleError... errors) {
            errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<BatchGetSchemaAnalysisRuleError.Builder>... errors) {
            errors(Stream.of(errors).map(c -> BatchGetSchemaAnalysisRuleError.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetSchemaAnalysisRuleResponse build() {
            return new BatchGetSchemaAnalysisRuleResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
