/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of the collaboration's privacy budget template. This summary includes information about who created the
 * privacy budget template and what collaborations it belongs to.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CollaborationPrivacyBudgetTemplateSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<CollaborationPrivacyBudgetTemplateSummary.Builder, CollaborationPrivacyBudgetTemplateSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(CollaborationPrivacyBudgetTemplateSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(CollaborationPrivacyBudgetTemplateSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> COLLABORATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("collaborationId").getter(getter(CollaborationPrivacyBudgetTemplateSummary::collaborationId))
            .setter(setter(Builder::collaborationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationId").build()).build();

    private static final SdkField<String> COLLABORATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("collaborationArn").getter(getter(CollaborationPrivacyBudgetTemplateSummary::collaborationArn))
            .setter(setter(Builder::collaborationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationArn").build()).build();

    private static final SdkField<String> CREATOR_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("creatorAccountId").getter(getter(CollaborationPrivacyBudgetTemplateSummary::creatorAccountId))
            .setter(setter(Builder::creatorAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creatorAccountId").build()).build();

    private static final SdkField<String> PRIVACY_BUDGET_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("privacyBudgetType").getter(getter(CollaborationPrivacyBudgetTemplateSummary::privacyBudgetTypeAsString))
            .setter(setter(Builder::privacyBudgetType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("privacyBudgetType").build()).build();

    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createTime").getter(getter(CollaborationPrivacyBudgetTemplateSummary::createTime))
            .setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build()).build();

    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updateTime").getter(getter(CollaborationPrivacyBudgetTemplateSummary::updateTime))
            .setter(setter(Builder::updateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD,
            COLLABORATION_ID_FIELD, COLLABORATION_ARN_FIELD, CREATOR_ACCOUNT_ID_FIELD, PRIVACY_BUDGET_TYPE_FIELD,
            CREATE_TIME_FIELD, UPDATE_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String arn;

    private final String collaborationId;

    private final String collaborationArn;

    private final String creatorAccountId;

    private final String privacyBudgetType;

    private final Instant createTime;

    private final Instant updateTime;

    private CollaborationPrivacyBudgetTemplateSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.collaborationId = builder.collaborationId;
        this.collaborationArn = builder.collaborationArn;
        this.creatorAccountId = builder.creatorAccountId;
        this.privacyBudgetType = builder.privacyBudgetType;
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
    }

    /**
     * <p>
     * The unique identifier of the collaboration privacy budget template.
     * </p>
     * 
     * @return The unique identifier of the collaboration privacy budget template.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The ARN of the collaboration privacy budget template.
     * </p>
     * 
     * @return The ARN of the collaboration privacy budget template.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The unique identifier of the collaboration that contains this collaboration privacy budget template.
     * </p>
     * 
     * @return The unique identifier of the collaboration that contains this collaboration privacy budget template.
     */
    public final String collaborationId() {
        return collaborationId;
    }

    /**
     * <p>
     * The ARN of the collaboration that contains this collaboration privacy budget template.
     * </p>
     * 
     * @return The ARN of the collaboration that contains this collaboration privacy budget template.
     */
    public final String collaborationArn() {
        return collaborationArn;
    }

    /**
     * <p>
     * The unique identifier of the account that created this collaboration privacy budget template.
     * </p>
     * 
     * @return The unique identifier of the account that created this collaboration privacy budget template.
     */
    public final String creatorAccountId() {
        return creatorAccountId;
    }

    /**
     * <p>
     * The type of the privacy budget template.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #privacyBudgetType}
     * will return {@link PrivacyBudgetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #privacyBudgetTypeAsString}.
     * </p>
     * 
     * @return The type of the privacy budget template.
     * @see PrivacyBudgetType
     */
    public final PrivacyBudgetType privacyBudgetType() {
        return PrivacyBudgetType.fromValue(privacyBudgetType);
    }

    /**
     * <p>
     * The type of the privacy budget template.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #privacyBudgetType}
     * will return {@link PrivacyBudgetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #privacyBudgetTypeAsString}.
     * </p>
     * 
     * @return The type of the privacy budget template.
     * @see PrivacyBudgetType
     */
    public final String privacyBudgetTypeAsString() {
        return privacyBudgetType;
    }

    /**
     * <p>
     * The time at which the collaboration privacy budget template was created.
     * </p>
     * 
     * @return The time at which the collaboration privacy budget template was created.
     */
    public final Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * The most recent time at which the collaboration privacy budget template was updated.
     * </p>
     * 
     * @return The most recent time at which the collaboration privacy budget template was updated.
     */
    public final Instant updateTime() {
        return updateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(collaborationId());
        hashCode = 31 * hashCode + Objects.hashCode(collaborationArn());
        hashCode = 31 * hashCode + Objects.hashCode(creatorAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(privacyBudgetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(updateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CollaborationPrivacyBudgetTemplateSummary)) {
            return false;
        }
        CollaborationPrivacyBudgetTemplateSummary other = (CollaborationPrivacyBudgetTemplateSummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn())
                && Objects.equals(collaborationId(), other.collaborationId())
                && Objects.equals(collaborationArn(), other.collaborationArn())
                && Objects.equals(creatorAccountId(), other.creatorAccountId())
                && Objects.equals(privacyBudgetTypeAsString(), other.privacyBudgetTypeAsString())
                && Objects.equals(createTime(), other.createTime()) && Objects.equals(updateTime(), other.updateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CollaborationPrivacyBudgetTemplateSummary").add("Id", id()).add("Arn", arn())
                .add("CollaborationId", collaborationId()).add("CollaborationArn", collaborationArn())
                .add("CreatorAccountId", creatorAccountId()).add("PrivacyBudgetType", privacyBudgetTypeAsString())
                .add("CreateTime", createTime()).add("UpdateTime", updateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "collaborationId":
            return Optional.ofNullable(clazz.cast(collaborationId()));
        case "collaborationArn":
            return Optional.ofNullable(clazz.cast(collaborationArn()));
        case "creatorAccountId":
            return Optional.ofNullable(clazz.cast(creatorAccountId()));
        case "privacyBudgetType":
            return Optional.ofNullable(clazz.cast(privacyBudgetTypeAsString()));
        case "createTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "updateTime":
            return Optional.ofNullable(clazz.cast(updateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("collaborationId", COLLABORATION_ID_FIELD);
        map.put("collaborationArn", COLLABORATION_ARN_FIELD);
        map.put("creatorAccountId", CREATOR_ACCOUNT_ID_FIELD);
        map.put("privacyBudgetType", PRIVACY_BUDGET_TYPE_FIELD);
        map.put("createTime", CREATE_TIME_FIELD);
        map.put("updateTime", UPDATE_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CollaborationPrivacyBudgetTemplateSummary, T> g) {
        return obj -> g.apply((CollaborationPrivacyBudgetTemplateSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CollaborationPrivacyBudgetTemplateSummary> {
        /**
         * <p>
         * The unique identifier of the collaboration privacy budget template.
         * </p>
         * 
         * @param id
         *        The unique identifier of the collaboration privacy budget template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The ARN of the collaboration privacy budget template.
         * </p>
         * 
         * @param arn
         *        The ARN of the collaboration privacy budget template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The unique identifier of the collaboration that contains this collaboration privacy budget template.
         * </p>
         * 
         * @param collaborationId
         *        The unique identifier of the collaboration that contains this collaboration privacy budget template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaborationId(String collaborationId);

        /**
         * <p>
         * The ARN of the collaboration that contains this collaboration privacy budget template.
         * </p>
         * 
         * @param collaborationArn
         *        The ARN of the collaboration that contains this collaboration privacy budget template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaborationArn(String collaborationArn);

        /**
         * <p>
         * The unique identifier of the account that created this collaboration privacy budget template.
         * </p>
         * 
         * @param creatorAccountId
         *        The unique identifier of the account that created this collaboration privacy budget template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creatorAccountId(String creatorAccountId);

        /**
         * <p>
         * The type of the privacy budget template.
         * </p>
         * 
         * @param privacyBudgetType
         *        The type of the privacy budget template.
         * @see PrivacyBudgetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PrivacyBudgetType
         */
        Builder privacyBudgetType(String privacyBudgetType);

        /**
         * <p>
         * The type of the privacy budget template.
         * </p>
         * 
         * @param privacyBudgetType
         *        The type of the privacy budget template.
         * @see PrivacyBudgetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PrivacyBudgetType
         */
        Builder privacyBudgetType(PrivacyBudgetType privacyBudgetType);

        /**
         * <p>
         * The time at which the collaboration privacy budget template was created.
         * </p>
         * 
         * @param createTime
         *        The time at which the collaboration privacy budget template was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * The most recent time at which the collaboration privacy budget template was updated.
         * </p>
         * 
         * @param updateTime
         *        The most recent time at which the collaboration privacy budget template was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTime(Instant updateTime);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String arn;

        private String collaborationId;

        private String collaborationArn;

        private String creatorAccountId;

        private String privacyBudgetType;

        private Instant createTime;

        private Instant updateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(CollaborationPrivacyBudgetTemplateSummary model) {
            id(model.id);
            arn(model.arn);
            collaborationId(model.collaborationId);
            collaborationArn(model.collaborationArn);
            creatorAccountId(model.creatorAccountId);
            privacyBudgetType(model.privacyBudgetType);
            createTime(model.createTime);
            updateTime(model.updateTime);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getCollaborationId() {
            return collaborationId;
        }

        public final void setCollaborationId(String collaborationId) {
            this.collaborationId = collaborationId;
        }

        @Override
        public final Builder collaborationId(String collaborationId) {
            this.collaborationId = collaborationId;
            return this;
        }

        public final String getCollaborationArn() {
            return collaborationArn;
        }

        public final void setCollaborationArn(String collaborationArn) {
            this.collaborationArn = collaborationArn;
        }

        @Override
        public final Builder collaborationArn(String collaborationArn) {
            this.collaborationArn = collaborationArn;
            return this;
        }

        public final String getCreatorAccountId() {
            return creatorAccountId;
        }

        public final void setCreatorAccountId(String creatorAccountId) {
            this.creatorAccountId = creatorAccountId;
        }

        @Override
        public final Builder creatorAccountId(String creatorAccountId) {
            this.creatorAccountId = creatorAccountId;
            return this;
        }

        public final String getPrivacyBudgetType() {
            return privacyBudgetType;
        }

        public final void setPrivacyBudgetType(String privacyBudgetType) {
            this.privacyBudgetType = privacyBudgetType;
        }

        @Override
        public final Builder privacyBudgetType(String privacyBudgetType) {
            this.privacyBudgetType = privacyBudgetType;
            return this;
        }

        @Override
        public final Builder privacyBudgetType(PrivacyBudgetType privacyBudgetType) {
            this.privacyBudgetType(privacyBudgetType == null ? null : privacyBudgetType.toString());
            return this;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        @Override
        public CollaborationPrivacyBudgetTemplateSummary build() {
            return new CollaborationPrivacyBudgetTemplateSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
