/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The metadata of the collaboration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CollaborationSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<CollaborationSummary.Builder, CollaborationSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(CollaborationSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(CollaborationSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CollaborationSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> CREATOR_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("creatorAccountId").getter(getter(CollaborationSummary::creatorAccountId))
            .setter(setter(Builder::creatorAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creatorAccountId").build()).build();

    private static final SdkField<String> CREATOR_DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("creatorDisplayName").getter(getter(CollaborationSummary::creatorDisplayName))
            .setter(setter(Builder::creatorDisplayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creatorDisplayName").build())
            .build();

    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createTime").getter(getter(CollaborationSummary::createTime)).setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build()).build();

    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updateTime").getter(getter(CollaborationSummary::updateTime)).setter(setter(Builder::updateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build()).build();

    private static final SdkField<String> MEMBER_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("memberStatus").getter(getter(CollaborationSummary::memberStatusAsString))
            .setter(setter(Builder::memberStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memberStatus").build()).build();

    private static final SdkField<String> MEMBERSHIP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("membershipId").getter(getter(CollaborationSummary::membershipId)).setter(setter(Builder::membershipId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipId").build()).build();

    private static final SdkField<String> MEMBERSHIP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("membershipArn").getter(getter(CollaborationSummary::membershipArn))
            .setter(setter(Builder::membershipArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipArn").build()).build();

    private static final SdkField<String> ANALYTICS_ENGINE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("analyticsEngine").getter(getter(CollaborationSummary::analyticsEngineAsString))
            .setter(setter(Builder::analyticsEngine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("analyticsEngine").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD,
            NAME_FIELD, CREATOR_ACCOUNT_ID_FIELD, CREATOR_DISPLAY_NAME_FIELD, CREATE_TIME_FIELD, UPDATE_TIME_FIELD,
            MEMBER_STATUS_FIELD, MEMBERSHIP_ID_FIELD, MEMBERSHIP_ARN_FIELD, ANALYTICS_ENGINE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String arn;

    private final String name;

    private final String creatorAccountId;

    private final String creatorDisplayName;

    private final Instant createTime;

    private final Instant updateTime;

    private final String memberStatus;

    private final String membershipId;

    private final String membershipArn;

    private final String analyticsEngine;

    private CollaborationSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.name = builder.name;
        this.creatorAccountId = builder.creatorAccountId;
        this.creatorDisplayName = builder.creatorDisplayName;
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
        this.memberStatus = builder.memberStatus;
        this.membershipId = builder.membershipId;
        this.membershipArn = builder.membershipArn;
        this.analyticsEngine = builder.analyticsEngine;
    }

    /**
     * <p>
     * The identifier for the collaboration.
     * </p>
     * 
     * @return The identifier for the collaboration.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The ARN of the collaboration.
     * </p>
     * 
     * @return The ARN of the collaboration.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * A human-readable identifier provided by the collaboration owner. Display names are not unique.
     * </p>
     * 
     * @return A human-readable identifier provided by the collaboration owner. Display names are not unique.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The identifier used to reference members of the collaboration. Currently only supports Amazon Web Services
     * account ID.
     * </p>
     * 
     * @return The identifier used to reference members of the collaboration. Currently only supports Amazon Web
     *         Services account ID.
     */
    public final String creatorAccountId() {
        return creatorAccountId;
    }

    /**
     * <p>
     * The display name of the collaboration creator.
     * </p>
     * 
     * @return The display name of the collaboration creator.
     */
    public final String creatorDisplayName() {
        return creatorDisplayName;
    }

    /**
     * <p>
     * The time when the collaboration was created.
     * </p>
     * 
     * @return The time when the collaboration was created.
     */
    public final Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * The time the collaboration metadata was last updated.
     * </p>
     * 
     * @return The time the collaboration metadata was last updated.
     */
    public final Instant updateTime() {
        return updateTime;
    }

    /**
     * <p>
     * The status of a member in a collaboration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #memberStatus} will
     * return {@link MemberStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #memberStatusAsString}.
     * </p>
     * 
     * @return The status of a member in a collaboration.
     * @see MemberStatus
     */
    public final MemberStatus memberStatus() {
        return MemberStatus.fromValue(memberStatus);
    }

    /**
     * <p>
     * The status of a member in a collaboration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #memberStatus} will
     * return {@link MemberStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #memberStatusAsString}.
     * </p>
     * 
     * @return The status of a member in a collaboration.
     * @see MemberStatus
     */
    public final String memberStatusAsString() {
        return memberStatus;
    }

    /**
     * <p>
     * The identifier of a member in a collaboration.
     * </p>
     * 
     * @return The identifier of a member in a collaboration.
     */
    public final String membershipId() {
        return membershipId;
    }

    /**
     * <p>
     * The ARN of a member in a collaboration.
     * </p>
     * 
     * @return The ARN of a member in a collaboration.
     */
    public final String membershipArn() {
        return membershipArn;
    }

    /**
     * <p>
     * The analytics engine.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #analyticsEngine}
     * will return {@link AnalyticsEngine#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #analyticsEngineAsString}.
     * </p>
     * 
     * @return The analytics engine.
     * @see AnalyticsEngine
     */
    public final AnalyticsEngine analyticsEngine() {
        return AnalyticsEngine.fromValue(analyticsEngine);
    }

    /**
     * <p>
     * The analytics engine.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #analyticsEngine}
     * will return {@link AnalyticsEngine#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #analyticsEngineAsString}.
     * </p>
     * 
     * @return The analytics engine.
     * @see AnalyticsEngine
     */
    public final String analyticsEngineAsString() {
        return analyticsEngine;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(creatorAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(creatorDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(memberStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(membershipId());
        hashCode = 31 * hashCode + Objects.hashCode(membershipArn());
        hashCode = 31 * hashCode + Objects.hashCode(analyticsEngineAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CollaborationSummary)) {
            return false;
        }
        CollaborationSummary other = (CollaborationSummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(creatorAccountId(), other.creatorAccountId())
                && Objects.equals(creatorDisplayName(), other.creatorDisplayName())
                && Objects.equals(createTime(), other.createTime()) && Objects.equals(updateTime(), other.updateTime())
                && Objects.equals(memberStatusAsString(), other.memberStatusAsString())
                && Objects.equals(membershipId(), other.membershipId()) && Objects.equals(membershipArn(), other.membershipArn())
                && Objects.equals(analyticsEngineAsString(), other.analyticsEngineAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CollaborationSummary").add("Id", id()).add("Arn", arn()).add("Name", name())
                .add("CreatorAccountId", creatorAccountId()).add("CreatorDisplayName", creatorDisplayName())
                .add("CreateTime", createTime()).add("UpdateTime", updateTime()).add("MemberStatus", memberStatusAsString())
                .add("MembershipId", membershipId()).add("MembershipArn", membershipArn())
                .add("AnalyticsEngine", analyticsEngineAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "creatorAccountId":
            return Optional.ofNullable(clazz.cast(creatorAccountId()));
        case "creatorDisplayName":
            return Optional.ofNullable(clazz.cast(creatorDisplayName()));
        case "createTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "updateTime":
            return Optional.ofNullable(clazz.cast(updateTime()));
        case "memberStatus":
            return Optional.ofNullable(clazz.cast(memberStatusAsString()));
        case "membershipId":
            return Optional.ofNullable(clazz.cast(membershipId()));
        case "membershipArn":
            return Optional.ofNullable(clazz.cast(membershipArn()));
        case "analyticsEngine":
            return Optional.ofNullable(clazz.cast(analyticsEngineAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("creatorAccountId", CREATOR_ACCOUNT_ID_FIELD);
        map.put("creatorDisplayName", CREATOR_DISPLAY_NAME_FIELD);
        map.put("createTime", CREATE_TIME_FIELD);
        map.put("updateTime", UPDATE_TIME_FIELD);
        map.put("memberStatus", MEMBER_STATUS_FIELD);
        map.put("membershipId", MEMBERSHIP_ID_FIELD);
        map.put("membershipArn", MEMBERSHIP_ARN_FIELD);
        map.put("analyticsEngine", ANALYTICS_ENGINE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CollaborationSummary, T> g) {
        return obj -> g.apply((CollaborationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CollaborationSummary> {
        /**
         * <p>
         * The identifier for the collaboration.
         * </p>
         * 
         * @param id
         *        The identifier for the collaboration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The ARN of the collaboration.
         * </p>
         * 
         * @param arn
         *        The ARN of the collaboration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * A human-readable identifier provided by the collaboration owner. Display names are not unique.
         * </p>
         * 
         * @param name
         *        A human-readable identifier provided by the collaboration owner. Display names are not unique.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The identifier used to reference members of the collaboration. Currently only supports Amazon Web Services
         * account ID.
         * </p>
         * 
         * @param creatorAccountId
         *        The identifier used to reference members of the collaboration. Currently only supports Amazon Web
         *        Services account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creatorAccountId(String creatorAccountId);

        /**
         * <p>
         * The display name of the collaboration creator.
         * </p>
         * 
         * @param creatorDisplayName
         *        The display name of the collaboration creator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creatorDisplayName(String creatorDisplayName);

        /**
         * <p>
         * The time when the collaboration was created.
         * </p>
         * 
         * @param createTime
         *        The time when the collaboration was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * The time the collaboration metadata was last updated.
         * </p>
         * 
         * @param updateTime
         *        The time the collaboration metadata was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTime(Instant updateTime);

        /**
         * <p>
         * The status of a member in a collaboration.
         * </p>
         * 
         * @param memberStatus
         *        The status of a member in a collaboration.
         * @see MemberStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MemberStatus
         */
        Builder memberStatus(String memberStatus);

        /**
         * <p>
         * The status of a member in a collaboration.
         * </p>
         * 
         * @param memberStatus
         *        The status of a member in a collaboration.
         * @see MemberStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MemberStatus
         */
        Builder memberStatus(MemberStatus memberStatus);

        /**
         * <p>
         * The identifier of a member in a collaboration.
         * </p>
         * 
         * @param membershipId
         *        The identifier of a member in a collaboration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder membershipId(String membershipId);

        /**
         * <p>
         * The ARN of a member in a collaboration.
         * </p>
         * 
         * @param membershipArn
         *        The ARN of a member in a collaboration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder membershipArn(String membershipArn);

        /**
         * <p>
         * The analytics engine.
         * </p>
         * 
         * @param analyticsEngine
         *        The analytics engine.
         * @see AnalyticsEngine
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnalyticsEngine
         */
        Builder analyticsEngine(String analyticsEngine);

        /**
         * <p>
         * The analytics engine.
         * </p>
         * 
         * @param analyticsEngine
         *        The analytics engine.
         * @see AnalyticsEngine
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnalyticsEngine
         */
        Builder analyticsEngine(AnalyticsEngine analyticsEngine);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String arn;

        private String name;

        private String creatorAccountId;

        private String creatorDisplayName;

        private Instant createTime;

        private Instant updateTime;

        private String memberStatus;

        private String membershipId;

        private String membershipArn;

        private String analyticsEngine;

        private BuilderImpl() {
        }

        private BuilderImpl(CollaborationSummary model) {
            id(model.id);
            arn(model.arn);
            name(model.name);
            creatorAccountId(model.creatorAccountId);
            creatorDisplayName(model.creatorDisplayName);
            createTime(model.createTime);
            updateTime(model.updateTime);
            memberStatus(model.memberStatus);
            membershipId(model.membershipId);
            membershipArn(model.membershipArn);
            analyticsEngine(model.analyticsEngine);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getCreatorAccountId() {
            return creatorAccountId;
        }

        public final void setCreatorAccountId(String creatorAccountId) {
            this.creatorAccountId = creatorAccountId;
        }

        @Override
        public final Builder creatorAccountId(String creatorAccountId) {
            this.creatorAccountId = creatorAccountId;
            return this;
        }

        public final String getCreatorDisplayName() {
            return creatorDisplayName;
        }

        public final void setCreatorDisplayName(String creatorDisplayName) {
            this.creatorDisplayName = creatorDisplayName;
        }

        @Override
        public final Builder creatorDisplayName(String creatorDisplayName) {
            this.creatorDisplayName = creatorDisplayName;
            return this;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final String getMemberStatus() {
            return memberStatus;
        }

        public final void setMemberStatus(String memberStatus) {
            this.memberStatus = memberStatus;
        }

        @Override
        public final Builder memberStatus(String memberStatus) {
            this.memberStatus = memberStatus;
            return this;
        }

        @Override
        public final Builder memberStatus(MemberStatus memberStatus) {
            this.memberStatus(memberStatus == null ? null : memberStatus.toString());
            return this;
        }

        public final String getMembershipId() {
            return membershipId;
        }

        public final void setMembershipId(String membershipId) {
            this.membershipId = membershipId;
        }

        @Override
        public final Builder membershipId(String membershipId) {
            this.membershipId = membershipId;
            return this;
        }

        public final String getMembershipArn() {
            return membershipArn;
        }

        public final void setMembershipArn(String membershipArn) {
            this.membershipArn = membershipArn;
        }

        @Override
        public final Builder membershipArn(String membershipArn) {
            this.membershipArn = membershipArn;
            return this;
        }

        public final String getAnalyticsEngine() {
            return analyticsEngine;
        }

        public final void setAnalyticsEngine(String analyticsEngine) {
            this.analyticsEngine = analyticsEngine;
        }

        @Override
        public final Builder analyticsEngine(String analyticsEngine) {
            this.analyticsEngine = analyticsEngine;
            return this;
        }

        @Override
        public final Builder analyticsEngine(AnalyticsEngine analyticsEngine) {
            this.analyticsEngine(analyticsEngine == null ? null : analyticsEngine.toString());
            return this;
        }

        @Override
        public CollaborationSummary build() {
            return new CollaborationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
