/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A configured table association links a configured table to a collaboration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConfiguredTableAssociation implements SdkPojo, Serializable,
        ToCopyableBuilder<ConfiguredTableAssociation.Builder, ConfiguredTableAssociation> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(ConfiguredTableAssociation::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(ConfiguredTableAssociation::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> CONFIGURED_TABLE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("configuredTableId").getter(getter(ConfiguredTableAssociation::configuredTableId))
            .setter(setter(Builder::configuredTableId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuredTableId").build()).build();

    private static final SdkField<String> CONFIGURED_TABLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("configuredTableArn").getter(getter(ConfiguredTableAssociation::configuredTableArn))
            .setter(setter(Builder::configuredTableArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuredTableArn").build())
            .build();

    private static final SdkField<String> MEMBERSHIP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("membershipId").getter(getter(ConfiguredTableAssociation::membershipId))
            .setter(setter(Builder::membershipId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipId").build()).build();

    private static final SdkField<String> MEMBERSHIP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("membershipArn").getter(getter(ConfiguredTableAssociation::membershipArn))
            .setter(setter(Builder::membershipArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipArn").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(ConfiguredTableAssociation::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ConfiguredTableAssociation::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(ConfiguredTableAssociation::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<String>> ANALYSIS_RULE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("analysisRuleTypes")
            .getter(getter(ConfiguredTableAssociation::analysisRuleTypesAsStrings))
            .setter(setter(Builder::analysisRuleTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("analysisRuleTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createTime").getter(getter(ConfiguredTableAssociation::createTime)).setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build()).build();

    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updateTime").getter(getter(ConfiguredTableAssociation::updateTime)).setter(setter(Builder::updateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ID_FIELD,
            CONFIGURED_TABLE_ID_FIELD, CONFIGURED_TABLE_ARN_FIELD, MEMBERSHIP_ID_FIELD, MEMBERSHIP_ARN_FIELD, ROLE_ARN_FIELD,
            NAME_FIELD, DESCRIPTION_FIELD, ANALYSIS_RULE_TYPES_FIELD, CREATE_TIME_FIELD, UPDATE_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String id;

    private final String configuredTableId;

    private final String configuredTableArn;

    private final String membershipId;

    private final String membershipArn;

    private final String roleArn;

    private final String name;

    private final String description;

    private final List<String> analysisRuleTypes;

    private final Instant createTime;

    private final Instant updateTime;

    private ConfiguredTableAssociation(BuilderImpl builder) {
        this.arn = builder.arn;
        this.id = builder.id;
        this.configuredTableId = builder.configuredTableId;
        this.configuredTableArn = builder.configuredTableArn;
        this.membershipId = builder.membershipId;
        this.membershipArn = builder.membershipArn;
        this.roleArn = builder.roleArn;
        this.name = builder.name;
        this.description = builder.description;
        this.analysisRuleTypes = builder.analysisRuleTypes;
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
    }

    /**
     * <p>
     * The unique ARN for the configured table association.
     * </p>
     * 
     * @return The unique ARN for the configured table association.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The unique ID for the configured table association.
     * </p>
     * 
     * @return The unique ID for the configured table association.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The unique ID for the configured table that the association refers to.
     * </p>
     * 
     * @return The unique ID for the configured table that the association refers to.
     */
    public final String configuredTableId() {
        return configuredTableId;
    }

    /**
     * <p>
     * The unique ARN for the configured table that the association refers to.
     * </p>
     * 
     * @return The unique ARN for the configured table that the association refers to.
     */
    public final String configuredTableArn() {
        return configuredTableArn;
    }

    /**
     * <p>
     * The unique ID for the membership this configured table association belongs to.
     * </p>
     * 
     * @return The unique ID for the membership this configured table association belongs to.
     */
    public final String membershipId() {
        return membershipId;
    }

    /**
     * <p>
     * The unique ARN for the membership this configured table association belongs to.
     * </p>
     * 
     * @return The unique ARN for the membership this configured table association belongs to.
     */
    public final String membershipArn() {
        return membershipArn;
    }

    /**
     * <p>
     * The service will assume this role to access catalog metadata and query the table.
     * </p>
     * 
     * @return The service will assume this role to access catalog metadata and query the table.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The name of the configured table association, in lowercase. The table is identified by this name when running
     * protected queries against the underlying data.
     * </p>
     * 
     * @return The name of the configured table association, in lowercase. The table is identified by this name when
     *         running protected queries against the underlying data.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A description of the configured table association.
     * </p>
     * 
     * @return A description of the configured table association.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The analysis rule types for the configured table association.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAnalysisRuleTypes} method.
     * </p>
     * 
     * @return The analysis rule types for the configured table association.
     */
    public final List<ConfiguredTableAssociationAnalysisRuleType> analysisRuleTypes() {
        return ConfiguredTableAssociationAnalysisRuleTypeListCopier.copyStringToEnum(analysisRuleTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the AnalysisRuleTypes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAnalysisRuleTypes() {
        return analysisRuleTypes != null && !(analysisRuleTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The analysis rule types for the configured table association.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAnalysisRuleTypes} method.
     * </p>
     * 
     * @return The analysis rule types for the configured table association.
     */
    public final List<String> analysisRuleTypesAsStrings() {
        return analysisRuleTypes;
    }

    /**
     * <p>
     * The time the configured table association was created.
     * </p>
     * 
     * @return The time the configured table association was created.
     */
    public final Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * The time the configured table association was last updated.
     * </p>
     * 
     * @return The time the configured table association was last updated.
     */
    public final Instant updateTime() {
        return updateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(configuredTableId());
        hashCode = 31 * hashCode + Objects.hashCode(configuredTableArn());
        hashCode = 31 * hashCode + Objects.hashCode(membershipId());
        hashCode = 31 * hashCode + Objects.hashCode(membershipArn());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasAnalysisRuleTypes() ? analysisRuleTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(updateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfiguredTableAssociation)) {
            return false;
        }
        ConfiguredTableAssociation other = (ConfiguredTableAssociation) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(id(), other.id())
                && Objects.equals(configuredTableId(), other.configuredTableId())
                && Objects.equals(configuredTableArn(), other.configuredTableArn())
                && Objects.equals(membershipId(), other.membershipId()) && Objects.equals(membershipArn(), other.membershipArn())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && hasAnalysisRuleTypes() == other.hasAnalysisRuleTypes()
                && Objects.equals(analysisRuleTypesAsStrings(), other.analysisRuleTypesAsStrings())
                && Objects.equals(createTime(), other.createTime()) && Objects.equals(updateTime(), other.updateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConfiguredTableAssociation").add("Arn", arn()).add("Id", id())
                .add("ConfiguredTableId", configuredTableId()).add("ConfiguredTableArn", configuredTableArn())
                .add("MembershipId", membershipId()).add("MembershipArn", membershipArn()).add("RoleArn", roleArn())
                .add("Name", name()).add("Description", description())
                .add("AnalysisRuleTypes", hasAnalysisRuleTypes() ? analysisRuleTypesAsStrings() : null)
                .add("CreateTime", createTime()).add("UpdateTime", updateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "configuredTableId":
            return Optional.ofNullable(clazz.cast(configuredTableId()));
        case "configuredTableArn":
            return Optional.ofNullable(clazz.cast(configuredTableArn()));
        case "membershipId":
            return Optional.ofNullable(clazz.cast(membershipId()));
        case "membershipArn":
            return Optional.ofNullable(clazz.cast(membershipArn()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "analysisRuleTypes":
            return Optional.ofNullable(clazz.cast(analysisRuleTypesAsStrings()));
        case "createTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "updateTime":
            return Optional.ofNullable(clazz.cast(updateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("id", ID_FIELD);
        map.put("configuredTableId", CONFIGURED_TABLE_ID_FIELD);
        map.put("configuredTableArn", CONFIGURED_TABLE_ARN_FIELD);
        map.put("membershipId", MEMBERSHIP_ID_FIELD);
        map.put("membershipArn", MEMBERSHIP_ARN_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("analysisRuleTypes", ANALYSIS_RULE_TYPES_FIELD);
        map.put("createTime", CREATE_TIME_FIELD);
        map.put("updateTime", UPDATE_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConfiguredTableAssociation, T> g) {
        return obj -> g.apply((ConfiguredTableAssociation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConfiguredTableAssociation> {
        /**
         * <p>
         * The unique ARN for the configured table association.
         * </p>
         * 
         * @param arn
         *        The unique ARN for the configured table association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The unique ID for the configured table association.
         * </p>
         * 
         * @param id
         *        The unique ID for the configured table association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The unique ID for the configured table that the association refers to.
         * </p>
         * 
         * @param configuredTableId
         *        The unique ID for the configured table that the association refers to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuredTableId(String configuredTableId);

        /**
         * <p>
         * The unique ARN for the configured table that the association refers to.
         * </p>
         * 
         * @param configuredTableArn
         *        The unique ARN for the configured table that the association refers to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuredTableArn(String configuredTableArn);

        /**
         * <p>
         * The unique ID for the membership this configured table association belongs to.
         * </p>
         * 
         * @param membershipId
         *        The unique ID for the membership this configured table association belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder membershipId(String membershipId);

        /**
         * <p>
         * The unique ARN for the membership this configured table association belongs to.
         * </p>
         * 
         * @param membershipArn
         *        The unique ARN for the membership this configured table association belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder membershipArn(String membershipArn);

        /**
         * <p>
         * The service will assume this role to access catalog metadata and query the table.
         * </p>
         * 
         * @param roleArn
         *        The service will assume this role to access catalog metadata and query the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The name of the configured table association, in lowercase. The table is identified by this name when running
         * protected queries against the underlying data.
         * </p>
         * 
         * @param name
         *        The name of the configured table association, in lowercase. The table is identified by this name when
         *        running protected queries against the underlying data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description of the configured table association.
         * </p>
         * 
         * @param description
         *        A description of the configured table association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The analysis rule types for the configured table association.
         * </p>
         * 
         * @param analysisRuleTypes
         *        The analysis rule types for the configured table association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analysisRuleTypesWithStrings(Collection<String> analysisRuleTypes);

        /**
         * <p>
         * The analysis rule types for the configured table association.
         * </p>
         * 
         * @param analysisRuleTypes
         *        The analysis rule types for the configured table association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analysisRuleTypesWithStrings(String... analysisRuleTypes);

        /**
         * <p>
         * The analysis rule types for the configured table association.
         * </p>
         * 
         * @param analysisRuleTypes
         *        The analysis rule types for the configured table association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analysisRuleTypes(Collection<ConfiguredTableAssociationAnalysisRuleType> analysisRuleTypes);

        /**
         * <p>
         * The analysis rule types for the configured table association.
         * </p>
         * 
         * @param analysisRuleTypes
         *        The analysis rule types for the configured table association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analysisRuleTypes(ConfiguredTableAssociationAnalysisRuleType... analysisRuleTypes);

        /**
         * <p>
         * The time the configured table association was created.
         * </p>
         * 
         * @param createTime
         *        The time the configured table association was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * The time the configured table association was last updated.
         * </p>
         * 
         * @param updateTime
         *        The time the configured table association was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTime(Instant updateTime);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String id;

        private String configuredTableId;

        private String configuredTableArn;

        private String membershipId;

        private String membershipArn;

        private String roleArn;

        private String name;

        private String description;

        private List<String> analysisRuleTypes = DefaultSdkAutoConstructList.getInstance();

        private Instant createTime;

        private Instant updateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfiguredTableAssociation model) {
            arn(model.arn);
            id(model.id);
            configuredTableId(model.configuredTableId);
            configuredTableArn(model.configuredTableArn);
            membershipId(model.membershipId);
            membershipArn(model.membershipArn);
            roleArn(model.roleArn);
            name(model.name);
            description(model.description);
            analysisRuleTypesWithStrings(model.analysisRuleTypes);
            createTime(model.createTime);
            updateTime(model.updateTime);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getConfiguredTableId() {
            return configuredTableId;
        }

        public final void setConfiguredTableId(String configuredTableId) {
            this.configuredTableId = configuredTableId;
        }

        @Override
        public final Builder configuredTableId(String configuredTableId) {
            this.configuredTableId = configuredTableId;
            return this;
        }

        public final String getConfiguredTableArn() {
            return configuredTableArn;
        }

        public final void setConfiguredTableArn(String configuredTableArn) {
            this.configuredTableArn = configuredTableArn;
        }

        @Override
        public final Builder configuredTableArn(String configuredTableArn) {
            this.configuredTableArn = configuredTableArn;
            return this;
        }

        public final String getMembershipId() {
            return membershipId;
        }

        public final void setMembershipId(String membershipId) {
            this.membershipId = membershipId;
        }

        @Override
        public final Builder membershipId(String membershipId) {
            this.membershipId = membershipId;
            return this;
        }

        public final String getMembershipArn() {
            return membershipArn;
        }

        public final void setMembershipArn(String membershipArn) {
            this.membershipArn = membershipArn;
        }

        @Override
        public final Builder membershipArn(String membershipArn) {
            this.membershipArn = membershipArn;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getAnalysisRuleTypes() {
            if (analysisRuleTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return analysisRuleTypes;
        }

        public final void setAnalysisRuleTypes(Collection<String> analysisRuleTypes) {
            this.analysisRuleTypes = ConfiguredTableAssociationAnalysisRuleTypeListCopier.copy(analysisRuleTypes);
        }

        @Override
        public final Builder analysisRuleTypesWithStrings(Collection<String> analysisRuleTypes) {
            this.analysisRuleTypes = ConfiguredTableAssociationAnalysisRuleTypeListCopier.copy(analysisRuleTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analysisRuleTypesWithStrings(String... analysisRuleTypes) {
            analysisRuleTypesWithStrings(Arrays.asList(analysisRuleTypes));
            return this;
        }

        @Override
        public final Builder analysisRuleTypes(Collection<ConfiguredTableAssociationAnalysisRuleType> analysisRuleTypes) {
            this.analysisRuleTypes = ConfiguredTableAssociationAnalysisRuleTypeListCopier.copyEnumToString(analysisRuleTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analysisRuleTypes(ConfiguredTableAssociationAnalysisRuleType... analysisRuleTypes) {
            analysisRuleTypes(Arrays.asList(analysisRuleTypes));
            return this;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        @Override
        public ConfiguredTableAssociation build() {
            return new ConfiguredTableAssociation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
