/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An analysis rule for a configured table association. This analysis rule specifies how data from the table can be used
 * within its associated collaboration. In the console, the <code>ConfiguredTableAssociationAnalysisRule</code> is
 * referred to as the <i>collaboration analysis rule</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConfiguredTableAssociationAnalysisRule implements SdkPojo, Serializable,
        ToCopyableBuilder<ConfiguredTableAssociationAnalysisRule.Builder, ConfiguredTableAssociationAnalysisRule> {
    private static final SdkField<String> MEMBERSHIP_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("membershipIdentifier").getter(getter(ConfiguredTableAssociationAnalysisRule::membershipIdentifier))
            .setter(setter(Builder::membershipIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipIdentifier").build())
            .build();

    private static final SdkField<String> CONFIGURED_TABLE_ASSOCIATION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("configuredTableAssociationId")
            .getter(getter(ConfiguredTableAssociationAnalysisRule::configuredTableAssociationId))
            .setter(setter(Builder::configuredTableAssociationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuredTableAssociationId")
                    .build()).build();

    private static final SdkField<String> CONFIGURED_TABLE_ASSOCIATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("configuredTableAssociationArn")
            .getter(getter(ConfiguredTableAssociationAnalysisRule::configuredTableAssociationArn))
            .setter(setter(Builder::configuredTableAssociationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuredTableAssociationArn")
                    .build()).build();

    private static final SdkField<ConfiguredTableAssociationAnalysisRulePolicy> POLICY_FIELD = SdkField
            .<ConfiguredTableAssociationAnalysisRulePolicy> builder(MarshallingType.SDK_POJO).memberName("policy")
            .getter(getter(ConfiguredTableAssociationAnalysisRule::policy)).setter(setter(Builder::policy))
            .constructor(ConfiguredTableAssociationAnalysisRulePolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policy").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(ConfiguredTableAssociationAnalysisRule::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createTime").getter(getter(ConfiguredTableAssociationAnalysisRule::createTime))
            .setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build()).build();

    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updateTime").getter(getter(ConfiguredTableAssociationAnalysisRule::updateTime))
            .setter(setter(Builder::updateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBERSHIP_IDENTIFIER_FIELD,
            CONFIGURED_TABLE_ASSOCIATION_ID_FIELD, CONFIGURED_TABLE_ASSOCIATION_ARN_FIELD, POLICY_FIELD, TYPE_FIELD,
            CREATE_TIME_FIELD, UPDATE_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String membershipIdentifier;

    private final String configuredTableAssociationId;

    private final String configuredTableAssociationArn;

    private final ConfiguredTableAssociationAnalysisRulePolicy policy;

    private final String type;

    private final Instant createTime;

    private final Instant updateTime;

    private ConfiguredTableAssociationAnalysisRule(BuilderImpl builder) {
        this.membershipIdentifier = builder.membershipIdentifier;
        this.configuredTableAssociationId = builder.configuredTableAssociationId;
        this.configuredTableAssociationArn = builder.configuredTableAssociationArn;
        this.policy = builder.policy;
        this.type = builder.type;
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
    }

    /**
     * <p>
     * The membership identifier for the configured table association analysis rule.
     * </p>
     * 
     * @return The membership identifier for the configured table association analysis rule.
     */
    public final String membershipIdentifier() {
        return membershipIdentifier;
    }

    /**
     * <p>
     * The unique identifier for the configured table association.
     * </p>
     * 
     * @return The unique identifier for the configured table association.
     */
    public final String configuredTableAssociationId() {
        return configuredTableAssociationId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the configured table association.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the configured table association.
     */
    public final String configuredTableAssociationArn() {
        return configuredTableAssociationArn;
    }

    /**
     * <p>
     * The policy of the configured table association analysis rule.
     * </p>
     * 
     * @return The policy of the configured table association analysis rule.
     */
    public final ConfiguredTableAssociationAnalysisRulePolicy policy() {
        return policy;
    }

    /**
     * <p>
     * The type of the configured table association analysis rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ConfiguredTableAssociationAnalysisRuleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the configured table association analysis rule.
     * @see ConfiguredTableAssociationAnalysisRuleType
     */
    public final ConfiguredTableAssociationAnalysisRuleType type() {
        return ConfiguredTableAssociationAnalysisRuleType.fromValue(type);
    }

    /**
     * <p>
     * The type of the configured table association analysis rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ConfiguredTableAssociationAnalysisRuleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the configured table association analysis rule.
     * @see ConfiguredTableAssociationAnalysisRuleType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The creation time of the configured table association analysis rule.
     * </p>
     * 
     * @return The creation time of the configured table association analysis rule.
     */
    public final Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * The update time of the configured table association analysis rule.
     * </p>
     * 
     * @return The update time of the configured table association analysis rule.
     */
    public final Instant updateTime() {
        return updateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(membershipIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(configuredTableAssociationId());
        hashCode = 31 * hashCode + Objects.hashCode(configuredTableAssociationArn());
        hashCode = 31 * hashCode + Objects.hashCode(policy());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(updateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfiguredTableAssociationAnalysisRule)) {
            return false;
        }
        ConfiguredTableAssociationAnalysisRule other = (ConfiguredTableAssociationAnalysisRule) obj;
        return Objects.equals(membershipIdentifier(), other.membershipIdentifier())
                && Objects.equals(configuredTableAssociationId(), other.configuredTableAssociationId())
                && Objects.equals(configuredTableAssociationArn(), other.configuredTableAssociationArn())
                && Objects.equals(policy(), other.policy()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(createTime(), other.createTime()) && Objects.equals(updateTime(), other.updateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConfiguredTableAssociationAnalysisRule").add("MembershipIdentifier", membershipIdentifier())
                .add("ConfiguredTableAssociationId", configuredTableAssociationId())
                .add("ConfiguredTableAssociationArn", configuredTableAssociationArn()).add("Policy", policy())
                .add("Type", typeAsString()).add("CreateTime", createTime()).add("UpdateTime", updateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "membershipIdentifier":
            return Optional.ofNullable(clazz.cast(membershipIdentifier()));
        case "configuredTableAssociationId":
            return Optional.ofNullable(clazz.cast(configuredTableAssociationId()));
        case "configuredTableAssociationArn":
            return Optional.ofNullable(clazz.cast(configuredTableAssociationArn()));
        case "policy":
            return Optional.ofNullable(clazz.cast(policy()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "createTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "updateTime":
            return Optional.ofNullable(clazz.cast(updateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("membershipIdentifier", MEMBERSHIP_IDENTIFIER_FIELD);
        map.put("configuredTableAssociationId", CONFIGURED_TABLE_ASSOCIATION_ID_FIELD);
        map.put("configuredTableAssociationArn", CONFIGURED_TABLE_ASSOCIATION_ARN_FIELD);
        map.put("policy", POLICY_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("createTime", CREATE_TIME_FIELD);
        map.put("updateTime", UPDATE_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConfiguredTableAssociationAnalysisRule, T> g) {
        return obj -> g.apply((ConfiguredTableAssociationAnalysisRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConfiguredTableAssociationAnalysisRule> {
        /**
         * <p>
         * The membership identifier for the configured table association analysis rule.
         * </p>
         * 
         * @param membershipIdentifier
         *        The membership identifier for the configured table association analysis rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder membershipIdentifier(String membershipIdentifier);

        /**
         * <p>
         * The unique identifier for the configured table association.
         * </p>
         * 
         * @param configuredTableAssociationId
         *        The unique identifier for the configured table association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuredTableAssociationId(String configuredTableAssociationId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the configured table association.
         * </p>
         * 
         * @param configuredTableAssociationArn
         *        The Amazon Resource Name (ARN) of the configured table association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuredTableAssociationArn(String configuredTableAssociationArn);

        /**
         * <p>
         * The policy of the configured table association analysis rule.
         * </p>
         * 
         * @param policy
         *        The policy of the configured table association analysis rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policy(ConfiguredTableAssociationAnalysisRulePolicy policy);

        /**
         * <p>
         * The policy of the configured table association analysis rule.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ConfiguredTableAssociationAnalysisRulePolicy.Builder} avoiding the need to create one manually via
         * {@link ConfiguredTableAssociationAnalysisRulePolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConfiguredTableAssociationAnalysisRulePolicy.Builder#build()} is
         * called immediately and its result is passed to {@link #policy(ConfiguredTableAssociationAnalysisRulePolicy)}.
         * 
         * @param policy
         *        a consumer that will call methods on {@link ConfiguredTableAssociationAnalysisRulePolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #policy(ConfiguredTableAssociationAnalysisRulePolicy)
         */
        default Builder policy(Consumer<ConfiguredTableAssociationAnalysisRulePolicy.Builder> policy) {
            return policy(ConfiguredTableAssociationAnalysisRulePolicy.builder().applyMutation(policy).build());
        }

        /**
         * <p>
         * The type of the configured table association analysis rule.
         * </p>
         * 
         * @param type
         *        The type of the configured table association analysis rule.
         * @see ConfiguredTableAssociationAnalysisRuleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfiguredTableAssociationAnalysisRuleType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the configured table association analysis rule.
         * </p>
         * 
         * @param type
         *        The type of the configured table association analysis rule.
         * @see ConfiguredTableAssociationAnalysisRuleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfiguredTableAssociationAnalysisRuleType
         */
        Builder type(ConfiguredTableAssociationAnalysisRuleType type);

        /**
         * <p>
         * The creation time of the configured table association analysis rule.
         * </p>
         * 
         * @param createTime
         *        The creation time of the configured table association analysis rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * The update time of the configured table association analysis rule.
         * </p>
         * 
         * @param updateTime
         *        The update time of the configured table association analysis rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTime(Instant updateTime);
    }

    static final class BuilderImpl implements Builder {
        private String membershipIdentifier;

        private String configuredTableAssociationId;

        private String configuredTableAssociationArn;

        private ConfiguredTableAssociationAnalysisRulePolicy policy;

        private String type;

        private Instant createTime;

        private Instant updateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfiguredTableAssociationAnalysisRule model) {
            membershipIdentifier(model.membershipIdentifier);
            configuredTableAssociationId(model.configuredTableAssociationId);
            configuredTableAssociationArn(model.configuredTableAssociationArn);
            policy(model.policy);
            type(model.type);
            createTime(model.createTime);
            updateTime(model.updateTime);
        }

        public final String getMembershipIdentifier() {
            return membershipIdentifier;
        }

        public final void setMembershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
        }

        @Override
        public final Builder membershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
            return this;
        }

        public final String getConfiguredTableAssociationId() {
            return configuredTableAssociationId;
        }

        public final void setConfiguredTableAssociationId(String configuredTableAssociationId) {
            this.configuredTableAssociationId = configuredTableAssociationId;
        }

        @Override
        public final Builder configuredTableAssociationId(String configuredTableAssociationId) {
            this.configuredTableAssociationId = configuredTableAssociationId;
            return this;
        }

        public final String getConfiguredTableAssociationArn() {
            return configuredTableAssociationArn;
        }

        public final void setConfiguredTableAssociationArn(String configuredTableAssociationArn) {
            this.configuredTableAssociationArn = configuredTableAssociationArn;
        }

        @Override
        public final Builder configuredTableAssociationArn(String configuredTableAssociationArn) {
            this.configuredTableAssociationArn = configuredTableAssociationArn;
            return this;
        }

        public final ConfiguredTableAssociationAnalysisRulePolicy.Builder getPolicy() {
            return policy != null ? policy.toBuilder() : null;
        }

        public final void setPolicy(ConfiguredTableAssociationAnalysisRulePolicy.BuilderImpl policy) {
            this.policy = policy != null ? policy.build() : null;
        }

        @Override
        public final Builder policy(ConfiguredTableAssociationAnalysisRulePolicy policy) {
            this.policy = policy;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ConfiguredTableAssociationAnalysisRuleType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        @Override
        public ConfiguredTableAssociationAnalysisRule build() {
            return new ConfiguredTableAssociationAnalysisRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
