/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configured table association analysis rule applied to a configured table with the aggregation analysis rule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConfiguredTableAssociationAnalysisRuleAggregation
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<ConfiguredTableAssociationAnalysisRuleAggregation.Builder, ConfiguredTableAssociationAnalysisRuleAggregation> {
    private static final SdkField<List<String>> ALLOWED_RESULT_RECEIVERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("allowedResultReceivers")
            .getter(getter(ConfiguredTableAssociationAnalysisRuleAggregation::allowedResultReceivers))
            .setter(setter(Builder::allowedResultReceivers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedResultReceivers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ALLOWED_ADDITIONAL_ANALYSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("allowedAdditionalAnalyses")
            .getter(getter(ConfiguredTableAssociationAnalysisRuleAggregation::allowedAdditionalAnalyses))
            .setter(setter(Builder::allowedAdditionalAnalyses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedAdditionalAnalyses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ALLOWED_RESULT_RECEIVERS_FIELD, ALLOWED_ADDITIONAL_ANALYSES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> allowedResultReceivers;

    private final List<String> allowedAdditionalAnalyses;

    private ConfiguredTableAssociationAnalysisRuleAggregation(BuilderImpl builder) {
        this.allowedResultReceivers = builder.allowedResultReceivers;
        this.allowedAdditionalAnalyses = builder.allowedAdditionalAnalyses;
    }

    /**
     * For responses, this returns true if the service returned a value for the AllowedResultReceivers property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAllowedResultReceivers() {
        return allowedResultReceivers != null && !(allowedResultReceivers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of collaboration members who are allowed to receive results of queries run with this configured table.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllowedResultReceivers} method.
     * </p>
     * 
     * @return The list of collaboration members who are allowed to receive results of queries run with this configured
     *         table.
     */
    public final List<String> allowedResultReceivers() {
        return allowedResultReceivers;
    }

    /**
     * For responses, this returns true if the service returned a value for the AllowedAdditionalAnalyses property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAllowedAdditionalAnalyses() {
        return allowedAdditionalAnalyses != null && !(allowedAdditionalAnalyses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of resources or wildcards (ARNs) that are allowed to perform additional analysis on query output.
     * </p>
     * <p>
     * The <code>allowedAdditionalAnalyses</code> parameter is currently supported for the list analysis rule (
     * <code>AnalysisRuleList</code>) and the custom analysis rule (<code>AnalysisRuleCustom</code>).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllowedAdditionalAnalyses} method.
     * </p>
     * 
     * @return The list of resources or wildcards (ARNs) that are allowed to perform additional analysis on query
     *         output.</p>
     *         <p>
     *         The <code>allowedAdditionalAnalyses</code> parameter is currently supported for the list analysis rule (
     *         <code>AnalysisRuleList</code>) and the custom analysis rule (<code>AnalysisRuleCustom</code>).
     */
    public final List<String> allowedAdditionalAnalyses() {
        return allowedAdditionalAnalyses;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAllowedResultReceivers() ? allowedResultReceivers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAllowedAdditionalAnalyses() ? allowedAdditionalAnalyses() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfiguredTableAssociationAnalysisRuleAggregation)) {
            return false;
        }
        ConfiguredTableAssociationAnalysisRuleAggregation other = (ConfiguredTableAssociationAnalysisRuleAggregation) obj;
        return hasAllowedResultReceivers() == other.hasAllowedResultReceivers()
                && Objects.equals(allowedResultReceivers(), other.allowedResultReceivers())
                && hasAllowedAdditionalAnalyses() == other.hasAllowedAdditionalAnalyses()
                && Objects.equals(allowedAdditionalAnalyses(), other.allowedAdditionalAnalyses());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConfiguredTableAssociationAnalysisRuleAggregation")
                .add("AllowedResultReceivers", hasAllowedResultReceivers() ? allowedResultReceivers() : null)
                .add("AllowedAdditionalAnalyses", hasAllowedAdditionalAnalyses() ? allowedAdditionalAnalyses() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "allowedResultReceivers":
            return Optional.ofNullable(clazz.cast(allowedResultReceivers()));
        case "allowedAdditionalAnalyses":
            return Optional.ofNullable(clazz.cast(allowedAdditionalAnalyses()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("allowedResultReceivers", ALLOWED_RESULT_RECEIVERS_FIELD);
        map.put("allowedAdditionalAnalyses", ALLOWED_ADDITIONAL_ANALYSES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConfiguredTableAssociationAnalysisRuleAggregation, T> g) {
        return obj -> g.apply((ConfiguredTableAssociationAnalysisRuleAggregation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConfiguredTableAssociationAnalysisRuleAggregation> {
        /**
         * <p>
         * The list of collaboration members who are allowed to receive results of queries run with this configured
         * table.
         * </p>
         * 
         * @param allowedResultReceivers
         *        The list of collaboration members who are allowed to receive results of queries run with this
         *        configured table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedResultReceivers(Collection<String> allowedResultReceivers);

        /**
         * <p>
         * The list of collaboration members who are allowed to receive results of queries run with this configured
         * table.
         * </p>
         * 
         * @param allowedResultReceivers
         *        The list of collaboration members who are allowed to receive results of queries run with this
         *        configured table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedResultReceivers(String... allowedResultReceivers);

        /**
         * <p>
         * The list of resources or wildcards (ARNs) that are allowed to perform additional analysis on query output.
         * </p>
         * <p>
         * The <code>allowedAdditionalAnalyses</code> parameter is currently supported for the list analysis rule (
         * <code>AnalysisRuleList</code>) and the custom analysis rule (<code>AnalysisRuleCustom</code>).
         * </p>
         * 
         * @param allowedAdditionalAnalyses
         *        The list of resources or wildcards (ARNs) that are allowed to perform additional analysis on query
         *        output.</p>
         *        <p>
         *        The <code>allowedAdditionalAnalyses</code> parameter is currently supported for the list analysis rule
         *        (<code>AnalysisRuleList</code>) and the custom analysis rule (<code>AnalysisRuleCustom</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedAdditionalAnalyses(Collection<String> allowedAdditionalAnalyses);

        /**
         * <p>
         * The list of resources or wildcards (ARNs) that are allowed to perform additional analysis on query output.
         * </p>
         * <p>
         * The <code>allowedAdditionalAnalyses</code> parameter is currently supported for the list analysis rule (
         * <code>AnalysisRuleList</code>) and the custom analysis rule (<code>AnalysisRuleCustom</code>).
         * </p>
         * 
         * @param allowedAdditionalAnalyses
         *        The list of resources or wildcards (ARNs) that are allowed to perform additional analysis on query
         *        output.</p>
         *        <p>
         *        The <code>allowedAdditionalAnalyses</code> parameter is currently supported for the list analysis rule
         *        (<code>AnalysisRuleList</code>) and the custom analysis rule (<code>AnalysisRuleCustom</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedAdditionalAnalyses(String... allowedAdditionalAnalyses);
    }

    static final class BuilderImpl implements Builder {
        private List<String> allowedResultReceivers = DefaultSdkAutoConstructList.getInstance();

        private List<String> allowedAdditionalAnalyses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ConfiguredTableAssociationAnalysisRuleAggregation model) {
            allowedResultReceivers(model.allowedResultReceivers);
            allowedAdditionalAnalyses(model.allowedAdditionalAnalyses);
        }

        public final Collection<String> getAllowedResultReceivers() {
            if (allowedResultReceivers instanceof SdkAutoConstructList) {
                return null;
            }
            return allowedResultReceivers;
        }

        public final void setAllowedResultReceivers(Collection<String> allowedResultReceivers) {
            this.allowedResultReceivers = AllowedResultReceiversCopier.copy(allowedResultReceivers);
        }

        @Override
        public final Builder allowedResultReceivers(Collection<String> allowedResultReceivers) {
            this.allowedResultReceivers = AllowedResultReceiversCopier.copy(allowedResultReceivers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedResultReceivers(String... allowedResultReceivers) {
            allowedResultReceivers(Arrays.asList(allowedResultReceivers));
            return this;
        }

        public final Collection<String> getAllowedAdditionalAnalyses() {
            if (allowedAdditionalAnalyses instanceof SdkAutoConstructList) {
                return null;
            }
            return allowedAdditionalAnalyses;
        }

        public final void setAllowedAdditionalAnalyses(Collection<String> allowedAdditionalAnalyses) {
            this.allowedAdditionalAnalyses = AllowedAdditionalAnalysesCopier.copy(allowedAdditionalAnalyses);
        }

        @Override
        public final Builder allowedAdditionalAnalyses(Collection<String> allowedAdditionalAnalyses) {
            this.allowedAdditionalAnalyses = AllowedAdditionalAnalysesCopier.copy(allowedAdditionalAnalyses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedAdditionalAnalyses(String... allowedAdditionalAnalyses) {
            allowedAdditionalAnalyses(Arrays.asList(allowedAdditionalAnalyses));
            return this;
        }

        @Override
        public ConfiguredTableAssociationAnalysisRuleAggregation build() {
            return new ConfiguredTableAssociationAnalysisRuleAggregation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
