/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An array that contains the sensitivity parameters.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DifferentialPrivacyParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<DifferentialPrivacyParameters.Builder, DifferentialPrivacyParameters> {
    private static final SdkField<List<DifferentialPrivacySensitivityParameters>> SENSITIVITY_PARAMETERS_FIELD = SdkField
            .<List<DifferentialPrivacySensitivityParameters>> builder(MarshallingType.LIST)
            .memberName("sensitivityParameters")
            .getter(getter(DifferentialPrivacyParameters::sensitivityParameters))
            .setter(setter(Builder::sensitivityParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sensitivityParameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DifferentialPrivacySensitivityParameters> builder(MarshallingType.SDK_POJO)
                                            .constructor(DifferentialPrivacySensitivityParameters::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SENSITIVITY_PARAMETERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<DifferentialPrivacySensitivityParameters> sensitivityParameters;

    private DifferentialPrivacyParameters(BuilderImpl builder) {
        this.sensitivityParameters = builder.sensitivityParameters;
    }

    /**
     * For responses, this returns true if the service returned a value for the SensitivityParameters property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSensitivityParameters() {
        return sensitivityParameters != null && !(sensitivityParameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Provides the sensitivity parameters that you can use to better understand the total amount of noise in query
     * results.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSensitivityParameters} method.
     * </p>
     * 
     * @return Provides the sensitivity parameters that you can use to better understand the total amount of noise in
     *         query results.
     */
    public final List<DifferentialPrivacySensitivityParameters> sensitivityParameters() {
        return sensitivityParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasSensitivityParameters() ? sensitivityParameters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DifferentialPrivacyParameters)) {
            return false;
        }
        DifferentialPrivacyParameters other = (DifferentialPrivacyParameters) obj;
        return hasSensitivityParameters() == other.hasSensitivityParameters()
                && Objects.equals(sensitivityParameters(), other.sensitivityParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DifferentialPrivacyParameters")
                .add("SensitivityParameters", hasSensitivityParameters() ? sensitivityParameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sensitivityParameters":
            return Optional.ofNullable(clazz.cast(sensitivityParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("sensitivityParameters", SENSITIVITY_PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DifferentialPrivacyParameters, T> g) {
        return obj -> g.apply((DifferentialPrivacyParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DifferentialPrivacyParameters> {
        /**
         * <p>
         * Provides the sensitivity parameters that you can use to better understand the total amount of noise in query
         * results.
         * </p>
         * 
         * @param sensitivityParameters
         *        Provides the sensitivity parameters that you can use to better understand the total amount of noise in
         *        query results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sensitivityParameters(Collection<DifferentialPrivacySensitivityParameters> sensitivityParameters);

        /**
         * <p>
         * Provides the sensitivity parameters that you can use to better understand the total amount of noise in query
         * results.
         * </p>
         * 
         * @param sensitivityParameters
         *        Provides the sensitivity parameters that you can use to better understand the total amount of noise in
         *        query results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sensitivityParameters(DifferentialPrivacySensitivityParameters... sensitivityParameters);

        /**
         * <p>
         * Provides the sensitivity parameters that you can use to better understand the total amount of noise in query
         * results.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cleanrooms.model.DifferentialPrivacySensitivityParameters.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.cleanrooms.model.DifferentialPrivacySensitivityParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cleanrooms.model.DifferentialPrivacySensitivityParameters.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #sensitivityParameters(List<DifferentialPrivacySensitivityParameters>)}.
         * 
         * @param sensitivityParameters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cleanrooms.model.DifferentialPrivacySensitivityParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sensitivityParameters(java.util.Collection<DifferentialPrivacySensitivityParameters>)
         */
        Builder sensitivityParameters(Consumer<DifferentialPrivacySensitivityParameters.Builder>... sensitivityParameters);
    }

    static final class BuilderImpl implements Builder {
        private List<DifferentialPrivacySensitivityParameters> sensitivityParameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DifferentialPrivacyParameters model) {
            sensitivityParameters(model.sensitivityParameters);
        }

        public final List<DifferentialPrivacySensitivityParameters.Builder> getSensitivityParameters() {
            List<DifferentialPrivacySensitivityParameters.Builder> result = DifferentialPrivacySensitivityParametersListCopier
                    .copyToBuilder(this.sensitivityParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSensitivityParameters(
                Collection<DifferentialPrivacySensitivityParameters.BuilderImpl> sensitivityParameters) {
            this.sensitivityParameters = DifferentialPrivacySensitivityParametersListCopier
                    .copyFromBuilder(sensitivityParameters);
        }

        @Override
        public final Builder sensitivityParameters(Collection<DifferentialPrivacySensitivityParameters> sensitivityParameters) {
            this.sensitivityParameters = DifferentialPrivacySensitivityParametersListCopier.copy(sensitivityParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sensitivityParameters(DifferentialPrivacySensitivityParameters... sensitivityParameters) {
            sensitivityParameters(Arrays.asList(sensitivityParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sensitivityParameters(
                Consumer<DifferentialPrivacySensitivityParameters.Builder>... sensitivityParameters) {
            sensitivityParameters(Stream.of(sensitivityParameters)
                    .map(c -> DifferentialPrivacySensitivityParameters.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DifferentialPrivacyParameters build() {
            return new DifferentialPrivacyParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
