/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCollaborationIdNamespaceAssociationResponse extends CleanRoomsResponse implements
        ToCopyableBuilder<GetCollaborationIdNamespaceAssociationResponse.Builder, GetCollaborationIdNamespaceAssociationResponse> {
    private static final SdkField<CollaborationIdNamespaceAssociation> COLLABORATION_ID_NAMESPACE_ASSOCIATION_FIELD = SdkField
            .<CollaborationIdNamespaceAssociation> builder(MarshallingType.SDK_POJO)
            .memberName("collaborationIdNamespaceAssociation")
            .getter(getter(GetCollaborationIdNamespaceAssociationResponse::collaborationIdNamespaceAssociation))
            .setter(setter(Builder::collaborationIdNamespaceAssociation))
            .constructor(CollaborationIdNamespaceAssociation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("collaborationIdNamespaceAssociation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(COLLABORATION_ID_NAMESPACE_ASSOCIATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final CollaborationIdNamespaceAssociation collaborationIdNamespaceAssociation;

    private GetCollaborationIdNamespaceAssociationResponse(BuilderImpl builder) {
        super(builder);
        this.collaborationIdNamespaceAssociation = builder.collaborationIdNamespaceAssociation;
    }

    /**
     * <p>
     * The ID namespace association that you requested.
     * </p>
     * 
     * @return The ID namespace association that you requested.
     */
    public final CollaborationIdNamespaceAssociation collaborationIdNamespaceAssociation() {
        return collaborationIdNamespaceAssociation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(collaborationIdNamespaceAssociation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCollaborationIdNamespaceAssociationResponse)) {
            return false;
        }
        GetCollaborationIdNamespaceAssociationResponse other = (GetCollaborationIdNamespaceAssociationResponse) obj;
        return Objects.equals(collaborationIdNamespaceAssociation(), other.collaborationIdNamespaceAssociation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCollaborationIdNamespaceAssociationResponse")
                .add("CollaborationIdNamespaceAssociation", collaborationIdNamespaceAssociation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "collaborationIdNamespaceAssociation":
            return Optional.ofNullable(clazz.cast(collaborationIdNamespaceAssociation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("collaborationIdNamespaceAssociation", COLLABORATION_ID_NAMESPACE_ASSOCIATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCollaborationIdNamespaceAssociationResponse, T> g) {
        return obj -> g.apply((GetCollaborationIdNamespaceAssociationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CleanRoomsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetCollaborationIdNamespaceAssociationResponse> {
        /**
         * <p>
         * The ID namespace association that you requested.
         * </p>
         * 
         * @param collaborationIdNamespaceAssociation
         *        The ID namespace association that you requested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaborationIdNamespaceAssociation(CollaborationIdNamespaceAssociation collaborationIdNamespaceAssociation);

        /**
         * <p>
         * The ID namespace association that you requested.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link CollaborationIdNamespaceAssociation.Builder} avoiding the need to create one manually via
         * {@link CollaborationIdNamespaceAssociation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CollaborationIdNamespaceAssociation.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #collaborationIdNamespaceAssociation(CollaborationIdNamespaceAssociation)}.
         * 
         * @param collaborationIdNamespaceAssociation
         *        a consumer that will call methods on {@link CollaborationIdNamespaceAssociation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #collaborationIdNamespaceAssociation(CollaborationIdNamespaceAssociation)
         */
        default Builder collaborationIdNamespaceAssociation(
                Consumer<CollaborationIdNamespaceAssociation.Builder> collaborationIdNamespaceAssociation) {
            return collaborationIdNamespaceAssociation(CollaborationIdNamespaceAssociation.builder()
                    .applyMutation(collaborationIdNamespaceAssociation).build());
        }
    }

    static final class BuilderImpl extends CleanRoomsResponse.BuilderImpl implements Builder {
        private CollaborationIdNamespaceAssociation collaborationIdNamespaceAssociation;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCollaborationIdNamespaceAssociationResponse model) {
            super(model);
            collaborationIdNamespaceAssociation(model.collaborationIdNamespaceAssociation);
        }

        public final CollaborationIdNamespaceAssociation.Builder getCollaborationIdNamespaceAssociation() {
            return collaborationIdNamespaceAssociation != null ? collaborationIdNamespaceAssociation.toBuilder() : null;
        }

        public final void setCollaborationIdNamespaceAssociation(
                CollaborationIdNamespaceAssociation.BuilderImpl collaborationIdNamespaceAssociation) {
            this.collaborationIdNamespaceAssociation = collaborationIdNamespaceAssociation != null ? collaborationIdNamespaceAssociation
                    .build() : null;
        }

        @Override
        public final Builder collaborationIdNamespaceAssociation(
                CollaborationIdNamespaceAssociation collaborationIdNamespaceAssociation) {
            this.collaborationIdNamespaceAssociation = collaborationIdNamespaceAssociation;
            return this;
        }

        @Override
        public GetCollaborationIdNamespaceAssociationResponse build() {
            return new GetCollaborationIdNamespaceAssociationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
