/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Detailed information about the ID namespace association input reference properties.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IdNamespaceAssociationInputReferencePropertiesSummary
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<IdNamespaceAssociationInputReferencePropertiesSummary.Builder, IdNamespaceAssociationInputReferencePropertiesSummary> {
    private static final SdkField<String> ID_NAMESPACE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("idNamespaceType")
            .getter(getter(IdNamespaceAssociationInputReferencePropertiesSummary::idNamespaceTypeAsString))
            .setter(setter(Builder::idNamespaceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idNamespaceType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_NAMESPACE_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String idNamespaceType;

    private IdNamespaceAssociationInputReferencePropertiesSummary(BuilderImpl builder) {
        this.idNamespaceType = builder.idNamespaceType;
    }

    /**
     * <p>
     * The ID namespace type for this ID namespace association.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #idNamespaceType}
     * will return {@link IdNamespaceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #idNamespaceTypeAsString}.
     * </p>
     * 
     * @return The ID namespace type for this ID namespace association.
     * @see IdNamespaceType
     */
    public final IdNamespaceType idNamespaceType() {
        return IdNamespaceType.fromValue(idNamespaceType);
    }

    /**
     * <p>
     * The ID namespace type for this ID namespace association.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #idNamespaceType}
     * will return {@link IdNamespaceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #idNamespaceTypeAsString}.
     * </p>
     * 
     * @return The ID namespace type for this ID namespace association.
     * @see IdNamespaceType
     */
    public final String idNamespaceTypeAsString() {
        return idNamespaceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(idNamespaceTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdNamespaceAssociationInputReferencePropertiesSummary)) {
            return false;
        }
        IdNamespaceAssociationInputReferencePropertiesSummary other = (IdNamespaceAssociationInputReferencePropertiesSummary) obj;
        return Objects.equals(idNamespaceTypeAsString(), other.idNamespaceTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IdNamespaceAssociationInputReferencePropertiesSummary")
                .add("IdNamespaceType", idNamespaceTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "idNamespaceType":
            return Optional.ofNullable(clazz.cast(idNamespaceTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("idNamespaceType", ID_NAMESPACE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IdNamespaceAssociationInputReferencePropertiesSummary, T> g) {
        return obj -> g.apply((IdNamespaceAssociationInputReferencePropertiesSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IdNamespaceAssociationInputReferencePropertiesSummary> {
        /**
         * <p>
         * The ID namespace type for this ID namespace association.
         * </p>
         * 
         * @param idNamespaceType
         *        The ID namespace type for this ID namespace association.
         * @see IdNamespaceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdNamespaceType
         */
        Builder idNamespaceType(String idNamespaceType);

        /**
         * <p>
         * The ID namespace type for this ID namespace association.
         * </p>
         * 
         * @param idNamespaceType
         *        The ID namespace type for this ID namespace association.
         * @see IdNamespaceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdNamespaceType
         */
        Builder idNamespaceType(IdNamespaceType idNamespaceType);
    }

    static final class BuilderImpl implements Builder {
        private String idNamespaceType;

        private BuilderImpl() {
        }

        private BuilderImpl(IdNamespaceAssociationInputReferencePropertiesSummary model) {
            idNamespaceType(model.idNamespaceType);
        }

        public final String getIdNamespaceType() {
            return idNamespaceType;
        }

        public final void setIdNamespaceType(String idNamespaceType) {
            this.idNamespaceType = idNamespaceType;
        }

        @Override
        public final Builder idNamespaceType(String idNamespaceType) {
            this.idNamespaceType = idNamespaceType;
            return this;
        }

        @Override
        public final Builder idNamespaceType(IdNamespaceType idNamespaceType) {
            this.idNamespaceType(idNamespaceType == null ? null : idNamespaceType.toString());
            return this;
        }

        @Override
        public IdNamespaceAssociationInputReferencePropertiesSummary build() {
            return new IdNamespaceAssociationInputReferencePropertiesSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
