/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCollaborationsRequest extends CleanRoomsRequest implements
        ToCopyableBuilder<ListCollaborationsRequest.Builder, ListCollaborationsRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListCollaborationsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListCollaborationsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> MEMBER_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("memberStatus").getter(getter(ListCollaborationsRequest::memberStatusAsString))
            .setter(setter(Builder::memberStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("memberStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            MAX_RESULTS_FIELD, MEMBER_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final Integer maxResults;

    private final String memberStatus;

    private ListCollaborationsRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.memberStatus = builder.memberStatus;
    }

    /**
     * <p>
     * The pagination token that's used to fetch the next set of results.
     * </p>
     * 
     * @return The pagination token that's used to fetch the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results that are returned for an API request call. The service chooses a default number if
     * you don't set one. The service might return a `nextToken` even if the `maxResults` value has not been met.
     * </p>
     * 
     * @return The maximum number of results that are returned for an API request call. The service chooses a default
     *         number if you don't set one. The service might return a `nextToken` even if the `maxResults` value has
     *         not been met.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The caller's status in a collaboration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #memberStatus} will
     * return {@link FilterableMemberStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #memberStatusAsString}.
     * </p>
     * 
     * @return The caller's status in a collaboration.
     * @see FilterableMemberStatus
     */
    public final FilterableMemberStatus memberStatus() {
        return FilterableMemberStatus.fromValue(memberStatus);
    }

    /**
     * <p>
     * The caller's status in a collaboration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #memberStatus} will
     * return {@link FilterableMemberStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #memberStatusAsString}.
     * </p>
     * 
     * @return The caller's status in a collaboration.
     * @see FilterableMemberStatus
     */
    public final String memberStatusAsString() {
        return memberStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(memberStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCollaborationsRequest)) {
            return false;
        }
        ListCollaborationsRequest other = (ListCollaborationsRequest) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(memberStatusAsString(), other.memberStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCollaborationsRequest").add("NextToken", nextToken()).add("MaxResults", maxResults())
                .add("MemberStatus", memberStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "memberStatus":
            return Optional.ofNullable(clazz.cast(memberStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("memberStatus", MEMBER_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCollaborationsRequest, T> g) {
        return obj -> g.apply((ListCollaborationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CleanRoomsRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListCollaborationsRequest> {
        /**
         * <p>
         * The pagination token that's used to fetch the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The pagination token that's used to fetch the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results that are returned for an API request call. The service chooses a default number
         * if you don't set one. The service might return a `nextToken` even if the `maxResults` value has not been met.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results that are returned for an API request call. The service chooses a default
         *        number if you don't set one. The service might return a `nextToken` even if the `maxResults` value has
         *        not been met.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The caller's status in a collaboration.
         * </p>
         * 
         * @param memberStatus
         *        The caller's status in a collaboration.
         * @see FilterableMemberStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FilterableMemberStatus
         */
        Builder memberStatus(String memberStatus);

        /**
         * <p>
         * The caller's status in a collaboration.
         * </p>
         * 
         * @param memberStatus
         *        The caller's status in a collaboration.
         * @see FilterableMemberStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FilterableMemberStatus
         */
        Builder memberStatus(FilterableMemberStatus memberStatus);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CleanRoomsRequest.BuilderImpl implements Builder {
        private String nextToken;

        private Integer maxResults;

        private String memberStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCollaborationsRequest model) {
            super(model);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            memberStatus(model.memberStatus);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getMemberStatus() {
            return memberStatus;
        }

        public final void setMemberStatus(String memberStatus) {
            this.memberStatus = memberStatus;
        }

        @Override
        public final Builder memberStatus(String memberStatus) {
            this.memberStatus = memberStatus;
            return this;
        }

        @Override
        public final Builder memberStatus(FilterableMemberStatus memberStatus) {
            this.memberStatus(memberStatus == null ? null : memberStatus.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListCollaborationsRequest build() {
            return new ListCollaborationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
