/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListProtectedQueriesResponse extends CleanRoomsResponse implements
        ToCopyableBuilder<ListProtectedQueriesResponse.Builder, ListProtectedQueriesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListProtectedQueriesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<ProtectedQuerySummary>> PROTECTED_QUERIES_FIELD = SdkField
            .<List<ProtectedQuerySummary>> builder(MarshallingType.LIST)
            .memberName("protectedQueries")
            .getter(getter(ListProtectedQueriesResponse::protectedQueries))
            .setter(setter(Builder::protectedQueries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protectedQueries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProtectedQuerySummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProtectedQuerySummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            PROTECTED_QUERIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<ProtectedQuerySummary> protectedQueries;

    private ListProtectedQueriesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.protectedQueries = builder.protectedQueries;
    }

    /**
     * <p>
     * The pagination token that's used to fetch the next set of results.
     * </p>
     * 
     * @return The pagination token that's used to fetch the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProtectedQueries property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasProtectedQueries() {
        return protectedQueries != null && !(protectedQueries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of protected queries.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProtectedQueries} method.
     * </p>
     * 
     * @return A list of protected queries.
     */
    public final List<ProtectedQuerySummary> protectedQueries() {
        return protectedQueries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasProtectedQueries() ? protectedQueries() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProtectedQueriesResponse)) {
            return false;
        }
        ListProtectedQueriesResponse other = (ListProtectedQueriesResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasProtectedQueries() == other.hasProtectedQueries()
                && Objects.equals(protectedQueries(), other.protectedQueries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListProtectedQueriesResponse").add("NextToken", nextToken())
                .add("ProtectedQueries", hasProtectedQueries() ? protectedQueries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "protectedQueries":
            return Optional.ofNullable(clazz.cast(protectedQueries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("protectedQueries", PROTECTED_QUERIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListProtectedQueriesResponse, T> g) {
        return obj -> g.apply((ListProtectedQueriesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CleanRoomsResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListProtectedQueriesResponse> {
        /**
         * <p>
         * The pagination token that's used to fetch the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The pagination token that's used to fetch the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A list of protected queries.
         * </p>
         * 
         * @param protectedQueries
         *        A list of protected queries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protectedQueries(Collection<ProtectedQuerySummary> protectedQueries);

        /**
         * <p>
         * A list of protected queries.
         * </p>
         * 
         * @param protectedQueries
         *        A list of protected queries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protectedQueries(ProtectedQuerySummary... protectedQueries);

        /**
         * <p>
         * A list of protected queries.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cleanrooms.model.ProtectedQuerySummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.cleanrooms.model.ProtectedQuerySummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cleanrooms.model.ProtectedQuerySummary.Builder#build()} is called
         * immediately and its result is passed to {@link #protectedQueries(List<ProtectedQuerySummary>)}.
         * 
         * @param protectedQueries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cleanrooms.model.ProtectedQuerySummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #protectedQueries(java.util.Collection<ProtectedQuerySummary>)
         */
        Builder protectedQueries(Consumer<ProtectedQuerySummary.Builder>... protectedQueries);
    }

    static final class BuilderImpl extends CleanRoomsResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<ProtectedQuerySummary> protectedQueries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListProtectedQueriesResponse model) {
            super(model);
            nextToken(model.nextToken);
            protectedQueries(model.protectedQueries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ProtectedQuerySummary.Builder> getProtectedQueries() {
            List<ProtectedQuerySummary.Builder> result = ProtectedQuerySummaryListCopier.copyToBuilder(this.protectedQueries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProtectedQueries(Collection<ProtectedQuerySummary.BuilderImpl> protectedQueries) {
            this.protectedQueries = ProtectedQuerySummaryListCopier.copyFromBuilder(protectedQueries);
        }

        @Override
        public final Builder protectedQueries(Collection<ProtectedQuerySummary> protectedQueries) {
            this.protectedQueries = ProtectedQuerySummaryListCopier.copy(protectedQueries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protectedQueries(ProtectedQuerySummary... protectedQueries) {
            protectedQueries(Arrays.asList(protectedQueries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protectedQueries(Consumer<ProtectedQuerySummary.Builder>... protectedQueries) {
            protectedQueries(Stream.of(protectedQueries).map(c -> ProtectedQuerySummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListProtectedQueriesResponse build() {
            return new ListProtectedQueriesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
