/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing the collaboration member's machine learning payment responsibilities set by the collaboration
 * creator.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MembershipMLPaymentConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<MembershipMLPaymentConfig.Builder, MembershipMLPaymentConfig> {
    private static final SdkField<MembershipModelTrainingPaymentConfig> MODEL_TRAINING_FIELD = SdkField
            .<MembershipModelTrainingPaymentConfig> builder(MarshallingType.SDK_POJO).memberName("modelTraining")
            .getter(getter(MembershipMLPaymentConfig::modelTraining)).setter(setter(Builder::modelTraining))
            .constructor(MembershipModelTrainingPaymentConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelTraining").build()).build();

    private static final SdkField<MembershipModelInferencePaymentConfig> MODEL_INFERENCE_FIELD = SdkField
            .<MembershipModelInferencePaymentConfig> builder(MarshallingType.SDK_POJO).memberName("modelInference")
            .getter(getter(MembershipMLPaymentConfig::modelInference)).setter(setter(Builder::modelInference))
            .constructor(MembershipModelInferencePaymentConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelInference").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_TRAINING_FIELD,
            MODEL_INFERENCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final MembershipModelTrainingPaymentConfig modelTraining;

    private final MembershipModelInferencePaymentConfig modelInference;

    private MembershipMLPaymentConfig(BuilderImpl builder) {
        this.modelTraining = builder.modelTraining;
        this.modelInference = builder.modelInference;
    }

    /**
     * <p>
     * The payment responsibilities accepted by the member for model training.
     * </p>
     * 
     * @return The payment responsibilities accepted by the member for model training.
     */
    public final MembershipModelTrainingPaymentConfig modelTraining() {
        return modelTraining;
    }

    /**
     * <p>
     * The payment responsibilities accepted by the member for model inference.
     * </p>
     * 
     * @return The payment responsibilities accepted by the member for model inference.
     */
    public final MembershipModelInferencePaymentConfig modelInference() {
        return modelInference;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(modelTraining());
        hashCode = 31 * hashCode + Objects.hashCode(modelInference());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MembershipMLPaymentConfig)) {
            return false;
        }
        MembershipMLPaymentConfig other = (MembershipMLPaymentConfig) obj;
        return Objects.equals(modelTraining(), other.modelTraining()) && Objects.equals(modelInference(), other.modelInference());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MembershipMLPaymentConfig").add("ModelTraining", modelTraining())
                .add("ModelInference", modelInference()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "modelTraining":
            return Optional.ofNullable(clazz.cast(modelTraining()));
        case "modelInference":
            return Optional.ofNullable(clazz.cast(modelInference()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("modelTraining", MODEL_TRAINING_FIELD);
        map.put("modelInference", MODEL_INFERENCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MembershipMLPaymentConfig, T> g) {
        return obj -> g.apply((MembershipMLPaymentConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MembershipMLPaymentConfig> {
        /**
         * <p>
         * The payment responsibilities accepted by the member for model training.
         * </p>
         * 
         * @param modelTraining
         *        The payment responsibilities accepted by the member for model training.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelTraining(MembershipModelTrainingPaymentConfig modelTraining);

        /**
         * <p>
         * The payment responsibilities accepted by the member for model training.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link MembershipModelTrainingPaymentConfig.Builder} avoiding the need to create one manually via
         * {@link MembershipModelTrainingPaymentConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MembershipModelTrainingPaymentConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #modelTraining(MembershipModelTrainingPaymentConfig)}.
         * 
         * @param modelTraining
         *        a consumer that will call methods on {@link MembershipModelTrainingPaymentConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelTraining(MembershipModelTrainingPaymentConfig)
         */
        default Builder modelTraining(Consumer<MembershipModelTrainingPaymentConfig.Builder> modelTraining) {
            return modelTraining(MembershipModelTrainingPaymentConfig.builder().applyMutation(modelTraining).build());
        }

        /**
         * <p>
         * The payment responsibilities accepted by the member for model inference.
         * </p>
         * 
         * @param modelInference
         *        The payment responsibilities accepted by the member for model inference.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelInference(MembershipModelInferencePaymentConfig modelInference);

        /**
         * <p>
         * The payment responsibilities accepted by the member for model inference.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link MembershipModelInferencePaymentConfig.Builder} avoiding the need to create one manually via
         * {@link MembershipModelInferencePaymentConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MembershipModelInferencePaymentConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #modelInference(MembershipModelInferencePaymentConfig)}.
         * 
         * @param modelInference
         *        a consumer that will call methods on {@link MembershipModelInferencePaymentConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelInference(MembershipModelInferencePaymentConfig)
         */
        default Builder modelInference(Consumer<MembershipModelInferencePaymentConfig.Builder> modelInference) {
            return modelInference(MembershipModelInferencePaymentConfig.builder().applyMutation(modelInference).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private MembershipModelTrainingPaymentConfig modelTraining;

        private MembershipModelInferencePaymentConfig modelInference;

        private BuilderImpl() {
        }

        private BuilderImpl(MembershipMLPaymentConfig model) {
            modelTraining(model.modelTraining);
            modelInference(model.modelInference);
        }

        public final MembershipModelTrainingPaymentConfig.Builder getModelTraining() {
            return modelTraining != null ? modelTraining.toBuilder() : null;
        }

        public final void setModelTraining(MembershipModelTrainingPaymentConfig.BuilderImpl modelTraining) {
            this.modelTraining = modelTraining != null ? modelTraining.build() : null;
        }

        @Override
        public final Builder modelTraining(MembershipModelTrainingPaymentConfig modelTraining) {
            this.modelTraining = modelTraining;
            return this;
        }

        public final MembershipModelInferencePaymentConfig.Builder getModelInference() {
            return modelInference != null ? modelInference.toBuilder() : null;
        }

        public final void setModelInference(MembershipModelInferencePaymentConfig.BuilderImpl modelInference) {
            this.modelInference = modelInference != null ? modelInference.build() : null;
        }

        @Override
        public final Builder modelInference(MembershipModelInferencePaymentConfig modelInference) {
            this.modelInference = modelInference;
            return this;
        }

        @Override
        public MembershipMLPaymentConfig build() {
            return new MembershipMLPaymentConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
