/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The protected query summary for the objects listed by the request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProtectedQuerySummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ProtectedQuerySummary.Builder, ProtectedQuerySummary> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(ProtectedQuerySummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> MEMBERSHIP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("membershipId").getter(getter(ProtectedQuerySummary::membershipId)).setter(setter(Builder::membershipId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipId").build()).build();

    private static final SdkField<String> MEMBERSHIP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("membershipArn").getter(getter(ProtectedQuerySummary::membershipArn))
            .setter(setter(Builder::membershipArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipArn").build()).build();

    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createTime").getter(getter(ProtectedQuerySummary::createTime)).setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(ProtectedQuerySummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<List<ReceiverConfiguration>> RECEIVER_CONFIGURATIONS_FIELD = SdkField
            .<List<ReceiverConfiguration>> builder(MarshallingType.LIST)
            .memberName("receiverConfigurations")
            .getter(getter(ProtectedQuerySummary::receiverConfigurations))
            .setter(setter(Builder::receiverConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("receiverConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReceiverConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReceiverConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, MEMBERSHIP_ID_FIELD,
            MEMBERSHIP_ARN_FIELD, CREATE_TIME_FIELD, STATUS_FIELD, RECEIVER_CONFIGURATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String membershipId;

    private final String membershipArn;

    private final Instant createTime;

    private final String status;

    private final List<ReceiverConfiguration> receiverConfigurations;

    private ProtectedQuerySummary(BuilderImpl builder) {
        this.id = builder.id;
        this.membershipId = builder.membershipId;
        this.membershipArn = builder.membershipArn;
        this.createTime = builder.createTime;
        this.status = builder.status;
        this.receiverConfigurations = builder.receiverConfigurations;
    }

    /**
     * <p>
     * The unique ID of the protected query.
     * </p>
     * 
     * @return The unique ID of the protected query.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The unique ID for the membership that initiated the protected query.
     * </p>
     * 
     * @return The unique ID for the membership that initiated the protected query.
     */
    public final String membershipId() {
        return membershipId;
    }

    /**
     * <p>
     * The unique ARN for the membership that initiated the protected query.
     * </p>
     * 
     * @return The unique ARN for the membership that initiated the protected query.
     */
    public final String membershipArn() {
        return membershipArn;
    }

    /**
     * <p>
     * The time the protected query was created.
     * </p>
     * 
     * @return The time the protected query was created.
     */
    public final Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * The status of the protected query.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ProtectedQueryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the protected query.
     * @see ProtectedQueryStatus
     */
    public final ProtectedQueryStatus status() {
        return ProtectedQueryStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the protected query.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ProtectedQueryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the protected query.
     * @see ProtectedQueryStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReceiverConfigurations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasReceiverConfigurations() {
        return receiverConfigurations != null && !(receiverConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The receiver configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReceiverConfigurations} method.
     * </p>
     * 
     * @return The receiver configuration.
     */
    public final List<ReceiverConfiguration> receiverConfigurations() {
        return receiverConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(membershipId());
        hashCode = 31 * hashCode + Objects.hashCode(membershipArn());
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasReceiverConfigurations() ? receiverConfigurations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProtectedQuerySummary)) {
            return false;
        }
        ProtectedQuerySummary other = (ProtectedQuerySummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(membershipId(), other.membershipId())
                && Objects.equals(membershipArn(), other.membershipArn()) && Objects.equals(createTime(), other.createTime())
                && Objects.equals(statusAsString(), other.statusAsString())
                && hasReceiverConfigurations() == other.hasReceiverConfigurations()
                && Objects.equals(receiverConfigurations(), other.receiverConfigurations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProtectedQuerySummary").add("Id", id()).add("MembershipId", membershipId())
                .add("MembershipArn", membershipArn()).add("CreateTime", createTime()).add("Status", statusAsString())
                .add("ReceiverConfigurations", hasReceiverConfigurations() ? receiverConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "membershipId":
            return Optional.ofNullable(clazz.cast(membershipId()));
        case "membershipArn":
            return Optional.ofNullable(clazz.cast(membershipArn()));
        case "createTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "receiverConfigurations":
            return Optional.ofNullable(clazz.cast(receiverConfigurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("membershipId", MEMBERSHIP_ID_FIELD);
        map.put("membershipArn", MEMBERSHIP_ARN_FIELD);
        map.put("createTime", CREATE_TIME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("receiverConfigurations", RECEIVER_CONFIGURATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProtectedQuerySummary, T> g) {
        return obj -> g.apply((ProtectedQuerySummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProtectedQuerySummary> {
        /**
         * <p>
         * The unique ID of the protected query.
         * </p>
         * 
         * @param id
         *        The unique ID of the protected query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The unique ID for the membership that initiated the protected query.
         * </p>
         * 
         * @param membershipId
         *        The unique ID for the membership that initiated the protected query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder membershipId(String membershipId);

        /**
         * <p>
         * The unique ARN for the membership that initiated the protected query.
         * </p>
         * 
         * @param membershipArn
         *        The unique ARN for the membership that initiated the protected query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder membershipArn(String membershipArn);

        /**
         * <p>
         * The time the protected query was created.
         * </p>
         * 
         * @param createTime
         *        The time the protected query was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * The status of the protected query.
         * </p>
         * 
         * @param status
         *        The status of the protected query.
         * @see ProtectedQueryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProtectedQueryStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the protected query.
         * </p>
         * 
         * @param status
         *        The status of the protected query.
         * @see ProtectedQueryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProtectedQueryStatus
         */
        Builder status(ProtectedQueryStatus status);

        /**
         * <p>
         * The receiver configuration.
         * </p>
         * 
         * @param receiverConfigurations
         *        The receiver configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder receiverConfigurations(Collection<ReceiverConfiguration> receiverConfigurations);

        /**
         * <p>
         * The receiver configuration.
         * </p>
         * 
         * @param receiverConfigurations
         *        The receiver configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder receiverConfigurations(ReceiverConfiguration... receiverConfigurations);

        /**
         * <p>
         * The receiver configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cleanrooms.model.ReceiverConfiguration.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.cleanrooms.model.ReceiverConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cleanrooms.model.ReceiverConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #receiverConfigurations(List<ReceiverConfiguration>)}.
         * 
         * @param receiverConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cleanrooms.model.ReceiverConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #receiverConfigurations(java.util.Collection<ReceiverConfiguration>)
         */
        Builder receiverConfigurations(Consumer<ReceiverConfiguration.Builder>... receiverConfigurations);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String membershipId;

        private String membershipArn;

        private Instant createTime;

        private String status;

        private List<ReceiverConfiguration> receiverConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ProtectedQuerySummary model) {
            id(model.id);
            membershipId(model.membershipId);
            membershipArn(model.membershipArn);
            createTime(model.createTime);
            status(model.status);
            receiverConfigurations(model.receiverConfigurations);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getMembershipId() {
            return membershipId;
        }

        public final void setMembershipId(String membershipId) {
            this.membershipId = membershipId;
        }

        @Override
        public final Builder membershipId(String membershipId) {
            this.membershipId = membershipId;
            return this;
        }

        public final String getMembershipArn() {
            return membershipArn;
        }

        public final void setMembershipArn(String membershipArn) {
            this.membershipArn = membershipArn;
        }

        @Override
        public final Builder membershipArn(String membershipArn) {
            this.membershipArn = membershipArn;
            return this;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ProtectedQueryStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final List<ReceiverConfiguration.Builder> getReceiverConfigurations() {
            List<ReceiverConfiguration.Builder> result = ReceiverConfigurationsListCopier
                    .copyToBuilder(this.receiverConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReceiverConfigurations(Collection<ReceiverConfiguration.BuilderImpl> receiverConfigurations) {
            this.receiverConfigurations = ReceiverConfigurationsListCopier.copyFromBuilder(receiverConfigurations);
        }

        @Override
        public final Builder receiverConfigurations(Collection<ReceiverConfiguration> receiverConfigurations) {
            this.receiverConfigurations = ReceiverConfigurationsListCopier.copy(receiverConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder receiverConfigurations(ReceiverConfiguration... receiverConfigurations) {
            receiverConfigurations(Arrays.asList(receiverConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder receiverConfigurations(Consumer<ReceiverConfiguration.Builder>... receiverConfigurations) {
            receiverConfigurations(Stream.of(receiverConfigurations)
                    .map(c -> ReceiverConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ProtectedQuerySummary build() {
            return new ProtectedQuerySummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
