/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateMembershipRequest extends CleanRoomsRequest implements
        ToCopyableBuilder<UpdateMembershipRequest.Builder, UpdateMembershipRequest> {
    private static final SdkField<String> MEMBERSHIP_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("membershipIdentifier").getter(getter(UpdateMembershipRequest::membershipIdentifier))
            .setter(setter(Builder::membershipIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("membershipIdentifier").build()).build();

    private static final SdkField<String> QUERY_LOG_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("queryLogStatus").getter(getter(UpdateMembershipRequest::queryLogStatusAsString))
            .setter(setter(Builder::queryLogStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryLogStatus").build()).build();

    private static final SdkField<MembershipProtectedQueryResultConfiguration> DEFAULT_RESULT_CONFIGURATION_FIELD = SdkField
            .<MembershipProtectedQueryResultConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("defaultResultConfiguration")
            .getter(getter(UpdateMembershipRequest::defaultResultConfiguration))
            .setter(setter(Builder::defaultResultConfiguration))
            .constructor(MembershipProtectedQueryResultConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultResultConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBERSHIP_IDENTIFIER_FIELD,
            QUERY_LOG_STATUS_FIELD, DEFAULT_RESULT_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String membershipIdentifier;

    private final String queryLogStatus;

    private final MembershipProtectedQueryResultConfiguration defaultResultConfiguration;

    private UpdateMembershipRequest(BuilderImpl builder) {
        super(builder);
        this.membershipIdentifier = builder.membershipIdentifier;
        this.queryLogStatus = builder.queryLogStatus;
        this.defaultResultConfiguration = builder.defaultResultConfiguration;
    }

    /**
     * <p>
     * The unique identifier of the membership.
     * </p>
     * 
     * @return The unique identifier of the membership.
     */
    public final String membershipIdentifier() {
        return membershipIdentifier;
    }

    /**
     * <p>
     * An indicator as to whether query logging has been enabled or disabled for the membership.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #queryLogStatus}
     * will return {@link MembershipQueryLogStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #queryLogStatusAsString}.
     * </p>
     * 
     * @return An indicator as to whether query logging has been enabled or disabled for the membership.
     * @see MembershipQueryLogStatus
     */
    public final MembershipQueryLogStatus queryLogStatus() {
        return MembershipQueryLogStatus.fromValue(queryLogStatus);
    }

    /**
     * <p>
     * An indicator as to whether query logging has been enabled or disabled for the membership.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #queryLogStatus}
     * will return {@link MembershipQueryLogStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #queryLogStatusAsString}.
     * </p>
     * 
     * @return An indicator as to whether query logging has been enabled or disabled for the membership.
     * @see MembershipQueryLogStatus
     */
    public final String queryLogStatusAsString() {
        return queryLogStatus;
    }

    /**
     * <p>
     * The default protected query result configuration as specified by the member who can receive results.
     * </p>
     * 
     * @return The default protected query result configuration as specified by the member who can receive results.
     */
    public final MembershipProtectedQueryResultConfiguration defaultResultConfiguration() {
        return defaultResultConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(membershipIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(queryLogStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(defaultResultConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMembershipRequest)) {
            return false;
        }
        UpdateMembershipRequest other = (UpdateMembershipRequest) obj;
        return Objects.equals(membershipIdentifier(), other.membershipIdentifier())
                && Objects.equals(queryLogStatusAsString(), other.queryLogStatusAsString())
                && Objects.equals(defaultResultConfiguration(), other.defaultResultConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateMembershipRequest").add("MembershipIdentifier", membershipIdentifier())
                .add("QueryLogStatus", queryLogStatusAsString()).add("DefaultResultConfiguration", defaultResultConfiguration())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "membershipIdentifier":
            return Optional.ofNullable(clazz.cast(membershipIdentifier()));
        case "queryLogStatus":
            return Optional.ofNullable(clazz.cast(queryLogStatusAsString()));
        case "defaultResultConfiguration":
            return Optional.ofNullable(clazz.cast(defaultResultConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("membershipIdentifier", MEMBERSHIP_IDENTIFIER_FIELD);
        map.put("queryLogStatus", QUERY_LOG_STATUS_FIELD);
        map.put("defaultResultConfiguration", DEFAULT_RESULT_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateMembershipRequest, T> g) {
        return obj -> g.apply((UpdateMembershipRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CleanRoomsRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateMembershipRequest> {
        /**
         * <p>
         * The unique identifier of the membership.
         * </p>
         * 
         * @param membershipIdentifier
         *        The unique identifier of the membership.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder membershipIdentifier(String membershipIdentifier);

        /**
         * <p>
         * An indicator as to whether query logging has been enabled or disabled for the membership.
         * </p>
         * 
         * @param queryLogStatus
         *        An indicator as to whether query logging has been enabled or disabled for the membership.
         * @see MembershipQueryLogStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MembershipQueryLogStatus
         */
        Builder queryLogStatus(String queryLogStatus);

        /**
         * <p>
         * An indicator as to whether query logging has been enabled or disabled for the membership.
         * </p>
         * 
         * @param queryLogStatus
         *        An indicator as to whether query logging has been enabled or disabled for the membership.
         * @see MembershipQueryLogStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MembershipQueryLogStatus
         */
        Builder queryLogStatus(MembershipQueryLogStatus queryLogStatus);

        /**
         * <p>
         * The default protected query result configuration as specified by the member who can receive results.
         * </p>
         * 
         * @param defaultResultConfiguration
         *        The default protected query result configuration as specified by the member who can receive results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultResultConfiguration(MembershipProtectedQueryResultConfiguration defaultResultConfiguration);

        /**
         * <p>
         * The default protected query result configuration as specified by the member who can receive results.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link MembershipProtectedQueryResultConfiguration.Builder} avoiding the need to create one manually via
         * {@link MembershipProtectedQueryResultConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MembershipProtectedQueryResultConfiguration.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #defaultResultConfiguration(MembershipProtectedQueryResultConfiguration)}.
         * 
         * @param defaultResultConfiguration
         *        a consumer that will call methods on {@link MembershipProtectedQueryResultConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultResultConfiguration(MembershipProtectedQueryResultConfiguration)
         */
        default Builder defaultResultConfiguration(
                Consumer<MembershipProtectedQueryResultConfiguration.Builder> defaultResultConfiguration) {
            return defaultResultConfiguration(MembershipProtectedQueryResultConfiguration.builder()
                    .applyMutation(defaultResultConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CleanRoomsRequest.BuilderImpl implements Builder {
        private String membershipIdentifier;

        private String queryLogStatus;

        private MembershipProtectedQueryResultConfiguration defaultResultConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMembershipRequest model) {
            super(model);
            membershipIdentifier(model.membershipIdentifier);
            queryLogStatus(model.queryLogStatus);
            defaultResultConfiguration(model.defaultResultConfiguration);
        }

        public final String getMembershipIdentifier() {
            return membershipIdentifier;
        }

        public final void setMembershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
        }

        @Override
        public final Builder membershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
            return this;
        }

        public final String getQueryLogStatus() {
            return queryLogStatus;
        }

        public final void setQueryLogStatus(String queryLogStatus) {
            this.queryLogStatus = queryLogStatus;
        }

        @Override
        public final Builder queryLogStatus(String queryLogStatus) {
            this.queryLogStatus = queryLogStatus;
            return this;
        }

        @Override
        public final Builder queryLogStatus(MembershipQueryLogStatus queryLogStatus) {
            this.queryLogStatus(queryLogStatus == null ? null : queryLogStatus.toString());
            return this;
        }

        public final MembershipProtectedQueryResultConfiguration.Builder getDefaultResultConfiguration() {
            return defaultResultConfiguration != null ? defaultResultConfiguration.toBuilder() : null;
        }

        public final void setDefaultResultConfiguration(
                MembershipProtectedQueryResultConfiguration.BuilderImpl defaultResultConfiguration) {
            this.defaultResultConfiguration = defaultResultConfiguration != null ? defaultResultConfiguration.build() : null;
        }

        @Override
        public final Builder defaultResultConfiguration(MembershipProtectedQueryResultConfiguration defaultResultConfiguration) {
            this.defaultResultConfiguration = defaultResultConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateMembershipRequest build() {
            return new UpdateMembershipRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
