/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdatePrivacyBudgetTemplateRequest extends CleanRoomsRequest implements
        ToCopyableBuilder<UpdatePrivacyBudgetTemplateRequest.Builder, UpdatePrivacyBudgetTemplateRequest> {
    private static final SdkField<String> MEMBERSHIP_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("membershipIdentifier").getter(getter(UpdatePrivacyBudgetTemplateRequest::membershipIdentifier))
            .setter(setter(Builder::membershipIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("membershipIdentifier").build()).build();

    private static final SdkField<String> PRIVACY_BUDGET_TEMPLATE_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("privacyBudgetTemplateIdentifier")
            .getter(getter(UpdatePrivacyBudgetTemplateRequest::privacyBudgetTemplateIdentifier))
            .setter(setter(Builder::privacyBudgetTemplateIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("privacyBudgetTemplateIdentifier")
                    .build()).build();

    private static final SdkField<String> PRIVACY_BUDGET_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("privacyBudgetType").getter(getter(UpdatePrivacyBudgetTemplateRequest::privacyBudgetTypeAsString))
            .setter(setter(Builder::privacyBudgetType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("privacyBudgetType").build()).build();

    private static final SdkField<PrivacyBudgetTemplateUpdateParameters> PARAMETERS_FIELD = SdkField
            .<PrivacyBudgetTemplateUpdateParameters> builder(MarshallingType.SDK_POJO).memberName("parameters")
            .getter(getter(UpdatePrivacyBudgetTemplateRequest::parameters)).setter(setter(Builder::parameters))
            .constructor(PrivacyBudgetTemplateUpdateParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBERSHIP_IDENTIFIER_FIELD,
            PRIVACY_BUDGET_TEMPLATE_IDENTIFIER_FIELD, PRIVACY_BUDGET_TYPE_FIELD, PARAMETERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String membershipIdentifier;

    private final String privacyBudgetTemplateIdentifier;

    private final String privacyBudgetType;

    private final PrivacyBudgetTemplateUpdateParameters parameters;

    private UpdatePrivacyBudgetTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.membershipIdentifier = builder.membershipIdentifier;
        this.privacyBudgetTemplateIdentifier = builder.privacyBudgetTemplateIdentifier;
        this.privacyBudgetType = builder.privacyBudgetType;
        this.parameters = builder.parameters;
    }

    /**
     * <p>
     * A unique identifier for one of your memberships for a collaboration. The privacy budget template is updated in
     * the collaboration that this membership belongs to. Accepts a membership ID.
     * </p>
     * 
     * @return A unique identifier for one of your memberships for a collaboration. The privacy budget template is
     *         updated in the collaboration that this membership belongs to. Accepts a membership ID.
     */
    public final String membershipIdentifier() {
        return membershipIdentifier;
    }

    /**
     * <p>
     * A unique identifier for your privacy budget template that you want to update.
     * </p>
     * 
     * @return A unique identifier for your privacy budget template that you want to update.
     */
    public final String privacyBudgetTemplateIdentifier() {
        return privacyBudgetTemplateIdentifier;
    }

    /**
     * <p>
     * Specifies the type of the privacy budget template.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #privacyBudgetType}
     * will return {@link PrivacyBudgetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #privacyBudgetTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of the privacy budget template.
     * @see PrivacyBudgetType
     */
    public final PrivacyBudgetType privacyBudgetType() {
        return PrivacyBudgetType.fromValue(privacyBudgetType);
    }

    /**
     * <p>
     * Specifies the type of the privacy budget template.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #privacyBudgetType}
     * will return {@link PrivacyBudgetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #privacyBudgetTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of the privacy budget template.
     * @see PrivacyBudgetType
     */
    public final String privacyBudgetTypeAsString() {
        return privacyBudgetType;
    }

    /**
     * <p>
     * Specifies the epsilon and noise parameters for the privacy budget template.
     * </p>
     * 
     * @return Specifies the epsilon and noise parameters for the privacy budget template.
     */
    public final PrivacyBudgetTemplateUpdateParameters parameters() {
        return parameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(membershipIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(privacyBudgetTemplateIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(privacyBudgetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(parameters());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePrivacyBudgetTemplateRequest)) {
            return false;
        }
        UpdatePrivacyBudgetTemplateRequest other = (UpdatePrivacyBudgetTemplateRequest) obj;
        return Objects.equals(membershipIdentifier(), other.membershipIdentifier())
                && Objects.equals(privacyBudgetTemplateIdentifier(), other.privacyBudgetTemplateIdentifier())
                && Objects.equals(privacyBudgetTypeAsString(), other.privacyBudgetTypeAsString())
                && Objects.equals(parameters(), other.parameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdatePrivacyBudgetTemplateRequest").add("MembershipIdentifier", membershipIdentifier())
                .add("PrivacyBudgetTemplateIdentifier", privacyBudgetTemplateIdentifier())
                .add("PrivacyBudgetType", privacyBudgetTypeAsString()).add("Parameters", parameters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "membershipIdentifier":
            return Optional.ofNullable(clazz.cast(membershipIdentifier()));
        case "privacyBudgetTemplateIdentifier":
            return Optional.ofNullable(clazz.cast(privacyBudgetTemplateIdentifier()));
        case "privacyBudgetType":
            return Optional.ofNullable(clazz.cast(privacyBudgetTypeAsString()));
        case "parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("membershipIdentifier", MEMBERSHIP_IDENTIFIER_FIELD);
        map.put("privacyBudgetTemplateIdentifier", PRIVACY_BUDGET_TEMPLATE_IDENTIFIER_FIELD);
        map.put("privacyBudgetType", PRIVACY_BUDGET_TYPE_FIELD);
        map.put("parameters", PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdatePrivacyBudgetTemplateRequest, T> g) {
        return obj -> g.apply((UpdatePrivacyBudgetTemplateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CleanRoomsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdatePrivacyBudgetTemplateRequest> {
        /**
         * <p>
         * A unique identifier for one of your memberships for a collaboration. The privacy budget template is updated
         * in the collaboration that this membership belongs to. Accepts a membership ID.
         * </p>
         * 
         * @param membershipIdentifier
         *        A unique identifier for one of your memberships for a collaboration. The privacy budget template is
         *        updated in the collaboration that this membership belongs to. Accepts a membership ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder membershipIdentifier(String membershipIdentifier);

        /**
         * <p>
         * A unique identifier for your privacy budget template that you want to update.
         * </p>
         * 
         * @param privacyBudgetTemplateIdentifier
         *        A unique identifier for your privacy budget template that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privacyBudgetTemplateIdentifier(String privacyBudgetTemplateIdentifier);

        /**
         * <p>
         * Specifies the type of the privacy budget template.
         * </p>
         * 
         * @param privacyBudgetType
         *        Specifies the type of the privacy budget template.
         * @see PrivacyBudgetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PrivacyBudgetType
         */
        Builder privacyBudgetType(String privacyBudgetType);

        /**
         * <p>
         * Specifies the type of the privacy budget template.
         * </p>
         * 
         * @param privacyBudgetType
         *        Specifies the type of the privacy budget template.
         * @see PrivacyBudgetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PrivacyBudgetType
         */
        Builder privacyBudgetType(PrivacyBudgetType privacyBudgetType);

        /**
         * <p>
         * Specifies the epsilon and noise parameters for the privacy budget template.
         * </p>
         * 
         * @param parameters
         *        Specifies the epsilon and noise parameters for the privacy budget template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(PrivacyBudgetTemplateUpdateParameters parameters);

        /**
         * <p>
         * Specifies the epsilon and noise parameters for the privacy budget template.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link PrivacyBudgetTemplateUpdateParameters.Builder} avoiding the need to create one manually via
         * {@link PrivacyBudgetTemplateUpdateParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PrivacyBudgetTemplateUpdateParameters.Builder#build()} is called
         * immediately and its result is passed to {@link #parameters(PrivacyBudgetTemplateUpdateParameters)}.
         * 
         * @param parameters
         *        a consumer that will call methods on {@link PrivacyBudgetTemplateUpdateParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameters(PrivacyBudgetTemplateUpdateParameters)
         */
        default Builder parameters(Consumer<PrivacyBudgetTemplateUpdateParameters.Builder> parameters) {
            return parameters(PrivacyBudgetTemplateUpdateParameters.builder().applyMutation(parameters).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CleanRoomsRequest.BuilderImpl implements Builder {
        private String membershipIdentifier;

        private String privacyBudgetTemplateIdentifier;

        private String privacyBudgetType;

        private PrivacyBudgetTemplateUpdateParameters parameters;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePrivacyBudgetTemplateRequest model) {
            super(model);
            membershipIdentifier(model.membershipIdentifier);
            privacyBudgetTemplateIdentifier(model.privacyBudgetTemplateIdentifier);
            privacyBudgetType(model.privacyBudgetType);
            parameters(model.parameters);
        }

        public final String getMembershipIdentifier() {
            return membershipIdentifier;
        }

        public final void setMembershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
        }

        @Override
        public final Builder membershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
            return this;
        }

        public final String getPrivacyBudgetTemplateIdentifier() {
            return privacyBudgetTemplateIdentifier;
        }

        public final void setPrivacyBudgetTemplateIdentifier(String privacyBudgetTemplateIdentifier) {
            this.privacyBudgetTemplateIdentifier = privacyBudgetTemplateIdentifier;
        }

        @Override
        public final Builder privacyBudgetTemplateIdentifier(String privacyBudgetTemplateIdentifier) {
            this.privacyBudgetTemplateIdentifier = privacyBudgetTemplateIdentifier;
            return this;
        }

        public final String getPrivacyBudgetType() {
            return privacyBudgetType;
        }

        public final void setPrivacyBudgetType(String privacyBudgetType) {
            this.privacyBudgetType = privacyBudgetType;
        }

        @Override
        public final Builder privacyBudgetType(String privacyBudgetType) {
            this.privacyBudgetType = privacyBudgetType;
            return this;
        }

        @Override
        public final Builder privacyBudgetType(PrivacyBudgetType privacyBudgetType) {
            this.privacyBudgetType(privacyBudgetType == null ? null : privacyBudgetType.toString());
            return this;
        }

        public final PrivacyBudgetTemplateUpdateParameters.Builder getParameters() {
            return parameters != null ? parameters.toBuilder() : null;
        }

        public final void setParameters(PrivacyBudgetTemplateUpdateParameters.BuilderImpl parameters) {
            this.parameters = parameters != null ? parameters.build() : null;
        }

        @Override
        public final Builder parameters(PrivacyBudgetTemplateUpdateParameters parameters) {
            this.parameters = parameters;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePrivacyBudgetTemplateRequest build() {
            return new UpdatePrivacyBudgetTemplateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
