/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cleanrooms.model.PrivacyBudget;
import software.amazon.awssdk.services.cleanrooms.model.PrivacyBudgetType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PrivacyBudgetSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PrivacyBudgetSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(PrivacyBudgetSummary.getter(PrivacyBudgetSummary::id)).setter(PrivacyBudgetSummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> PRIVACY_BUDGET_TEMPLATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("privacyBudgetTemplateId").getter(PrivacyBudgetSummary.getter(PrivacyBudgetSummary::privacyBudgetTemplateId)).setter(PrivacyBudgetSummary.setter(Builder::privacyBudgetTemplateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("privacyBudgetTemplateId").build()}).build();
    private static final SdkField<String> PRIVACY_BUDGET_TEMPLATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("privacyBudgetTemplateArn").getter(PrivacyBudgetSummary.getter(PrivacyBudgetSummary::privacyBudgetTemplateArn)).setter(PrivacyBudgetSummary.setter(Builder::privacyBudgetTemplateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("privacyBudgetTemplateArn").build()}).build();
    private static final SdkField<String> MEMBERSHIP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("membershipId").getter(PrivacyBudgetSummary.getter(PrivacyBudgetSummary::membershipId)).setter(PrivacyBudgetSummary.setter(Builder::membershipId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipId").build()}).build();
    private static final SdkField<String> MEMBERSHIP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("membershipArn").getter(PrivacyBudgetSummary.getter(PrivacyBudgetSummary::membershipArn)).setter(PrivacyBudgetSummary.setter(Builder::membershipArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipArn").build()}).build();
    private static final SdkField<String> COLLABORATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("collaborationId").getter(PrivacyBudgetSummary.getter(PrivacyBudgetSummary::collaborationId)).setter(PrivacyBudgetSummary.setter(Builder::collaborationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationId").build()}).build();
    private static final SdkField<String> COLLABORATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("collaborationArn").getter(PrivacyBudgetSummary.getter(PrivacyBudgetSummary::collaborationArn)).setter(PrivacyBudgetSummary.setter(Builder::collaborationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationArn").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(PrivacyBudgetSummary.getter(PrivacyBudgetSummary::typeAsString)).setter(PrivacyBudgetSummary.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createTime").getter(PrivacyBudgetSummary.getter(PrivacyBudgetSummary::createTime)).setter(PrivacyBudgetSummary.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build()}).build();
    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updateTime").getter(PrivacyBudgetSummary.getter(PrivacyBudgetSummary::updateTime)).setter(PrivacyBudgetSummary.setter(Builder::updateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build()}).build();
    private static final SdkField<PrivacyBudget> BUDGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("budget").getter(PrivacyBudgetSummary.getter(PrivacyBudgetSummary::budget)).setter(PrivacyBudgetSummary.setter(Builder::budget)).constructor(PrivacyBudget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("budget").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, PRIVACY_BUDGET_TEMPLATE_ID_FIELD, PRIVACY_BUDGET_TEMPLATE_ARN_FIELD, MEMBERSHIP_ID_FIELD, MEMBERSHIP_ARN_FIELD, COLLABORATION_ID_FIELD, COLLABORATION_ARN_FIELD, TYPE_FIELD, CREATE_TIME_FIELD, UPDATE_TIME_FIELD, BUDGET_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PrivacyBudgetSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String privacyBudgetTemplateId;
    private final String privacyBudgetTemplateArn;
    private final String membershipId;
    private final String membershipArn;
    private final String collaborationId;
    private final String collaborationArn;
    private final String type;
    private final Instant createTime;
    private final Instant updateTime;
    private final PrivacyBudget budget;

    private PrivacyBudgetSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.privacyBudgetTemplateId = builder.privacyBudgetTemplateId;
        this.privacyBudgetTemplateArn = builder.privacyBudgetTemplateArn;
        this.membershipId = builder.membershipId;
        this.membershipArn = builder.membershipArn;
        this.collaborationId = builder.collaborationId;
        this.collaborationArn = builder.collaborationArn;
        this.type = builder.type;
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
        this.budget = builder.budget;
    }

    public final String id() {
        return this.id;
    }

    public final String privacyBudgetTemplateId() {
        return this.privacyBudgetTemplateId;
    }

    public final String privacyBudgetTemplateArn() {
        return this.privacyBudgetTemplateArn;
    }

    public final String membershipId() {
        return this.membershipId;
    }

    public final String membershipArn() {
        return this.membershipArn;
    }

    public final String collaborationId() {
        return this.collaborationId;
    }

    public final String collaborationArn() {
        return this.collaborationArn;
    }

    public final PrivacyBudgetType type() {
        return PrivacyBudgetType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public final Instant updateTime() {
        return this.updateTime;
    }

    public final PrivacyBudget budget() {
        return this.budget;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.privacyBudgetTemplateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.privacyBudgetTemplateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.membershipId());
        hashCode = 31 * hashCode + Objects.hashCode(this.membershipArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.collaborationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.collaborationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.budget());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PrivacyBudgetSummary)) {
            return false;
        }
        PrivacyBudgetSummary other = (PrivacyBudgetSummary)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.privacyBudgetTemplateId(), other.privacyBudgetTemplateId()) && Objects.equals(this.privacyBudgetTemplateArn(), other.privacyBudgetTemplateArn()) && Objects.equals(this.membershipId(), other.membershipId()) && Objects.equals(this.membershipArn(), other.membershipArn()) && Objects.equals(this.collaborationId(), other.collaborationId()) && Objects.equals(this.collaborationArn(), other.collaborationArn()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.updateTime(), other.updateTime()) && Objects.equals(this.budget(), other.budget());
    }

    public final String toString() {
        return ToString.builder((String)"PrivacyBudgetSummary").add("Id", (Object)this.id()).add("PrivacyBudgetTemplateId", (Object)this.privacyBudgetTemplateId()).add("PrivacyBudgetTemplateArn", (Object)this.privacyBudgetTemplateArn()).add("MembershipId", (Object)this.membershipId()).add("MembershipArn", (Object)this.membershipArn()).add("CollaborationId", (Object)this.collaborationId()).add("CollaborationArn", (Object)this.collaborationArn()).add("Type", (Object)this.typeAsString()).add("CreateTime", (Object)this.createTime()).add("UpdateTime", (Object)this.updateTime()).add("Budget", (Object)this.budget()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "privacyBudgetTemplateId": {
                return Optional.ofNullable(clazz.cast(this.privacyBudgetTemplateId()));
            }
            case "privacyBudgetTemplateArn": {
                return Optional.ofNullable(clazz.cast(this.privacyBudgetTemplateArn()));
            }
            case "membershipId": {
                return Optional.ofNullable(clazz.cast(this.membershipId()));
            }
            case "membershipArn": {
                return Optional.ofNullable(clazz.cast(this.membershipArn()));
            }
            case "collaborationId": {
                return Optional.ofNullable(clazz.cast(this.collaborationId()));
            }
            case "collaborationArn": {
                return Optional.ofNullable(clazz.cast(this.collaborationArn()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "createTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "updateTime": {
                return Optional.ofNullable(clazz.cast(this.updateTime()));
            }
            case "budget": {
                return Optional.ofNullable(clazz.cast(this.budget()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", ID_FIELD);
        map.put("privacyBudgetTemplateId", PRIVACY_BUDGET_TEMPLATE_ID_FIELD);
        map.put("privacyBudgetTemplateArn", PRIVACY_BUDGET_TEMPLATE_ARN_FIELD);
        map.put("membershipId", MEMBERSHIP_ID_FIELD);
        map.put("membershipArn", MEMBERSHIP_ARN_FIELD);
        map.put("collaborationId", COLLABORATION_ID_FIELD);
        map.put("collaborationArn", COLLABORATION_ARN_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("createTime", CREATE_TIME_FIELD);
        map.put("updateTime", UPDATE_TIME_FIELD);
        map.put("budget", BUDGET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PrivacyBudgetSummary, T> g) {
        return obj -> g.apply((PrivacyBudgetSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String privacyBudgetTemplateId;
        private String privacyBudgetTemplateArn;
        private String membershipId;
        private String membershipArn;
        private String collaborationId;
        private String collaborationArn;
        private String type;
        private Instant createTime;
        private Instant updateTime;
        private PrivacyBudget budget;

        private BuilderImpl() {
        }

        private BuilderImpl(PrivacyBudgetSummary model) {
            this.id(model.id);
            this.privacyBudgetTemplateId(model.privacyBudgetTemplateId);
            this.privacyBudgetTemplateArn(model.privacyBudgetTemplateArn);
            this.membershipId(model.membershipId);
            this.membershipArn(model.membershipArn);
            this.collaborationId(model.collaborationId);
            this.collaborationArn(model.collaborationArn);
            this.type(model.type);
            this.createTime(model.createTime);
            this.updateTime(model.updateTime);
            this.budget(model.budget);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getPrivacyBudgetTemplateId() {
            return this.privacyBudgetTemplateId;
        }

        public final void setPrivacyBudgetTemplateId(String privacyBudgetTemplateId) {
            this.privacyBudgetTemplateId = privacyBudgetTemplateId;
        }

        @Override
        public final Builder privacyBudgetTemplateId(String privacyBudgetTemplateId) {
            this.privacyBudgetTemplateId = privacyBudgetTemplateId;
            return this;
        }

        public final String getPrivacyBudgetTemplateArn() {
            return this.privacyBudgetTemplateArn;
        }

        public final void setPrivacyBudgetTemplateArn(String privacyBudgetTemplateArn) {
            this.privacyBudgetTemplateArn = privacyBudgetTemplateArn;
        }

        @Override
        public final Builder privacyBudgetTemplateArn(String privacyBudgetTemplateArn) {
            this.privacyBudgetTemplateArn = privacyBudgetTemplateArn;
            return this;
        }

        public final String getMembershipId() {
            return this.membershipId;
        }

        public final void setMembershipId(String membershipId) {
            this.membershipId = membershipId;
        }

        @Override
        public final Builder membershipId(String membershipId) {
            this.membershipId = membershipId;
            return this;
        }

        public final String getMembershipArn() {
            return this.membershipArn;
        }

        public final void setMembershipArn(String membershipArn) {
            this.membershipArn = membershipArn;
        }

        @Override
        public final Builder membershipArn(String membershipArn) {
            this.membershipArn = membershipArn;
            return this;
        }

        public final String getCollaborationId() {
            return this.collaborationId;
        }

        public final void setCollaborationId(String collaborationId) {
            this.collaborationId = collaborationId;
        }

        @Override
        public final Builder collaborationId(String collaborationId) {
            this.collaborationId = collaborationId;
            return this;
        }

        public final String getCollaborationArn() {
            return this.collaborationArn;
        }

        public final void setCollaborationArn(String collaborationArn) {
            this.collaborationArn = collaborationArn;
        }

        @Override
        public final Builder collaborationArn(String collaborationArn) {
            this.collaborationArn = collaborationArn;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(PrivacyBudgetType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return this.updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final PrivacyBudget.Builder getBudget() {
            return this.budget != null ? this.budget.toBuilder() : null;
        }

        public final void setBudget(PrivacyBudget.BuilderImpl budget) {
            this.budget = budget != null ? budget.build() : null;
        }

        @Override
        public final Builder budget(PrivacyBudget budget) {
            this.budget = budget;
            return this;
        }

        public PrivacyBudgetSummary build() {
            return new PrivacyBudgetSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PrivacyBudgetSummary> {
        public Builder id(String var1);

        public Builder privacyBudgetTemplateId(String var1);

        public Builder privacyBudgetTemplateArn(String var1);

        public Builder membershipId(String var1);

        public Builder membershipArn(String var1);

        public Builder collaborationId(String var1);

        public Builder collaborationArn(String var1);

        public Builder type(String var1);

        public Builder type(PrivacyBudgetType var1);

        public Builder createTime(Instant var1);

        public Builder updateTime(Instant var1);

        public Builder budget(PrivacyBudget var1);

        default public Builder budget(Consumer<PrivacyBudget.Builder> budget) {
            return this.budget((PrivacyBudget)((PrivacyBudget.Builder)PrivacyBudget.builder().applyMutation(budget)).build());
        }
    }
}

