/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines details for the analysis rule ID mapping table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnalysisRuleIdMappingTable implements SdkPojo, Serializable,
        ToCopyableBuilder<AnalysisRuleIdMappingTable.Builder, AnalysisRuleIdMappingTable> {
    private static final SdkField<List<String>> JOIN_COLUMNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("joinColumns")
            .getter(getter(AnalysisRuleIdMappingTable::joinColumns))
            .setter(setter(Builder::joinColumns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("joinColumns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<QueryConstraint>> QUERY_CONSTRAINTS_FIELD = SdkField
            .<List<QueryConstraint>> builder(MarshallingType.LIST)
            .memberName("queryConstraints")
            .getter(getter(AnalysisRuleIdMappingTable::queryConstraints))
            .setter(setter(Builder::queryConstraints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryConstraints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<QueryConstraint> builder(MarshallingType.SDK_POJO)
                                            .constructor(QueryConstraint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> DIMENSION_COLUMNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("dimensionColumns")
            .getter(getter(AnalysisRuleIdMappingTable::dimensionColumns))
            .setter(setter(Builder::dimensionColumns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dimensionColumns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOIN_COLUMNS_FIELD,
            QUERY_CONSTRAINTS_FIELD, DIMENSION_COLUMNS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> joinColumns;

    private final List<QueryConstraint> queryConstraints;

    private final List<String> dimensionColumns;

    private AnalysisRuleIdMappingTable(BuilderImpl builder) {
        this.joinColumns = builder.joinColumns;
        this.queryConstraints = builder.queryConstraints;
        this.dimensionColumns = builder.dimensionColumns;
    }

    /**
     * For responses, this returns true if the service returned a value for the JoinColumns property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasJoinColumns() {
        return joinColumns != null && !(joinColumns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The columns that query runners are allowed to use in an INNER JOIN statement.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasJoinColumns} method.
     * </p>
     * 
     * @return The columns that query runners are allowed to use in an INNER JOIN statement.
     */
    public final List<String> joinColumns() {
        return joinColumns;
    }

    /**
     * For responses, this returns true if the service returned a value for the QueryConstraints property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasQueryConstraints() {
        return queryConstraints != null && !(queryConstraints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The query constraints of the analysis rule ID mapping table.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasQueryConstraints} method.
     * </p>
     * 
     * @return The query constraints of the analysis rule ID mapping table.
     */
    public final List<QueryConstraint> queryConstraints() {
        return queryConstraints;
    }

    /**
     * For responses, this returns true if the service returned a value for the DimensionColumns property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDimensionColumns() {
        return dimensionColumns != null && !(dimensionColumns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The columns that query runners are allowed to select, group by, or filter by.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDimensionColumns} method.
     * </p>
     * 
     * @return The columns that query runners are allowed to select, group by, or filter by.
     */
    public final List<String> dimensionColumns() {
        return dimensionColumns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasJoinColumns() ? joinColumns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasQueryConstraints() ? queryConstraints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDimensionColumns() ? dimensionColumns() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalysisRuleIdMappingTable)) {
            return false;
        }
        AnalysisRuleIdMappingTable other = (AnalysisRuleIdMappingTable) obj;
        return hasJoinColumns() == other.hasJoinColumns() && Objects.equals(joinColumns(), other.joinColumns())
                && hasQueryConstraints() == other.hasQueryConstraints()
                && Objects.equals(queryConstraints(), other.queryConstraints())
                && hasDimensionColumns() == other.hasDimensionColumns()
                && Objects.equals(dimensionColumns(), other.dimensionColumns());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AnalysisRuleIdMappingTable").add("JoinColumns", hasJoinColumns() ? joinColumns() : null)
                .add("QueryConstraints", hasQueryConstraints() ? queryConstraints() : null)
                .add("DimensionColumns", hasDimensionColumns() ? dimensionColumns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "joinColumns":
            return Optional.ofNullable(clazz.cast(joinColumns()));
        case "queryConstraints":
            return Optional.ofNullable(clazz.cast(queryConstraints()));
        case "dimensionColumns":
            return Optional.ofNullable(clazz.cast(dimensionColumns()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("joinColumns", JOIN_COLUMNS_FIELD);
        map.put("queryConstraints", QUERY_CONSTRAINTS_FIELD);
        map.put("dimensionColumns", DIMENSION_COLUMNS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AnalysisRuleIdMappingTable, T> g) {
        return obj -> g.apply((AnalysisRuleIdMappingTable) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnalysisRuleIdMappingTable> {
        /**
         * <p>
         * The columns that query runners are allowed to use in an INNER JOIN statement.
         * </p>
         * 
         * @param joinColumns
         *        The columns that query runners are allowed to use in an INNER JOIN statement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder joinColumns(Collection<String> joinColumns);

        /**
         * <p>
         * The columns that query runners are allowed to use in an INNER JOIN statement.
         * </p>
         * 
         * @param joinColumns
         *        The columns that query runners are allowed to use in an INNER JOIN statement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder joinColumns(String... joinColumns);

        /**
         * <p>
         * The query constraints of the analysis rule ID mapping table.
         * </p>
         * 
         * @param queryConstraints
         *        The query constraints of the analysis rule ID mapping table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryConstraints(Collection<QueryConstraint> queryConstraints);

        /**
         * <p>
         * The query constraints of the analysis rule ID mapping table.
         * </p>
         * 
         * @param queryConstraints
         *        The query constraints of the analysis rule ID mapping table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryConstraints(QueryConstraint... queryConstraints);

        /**
         * <p>
         * The query constraints of the analysis rule ID mapping table.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cleanrooms.model.QueryConstraint.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.cleanrooms.model.QueryConstraint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cleanrooms.model.QueryConstraint.Builder#build()} is called
         * immediately and its result is passed to {@link #queryConstraints(List<QueryConstraint>)}.
         * 
         * @param queryConstraints
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cleanrooms.model.QueryConstraint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #queryConstraints(java.util.Collection<QueryConstraint>)
         */
        Builder queryConstraints(Consumer<QueryConstraint.Builder>... queryConstraints);

        /**
         * <p>
         * The columns that query runners are allowed to select, group by, or filter by.
         * </p>
         * 
         * @param dimensionColumns
         *        The columns that query runners are allowed to select, group by, or filter by.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensionColumns(Collection<String> dimensionColumns);

        /**
         * <p>
         * The columns that query runners are allowed to select, group by, or filter by.
         * </p>
         * 
         * @param dimensionColumns
         *        The columns that query runners are allowed to select, group by, or filter by.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensionColumns(String... dimensionColumns);
    }

    static final class BuilderImpl implements Builder {
        private List<String> joinColumns = DefaultSdkAutoConstructList.getInstance();

        private List<QueryConstraint> queryConstraints = DefaultSdkAutoConstructList.getInstance();

        private List<String> dimensionColumns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AnalysisRuleIdMappingTable model) {
            joinColumns(model.joinColumns);
            queryConstraints(model.queryConstraints);
            dimensionColumns(model.dimensionColumns);
        }

        public final Collection<String> getJoinColumns() {
            if (joinColumns instanceof SdkAutoConstructList) {
                return null;
            }
            return joinColumns;
        }

        public final void setJoinColumns(Collection<String> joinColumns) {
            this.joinColumns = AnalysisRuleIdMappingTableJoinColumnsListCopier.copy(joinColumns);
        }

        @Override
        public final Builder joinColumns(Collection<String> joinColumns) {
            this.joinColumns = AnalysisRuleIdMappingTableJoinColumnsListCopier.copy(joinColumns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder joinColumns(String... joinColumns) {
            joinColumns(Arrays.asList(joinColumns));
            return this;
        }

        public final List<QueryConstraint.Builder> getQueryConstraints() {
            List<QueryConstraint.Builder> result = QueryConstraintListCopier.copyToBuilder(this.queryConstraints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setQueryConstraints(Collection<QueryConstraint.BuilderImpl> queryConstraints) {
            this.queryConstraints = QueryConstraintListCopier.copyFromBuilder(queryConstraints);
        }

        @Override
        public final Builder queryConstraints(Collection<QueryConstraint> queryConstraints) {
            this.queryConstraints = QueryConstraintListCopier.copy(queryConstraints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queryConstraints(QueryConstraint... queryConstraints) {
            queryConstraints(Arrays.asList(queryConstraints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queryConstraints(Consumer<QueryConstraint.Builder>... queryConstraints) {
            queryConstraints(Stream.of(queryConstraints).map(c -> QueryConstraint.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getDimensionColumns() {
            if (dimensionColumns instanceof SdkAutoConstructList) {
                return null;
            }
            return dimensionColumns;
        }

        public final void setDimensionColumns(Collection<String> dimensionColumns) {
            this.dimensionColumns = AnalysisRuleColumnListCopier.copy(dimensionColumns);
        }

        @Override
        public final Builder dimensionColumns(Collection<String> dimensionColumns) {
            this.dimensionColumns = AnalysisRuleColumnListCopier.copy(dimensionColumns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensionColumns(String... dimensionColumns) {
            dimensionColumns(Arrays.asList(dimensionColumns));
            return this;
        }

        @Override
        public AnalysisRuleIdMappingTable build() {
            return new AnalysisRuleIdMappingTable(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
