/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A type of analysis rule that enables row-level analysis.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnalysisRuleList implements SdkPojo, Serializable,
        ToCopyableBuilder<AnalysisRuleList.Builder, AnalysisRuleList> {
    private static final SdkField<List<String>> JOIN_COLUMNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("joinColumns")
            .getter(getter(AnalysisRuleList::joinColumns))
            .setter(setter(Builder::joinColumns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("joinColumns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ALLOWED_JOIN_OPERATORS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("allowedJoinOperators")
            .getter(getter(AnalysisRuleList::allowedJoinOperatorsAsStrings))
            .setter(setter(Builder::allowedJoinOperatorsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedJoinOperators").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> LIST_COLUMNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("listColumns")
            .getter(getter(AnalysisRuleList::listColumns))
            .setter(setter(Builder::listColumns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listColumns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ADDITIONAL_ANALYSES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("additionalAnalyses").getter(getter(AnalysisRuleList::additionalAnalysesAsString))
            .setter(setter(Builder::additionalAnalyses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalAnalyses").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOIN_COLUMNS_FIELD,
            ALLOWED_JOIN_OPERATORS_FIELD, LIST_COLUMNS_FIELD, ADDITIONAL_ANALYSES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> joinColumns;

    private final List<String> allowedJoinOperators;

    private final List<String> listColumns;

    private final String additionalAnalyses;

    private AnalysisRuleList(BuilderImpl builder) {
        this.joinColumns = builder.joinColumns;
        this.allowedJoinOperators = builder.allowedJoinOperators;
        this.listColumns = builder.listColumns;
        this.additionalAnalyses = builder.additionalAnalyses;
    }

    /**
     * For responses, this returns true if the service returned a value for the JoinColumns property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasJoinColumns() {
        return joinColumns != null && !(joinColumns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Columns that can be used to join a configured table with the table of the member who can query and other members'
     * configured tables.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasJoinColumns} method.
     * </p>
     * 
     * @return Columns that can be used to join a configured table with the table of the member who can query and other
     *         members' configured tables.
     */
    public final List<String> joinColumns() {
        return joinColumns;
    }

    /**
     * <p>
     * The logical operators (if any) that are to be used in an INNER JOIN match condition. Default is <code>AND</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllowedJoinOperators} method.
     * </p>
     * 
     * @return The logical operators (if any) that are to be used in an INNER JOIN match condition. Default is
     *         <code>AND</code>.
     */
    public final List<JoinOperator> allowedJoinOperators() {
        return JoinOperatorsListCopier.copyStringToEnum(allowedJoinOperators);
    }

    /**
     * For responses, this returns true if the service returned a value for the AllowedJoinOperators property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAllowedJoinOperators() {
        return allowedJoinOperators != null && !(allowedJoinOperators instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The logical operators (if any) that are to be used in an INNER JOIN match condition. Default is <code>AND</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllowedJoinOperators} method.
     * </p>
     * 
     * @return The logical operators (if any) that are to be used in an INNER JOIN match condition. Default is
     *         <code>AND</code>.
     */
    public final List<String> allowedJoinOperatorsAsStrings() {
        return allowedJoinOperators;
    }

    /**
     * For responses, this returns true if the service returned a value for the ListColumns property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasListColumns() {
        return listColumns != null && !(listColumns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Columns that can be listed in the output.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasListColumns} method.
     * </p>
     * 
     * @return Columns that can be listed in the output.
     */
    public final List<String> listColumns() {
        return listColumns;
    }

    /**
     * <p>
     * An indicator as to whether additional analyses (such as Clean Rooms ML) can be applied to the output of the
     * direct query.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #additionalAnalyses} will return {@link AdditionalAnalyses#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #additionalAnalysesAsString}.
     * </p>
     * 
     * @return An indicator as to whether additional analyses (such as Clean Rooms ML) can be applied to the output of
     *         the direct query.
     * @see AdditionalAnalyses
     */
    public final AdditionalAnalyses additionalAnalyses() {
        return AdditionalAnalyses.fromValue(additionalAnalyses);
    }

    /**
     * <p>
     * An indicator as to whether additional analyses (such as Clean Rooms ML) can be applied to the output of the
     * direct query.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #additionalAnalyses} will return {@link AdditionalAnalyses#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #additionalAnalysesAsString}.
     * </p>
     * 
     * @return An indicator as to whether additional analyses (such as Clean Rooms ML) can be applied to the output of
     *         the direct query.
     * @see AdditionalAnalyses
     */
    public final String additionalAnalysesAsString() {
        return additionalAnalyses;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasJoinColumns() ? joinColumns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAllowedJoinOperators() ? allowedJoinOperatorsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasListColumns() ? listColumns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(additionalAnalysesAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalysisRuleList)) {
            return false;
        }
        AnalysisRuleList other = (AnalysisRuleList) obj;
        return hasJoinColumns() == other.hasJoinColumns() && Objects.equals(joinColumns(), other.joinColumns())
                && hasAllowedJoinOperators() == other.hasAllowedJoinOperators()
                && Objects.equals(allowedJoinOperatorsAsStrings(), other.allowedJoinOperatorsAsStrings())
                && hasListColumns() == other.hasListColumns() && Objects.equals(listColumns(), other.listColumns())
                && Objects.equals(additionalAnalysesAsString(), other.additionalAnalysesAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AnalysisRuleList").add("JoinColumns", hasJoinColumns() ? joinColumns() : null)
                .add("AllowedJoinOperators", hasAllowedJoinOperators() ? allowedJoinOperatorsAsStrings() : null)
                .add("ListColumns", hasListColumns() ? listColumns() : null)
                .add("AdditionalAnalyses", additionalAnalysesAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "joinColumns":
            return Optional.ofNullable(clazz.cast(joinColumns()));
        case "allowedJoinOperators":
            return Optional.ofNullable(clazz.cast(allowedJoinOperatorsAsStrings()));
        case "listColumns":
            return Optional.ofNullable(clazz.cast(listColumns()));
        case "additionalAnalyses":
            return Optional.ofNullable(clazz.cast(additionalAnalysesAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("joinColumns", JOIN_COLUMNS_FIELD);
        map.put("allowedJoinOperators", ALLOWED_JOIN_OPERATORS_FIELD);
        map.put("listColumns", LIST_COLUMNS_FIELD);
        map.put("additionalAnalyses", ADDITIONAL_ANALYSES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AnalysisRuleList, T> g) {
        return obj -> g.apply((AnalysisRuleList) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnalysisRuleList> {
        /**
         * <p>
         * Columns that can be used to join a configured table with the table of the member who can query and other
         * members' configured tables.
         * </p>
         * 
         * @param joinColumns
         *        Columns that can be used to join a configured table with the table of the member who can query and
         *        other members' configured tables.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder joinColumns(Collection<String> joinColumns);

        /**
         * <p>
         * Columns that can be used to join a configured table with the table of the member who can query and other
         * members' configured tables.
         * </p>
         * 
         * @param joinColumns
         *        Columns that can be used to join a configured table with the table of the member who can query and
         *        other members' configured tables.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder joinColumns(String... joinColumns);

        /**
         * <p>
         * The logical operators (if any) that are to be used in an INNER JOIN match condition. Default is
         * <code>AND</code>.
         * </p>
         * 
         * @param allowedJoinOperators
         *        The logical operators (if any) that are to be used in an INNER JOIN match condition. Default is
         *        <code>AND</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedJoinOperatorsWithStrings(Collection<String> allowedJoinOperators);

        /**
         * <p>
         * The logical operators (if any) that are to be used in an INNER JOIN match condition. Default is
         * <code>AND</code>.
         * </p>
         * 
         * @param allowedJoinOperators
         *        The logical operators (if any) that are to be used in an INNER JOIN match condition. Default is
         *        <code>AND</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedJoinOperatorsWithStrings(String... allowedJoinOperators);

        /**
         * <p>
         * The logical operators (if any) that are to be used in an INNER JOIN match condition. Default is
         * <code>AND</code>.
         * </p>
         * 
         * @param allowedJoinOperators
         *        The logical operators (if any) that are to be used in an INNER JOIN match condition. Default is
         *        <code>AND</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedJoinOperators(Collection<JoinOperator> allowedJoinOperators);

        /**
         * <p>
         * The logical operators (if any) that are to be used in an INNER JOIN match condition. Default is
         * <code>AND</code>.
         * </p>
         * 
         * @param allowedJoinOperators
         *        The logical operators (if any) that are to be used in an INNER JOIN match condition. Default is
         *        <code>AND</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedJoinOperators(JoinOperator... allowedJoinOperators);

        /**
         * <p>
         * Columns that can be listed in the output.
         * </p>
         * 
         * @param listColumns
         *        Columns that can be listed in the output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listColumns(Collection<String> listColumns);

        /**
         * <p>
         * Columns that can be listed in the output.
         * </p>
         * 
         * @param listColumns
         *        Columns that can be listed in the output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listColumns(String... listColumns);

        /**
         * <p>
         * An indicator as to whether additional analyses (such as Clean Rooms ML) can be applied to the output of the
         * direct query.
         * </p>
         * 
         * @param additionalAnalyses
         *        An indicator as to whether additional analyses (such as Clean Rooms ML) can be applied to the output
         *        of the direct query.
         * @see AdditionalAnalyses
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AdditionalAnalyses
         */
        Builder additionalAnalyses(String additionalAnalyses);

        /**
         * <p>
         * An indicator as to whether additional analyses (such as Clean Rooms ML) can be applied to the output of the
         * direct query.
         * </p>
         * 
         * @param additionalAnalyses
         *        An indicator as to whether additional analyses (such as Clean Rooms ML) can be applied to the output
         *        of the direct query.
         * @see AdditionalAnalyses
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AdditionalAnalyses
         */
        Builder additionalAnalyses(AdditionalAnalyses additionalAnalyses);
    }

    static final class BuilderImpl implements Builder {
        private List<String> joinColumns = DefaultSdkAutoConstructList.getInstance();

        private List<String> allowedJoinOperators = DefaultSdkAutoConstructList.getInstance();

        private List<String> listColumns = DefaultSdkAutoConstructList.getInstance();

        private String additionalAnalyses;

        private BuilderImpl() {
        }

        private BuilderImpl(AnalysisRuleList model) {
            joinColumns(model.joinColumns);
            allowedJoinOperatorsWithStrings(model.allowedJoinOperators);
            listColumns(model.listColumns);
            additionalAnalyses(model.additionalAnalyses);
        }

        public final Collection<String> getJoinColumns() {
            if (joinColumns instanceof SdkAutoConstructList) {
                return null;
            }
            return joinColumns;
        }

        public final void setJoinColumns(Collection<String> joinColumns) {
            this.joinColumns = AnalysisRuleListJoinColumnsListCopier.copy(joinColumns);
        }

        @Override
        public final Builder joinColumns(Collection<String> joinColumns) {
            this.joinColumns = AnalysisRuleListJoinColumnsListCopier.copy(joinColumns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder joinColumns(String... joinColumns) {
            joinColumns(Arrays.asList(joinColumns));
            return this;
        }

        public final Collection<String> getAllowedJoinOperators() {
            if (allowedJoinOperators instanceof SdkAutoConstructList) {
                return null;
            }
            return allowedJoinOperators;
        }

        public final void setAllowedJoinOperators(Collection<String> allowedJoinOperators) {
            this.allowedJoinOperators = JoinOperatorsListCopier.copy(allowedJoinOperators);
        }

        @Override
        public final Builder allowedJoinOperatorsWithStrings(Collection<String> allowedJoinOperators) {
            this.allowedJoinOperators = JoinOperatorsListCopier.copy(allowedJoinOperators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedJoinOperatorsWithStrings(String... allowedJoinOperators) {
            allowedJoinOperatorsWithStrings(Arrays.asList(allowedJoinOperators));
            return this;
        }

        @Override
        public final Builder allowedJoinOperators(Collection<JoinOperator> allowedJoinOperators) {
            this.allowedJoinOperators = JoinOperatorsListCopier.copyEnumToString(allowedJoinOperators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedJoinOperators(JoinOperator... allowedJoinOperators) {
            allowedJoinOperators(Arrays.asList(allowedJoinOperators));
            return this;
        }

        public final Collection<String> getListColumns() {
            if (listColumns instanceof SdkAutoConstructList) {
                return null;
            }
            return listColumns;
        }

        public final void setListColumns(Collection<String> listColumns) {
            this.listColumns = AnalysisRuleColumnListCopier.copy(listColumns);
        }

        @Override
        public final Builder listColumns(Collection<String> listColumns) {
            this.listColumns = AnalysisRuleColumnListCopier.copy(listColumns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listColumns(String... listColumns) {
            listColumns(Arrays.asList(listColumns));
            return this;
        }

        public final String getAdditionalAnalyses() {
            return additionalAnalyses;
        }

        public final void setAdditionalAnalyses(String additionalAnalyses) {
            this.additionalAnalyses = additionalAnalyses;
        }

        @Override
        public final Builder additionalAnalyses(String additionalAnalyses) {
            this.additionalAnalyses = additionalAnalyses;
            return this;
        }

        @Override
        public final Builder additionalAnalyses(AdditionalAnalyses additionalAnalyses) {
            this.additionalAnalyses(additionalAnalyses == null ? null : additionalAnalyses.toString());
            return this;
        }

        @Override
        public AnalysisRuleList build() {
            return new AnalysisRuleList(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
