/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides summary information about the collaboration ID namespace association.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CollaborationIdNamespaceAssociationSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<CollaborationIdNamespaceAssociationSummary.Builder, CollaborationIdNamespaceAssociationSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(CollaborationIdNamespaceAssociationSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createTime").getter(getter(CollaborationIdNamespaceAssociationSummary::createTime))
            .setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(CollaborationIdNamespaceAssociationSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updateTime").getter(getter(CollaborationIdNamespaceAssociationSummary::updateTime))
            .setter(setter(Builder::updateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build()).build();

    private static final SdkField<String> COLLABORATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("collaborationArn").getter(getter(CollaborationIdNamespaceAssociationSummary::collaborationArn))
            .setter(setter(Builder::collaborationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationArn").build()).build();

    private static final SdkField<String> COLLABORATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("collaborationId").getter(getter(CollaborationIdNamespaceAssociationSummary::collaborationId))
            .setter(setter(Builder::collaborationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationId").build()).build();

    private static final SdkField<String> CREATOR_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("creatorAccountId").getter(getter(CollaborationIdNamespaceAssociationSummary::creatorAccountId))
            .setter(setter(Builder::creatorAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creatorAccountId").build()).build();

    private static final SdkField<IdNamespaceAssociationInputReferenceConfig> INPUT_REFERENCE_CONFIG_FIELD = SdkField
            .<IdNamespaceAssociationInputReferenceConfig> builder(MarshallingType.SDK_POJO).memberName("inputReferenceConfig")
            .getter(getter(CollaborationIdNamespaceAssociationSummary::inputReferenceConfig))
            .setter(setter(Builder::inputReferenceConfig)).constructor(IdNamespaceAssociationInputReferenceConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputReferenceConfig").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CollaborationIdNamespaceAssociationSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CollaborationIdNamespaceAssociationSummary::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<IdNamespaceAssociationInputReferencePropertiesSummary> INPUT_REFERENCE_PROPERTIES_FIELD = SdkField
            .<IdNamespaceAssociationInputReferencePropertiesSummary> builder(MarshallingType.SDK_POJO)
            .memberName("inputReferenceProperties")
            .getter(getter(CollaborationIdNamespaceAssociationSummary::inputReferenceProperties))
            .setter(setter(Builder::inputReferenceProperties))
            .constructor(IdNamespaceAssociationInputReferencePropertiesSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputReferenceProperties").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATE_TIME_FIELD,
            ID_FIELD, UPDATE_TIME_FIELD, COLLABORATION_ARN_FIELD, COLLABORATION_ID_FIELD, CREATOR_ACCOUNT_ID_FIELD,
            INPUT_REFERENCE_CONFIG_FIELD, NAME_FIELD, DESCRIPTION_FIELD, INPUT_REFERENCE_PROPERTIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final Instant createTime;

    private final String id;

    private final Instant updateTime;

    private final String collaborationArn;

    private final String collaborationId;

    private final String creatorAccountId;

    private final IdNamespaceAssociationInputReferenceConfig inputReferenceConfig;

    private final String name;

    private final String description;

    private final IdNamespaceAssociationInputReferencePropertiesSummary inputReferenceProperties;

    private CollaborationIdNamespaceAssociationSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.createTime = builder.createTime;
        this.id = builder.id;
        this.updateTime = builder.updateTime;
        this.collaborationArn = builder.collaborationArn;
        this.collaborationId = builder.collaborationId;
        this.creatorAccountId = builder.creatorAccountId;
        this.inputReferenceConfig = builder.inputReferenceConfig;
        this.name = builder.name;
        this.description = builder.description;
        this.inputReferenceProperties = builder.inputReferenceProperties;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the collaboration ID namespace association.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the collaboration ID namespace association.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The time at which the collaboration ID namespace association was created.
     * </p>
     * 
     * @return The time at which the collaboration ID namespace association was created.
     */
    public final Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * The unique identifier of the collaboration ID namespace association.
     * </p>
     * 
     * @return The unique identifier of the collaboration ID namespace association.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The most recent time at which the collaboration ID namespace association was updated.
     * </p>
     * 
     * @return The most recent time at which the collaboration ID namespace association was updated.
     */
    public final Instant updateTime() {
        return updateTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the collaboration that contains this collaboration ID namespace association.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the collaboration that contains this collaboration ID namespace
     *         association.
     */
    public final String collaborationArn() {
        return collaborationArn;
    }

    /**
     * <p>
     * The unique identifier of the collaboration that contains this collaboration ID namespace association.
     * </p>
     * 
     * @return The unique identifier of the collaboration that contains this collaboration ID namespace association.
     */
    public final String collaborationId() {
        return collaborationId;
    }

    /**
     * <p>
     * The Amazon Web Services account that created this collaboration ID namespace association.
     * </p>
     * 
     * @return The Amazon Web Services account that created this collaboration ID namespace association.
     */
    public final String creatorAccountId() {
        return creatorAccountId;
    }

    /**
     * <p>
     * The input reference configuration that's used to create the collaboration ID namespace association.
     * </p>
     * 
     * @return The input reference configuration that's used to create the collaboration ID namespace association.
     */
    public final IdNamespaceAssociationInputReferenceConfig inputReferenceConfig() {
        return inputReferenceConfig;
    }

    /**
     * <p>
     * The name of the collaboration ID namespace association.
     * </p>
     * 
     * @return The name of the collaboration ID namespace association.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the collaboration ID namepsace association.
     * </p>
     * 
     * @return The description of the collaboration ID namepsace association.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The input reference properties that are used to create the collaboration ID namespace association.
     * </p>
     * 
     * @return The input reference properties that are used to create the collaboration ID namespace association.
     */
    public final IdNamespaceAssociationInputReferencePropertiesSummary inputReferenceProperties() {
        return inputReferenceProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(collaborationArn());
        hashCode = 31 * hashCode + Objects.hashCode(collaborationId());
        hashCode = 31 * hashCode + Objects.hashCode(creatorAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(inputReferenceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(inputReferenceProperties());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CollaborationIdNamespaceAssociationSummary)) {
            return false;
        }
        CollaborationIdNamespaceAssociationSummary other = (CollaborationIdNamespaceAssociationSummary) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(createTime(), other.createTime())
                && Objects.equals(id(), other.id()) && Objects.equals(updateTime(), other.updateTime())
                && Objects.equals(collaborationArn(), other.collaborationArn())
                && Objects.equals(collaborationId(), other.collaborationId())
                && Objects.equals(creatorAccountId(), other.creatorAccountId())
                && Objects.equals(inputReferenceConfig(), other.inputReferenceConfig()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description())
                && Objects.equals(inputReferenceProperties(), other.inputReferenceProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CollaborationIdNamespaceAssociationSummary").add("Arn", arn()).add("CreateTime", createTime())
                .add("Id", id()).add("UpdateTime", updateTime()).add("CollaborationArn", collaborationArn())
                .add("CollaborationId", collaborationId()).add("CreatorAccountId", creatorAccountId())
                .add("InputReferenceConfig", inputReferenceConfig()).add("Name", name()).add("Description", description())
                .add("InputReferenceProperties", inputReferenceProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "createTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "updateTime":
            return Optional.ofNullable(clazz.cast(updateTime()));
        case "collaborationArn":
            return Optional.ofNullable(clazz.cast(collaborationArn()));
        case "collaborationId":
            return Optional.ofNullable(clazz.cast(collaborationId()));
        case "creatorAccountId":
            return Optional.ofNullable(clazz.cast(creatorAccountId()));
        case "inputReferenceConfig":
            return Optional.ofNullable(clazz.cast(inputReferenceConfig()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "inputReferenceProperties":
            return Optional.ofNullable(clazz.cast(inputReferenceProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("createTime", CREATE_TIME_FIELD);
        map.put("id", ID_FIELD);
        map.put("updateTime", UPDATE_TIME_FIELD);
        map.put("collaborationArn", COLLABORATION_ARN_FIELD);
        map.put("collaborationId", COLLABORATION_ID_FIELD);
        map.put("creatorAccountId", CREATOR_ACCOUNT_ID_FIELD);
        map.put("inputReferenceConfig", INPUT_REFERENCE_CONFIG_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("inputReferenceProperties", INPUT_REFERENCE_PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CollaborationIdNamespaceAssociationSummary, T> g) {
        return obj -> g.apply((CollaborationIdNamespaceAssociationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CollaborationIdNamespaceAssociationSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the collaboration ID namespace association.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the collaboration ID namespace association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The time at which the collaboration ID namespace association was created.
         * </p>
         * 
         * @param createTime
         *        The time at which the collaboration ID namespace association was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * The unique identifier of the collaboration ID namespace association.
         * </p>
         * 
         * @param id
         *        The unique identifier of the collaboration ID namespace association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The most recent time at which the collaboration ID namespace association was updated.
         * </p>
         * 
         * @param updateTime
         *        The most recent time at which the collaboration ID namespace association was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTime(Instant updateTime);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the collaboration that contains this collaboration ID namespace
         * association.
         * </p>
         * 
         * @param collaborationArn
         *        The Amazon Resource Name (ARN) of the collaboration that contains this collaboration ID namespace
         *        association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaborationArn(String collaborationArn);

        /**
         * <p>
         * The unique identifier of the collaboration that contains this collaboration ID namespace association.
         * </p>
         * 
         * @param collaborationId
         *        The unique identifier of the collaboration that contains this collaboration ID namespace association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaborationId(String collaborationId);

        /**
         * <p>
         * The Amazon Web Services account that created this collaboration ID namespace association.
         * </p>
         * 
         * @param creatorAccountId
         *        The Amazon Web Services account that created this collaboration ID namespace association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creatorAccountId(String creatorAccountId);

        /**
         * <p>
         * The input reference configuration that's used to create the collaboration ID namespace association.
         * </p>
         * 
         * @param inputReferenceConfig
         *        The input reference configuration that's used to create the collaboration ID namespace association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputReferenceConfig(IdNamespaceAssociationInputReferenceConfig inputReferenceConfig);

        /**
         * <p>
         * The input reference configuration that's used to create the collaboration ID namespace association.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link IdNamespaceAssociationInputReferenceConfig.Builder} avoiding the need to create one manually via
         * {@link IdNamespaceAssociationInputReferenceConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IdNamespaceAssociationInputReferenceConfig.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #inputReferenceConfig(IdNamespaceAssociationInputReferenceConfig)}.
         * 
         * @param inputReferenceConfig
         *        a consumer that will call methods on {@link IdNamespaceAssociationInputReferenceConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputReferenceConfig(IdNamespaceAssociationInputReferenceConfig)
         */
        default Builder inputReferenceConfig(Consumer<IdNamespaceAssociationInputReferenceConfig.Builder> inputReferenceConfig) {
            return inputReferenceConfig(IdNamespaceAssociationInputReferenceConfig.builder().applyMutation(inputReferenceConfig)
                    .build());
        }

        /**
         * <p>
         * The name of the collaboration ID namespace association.
         * </p>
         * 
         * @param name
         *        The name of the collaboration ID namespace association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the collaboration ID namepsace association.
         * </p>
         * 
         * @param description
         *        The description of the collaboration ID namepsace association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The input reference properties that are used to create the collaboration ID namespace association.
         * </p>
         * 
         * @param inputReferenceProperties
         *        The input reference properties that are used to create the collaboration ID namespace association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputReferenceProperties(IdNamespaceAssociationInputReferencePropertiesSummary inputReferenceProperties);

        /**
         * <p>
         * The input reference properties that are used to create the collaboration ID namespace association.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link IdNamespaceAssociationInputReferencePropertiesSummary.Builder} avoiding the need to create one
         * manually via {@link IdNamespaceAssociationInputReferencePropertiesSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link IdNamespaceAssociationInputReferencePropertiesSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #inputReferenceProperties(IdNamespaceAssociationInputReferencePropertiesSummary)}.
         * 
         * @param inputReferenceProperties
         *        a consumer that will call methods on
         *        {@link IdNamespaceAssociationInputReferencePropertiesSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputReferenceProperties(IdNamespaceAssociationInputReferencePropertiesSummary)
         */
        default Builder inputReferenceProperties(
                Consumer<IdNamespaceAssociationInputReferencePropertiesSummary.Builder> inputReferenceProperties) {
            return inputReferenceProperties(IdNamespaceAssociationInputReferencePropertiesSummary.builder()
                    .applyMutation(inputReferenceProperties).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private Instant createTime;

        private String id;

        private Instant updateTime;

        private String collaborationArn;

        private String collaborationId;

        private String creatorAccountId;

        private IdNamespaceAssociationInputReferenceConfig inputReferenceConfig;

        private String name;

        private String description;

        private IdNamespaceAssociationInputReferencePropertiesSummary inputReferenceProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(CollaborationIdNamespaceAssociationSummary model) {
            arn(model.arn);
            createTime(model.createTime);
            id(model.id);
            updateTime(model.updateTime);
            collaborationArn(model.collaborationArn);
            collaborationId(model.collaborationId);
            creatorAccountId(model.creatorAccountId);
            inputReferenceConfig(model.inputReferenceConfig);
            name(model.name);
            description(model.description);
            inputReferenceProperties(model.inputReferenceProperties);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Instant getUpdateTime() {
            return updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final String getCollaborationArn() {
            return collaborationArn;
        }

        public final void setCollaborationArn(String collaborationArn) {
            this.collaborationArn = collaborationArn;
        }

        @Override
        public final Builder collaborationArn(String collaborationArn) {
            this.collaborationArn = collaborationArn;
            return this;
        }

        public final String getCollaborationId() {
            return collaborationId;
        }

        public final void setCollaborationId(String collaborationId) {
            this.collaborationId = collaborationId;
        }

        @Override
        public final Builder collaborationId(String collaborationId) {
            this.collaborationId = collaborationId;
            return this;
        }

        public final String getCreatorAccountId() {
            return creatorAccountId;
        }

        public final void setCreatorAccountId(String creatorAccountId) {
            this.creatorAccountId = creatorAccountId;
        }

        @Override
        public final Builder creatorAccountId(String creatorAccountId) {
            this.creatorAccountId = creatorAccountId;
            return this;
        }

        public final IdNamespaceAssociationInputReferenceConfig.Builder getInputReferenceConfig() {
            return inputReferenceConfig != null ? inputReferenceConfig.toBuilder() : null;
        }

        public final void setInputReferenceConfig(IdNamespaceAssociationInputReferenceConfig.BuilderImpl inputReferenceConfig) {
            this.inputReferenceConfig = inputReferenceConfig != null ? inputReferenceConfig.build() : null;
        }

        @Override
        public final Builder inputReferenceConfig(IdNamespaceAssociationInputReferenceConfig inputReferenceConfig) {
            this.inputReferenceConfig = inputReferenceConfig;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final IdNamespaceAssociationInputReferencePropertiesSummary.Builder getInputReferenceProperties() {
            return inputReferenceProperties != null ? inputReferenceProperties.toBuilder() : null;
        }

        public final void setInputReferenceProperties(
                IdNamespaceAssociationInputReferencePropertiesSummary.BuilderImpl inputReferenceProperties) {
            this.inputReferenceProperties = inputReferenceProperties != null ? inputReferenceProperties.build() : null;
        }

        @Override
        public final Builder inputReferenceProperties(
                IdNamespaceAssociationInputReferencePropertiesSummary inputReferenceProperties) {
            this.inputReferenceProperties = inputReferenceProperties;
            return this;
        }

        @Override
        public CollaborationIdNamespaceAssociationSummary build() {
            return new CollaborationIdNamespaceAssociationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
