/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConfigurationDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<ConfigurationDetails.Builder, ConfigurationDetails> {
    private static final SdkField<DirectAnalysisConfigurationDetails> DIRECT_ANALYSIS_CONFIGURATION_DETAILS_FIELD = SdkField
            .<DirectAnalysisConfigurationDetails> builder(MarshallingType.SDK_POJO)
            .memberName("directAnalysisConfigurationDetails")
            .getter(getter(ConfigurationDetails::directAnalysisConfigurationDetails))
            .setter(setter(Builder::directAnalysisConfigurationDetails))
            .constructor(DirectAnalysisConfigurationDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("directAnalysisConfigurationDetails")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(DIRECT_ANALYSIS_CONFIGURATION_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final DirectAnalysisConfigurationDetails directAnalysisConfigurationDetails;

    private final Type type;

    private ConfigurationDetails(BuilderImpl builder) {
        this.directAnalysisConfigurationDetails = builder.directAnalysisConfigurationDetails;
        this.type = builder.type;
    }

    /**
     * <p>
     * The direct analysis configuration details.
     * </p>
     * 
     * @return The direct analysis configuration details.
     */
    public final DirectAnalysisConfigurationDetails directAnalysisConfigurationDetails() {
        return directAnalysisConfigurationDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(directAnalysisConfigurationDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurationDetails)) {
            return false;
        }
        ConfigurationDetails other = (ConfigurationDetails) obj;
        return Objects.equals(directAnalysisConfigurationDetails(), other.directAnalysisConfigurationDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConfigurationDetails")
                .add("DirectAnalysisConfigurationDetails", directAnalysisConfigurationDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "directAnalysisConfigurationDetails":
            return Optional.ofNullable(clazz.cast(directAnalysisConfigurationDetails()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #directAnalysisConfigurationDetails()} initialized to the given
     * value.
     *
     * <p>
     * The direct analysis configuration details.
     * </p>
     * 
     * @param directAnalysisConfigurationDetails
     *        The direct analysis configuration details.
     */
    public static ConfigurationDetails fromDirectAnalysisConfigurationDetails(
            DirectAnalysisConfigurationDetails directAnalysisConfigurationDetails) {
        return builder().directAnalysisConfigurationDetails(directAnalysisConfigurationDetails).build();
    }

    /**
     * Create an instance of this class with {@link #directAnalysisConfigurationDetails()} initialized to the given
     * value.
     *
     * <p>
     * The direct analysis configuration details.
     * </p>
     * 
     * @param directAnalysisConfigurationDetails
     *        The direct analysis configuration details.
     */
    public static ConfigurationDetails fromDirectAnalysisConfigurationDetails(
            Consumer<DirectAnalysisConfigurationDetails.Builder> directAnalysisConfigurationDetails) {
        DirectAnalysisConfigurationDetails.Builder builder = DirectAnalysisConfigurationDetails.builder();
        directAnalysisConfigurationDetails.accept(builder);
        return fromDirectAnalysisConfigurationDetails(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("directAnalysisConfigurationDetails", DIRECT_ANALYSIS_CONFIGURATION_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConfigurationDetails, T> g) {
        return obj -> g.apply((ConfigurationDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConfigurationDetails> {
        /**
         * <p>
         * The direct analysis configuration details.
         * </p>
         * 
         * @param directAnalysisConfigurationDetails
         *        The direct analysis configuration details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directAnalysisConfigurationDetails(DirectAnalysisConfigurationDetails directAnalysisConfigurationDetails);

        /**
         * <p>
         * The direct analysis configuration details.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DirectAnalysisConfigurationDetails.Builder} avoiding the need to create one manually via
         * {@link DirectAnalysisConfigurationDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DirectAnalysisConfigurationDetails.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #directAnalysisConfigurationDetails(DirectAnalysisConfigurationDetails)}.
         * 
         * @param directAnalysisConfigurationDetails
         *        a consumer that will call methods on {@link DirectAnalysisConfigurationDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #directAnalysisConfigurationDetails(DirectAnalysisConfigurationDetails)
         */
        default Builder directAnalysisConfigurationDetails(
                Consumer<DirectAnalysisConfigurationDetails.Builder> directAnalysisConfigurationDetails) {
            return directAnalysisConfigurationDetails(DirectAnalysisConfigurationDetails.builder()
                    .applyMutation(directAnalysisConfigurationDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DirectAnalysisConfigurationDetails directAnalysisConfigurationDetails;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigurationDetails model) {
            directAnalysisConfigurationDetails(model.directAnalysisConfigurationDetails);
        }

        public final DirectAnalysisConfigurationDetails.Builder getDirectAnalysisConfigurationDetails() {
            return directAnalysisConfigurationDetails != null ? directAnalysisConfigurationDetails.toBuilder() : null;
        }

        public final void setDirectAnalysisConfigurationDetails(
                DirectAnalysisConfigurationDetails.BuilderImpl directAnalysisConfigurationDetails) {
            Object oldValue = this.directAnalysisConfigurationDetails;
            this.directAnalysisConfigurationDetails = directAnalysisConfigurationDetails != null ? directAnalysisConfigurationDetails
                    .build() : null;
            handleUnionValueChange(Type.DIRECT_ANALYSIS_CONFIGURATION_DETAILS, oldValue, this.directAnalysisConfigurationDetails);
        }

        @Override
        public final Builder directAnalysisConfigurationDetails(
                DirectAnalysisConfigurationDetails directAnalysisConfigurationDetails) {
            Object oldValue = this.directAnalysisConfigurationDetails;
            this.directAnalysisConfigurationDetails = directAnalysisConfigurationDetails;
            handleUnionValueChange(Type.DIRECT_ANALYSIS_CONFIGURATION_DETAILS, oldValue, this.directAnalysisConfigurationDetails);
            return this;
        }

        @Override
        public ConfigurationDetails build() {
            return new ConfigurationDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ConfigurationDetails#type()
     */
    public enum Type {
        DIRECT_ANALYSIS_CONFIGURATION_DETAILS,

        UNKNOWN_TO_SDK_VERSION
    }
}
