/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateMembershipResponse extends CleanRoomsResponse implements
        ToCopyableBuilder<CreateMembershipResponse.Builder, CreateMembershipResponse> {
    private static final SdkField<Membership> MEMBERSHIP_FIELD = SdkField.<Membership> builder(MarshallingType.SDK_POJO)
            .memberName("membership").getter(getter(CreateMembershipResponse::membership)).setter(setter(Builder::membership))
            .constructor(Membership::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membership").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBERSHIP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Membership membership;

    private CreateMembershipResponse(BuilderImpl builder) {
        super(builder);
        this.membership = builder.membership;
    }

    /**
     * <p>
     * The membership that was created.
     * </p>
     * 
     * @return The membership that was created.
     */
    public final Membership membership() {
        return membership;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(membership());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMembershipResponse)) {
            return false;
        }
        CreateMembershipResponse other = (CreateMembershipResponse) obj;
        return Objects.equals(membership(), other.membership());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateMembershipResponse").add("Membership", membership()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "membership":
            return Optional.ofNullable(clazz.cast(membership()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("membership", MEMBERSHIP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateMembershipResponse, T> g) {
        return obj -> g.apply((CreateMembershipResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CleanRoomsResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateMembershipResponse> {
        /**
         * <p>
         * The membership that was created.
         * </p>
         * 
         * @param membership
         *        The membership that was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder membership(Membership membership);

        /**
         * <p>
         * The membership that was created.
         * </p>
         * This is a convenience method that creates an instance of the {@link Membership.Builder} avoiding the need to
         * create one manually via {@link Membership#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Membership.Builder#build()} is called immediately and its result
         * is passed to {@link #membership(Membership)}.
         * 
         * @param membership
         *        a consumer that will call methods on {@link Membership.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #membership(Membership)
         */
        default Builder membership(Consumer<Membership.Builder> membership) {
            return membership(Membership.builder().applyMutation(membership).build());
        }
    }

    static final class BuilderImpl extends CleanRoomsResponse.BuilderImpl implements Builder {
        private Membership membership;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMembershipResponse model) {
            super(model);
            membership(model.membership);
        }

        public final Membership.Builder getMembership() {
            return membership != null ? membership.toBuilder() : null;
        }

        public final void setMembership(Membership.BuilderImpl membership) {
            this.membership = membership != null ? membership.build() : null;
        }

        @Override
        public final Builder membership(Membership membership) {
            this.membership = membership;
            return this;
        }

        @Override
        public CreateMembershipResponse build() {
            return new CreateMembershipResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
