/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides an estimate of the number of aggregation functions that the member who can query can run given the epsilon
 * and noise parameters.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DifferentialPrivacyPreviewAggregation implements SdkPojo, Serializable,
        ToCopyableBuilder<DifferentialPrivacyPreviewAggregation.Builder, DifferentialPrivacyPreviewAggregation> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(DifferentialPrivacyPreviewAggregation::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<Integer> MAX_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxCount").getter(getter(DifferentialPrivacyPreviewAggregation::maxCount))
            .setter(setter(Builder::maxCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, MAX_COUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final Integer maxCount;

    private DifferentialPrivacyPreviewAggregation(BuilderImpl builder) {
        this.type = builder.type;
        this.maxCount = builder.maxCount;
    }

    /**
     * <p>
     * The type of aggregation function.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DifferentialPrivacyAggregationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #typeAsString}.
     * </p>
     * 
     * @return The type of aggregation function.
     * @see DifferentialPrivacyAggregationType
     */
    public final DifferentialPrivacyAggregationType type() {
        return DifferentialPrivacyAggregationType.fromValue(type);
    }

    /**
     * <p>
     * The type of aggregation function.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DifferentialPrivacyAggregationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #typeAsString}.
     * </p>
     * 
     * @return The type of aggregation function.
     * @see DifferentialPrivacyAggregationType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The maximum number of aggregations that the member who can query can run given the epsilon and noise parameters.
     * </p>
     * 
     * @return The maximum number of aggregations that the member who can query can run given the epsilon and noise
     *         parameters.
     */
    public final Integer maxCount() {
        return maxCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DifferentialPrivacyPreviewAggregation)) {
            return false;
        }
        DifferentialPrivacyPreviewAggregation other = (DifferentialPrivacyPreviewAggregation) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(maxCount(), other.maxCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DifferentialPrivacyPreviewAggregation").add("Type", typeAsString()).add("MaxCount", maxCount())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "maxCount":
            return Optional.ofNullable(clazz.cast(maxCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("type", TYPE_FIELD);
        map.put("maxCount", MAX_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DifferentialPrivacyPreviewAggregation, T> g) {
        return obj -> g.apply((DifferentialPrivacyPreviewAggregation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DifferentialPrivacyPreviewAggregation> {
        /**
         * <p>
         * The type of aggregation function.
         * </p>
         * 
         * @param type
         *        The type of aggregation function.
         * @see DifferentialPrivacyAggregationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DifferentialPrivacyAggregationType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of aggregation function.
         * </p>
         * 
         * @param type
         *        The type of aggregation function.
         * @see DifferentialPrivacyAggregationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DifferentialPrivacyAggregationType
         */
        Builder type(DifferentialPrivacyAggregationType type);

        /**
         * <p>
         * The maximum number of aggregations that the member who can query can run given the epsilon and noise
         * parameters.
         * </p>
         * 
         * @param maxCount
         *        The maximum number of aggregations that the member who can query can run given the epsilon and noise
         *        parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxCount(Integer maxCount);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private Integer maxCount;

        private BuilderImpl() {
        }

        private BuilderImpl(DifferentialPrivacyPreviewAggregation model) {
            type(model.type);
            maxCount(model.maxCount);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(DifferentialPrivacyAggregationType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Integer getMaxCount() {
            return maxCount;
        }

        public final void setMaxCount(Integer maxCount) {
            this.maxCount = maxCount;
        }

        @Override
        public final Builder maxCount(Integer maxCount) {
            this.maxCount = maxCount;
            return this;
        }

        @Override
        public DifferentialPrivacyPreviewAggregation build() {
            return new DifferentialPrivacyPreviewAggregation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
