/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the configured epsilon value and the utility in terms of total aggregations, as well as the remaining
 * aggregations available.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DifferentialPrivacyPrivacyBudget implements SdkPojo, Serializable,
        ToCopyableBuilder<DifferentialPrivacyPrivacyBudget.Builder, DifferentialPrivacyPrivacyBudget> {
    private static final SdkField<List<DifferentialPrivacyPrivacyBudgetAggregation>> AGGREGATIONS_FIELD = SdkField
            .<List<DifferentialPrivacyPrivacyBudgetAggregation>> builder(MarshallingType.LIST)
            .memberName("aggregations")
            .getter(getter(DifferentialPrivacyPrivacyBudget::aggregations))
            .setter(setter(Builder::aggregations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DifferentialPrivacyPrivacyBudgetAggregation> builder(MarshallingType.SDK_POJO)
                                            .constructor(DifferentialPrivacyPrivacyBudgetAggregation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> EPSILON_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("epsilon").getter(getter(DifferentialPrivacyPrivacyBudget::epsilon)).setter(setter(Builder::epsilon))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("epsilon").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGGREGATIONS_FIELD,
            EPSILON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<DifferentialPrivacyPrivacyBudgetAggregation> aggregations;

    private final Integer epsilon;

    private DifferentialPrivacyPrivacyBudget(BuilderImpl builder) {
        this.aggregations = builder.aggregations;
        this.epsilon = builder.epsilon;
    }

    /**
     * For responses, this returns true if the service returned a value for the Aggregations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAggregations() {
        return aggregations != null && !(aggregations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * This information includes the configured epsilon value and the utility in terms of total aggregations, as well as
     * the remaining aggregations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAggregations} method.
     * </p>
     * 
     * @return This information includes the configured epsilon value and the utility in terms of total aggregations, as
     *         well as the remaining aggregations.
     */
    public final List<DifferentialPrivacyPrivacyBudgetAggregation> aggregations() {
        return aggregations;
    }

    /**
     * <p>
     * The epsilon value that you configured.
     * </p>
     * 
     * @return The epsilon value that you configured.
     */
    public final Integer epsilon() {
        return epsilon;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAggregations() ? aggregations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(epsilon());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DifferentialPrivacyPrivacyBudget)) {
            return false;
        }
        DifferentialPrivacyPrivacyBudget other = (DifferentialPrivacyPrivacyBudget) obj;
        return hasAggregations() == other.hasAggregations() && Objects.equals(aggregations(), other.aggregations())
                && Objects.equals(epsilon(), other.epsilon());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DifferentialPrivacyPrivacyBudget")
                .add("Aggregations", hasAggregations() ? aggregations() : null).add("Epsilon", epsilon()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "aggregations":
            return Optional.ofNullable(clazz.cast(aggregations()));
        case "epsilon":
            return Optional.ofNullable(clazz.cast(epsilon()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("aggregations", AGGREGATIONS_FIELD);
        map.put("epsilon", EPSILON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DifferentialPrivacyPrivacyBudget, T> g) {
        return obj -> g.apply((DifferentialPrivacyPrivacyBudget) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DifferentialPrivacyPrivacyBudget> {
        /**
         * <p>
         * This information includes the configured epsilon value and the utility in terms of total aggregations, as
         * well as the remaining aggregations.
         * </p>
         * 
         * @param aggregations
         *        This information includes the configured epsilon value and the utility in terms of total aggregations,
         *        as well as the remaining aggregations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregations(Collection<DifferentialPrivacyPrivacyBudgetAggregation> aggregations);

        /**
         * <p>
         * This information includes the configured epsilon value and the utility in terms of total aggregations, as
         * well as the remaining aggregations.
         * </p>
         * 
         * @param aggregations
         *        This information includes the configured epsilon value and the utility in terms of total aggregations,
         *        as well as the remaining aggregations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregations(DifferentialPrivacyPrivacyBudgetAggregation... aggregations);

        /**
         * <p>
         * This information includes the configured epsilon value and the utility in terms of total aggregations, as
         * well as the remaining aggregations.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cleanrooms.model.DifferentialPrivacyPrivacyBudgetAggregation.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.cleanrooms.model.DifferentialPrivacyPrivacyBudgetAggregation#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cleanrooms.model.DifferentialPrivacyPrivacyBudgetAggregation.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #aggregations(List<DifferentialPrivacyPrivacyBudgetAggregation>)}.
         * 
         * @param aggregations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cleanrooms.model.DifferentialPrivacyPrivacyBudgetAggregation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aggregations(java.util.Collection<DifferentialPrivacyPrivacyBudgetAggregation>)
         */
        Builder aggregations(Consumer<DifferentialPrivacyPrivacyBudgetAggregation.Builder>... aggregations);

        /**
         * <p>
         * The epsilon value that you configured.
         * </p>
         * 
         * @param epsilon
         *        The epsilon value that you configured.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder epsilon(Integer epsilon);
    }

    static final class BuilderImpl implements Builder {
        private List<DifferentialPrivacyPrivacyBudgetAggregation> aggregations = DefaultSdkAutoConstructList.getInstance();

        private Integer epsilon;

        private BuilderImpl() {
        }

        private BuilderImpl(DifferentialPrivacyPrivacyBudget model) {
            aggregations(model.aggregations);
            epsilon(model.epsilon);
        }

        public final List<DifferentialPrivacyPrivacyBudgetAggregation.Builder> getAggregations() {
            List<DifferentialPrivacyPrivacyBudgetAggregation.Builder> result = DifferentialPrivacyPrivacyBudgetAggregationListCopier
                    .copyToBuilder(this.aggregations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAggregations(Collection<DifferentialPrivacyPrivacyBudgetAggregation.BuilderImpl> aggregations) {
            this.aggregations = DifferentialPrivacyPrivacyBudgetAggregationListCopier.copyFromBuilder(aggregations);
        }

        @Override
        public final Builder aggregations(Collection<DifferentialPrivacyPrivacyBudgetAggregation> aggregations) {
            this.aggregations = DifferentialPrivacyPrivacyBudgetAggregationListCopier.copy(aggregations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregations(DifferentialPrivacyPrivacyBudgetAggregation... aggregations) {
            aggregations(Arrays.asList(aggregations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregations(Consumer<DifferentialPrivacyPrivacyBudgetAggregation.Builder>... aggregations) {
            aggregations(Stream.of(aggregations)
                    .map(c -> DifferentialPrivacyPrivacyBudgetAggregation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Integer getEpsilon() {
            return epsilon;
        }

        public final void setEpsilon(Integer epsilon) {
            this.epsilon = epsilon;
        }

        @Override
        public final Builder epsilon(Integer epsilon) {
            this.epsilon = epsilon;
            return this;
        }

        @Override
        public DifferentialPrivacyPrivacyBudget build() {
            return new DifferentialPrivacyPrivacyBudget(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
