/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The epsilon and noise parameter values that you want to update in the differential privacy template.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DifferentialPrivacyTemplateUpdateParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<DifferentialPrivacyTemplateUpdateParameters.Builder, DifferentialPrivacyTemplateUpdateParameters> {
    private static final SdkField<Integer> EPSILON_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("epsilon").getter(getter(DifferentialPrivacyTemplateUpdateParameters::epsilon))
            .setter(setter(Builder::epsilon))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("epsilon").build()).build();

    private static final SdkField<Integer> USERS_NOISE_PER_QUERY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("usersNoisePerQuery").getter(getter(DifferentialPrivacyTemplateUpdateParameters::usersNoisePerQuery))
            .setter(setter(Builder::usersNoisePerQuery))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usersNoisePerQuery").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EPSILON_FIELD,
            USERS_NOISE_PER_QUERY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer epsilon;

    private final Integer usersNoisePerQuery;

    private DifferentialPrivacyTemplateUpdateParameters(BuilderImpl builder) {
        this.epsilon = builder.epsilon;
        this.usersNoisePerQuery = builder.usersNoisePerQuery;
    }

    /**
     * <p>
     * The updated epsilon value that you want to use.
     * </p>
     * 
     * @return The updated epsilon value that you want to use.
     */
    public final Integer epsilon() {
        return epsilon;
    }

    /**
     * <p>
     * The updated value of noise added per query. It is measured in terms of the number of users whose contributions
     * you want to obscure. This value governs the rate at which the privacy budget is depleted.
     * </p>
     * 
     * @return The updated value of noise added per query. It is measured in terms of the number of users whose
     *         contributions you want to obscure. This value governs the rate at which the privacy budget is depleted.
     */
    public final Integer usersNoisePerQuery() {
        return usersNoisePerQuery;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(epsilon());
        hashCode = 31 * hashCode + Objects.hashCode(usersNoisePerQuery());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DifferentialPrivacyTemplateUpdateParameters)) {
            return false;
        }
        DifferentialPrivacyTemplateUpdateParameters other = (DifferentialPrivacyTemplateUpdateParameters) obj;
        return Objects.equals(epsilon(), other.epsilon()) && Objects.equals(usersNoisePerQuery(), other.usersNoisePerQuery());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DifferentialPrivacyTemplateUpdateParameters").add("Epsilon", epsilon())
                .add("UsersNoisePerQuery", usersNoisePerQuery()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "epsilon":
            return Optional.ofNullable(clazz.cast(epsilon()));
        case "usersNoisePerQuery":
            return Optional.ofNullable(clazz.cast(usersNoisePerQuery()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("epsilon", EPSILON_FIELD);
        map.put("usersNoisePerQuery", USERS_NOISE_PER_QUERY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DifferentialPrivacyTemplateUpdateParameters, T> g) {
        return obj -> g.apply((DifferentialPrivacyTemplateUpdateParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DifferentialPrivacyTemplateUpdateParameters> {
        /**
         * <p>
         * The updated epsilon value that you want to use.
         * </p>
         * 
         * @param epsilon
         *        The updated epsilon value that you want to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder epsilon(Integer epsilon);

        /**
         * <p>
         * The updated value of noise added per query. It is measured in terms of the number of users whose
         * contributions you want to obscure. This value governs the rate at which the privacy budget is depleted.
         * </p>
         * 
         * @param usersNoisePerQuery
         *        The updated value of noise added per query. It is measured in terms of the number of users whose
         *        contributions you want to obscure. This value governs the rate at which the privacy budget is
         *        depleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usersNoisePerQuery(Integer usersNoisePerQuery);
    }

    static final class BuilderImpl implements Builder {
        private Integer epsilon;

        private Integer usersNoisePerQuery;

        private BuilderImpl() {
        }

        private BuilderImpl(DifferentialPrivacyTemplateUpdateParameters model) {
            epsilon(model.epsilon);
            usersNoisePerQuery(model.usersNoisePerQuery);
        }

        public final Integer getEpsilon() {
            return epsilon;
        }

        public final void setEpsilon(Integer epsilon) {
            this.epsilon = epsilon;
        }

        @Override
        public final Builder epsilon(Integer epsilon) {
            this.epsilon = epsilon;
            return this;
        }

        public final Integer getUsersNoisePerQuery() {
            return usersNoisePerQuery;
        }

        public final void setUsersNoisePerQuery(Integer usersNoisePerQuery) {
            this.usersNoisePerQuery = usersNoisePerQuery;
        }

        @Override
        public final Builder usersNoisePerQuery(Integer usersNoisePerQuery) {
            this.usersNoisePerQuery = usersNoisePerQuery;
            return this;
        }

        @Override
        public DifferentialPrivacyTemplateUpdateParameters build() {
            return new DifferentialPrivacyTemplateUpdateParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
