/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetConfiguredTableResponse extends CleanRoomsResponse implements
        ToCopyableBuilder<GetConfiguredTableResponse.Builder, GetConfiguredTableResponse> {
    private static final SdkField<ConfiguredTable> CONFIGURED_TABLE_FIELD = SdkField
            .<ConfiguredTable> builder(MarshallingType.SDK_POJO).memberName("configuredTable")
            .getter(getter(GetConfiguredTableResponse::configuredTable)).setter(setter(Builder::configuredTable))
            .constructor(ConfiguredTable::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuredTable").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURED_TABLE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ConfiguredTable configuredTable;

    private GetConfiguredTableResponse(BuilderImpl builder) {
        super(builder);
        this.configuredTable = builder.configuredTable;
    }

    /**
     * <p>
     * The retrieved configured table.
     * </p>
     * 
     * @return The retrieved configured table.
     */
    public final ConfiguredTable configuredTable() {
        return configuredTable;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(configuredTable());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConfiguredTableResponse)) {
            return false;
        }
        GetConfiguredTableResponse other = (GetConfiguredTableResponse) obj;
        return Objects.equals(configuredTable(), other.configuredTable());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetConfiguredTableResponse").add("ConfiguredTable", configuredTable()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "configuredTable":
            return Optional.ofNullable(clazz.cast(configuredTable()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("configuredTable", CONFIGURED_TABLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetConfiguredTableResponse, T> g) {
        return obj -> g.apply((GetConfiguredTableResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CleanRoomsResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetConfiguredTableResponse> {
        /**
         * <p>
         * The retrieved configured table.
         * </p>
         * 
         * @param configuredTable
         *        The retrieved configured table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuredTable(ConfiguredTable configuredTable);

        /**
         * <p>
         * The retrieved configured table.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConfiguredTable.Builder} avoiding the
         * need to create one manually via {@link ConfiguredTable#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConfiguredTable.Builder#build()} is called immediately and its
         * result is passed to {@link #configuredTable(ConfiguredTable)}.
         * 
         * @param configuredTable
         *        a consumer that will call methods on {@link ConfiguredTable.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuredTable(ConfiguredTable)
         */
        default Builder configuredTable(Consumer<ConfiguredTable.Builder> configuredTable) {
            return configuredTable(ConfiguredTable.builder().applyMutation(configuredTable).build());
        }
    }

    static final class BuilderImpl extends CleanRoomsResponse.BuilderImpl implements Builder {
        private ConfiguredTable configuredTable;

        private BuilderImpl() {
        }

        private BuilderImpl(GetConfiguredTableResponse model) {
            super(model);
            configuredTable(model.configuredTable);
        }

        public final ConfiguredTable.Builder getConfiguredTable() {
            return configuredTable != null ? configuredTable.toBuilder() : null;
        }

        public final void setConfiguredTable(ConfiguredTable.BuilderImpl configuredTable) {
            this.configuredTable = configuredTable != null ? configuredTable.build() : null;
        }

        @Override
        public final Builder configuredTable(ConfiguredTable configuredTable) {
            this.configuredTable = configuredTable;
            return this;
        }

        @Override
        public GetConfiguredTableResponse build() {
            return new GetConfiguredTableResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
