/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration settings for the ID mapping table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IdMappingConfig implements SdkPojo, Serializable, ToCopyableBuilder<IdMappingConfig.Builder, IdMappingConfig> {
    private static final SdkField<Boolean> ALLOW_USE_AS_DIMENSION_COLUMN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("allowUseAsDimensionColumn")
            .getter(getter(IdMappingConfig::allowUseAsDimensionColumn)).setter(setter(Builder::allowUseAsDimensionColumn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowUseAsDimensionColumn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ALLOW_USE_AS_DIMENSION_COLUMN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean allowUseAsDimensionColumn;

    private IdMappingConfig(BuilderImpl builder) {
        this.allowUseAsDimensionColumn = builder.allowUseAsDimensionColumn;
    }

    /**
     * <p>
     * An indicator as to whether you can use your column as a dimension column in the ID mapping table (
     * <code>TRUE</code>) or not (<code>FALSE</code>).
     * </p>
     * <p>
     * Default is <code>FALSE</code>.
     * </p>
     * 
     * @return An indicator as to whether you can use your column as a dimension column in the ID mapping table (
     *         <code>TRUE</code>) or not (<code>FALSE</code>).</p>
     *         <p>
     *         Default is <code>FALSE</code>.
     */
    public final Boolean allowUseAsDimensionColumn() {
        return allowUseAsDimensionColumn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(allowUseAsDimensionColumn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdMappingConfig)) {
            return false;
        }
        IdMappingConfig other = (IdMappingConfig) obj;
        return Objects.equals(allowUseAsDimensionColumn(), other.allowUseAsDimensionColumn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IdMappingConfig").add("AllowUseAsDimensionColumn", allowUseAsDimensionColumn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "allowUseAsDimensionColumn":
            return Optional.ofNullable(clazz.cast(allowUseAsDimensionColumn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("allowUseAsDimensionColumn", ALLOW_USE_AS_DIMENSION_COLUMN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IdMappingConfig, T> g) {
        return obj -> g.apply((IdMappingConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IdMappingConfig> {
        /**
         * <p>
         * An indicator as to whether you can use your column as a dimension column in the ID mapping table (
         * <code>TRUE</code>) or not (<code>FALSE</code>).
         * </p>
         * <p>
         * Default is <code>FALSE</code>.
         * </p>
         * 
         * @param allowUseAsDimensionColumn
         *        An indicator as to whether you can use your column as a dimension column in the ID mapping table (
         *        <code>TRUE</code>) or not (<code>FALSE</code>).</p>
         *        <p>
         *        Default is <code>FALSE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowUseAsDimensionColumn(Boolean allowUseAsDimensionColumn);
    }

    static final class BuilderImpl implements Builder {
        private Boolean allowUseAsDimensionColumn;

        private BuilderImpl() {
        }

        private BuilderImpl(IdMappingConfig model) {
            allowUseAsDimensionColumn(model.allowUseAsDimensionColumn);
        }

        public final Boolean getAllowUseAsDimensionColumn() {
            return allowUseAsDimensionColumn;
        }

        public final void setAllowUseAsDimensionColumn(Boolean allowUseAsDimensionColumn) {
            this.allowUseAsDimensionColumn = allowUseAsDimensionColumn;
        }

        @Override
        public final Builder allowUseAsDimensionColumn(Boolean allowUseAsDimensionColumn) {
            this.allowUseAsDimensionColumn = allowUseAsDimensionColumn;
            return this;
        }

        @Override
        public IdMappingConfig build() {
            return new IdMappingConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
