/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Detailed information about the ID mapping table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IdMappingTableSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<IdMappingTableSummary.Builder, IdMappingTableSummary> {
    private static final SdkField<String> COLLABORATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("collaborationArn").getter(getter(IdMappingTableSummary::collaborationArn))
            .setter(setter(Builder::collaborationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationArn").build()).build();

    private static final SdkField<String> COLLABORATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("collaborationId").getter(getter(IdMappingTableSummary::collaborationId))
            .setter(setter(Builder::collaborationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationId").build()).build();

    private static final SdkField<String> MEMBERSHIP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("membershipId").getter(getter(IdMappingTableSummary::membershipId)).setter(setter(Builder::membershipId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipId").build()).build();

    private static final SdkField<String> MEMBERSHIP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("membershipArn").getter(getter(IdMappingTableSummary::membershipArn))
            .setter(setter(Builder::membershipArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipArn").build()).build();

    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createTime").getter(getter(IdMappingTableSummary::createTime)).setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build()).build();

    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updateTime").getter(getter(IdMappingTableSummary::updateTime)).setter(setter(Builder::updateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(IdMappingTableSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(IdMappingTableSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(IdMappingTableSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<IdMappingTableInputReferenceConfig> INPUT_REFERENCE_CONFIG_FIELD = SdkField
            .<IdMappingTableInputReferenceConfig> builder(MarshallingType.SDK_POJO).memberName("inputReferenceConfig")
            .getter(getter(IdMappingTableSummary::inputReferenceConfig)).setter(setter(Builder::inputReferenceConfig))
            .constructor(IdMappingTableInputReferenceConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputReferenceConfig").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(IdMappingTableSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLLABORATION_ARN_FIELD,
            COLLABORATION_ID_FIELD, MEMBERSHIP_ID_FIELD, MEMBERSHIP_ARN_FIELD, CREATE_TIME_FIELD, UPDATE_TIME_FIELD, ID_FIELD,
            ARN_FIELD, DESCRIPTION_FIELD, INPUT_REFERENCE_CONFIG_FIELD, NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String collaborationArn;

    private final String collaborationId;

    private final String membershipId;

    private final String membershipArn;

    private final Instant createTime;

    private final Instant updateTime;

    private final String id;

    private final String arn;

    private final String description;

    private final IdMappingTableInputReferenceConfig inputReferenceConfig;

    private final String name;

    private IdMappingTableSummary(BuilderImpl builder) {
        this.collaborationArn = builder.collaborationArn;
        this.collaborationId = builder.collaborationId;
        this.membershipId = builder.membershipId;
        this.membershipArn = builder.membershipArn;
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
        this.id = builder.id;
        this.arn = builder.arn;
        this.description = builder.description;
        this.inputReferenceConfig = builder.inputReferenceConfig;
        this.name = builder.name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the collaboration that contains this ID mapping table.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the collaboration that contains this ID mapping table.
     */
    public final String collaborationArn() {
        return collaborationArn;
    }

    /**
     * <p>
     * The unique identifier of the collaboration that contains this ID mapping table.
     * </p>
     * 
     * @return The unique identifier of the collaboration that contains this ID mapping table.
     */
    public final String collaborationId() {
        return collaborationId;
    }

    /**
     * <p>
     * The unique identifier of the membership resource for this ID mapping table.
     * </p>
     * 
     * @return The unique identifier of the membership resource for this ID mapping table.
     */
    public final String membershipId() {
        return membershipId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the membership resource for this ID mapping table.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the membership resource for this ID mapping table.
     */
    public final String membershipArn() {
        return membershipArn;
    }

    /**
     * <p>
     * The time at which this ID mapping table was created.
     * </p>
     * 
     * @return The time at which this ID mapping table was created.
     */
    public final Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * The most recent time at which this ID mapping table was updated.
     * </p>
     * 
     * @return The most recent time at which this ID mapping table was updated.
     */
    public final Instant updateTime() {
        return updateTime;
    }

    /**
     * <p>
     * The unique identifier of this ID mapping table.
     * </p>
     * 
     * @return The unique identifier of this ID mapping table.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of this ID mapping table.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of this ID mapping table.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The description of this ID mapping table.
     * </p>
     * 
     * @return The description of this ID mapping table.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The input reference configuration for the ID mapping table.
     * </p>
     * 
     * @return The input reference configuration for the ID mapping table.
     */
    public final IdMappingTableInputReferenceConfig inputReferenceConfig() {
        return inputReferenceConfig;
    }

    /**
     * <p>
     * The name of this ID mapping table.
     * </p>
     * 
     * @return The name of this ID mapping table.
     */
    public final String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(collaborationArn());
        hashCode = 31 * hashCode + Objects.hashCode(collaborationId());
        hashCode = 31 * hashCode + Objects.hashCode(membershipId());
        hashCode = 31 * hashCode + Objects.hashCode(membershipArn());
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(inputReferenceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdMappingTableSummary)) {
            return false;
        }
        IdMappingTableSummary other = (IdMappingTableSummary) obj;
        return Objects.equals(collaborationArn(), other.collaborationArn())
                && Objects.equals(collaborationId(), other.collaborationId())
                && Objects.equals(membershipId(), other.membershipId()) && Objects.equals(membershipArn(), other.membershipArn())
                && Objects.equals(createTime(), other.createTime()) && Objects.equals(updateTime(), other.updateTime())
                && Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn())
                && Objects.equals(description(), other.description())
                && Objects.equals(inputReferenceConfig(), other.inputReferenceConfig()) && Objects.equals(name(), other.name());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IdMappingTableSummary").add("CollaborationArn", collaborationArn())
                .add("CollaborationId", collaborationId()).add("MembershipId", membershipId())
                .add("MembershipArn", membershipArn()).add("CreateTime", createTime()).add("UpdateTime", updateTime())
                .add("Id", id()).add("Arn", arn()).add("Description", description())
                .add("InputReferenceConfig", inputReferenceConfig()).add("Name", name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "collaborationArn":
            return Optional.ofNullable(clazz.cast(collaborationArn()));
        case "collaborationId":
            return Optional.ofNullable(clazz.cast(collaborationId()));
        case "membershipId":
            return Optional.ofNullable(clazz.cast(membershipId()));
        case "membershipArn":
            return Optional.ofNullable(clazz.cast(membershipArn()));
        case "createTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "updateTime":
            return Optional.ofNullable(clazz.cast(updateTime()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "inputReferenceConfig":
            return Optional.ofNullable(clazz.cast(inputReferenceConfig()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("collaborationArn", COLLABORATION_ARN_FIELD);
        map.put("collaborationId", COLLABORATION_ID_FIELD);
        map.put("membershipId", MEMBERSHIP_ID_FIELD);
        map.put("membershipArn", MEMBERSHIP_ARN_FIELD);
        map.put("createTime", CREATE_TIME_FIELD);
        map.put("updateTime", UPDATE_TIME_FIELD);
        map.put("id", ID_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("inputReferenceConfig", INPUT_REFERENCE_CONFIG_FIELD);
        map.put("name", NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IdMappingTableSummary, T> g) {
        return obj -> g.apply((IdMappingTableSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IdMappingTableSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the collaboration that contains this ID mapping table.
         * </p>
         * 
         * @param collaborationArn
         *        The Amazon Resource Name (ARN) of the collaboration that contains this ID mapping table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaborationArn(String collaborationArn);

        /**
         * <p>
         * The unique identifier of the collaboration that contains this ID mapping table.
         * </p>
         * 
         * @param collaborationId
         *        The unique identifier of the collaboration that contains this ID mapping table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaborationId(String collaborationId);

        /**
         * <p>
         * The unique identifier of the membership resource for this ID mapping table.
         * </p>
         * 
         * @param membershipId
         *        The unique identifier of the membership resource for this ID mapping table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder membershipId(String membershipId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the membership resource for this ID mapping table.
         * </p>
         * 
         * @param membershipArn
         *        The Amazon Resource Name (ARN) of the membership resource for this ID mapping table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder membershipArn(String membershipArn);

        /**
         * <p>
         * The time at which this ID mapping table was created.
         * </p>
         * 
         * @param createTime
         *        The time at which this ID mapping table was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * The most recent time at which this ID mapping table was updated.
         * </p>
         * 
         * @param updateTime
         *        The most recent time at which this ID mapping table was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTime(Instant updateTime);

        /**
         * <p>
         * The unique identifier of this ID mapping table.
         * </p>
         * 
         * @param id
         *        The unique identifier of this ID mapping table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of this ID mapping table.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of this ID mapping table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The description of this ID mapping table.
         * </p>
         * 
         * @param description
         *        The description of this ID mapping table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The input reference configuration for the ID mapping table.
         * </p>
         * 
         * @param inputReferenceConfig
         *        The input reference configuration for the ID mapping table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputReferenceConfig(IdMappingTableInputReferenceConfig inputReferenceConfig);

        /**
         * <p>
         * The input reference configuration for the ID mapping table.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link IdMappingTableInputReferenceConfig.Builder} avoiding the need to create one manually via
         * {@link IdMappingTableInputReferenceConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IdMappingTableInputReferenceConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #inputReferenceConfig(IdMappingTableInputReferenceConfig)}.
         * 
         * @param inputReferenceConfig
         *        a consumer that will call methods on {@link IdMappingTableInputReferenceConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputReferenceConfig(IdMappingTableInputReferenceConfig)
         */
        default Builder inputReferenceConfig(Consumer<IdMappingTableInputReferenceConfig.Builder> inputReferenceConfig) {
            return inputReferenceConfig(IdMappingTableInputReferenceConfig.builder().applyMutation(inputReferenceConfig).build());
        }

        /**
         * <p>
         * The name of this ID mapping table.
         * </p>
         * 
         * @param name
         *        The name of this ID mapping table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);
    }

    static final class BuilderImpl implements Builder {
        private String collaborationArn;

        private String collaborationId;

        private String membershipId;

        private String membershipArn;

        private Instant createTime;

        private Instant updateTime;

        private String id;

        private String arn;

        private String description;

        private IdMappingTableInputReferenceConfig inputReferenceConfig;

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(IdMappingTableSummary model) {
            collaborationArn(model.collaborationArn);
            collaborationId(model.collaborationId);
            membershipId(model.membershipId);
            membershipArn(model.membershipArn);
            createTime(model.createTime);
            updateTime(model.updateTime);
            id(model.id);
            arn(model.arn);
            description(model.description);
            inputReferenceConfig(model.inputReferenceConfig);
            name(model.name);
        }

        public final String getCollaborationArn() {
            return collaborationArn;
        }

        public final void setCollaborationArn(String collaborationArn) {
            this.collaborationArn = collaborationArn;
        }

        @Override
        public final Builder collaborationArn(String collaborationArn) {
            this.collaborationArn = collaborationArn;
            return this;
        }

        public final String getCollaborationId() {
            return collaborationId;
        }

        public final void setCollaborationId(String collaborationId) {
            this.collaborationId = collaborationId;
        }

        @Override
        public final Builder collaborationId(String collaborationId) {
            this.collaborationId = collaborationId;
            return this;
        }

        public final String getMembershipId() {
            return membershipId;
        }

        public final void setMembershipId(String membershipId) {
            this.membershipId = membershipId;
        }

        @Override
        public final Builder membershipId(String membershipId) {
            this.membershipId = membershipId;
            return this;
        }

        public final String getMembershipArn() {
            return membershipArn;
        }

        public final void setMembershipArn(String membershipArn) {
            this.membershipArn = membershipArn;
        }

        @Override
        public final Builder membershipArn(String membershipArn) {
            this.membershipArn = membershipArn;
            return this;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final IdMappingTableInputReferenceConfig.Builder getInputReferenceConfig() {
            return inputReferenceConfig != null ? inputReferenceConfig.toBuilder() : null;
        }

        public final void setInputReferenceConfig(IdMappingTableInputReferenceConfig.BuilderImpl inputReferenceConfig) {
            this.inputReferenceConfig = inputReferenceConfig != null ? inputReferenceConfig.build() : null;
        }

        @Override
        public final Builder inputReferenceConfig(IdMappingTableInputReferenceConfig inputReferenceConfig) {
            this.inputReferenceConfig = inputReferenceConfig;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public IdMappingTableSummary build() {
            return new IdMappingTableSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
