/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the information for the ID namespace association input reference properties.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IdNamespaceAssociationInputReferenceProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<IdNamespaceAssociationInputReferenceProperties.Builder, IdNamespaceAssociationInputReferenceProperties> {
    private static final SdkField<String> ID_NAMESPACE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("idNamespaceType")
            .getter(getter(IdNamespaceAssociationInputReferenceProperties::idNamespaceTypeAsString))
            .setter(setter(Builder::idNamespaceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idNamespaceType").build()).build();

    private static final SdkField<List<Document>> ID_MAPPING_WORKFLOWS_SUPPORTED_FIELD = SdkField
            .<List<Document>> builder(MarshallingType.LIST)
            .memberName("idMappingWorkflowsSupported")
            .getter(getter(IdNamespaceAssociationInputReferenceProperties::idMappingWorkflowsSupported))
            .setter(setter(Builder::idMappingWorkflowsSupported))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idMappingWorkflowsSupported")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Document> builder(MarshallingType.DOCUMENT)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_NAMESPACE_TYPE_FIELD,
            ID_MAPPING_WORKFLOWS_SUPPORTED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String idNamespaceType;

    private final List<Document> idMappingWorkflowsSupported;

    private IdNamespaceAssociationInputReferenceProperties(BuilderImpl builder) {
        this.idNamespaceType = builder.idNamespaceType;
        this.idMappingWorkflowsSupported = builder.idMappingWorkflowsSupported;
    }

    /**
     * <p>
     * The ID namespace type for this ID namespace association.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #idNamespaceType}
     * will return {@link IdNamespaceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #idNamespaceTypeAsString}.
     * </p>
     * 
     * @return The ID namespace type for this ID namespace association.
     * @see IdNamespaceType
     */
    public final IdNamespaceType idNamespaceType() {
        return IdNamespaceType.fromValue(idNamespaceType);
    }

    /**
     * <p>
     * The ID namespace type for this ID namespace association.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #idNamespaceType}
     * will return {@link IdNamespaceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #idNamespaceTypeAsString}.
     * </p>
     * 
     * @return The ID namespace type for this ID namespace association.
     * @see IdNamespaceType
     */
    public final String idNamespaceTypeAsString() {
        return idNamespaceType;
    }

    /**
     * For responses, this returns true if the service returned a value for the IdMappingWorkflowsSupported property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasIdMappingWorkflowsSupported() {
        return idMappingWorkflowsSupported != null && !(idMappingWorkflowsSupported instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Defines how ID mapping workflows are supported for this ID namespace association.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIdMappingWorkflowsSupported} method.
     * </p>
     * 
     * @return Defines how ID mapping workflows are supported for this ID namespace association.
     */
    public final List<Document> idMappingWorkflowsSupported() {
        return idMappingWorkflowsSupported;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(idNamespaceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasIdMappingWorkflowsSupported() ? idMappingWorkflowsSupported() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdNamespaceAssociationInputReferenceProperties)) {
            return false;
        }
        IdNamespaceAssociationInputReferenceProperties other = (IdNamespaceAssociationInputReferenceProperties) obj;
        return Objects.equals(idNamespaceTypeAsString(), other.idNamespaceTypeAsString())
                && hasIdMappingWorkflowsSupported() == other.hasIdMappingWorkflowsSupported()
                && Objects.equals(idMappingWorkflowsSupported(), other.idMappingWorkflowsSupported());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IdNamespaceAssociationInputReferenceProperties")
                .add("IdNamespaceType", idNamespaceTypeAsString())
                .add("IdMappingWorkflowsSupported", hasIdMappingWorkflowsSupported() ? idMappingWorkflowsSupported() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "idNamespaceType":
            return Optional.ofNullable(clazz.cast(idNamespaceTypeAsString()));
        case "idMappingWorkflowsSupported":
            return Optional.ofNullable(clazz.cast(idMappingWorkflowsSupported()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("idNamespaceType", ID_NAMESPACE_TYPE_FIELD);
        map.put("idMappingWorkflowsSupported", ID_MAPPING_WORKFLOWS_SUPPORTED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IdNamespaceAssociationInputReferenceProperties, T> g) {
        return obj -> g.apply((IdNamespaceAssociationInputReferenceProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IdNamespaceAssociationInputReferenceProperties> {
        /**
         * <p>
         * The ID namespace type for this ID namespace association.
         * </p>
         * 
         * @param idNamespaceType
         *        The ID namespace type for this ID namespace association.
         * @see IdNamespaceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdNamespaceType
         */
        Builder idNamespaceType(String idNamespaceType);

        /**
         * <p>
         * The ID namespace type for this ID namespace association.
         * </p>
         * 
         * @param idNamespaceType
         *        The ID namespace type for this ID namespace association.
         * @see IdNamespaceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdNamespaceType
         */
        Builder idNamespaceType(IdNamespaceType idNamespaceType);

        /**
         * <p>
         * Defines how ID mapping workflows are supported for this ID namespace association.
         * </p>
         * 
         * @param idMappingWorkflowsSupported
         *        Defines how ID mapping workflows are supported for this ID namespace association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idMappingWorkflowsSupported(Collection<Document> idMappingWorkflowsSupported);

        /**
         * <p>
         * Defines how ID mapping workflows are supported for this ID namespace association.
         * </p>
         * 
         * @param idMappingWorkflowsSupported
         *        Defines how ID mapping workflows are supported for this ID namespace association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idMappingWorkflowsSupported(Document... idMappingWorkflowsSupported);
    }

    static final class BuilderImpl implements Builder {
        private String idNamespaceType;

        private List<Document> idMappingWorkflowsSupported = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(IdNamespaceAssociationInputReferenceProperties model) {
            idNamespaceType(model.idNamespaceType);
            idMappingWorkflowsSupported(model.idMappingWorkflowsSupported);
        }

        public final String getIdNamespaceType() {
            return idNamespaceType;
        }

        public final void setIdNamespaceType(String idNamespaceType) {
            this.idNamespaceType = idNamespaceType;
        }

        @Override
        public final Builder idNamespaceType(String idNamespaceType) {
            this.idNamespaceType = idNamespaceType;
            return this;
        }

        @Override
        public final Builder idNamespaceType(IdNamespaceType idNamespaceType) {
            this.idNamespaceType(idNamespaceType == null ? null : idNamespaceType.toString());
            return this;
        }

        public final Collection<Document> getIdMappingWorkflowsSupported() {
            if (idMappingWorkflowsSupported instanceof SdkAutoConstructList) {
                return null;
            }
            return idMappingWorkflowsSupported;
        }

        public final void setIdMappingWorkflowsSupported(Collection<Document> idMappingWorkflowsSupported) {
            this.idMappingWorkflowsSupported = IdMappingWorkflowsSupportedCopier.copy(idMappingWorkflowsSupported);
        }

        @Override
        public final Builder idMappingWorkflowsSupported(Collection<Document> idMappingWorkflowsSupported) {
            this.idMappingWorkflowsSupported = IdMappingWorkflowsSupportedCopier.copy(idMappingWorkflowsSupported);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder idMappingWorkflowsSupported(Document... idMappingWorkflowsSupported) {
            idMappingWorkflowsSupported(Arrays.asList(idMappingWorkflowsSupported));
            return this;
        }

        @Override
        public IdNamespaceAssociationInputReferenceProperties build() {
            return new IdNamespaceAssociationInputReferenceProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
