/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCollaborationAnalysisTemplatesResponse extends CleanRoomsResponse implements
        ToCopyableBuilder<ListCollaborationAnalysisTemplatesResponse.Builder, ListCollaborationAnalysisTemplatesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListCollaborationAnalysisTemplatesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<CollaborationAnalysisTemplateSummary>> COLLABORATION_ANALYSIS_TEMPLATE_SUMMARIES_FIELD = SdkField
            .<List<CollaborationAnalysisTemplateSummary>> builder(MarshallingType.LIST)
            .memberName("collaborationAnalysisTemplateSummaries")
            .getter(getter(ListCollaborationAnalysisTemplatesResponse::collaborationAnalysisTemplateSummaries))
            .setter(setter(Builder::collaborationAnalysisTemplateSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("collaborationAnalysisTemplateSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CollaborationAnalysisTemplateSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(CollaborationAnalysisTemplateSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            COLLABORATION_ANALYSIS_TEMPLATE_SUMMARIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<CollaborationAnalysisTemplateSummary> collaborationAnalysisTemplateSummaries;

    private ListCollaborationAnalysisTemplatesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.collaborationAnalysisTemplateSummaries = builder.collaborationAnalysisTemplateSummaries;
    }

    /**
     * <p>
     * The pagination token that's used to fetch the next set of results.
     * </p>
     * 
     * @return The pagination token that's used to fetch the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the CollaborationAnalysisTemplateSummaries
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasCollaborationAnalysisTemplateSummaries() {
        return collaborationAnalysisTemplateSummaries != null
                && !(collaborationAnalysisTemplateSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The metadata of the analysis template within a collaboration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCollaborationAnalysisTemplateSummaries}
     * method.
     * </p>
     * 
     * @return The metadata of the analysis template within a collaboration.
     */
    public final List<CollaborationAnalysisTemplateSummary> collaborationAnalysisTemplateSummaries() {
        return collaborationAnalysisTemplateSummaries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasCollaborationAnalysisTemplateSummaries() ? collaborationAnalysisTemplateSummaries() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCollaborationAnalysisTemplatesResponse)) {
            return false;
        }
        ListCollaborationAnalysisTemplatesResponse other = (ListCollaborationAnalysisTemplatesResponse) obj;
        return Objects.equals(nextToken(), other.nextToken())
                && hasCollaborationAnalysisTemplateSummaries() == other.hasCollaborationAnalysisTemplateSummaries()
                && Objects.equals(collaborationAnalysisTemplateSummaries(), other.collaborationAnalysisTemplateSummaries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ListCollaborationAnalysisTemplatesResponse")
                .add("NextToken", nextToken())
                .add("CollaborationAnalysisTemplateSummaries",
                        hasCollaborationAnalysisTemplateSummaries() ? collaborationAnalysisTemplateSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "collaborationAnalysisTemplateSummaries":
            return Optional.ofNullable(clazz.cast(collaborationAnalysisTemplateSummaries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("collaborationAnalysisTemplateSummaries", COLLABORATION_ANALYSIS_TEMPLATE_SUMMARIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCollaborationAnalysisTemplatesResponse, T> g) {
        return obj -> g.apply((ListCollaborationAnalysisTemplatesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CleanRoomsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListCollaborationAnalysisTemplatesResponse> {
        /**
         * <p>
         * The pagination token that's used to fetch the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The pagination token that's used to fetch the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The metadata of the analysis template within a collaboration.
         * </p>
         * 
         * @param collaborationAnalysisTemplateSummaries
         *        The metadata of the analysis template within a collaboration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaborationAnalysisTemplateSummaries(
                Collection<CollaborationAnalysisTemplateSummary> collaborationAnalysisTemplateSummaries);

        /**
         * <p>
         * The metadata of the analysis template within a collaboration.
         * </p>
         * 
         * @param collaborationAnalysisTemplateSummaries
         *        The metadata of the analysis template within a collaboration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaborationAnalysisTemplateSummaries(
                CollaborationAnalysisTemplateSummary... collaborationAnalysisTemplateSummaries);

        /**
         * <p>
         * The metadata of the analysis template within a collaboration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cleanrooms.model.CollaborationAnalysisTemplateSummary.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.cleanrooms.model.CollaborationAnalysisTemplateSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cleanrooms.model.CollaborationAnalysisTemplateSummary.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #collaborationAnalysisTemplateSummaries(List<CollaborationAnalysisTemplateSummary>)}.
         * 
         * @param collaborationAnalysisTemplateSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cleanrooms.model.CollaborationAnalysisTemplateSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #collaborationAnalysisTemplateSummaries(java.util.Collection<CollaborationAnalysisTemplateSummary>)
         */
        Builder collaborationAnalysisTemplateSummaries(
                Consumer<CollaborationAnalysisTemplateSummary.Builder>... collaborationAnalysisTemplateSummaries);
    }

    static final class BuilderImpl extends CleanRoomsResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<CollaborationAnalysisTemplateSummary> collaborationAnalysisTemplateSummaries = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListCollaborationAnalysisTemplatesResponse model) {
            super(model);
            nextToken(model.nextToken);
            collaborationAnalysisTemplateSummaries(model.collaborationAnalysisTemplateSummaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<CollaborationAnalysisTemplateSummary.Builder> getCollaborationAnalysisTemplateSummaries() {
            List<CollaborationAnalysisTemplateSummary.Builder> result = CollaborationAnalysisTemplateSummaryListCopier
                    .copyToBuilder(this.collaborationAnalysisTemplateSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCollaborationAnalysisTemplateSummaries(
                Collection<CollaborationAnalysisTemplateSummary.BuilderImpl> collaborationAnalysisTemplateSummaries) {
            this.collaborationAnalysisTemplateSummaries = CollaborationAnalysisTemplateSummaryListCopier
                    .copyFromBuilder(collaborationAnalysisTemplateSummaries);
        }

        @Override
        public final Builder collaborationAnalysisTemplateSummaries(
                Collection<CollaborationAnalysisTemplateSummary> collaborationAnalysisTemplateSummaries) {
            this.collaborationAnalysisTemplateSummaries = CollaborationAnalysisTemplateSummaryListCopier
                    .copy(collaborationAnalysisTemplateSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder collaborationAnalysisTemplateSummaries(
                CollaborationAnalysisTemplateSummary... collaborationAnalysisTemplateSummaries) {
            collaborationAnalysisTemplateSummaries(Arrays.asList(collaborationAnalysisTemplateSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder collaborationAnalysisTemplateSummaries(
                Consumer<CollaborationAnalysisTemplateSummary.Builder>... collaborationAnalysisTemplateSummaries) {
            collaborationAnalysisTemplateSummaries(Stream.of(collaborationAnalysisTemplateSummaries)
                    .map(c -> CollaborationAnalysisTemplateSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListCollaborationAnalysisTemplatesResponse build() {
            return new ListCollaborationAnalysisTemplatesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
