/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCollaborationIdNamespaceAssociationsResponse extends CleanRoomsResponse
        implements
        ToCopyableBuilder<ListCollaborationIdNamespaceAssociationsResponse.Builder, ListCollaborationIdNamespaceAssociationsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListCollaborationIdNamespaceAssociationsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<CollaborationIdNamespaceAssociationSummary>> COLLABORATION_ID_NAMESPACE_ASSOCIATION_SUMMARIES_FIELD = SdkField
            .<List<CollaborationIdNamespaceAssociationSummary>> builder(MarshallingType.LIST)
            .memberName("collaborationIdNamespaceAssociationSummaries")
            .getter(getter(ListCollaborationIdNamespaceAssociationsResponse::collaborationIdNamespaceAssociationSummaries))
            .setter(setter(Builder::collaborationIdNamespaceAssociationSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("collaborationIdNamespaceAssociationSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CollaborationIdNamespaceAssociationSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(CollaborationIdNamespaceAssociationSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            COLLABORATION_ID_NAMESPACE_ASSOCIATION_SUMMARIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<CollaborationIdNamespaceAssociationSummary> collaborationIdNamespaceAssociationSummaries;

    private ListCollaborationIdNamespaceAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.collaborationIdNamespaceAssociationSummaries = builder.collaborationIdNamespaceAssociationSummaries;
    }

    /**
     * <p>
     * The token value provided to access the next page of results.
     * </p>
     * 
     * @return The token value provided to access the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the
     * CollaborationIdNamespaceAssociationSummaries property. This DOES NOT check that the value is non-empty (for
     * which, you should check the {@code isEmpty()} method on the property). This is useful because the SDK will never
     * return a null collection or map, but you may need to differentiate between the service returning nothing (or
     * null) and the service returning an empty collection or map. For requests, this returns true if a value for the
     * property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasCollaborationIdNamespaceAssociationSummaries() {
        return collaborationIdNamespaceAssociationSummaries != null
                && !(collaborationIdNamespaceAssociationSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The summary information of the collaboration ID namespace associations that you requested.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the
     * {@link #hasCollaborationIdNamespaceAssociationSummaries} method.
     * </p>
     * 
     * @return The summary information of the collaboration ID namespace associations that you requested.
     */
    public final List<CollaborationIdNamespaceAssociationSummary> collaborationIdNamespaceAssociationSummaries() {
        return collaborationIdNamespaceAssociationSummaries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31
                * hashCode
                + Objects
                        .hashCode(hasCollaborationIdNamespaceAssociationSummaries() ? collaborationIdNamespaceAssociationSummaries()
                                : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCollaborationIdNamespaceAssociationsResponse)) {
            return false;
        }
        ListCollaborationIdNamespaceAssociationsResponse other = (ListCollaborationIdNamespaceAssociationsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken())
                && hasCollaborationIdNamespaceAssociationSummaries() == other.hasCollaborationIdNamespaceAssociationSummaries()
                && Objects.equals(collaborationIdNamespaceAssociationSummaries(),
                        other.collaborationIdNamespaceAssociationSummaries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ListCollaborationIdNamespaceAssociationsResponse")
                .add("NextToken", nextToken())
                .add("CollaborationIdNamespaceAssociationSummaries",
                        hasCollaborationIdNamespaceAssociationSummaries() ? collaborationIdNamespaceAssociationSummaries() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "collaborationIdNamespaceAssociationSummaries":
            return Optional.ofNullable(clazz.cast(collaborationIdNamespaceAssociationSummaries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("collaborationIdNamespaceAssociationSummaries", COLLABORATION_ID_NAMESPACE_ASSOCIATION_SUMMARIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCollaborationIdNamespaceAssociationsResponse, T> g) {
        return obj -> g.apply((ListCollaborationIdNamespaceAssociationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CleanRoomsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListCollaborationIdNamespaceAssociationsResponse> {
        /**
         * <p>
         * The token value provided to access the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token value provided to access the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The summary information of the collaboration ID namespace associations that you requested.
         * </p>
         * 
         * @param collaborationIdNamespaceAssociationSummaries
         *        The summary information of the collaboration ID namespace associations that you requested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaborationIdNamespaceAssociationSummaries(
                Collection<CollaborationIdNamespaceAssociationSummary> collaborationIdNamespaceAssociationSummaries);

        /**
         * <p>
         * The summary information of the collaboration ID namespace associations that you requested.
         * </p>
         * 
         * @param collaborationIdNamespaceAssociationSummaries
         *        The summary information of the collaboration ID namespace associations that you requested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaborationIdNamespaceAssociationSummaries(
                CollaborationIdNamespaceAssociationSummary... collaborationIdNamespaceAssociationSummaries);

        /**
         * <p>
         * The summary information of the collaboration ID namespace associations that you requested.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cleanrooms.model.CollaborationIdNamespaceAssociationSummary.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.cleanrooms.model.CollaborationIdNamespaceAssociationSummary#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cleanrooms.model.CollaborationIdNamespaceAssociationSummary.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #collaborationIdNamespaceAssociationSummaries(List<CollaborationIdNamespaceAssociationSummary>)}.
         * 
         * @param collaborationIdNamespaceAssociationSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cleanrooms.model.CollaborationIdNamespaceAssociationSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #collaborationIdNamespaceAssociationSummaries(java.util.Collection<
         *      CollaborationIdNamespaceAssociationSummary>)
         */
        Builder collaborationIdNamespaceAssociationSummaries(
                Consumer<CollaborationIdNamespaceAssociationSummary.Builder>... collaborationIdNamespaceAssociationSummaries);
    }

    static final class BuilderImpl extends CleanRoomsResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<CollaborationIdNamespaceAssociationSummary> collaborationIdNamespaceAssociationSummaries = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListCollaborationIdNamespaceAssociationsResponse model) {
            super(model);
            nextToken(model.nextToken);
            collaborationIdNamespaceAssociationSummaries(model.collaborationIdNamespaceAssociationSummaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<CollaborationIdNamespaceAssociationSummary.Builder> getCollaborationIdNamespaceAssociationSummaries() {
            List<CollaborationIdNamespaceAssociationSummary.Builder> result = CollaborationIdNamespaceAssociationSummaryListCopier
                    .copyToBuilder(this.collaborationIdNamespaceAssociationSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCollaborationIdNamespaceAssociationSummaries(
                Collection<CollaborationIdNamespaceAssociationSummary.BuilderImpl> collaborationIdNamespaceAssociationSummaries) {
            this.collaborationIdNamespaceAssociationSummaries = CollaborationIdNamespaceAssociationSummaryListCopier
                    .copyFromBuilder(collaborationIdNamespaceAssociationSummaries);
        }

        @Override
        public final Builder collaborationIdNamespaceAssociationSummaries(
                Collection<CollaborationIdNamespaceAssociationSummary> collaborationIdNamespaceAssociationSummaries) {
            this.collaborationIdNamespaceAssociationSummaries = CollaborationIdNamespaceAssociationSummaryListCopier
                    .copy(collaborationIdNamespaceAssociationSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder collaborationIdNamespaceAssociationSummaries(
                CollaborationIdNamespaceAssociationSummary... collaborationIdNamespaceAssociationSummaries) {
            collaborationIdNamespaceAssociationSummaries(Arrays.asList(collaborationIdNamespaceAssociationSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder collaborationIdNamespaceAssociationSummaries(
                Consumer<CollaborationIdNamespaceAssociationSummary.Builder>... collaborationIdNamespaceAssociationSummaries) {
            collaborationIdNamespaceAssociationSummaries(Stream.of(collaborationIdNamespaceAssociationSummaries)
                    .map(c -> CollaborationIdNamespaceAssociationSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListCollaborationIdNamespaceAssociationsResponse build() {
            return new ListCollaborationIdNamespaceAssociationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
