/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListConfiguredAudienceModelAssociationsResponse extends CleanRoomsResponse
        implements
        ToCopyableBuilder<ListConfiguredAudienceModelAssociationsResponse.Builder, ListConfiguredAudienceModelAssociationsResponse> {
    private static final SdkField<List<ConfiguredAudienceModelAssociationSummary>> CONFIGURED_AUDIENCE_MODEL_ASSOCIATION_SUMMARIES_FIELD = SdkField
            .<List<ConfiguredAudienceModelAssociationSummary>> builder(MarshallingType.LIST)
            .memberName("configuredAudienceModelAssociationSummaries")
            .getter(getter(ListConfiguredAudienceModelAssociationsResponse::configuredAudienceModelAssociationSummaries))
            .setter(setter(Builder::configuredAudienceModelAssociationSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("configuredAudienceModelAssociationSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConfiguredAudienceModelAssociationSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConfiguredAudienceModelAssociationSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListConfiguredAudienceModelAssociationsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CONFIGURED_AUDIENCE_MODEL_ASSOCIATION_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ConfiguredAudienceModelAssociationSummary> configuredAudienceModelAssociationSummaries;

    private final String nextToken;

    private ListConfiguredAudienceModelAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.configuredAudienceModelAssociationSummaries = builder.configuredAudienceModelAssociationSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the
     * ConfiguredAudienceModelAssociationSummaries property. This DOES NOT check that the value is non-empty (for which,
     * you should check the {@code isEmpty()} method on the property). This is useful because the SDK will never return
     * a null collection or map, but you may need to differentiate between the service returning nothing (or null) and
     * the service returning an empty collection or map. For requests, this returns true if a value for the property was
     * specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasConfiguredAudienceModelAssociationSummaries() {
        return configuredAudienceModelAssociationSummaries != null
                && !(configuredAudienceModelAssociationSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Summaries of the configured audience model associations that you requested.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the
     * {@link #hasConfiguredAudienceModelAssociationSummaries} method.
     * </p>
     * 
     * @return Summaries of the configured audience model associations that you requested.
     */
    public final List<ConfiguredAudienceModelAssociationSummary> configuredAudienceModelAssociationSummaries() {
        return configuredAudienceModelAssociationSummaries;
    }

    /**
     * <p>
     * The token value provided to access the next page of results.
     * </p>
     * 
     * @return The token value provided to access the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31
                * hashCode
                + Objects
                        .hashCode(hasConfiguredAudienceModelAssociationSummaries() ? configuredAudienceModelAssociationSummaries()
                                : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConfiguredAudienceModelAssociationsResponse)) {
            return false;
        }
        ListConfiguredAudienceModelAssociationsResponse other = (ListConfiguredAudienceModelAssociationsResponse) obj;
        return hasConfiguredAudienceModelAssociationSummaries() == other.hasConfiguredAudienceModelAssociationSummaries()
                && Objects.equals(configuredAudienceModelAssociationSummaries(),
                        other.configuredAudienceModelAssociationSummaries()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ListConfiguredAudienceModelAssociationsResponse")
                .add("ConfiguredAudienceModelAssociationSummaries",
                        hasConfiguredAudienceModelAssociationSummaries() ? configuredAudienceModelAssociationSummaries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "configuredAudienceModelAssociationSummaries":
            return Optional.ofNullable(clazz.cast(configuredAudienceModelAssociationSummaries()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("configuredAudienceModelAssociationSummaries", CONFIGURED_AUDIENCE_MODEL_ASSOCIATION_SUMMARIES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListConfiguredAudienceModelAssociationsResponse, T> g) {
        return obj -> g.apply((ListConfiguredAudienceModelAssociationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CleanRoomsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListConfiguredAudienceModelAssociationsResponse> {
        /**
         * <p>
         * Summaries of the configured audience model associations that you requested.
         * </p>
         * 
         * @param configuredAudienceModelAssociationSummaries
         *        Summaries of the configured audience model associations that you requested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuredAudienceModelAssociationSummaries(
                Collection<ConfiguredAudienceModelAssociationSummary> configuredAudienceModelAssociationSummaries);

        /**
         * <p>
         * Summaries of the configured audience model associations that you requested.
         * </p>
         * 
         * @param configuredAudienceModelAssociationSummaries
         *        Summaries of the configured audience model associations that you requested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuredAudienceModelAssociationSummaries(
                ConfiguredAudienceModelAssociationSummary... configuredAudienceModelAssociationSummaries);

        /**
         * <p>
         * Summaries of the configured audience model associations that you requested.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cleanrooms.model.ConfiguredAudienceModelAssociationSummary.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.cleanrooms.model.ConfiguredAudienceModelAssociationSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cleanrooms.model.ConfiguredAudienceModelAssociationSummary.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #configuredAudienceModelAssociationSummaries(List<ConfiguredAudienceModelAssociationSummary>)}.
         * 
         * @param configuredAudienceModelAssociationSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cleanrooms.model.ConfiguredAudienceModelAssociationSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see 
         *      #configuredAudienceModelAssociationSummaries(java.util.Collection<ConfiguredAudienceModelAssociationSummary
         *      >)
         */
        Builder configuredAudienceModelAssociationSummaries(
                Consumer<ConfiguredAudienceModelAssociationSummary.Builder>... configuredAudienceModelAssociationSummaries);

        /**
         * <p>
         * The token value provided to access the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token value provided to access the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CleanRoomsResponse.BuilderImpl implements Builder {
        private List<ConfiguredAudienceModelAssociationSummary> configuredAudienceModelAssociationSummaries = DefaultSdkAutoConstructList
                .getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListConfiguredAudienceModelAssociationsResponse model) {
            super(model);
            configuredAudienceModelAssociationSummaries(model.configuredAudienceModelAssociationSummaries);
            nextToken(model.nextToken);
        }

        public final List<ConfiguredAudienceModelAssociationSummary.Builder> getConfiguredAudienceModelAssociationSummaries() {
            List<ConfiguredAudienceModelAssociationSummary.Builder> result = ConfiguredAudienceModelAssociationSummaryListCopier
                    .copyToBuilder(this.configuredAudienceModelAssociationSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConfiguredAudienceModelAssociationSummaries(
                Collection<ConfiguredAudienceModelAssociationSummary.BuilderImpl> configuredAudienceModelAssociationSummaries) {
            this.configuredAudienceModelAssociationSummaries = ConfiguredAudienceModelAssociationSummaryListCopier
                    .copyFromBuilder(configuredAudienceModelAssociationSummaries);
        }

        @Override
        public final Builder configuredAudienceModelAssociationSummaries(
                Collection<ConfiguredAudienceModelAssociationSummary> configuredAudienceModelAssociationSummaries) {
            this.configuredAudienceModelAssociationSummaries = ConfiguredAudienceModelAssociationSummaryListCopier
                    .copy(configuredAudienceModelAssociationSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configuredAudienceModelAssociationSummaries(
                ConfiguredAudienceModelAssociationSummary... configuredAudienceModelAssociationSummaries) {
            configuredAudienceModelAssociationSummaries(Arrays.asList(configuredAudienceModelAssociationSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configuredAudienceModelAssociationSummaries(
                Consumer<ConfiguredAudienceModelAssociationSummary.Builder>... configuredAudienceModelAssociationSummaries) {
            configuredAudienceModelAssociationSummaries(Stream.of(configuredAudienceModelAssociationSummaries)
                    .map(c -> ConfiguredAudienceModelAssociationSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListConfiguredAudienceModelAssociationsResponse build() {
            return new ListConfiguredAudienceModelAssociationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
