/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSchemasRequest extends CleanRoomsRequest implements
        ToCopyableBuilder<ListSchemasRequest.Builder, ListSchemasRequest> {
    private static final SdkField<String> COLLABORATION_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("collaborationIdentifier").getter(getter(ListSchemasRequest::collaborationIdentifier))
            .setter(setter(Builder::collaborationIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("collaborationIdentifier").build())
            .build();

    private static final SdkField<String> SCHEMA_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("schemaType").getter(getter(ListSchemasRequest::schemaTypeAsString)).setter(setter(Builder::schemaType))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("schemaType").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListSchemasRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListSchemasRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            COLLABORATION_IDENTIFIER_FIELD, SCHEMA_TYPE_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String collaborationIdentifier;

    private final String schemaType;

    private final String nextToken;

    private final Integer maxResults;

    private ListSchemasRequest(BuilderImpl builder) {
        super(builder);
        this.collaborationIdentifier = builder.collaborationIdentifier;
        this.schemaType = builder.schemaType;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * A unique identifier for the collaboration that the schema belongs to. Currently accepts a collaboration ID.
     * </p>
     * 
     * @return A unique identifier for the collaboration that the schema belongs to. Currently accepts a collaboration
     *         ID.
     */
    public final String collaborationIdentifier() {
        return collaborationIdentifier;
    }

    /**
     * <p>
     * If present, filter schemas by schema type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #schemaType} will
     * return {@link SchemaType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #schemaTypeAsString}.
     * </p>
     * 
     * @return If present, filter schemas by schema type.
     * @see SchemaType
     */
    public final SchemaType schemaType() {
        return SchemaType.fromValue(schemaType);
    }

    /**
     * <p>
     * If present, filter schemas by schema type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #schemaType} will
     * return {@link SchemaType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #schemaTypeAsString}.
     * </p>
     * 
     * @return If present, filter schemas by schema type.
     * @see SchemaType
     */
    public final String schemaTypeAsString() {
        return schemaType;
    }

    /**
     * <p>
     * The pagination token that's used to fetch the next set of results.
     * </p>
     * 
     * @return The pagination token that's used to fetch the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results that are returned for an API request call. The service chooses a default number if
     * you don't set one. The service might return a `nextToken` even if the `maxResults` value has not been met.
     * </p>
     * 
     * @return The maximum number of results that are returned for an API request call. The service chooses a default
     *         number if you don't set one. The service might return a `nextToken` even if the `maxResults` value has
     *         not been met.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(collaborationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(schemaTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSchemasRequest)) {
            return false;
        }
        ListSchemasRequest other = (ListSchemasRequest) obj;
        return Objects.equals(collaborationIdentifier(), other.collaborationIdentifier())
                && Objects.equals(schemaTypeAsString(), other.schemaTypeAsString())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSchemasRequest").add("CollaborationIdentifier", collaborationIdentifier())
                .add("SchemaType", schemaTypeAsString()).add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "collaborationIdentifier":
            return Optional.ofNullable(clazz.cast(collaborationIdentifier()));
        case "schemaType":
            return Optional.ofNullable(clazz.cast(schemaTypeAsString()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("collaborationIdentifier", COLLABORATION_IDENTIFIER_FIELD);
        map.put("schemaType", SCHEMA_TYPE_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSchemasRequest, T> g) {
        return obj -> g.apply((ListSchemasRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CleanRoomsRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListSchemasRequest> {
        /**
         * <p>
         * A unique identifier for the collaboration that the schema belongs to. Currently accepts a collaboration ID.
         * </p>
         * 
         * @param collaborationIdentifier
         *        A unique identifier for the collaboration that the schema belongs to. Currently accepts a
         *        collaboration ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaborationIdentifier(String collaborationIdentifier);

        /**
         * <p>
         * If present, filter schemas by schema type.
         * </p>
         * 
         * @param schemaType
         *        If present, filter schemas by schema type.
         * @see SchemaType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SchemaType
         */
        Builder schemaType(String schemaType);

        /**
         * <p>
         * If present, filter schemas by schema type.
         * </p>
         * 
         * @param schemaType
         *        If present, filter schemas by schema type.
         * @see SchemaType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SchemaType
         */
        Builder schemaType(SchemaType schemaType);

        /**
         * <p>
         * The pagination token that's used to fetch the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The pagination token that's used to fetch the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results that are returned for an API request call. The service chooses a default number
         * if you don't set one. The service might return a `nextToken` even if the `maxResults` value has not been met.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results that are returned for an API request call. The service chooses a default
         *        number if you don't set one. The service might return a `nextToken` even if the `maxResults` value has
         *        not been met.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CleanRoomsRequest.BuilderImpl implements Builder {
        private String collaborationIdentifier;

        private String schemaType;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSchemasRequest model) {
            super(model);
            collaborationIdentifier(model.collaborationIdentifier);
            schemaType(model.schemaType);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getCollaborationIdentifier() {
            return collaborationIdentifier;
        }

        public final void setCollaborationIdentifier(String collaborationIdentifier) {
            this.collaborationIdentifier = collaborationIdentifier;
        }

        @Override
        public final Builder collaborationIdentifier(String collaborationIdentifier) {
            this.collaborationIdentifier = collaborationIdentifier;
            return this;
        }

        public final String getSchemaType() {
            return schemaType;
        }

        public final void setSchemaType(String schemaType) {
            this.schemaType = schemaType;
        }

        @Override
        public final Builder schemaType(String schemaType) {
            this.schemaType = schemaType;
            return this;
        }

        @Override
        public final Builder schemaType(SchemaType schemaType) {
            this.schemaType(schemaType == null ? null : schemaType.toString());
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListSchemasRequest build() {
            return new ListSchemasRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
