/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Basic metadata used to construct a new member.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MemberSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<MemberSpecification.Builder, MemberSpecification> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountId").getter(getter(MemberSpecification::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()).build();

    private static final SdkField<List<String>> MEMBER_ABILITIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("memberAbilities")
            .getter(getter(MemberSpecification::memberAbilitiesAsStrings))
            .setter(setter(Builder::memberAbilitiesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memberAbilities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<MLMemberAbilities> ML_MEMBER_ABILITIES_FIELD = SdkField
            .<MLMemberAbilities> builder(MarshallingType.SDK_POJO).memberName("mlMemberAbilities")
            .getter(getter(MemberSpecification::mlMemberAbilities)).setter(setter(Builder::mlMemberAbilities))
            .constructor(MLMemberAbilities::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mlMemberAbilities").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(MemberSpecification::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<PaymentConfiguration> PAYMENT_CONFIGURATION_FIELD = SdkField
            .<PaymentConfiguration> builder(MarshallingType.SDK_POJO).memberName("paymentConfiguration")
            .getter(getter(MemberSpecification::paymentConfiguration)).setter(setter(Builder::paymentConfiguration))
            .constructor(PaymentConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("paymentConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            MEMBER_ABILITIES_FIELD, ML_MEMBER_ABILITIES_FIELD, DISPLAY_NAME_FIELD, PAYMENT_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String accountId;

    private final List<String> memberAbilities;

    private final MLMemberAbilities mlMemberAbilities;

    private final String displayName;

    private final PaymentConfiguration paymentConfiguration;

    private MemberSpecification(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.memberAbilities = builder.memberAbilities;
        this.mlMemberAbilities = builder.mlMemberAbilities;
        this.displayName = builder.displayName;
        this.paymentConfiguration = builder.paymentConfiguration;
    }

    /**
     * <p>
     * The identifier used to reference members of the collaboration. Currently only supports Amazon Web Services
     * account ID.
     * </p>
     * 
     * @return The identifier used to reference members of the collaboration. Currently only supports Amazon Web
     *         Services account ID.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The abilities granted to the collaboration member.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMemberAbilities} method.
     * </p>
     * 
     * @return The abilities granted to the collaboration member.
     */
    public final List<MemberAbility> memberAbilities() {
        return MemberAbilitiesCopier.copyStringToEnum(memberAbilities);
    }

    /**
     * For responses, this returns true if the service returned a value for the MemberAbilities property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMemberAbilities() {
        return memberAbilities != null && !(memberAbilities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The abilities granted to the collaboration member.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMemberAbilities} method.
     * </p>
     * 
     * @return The abilities granted to the collaboration member.
     */
    public final List<String> memberAbilitiesAsStrings() {
        return memberAbilities;
    }

    /**
     * <p>
     * The ML abilities granted to the collaboration member.
     * </p>
     * <p>
     * Custom ML modeling is in beta release and is subject to change. For beta terms and conditions, see <i>Betas and
     * Previews</i> in the <a href="https://aws.amazon.com/service-terms/">Amazon Web Services Service Terms</a>.
     * </p>
     * 
     * @return The ML abilities granted to the collaboration member.</p>
     *         <p>
     *         Custom ML modeling is in beta release and is subject to change. For beta terms and conditions, see
     *         <i>Betas and Previews</i> in the <a href="https://aws.amazon.com/service-terms/">Amazon Web Services
     *         Service Terms</a>.
     */
    public final MLMemberAbilities mlMemberAbilities() {
        return mlMemberAbilities;
    }

    /**
     * <p>
     * The member's display name.
     * </p>
     * 
     * @return The member's display name.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The collaboration member's payment responsibilities set by the collaboration creator.
     * </p>
     * <p>
     * If the collaboration creator hasn't speciﬁed anyone as the member paying for query compute costs, then the member
     * who can query is the default payer.
     * </p>
     * 
     * @return The collaboration member's payment responsibilities set by the collaboration creator. </p>
     *         <p>
     *         If the collaboration creator hasn't speciﬁed anyone as the member paying for query compute costs, then
     *         the member who can query is the default payer.
     */
    public final PaymentConfiguration paymentConfiguration() {
        return paymentConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(hasMemberAbilities() ? memberAbilitiesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(mlMemberAbilities());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(paymentConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MemberSpecification)) {
            return false;
        }
        MemberSpecification other = (MemberSpecification) obj;
        return Objects.equals(accountId(), other.accountId()) && hasMemberAbilities() == other.hasMemberAbilities()
                && Objects.equals(memberAbilitiesAsStrings(), other.memberAbilitiesAsStrings())
                && Objects.equals(mlMemberAbilities(), other.mlMemberAbilities())
                && Objects.equals(displayName(), other.displayName())
                && Objects.equals(paymentConfiguration(), other.paymentConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MemberSpecification").add("AccountId", accountId())
                .add("MemberAbilities", hasMemberAbilities() ? memberAbilitiesAsStrings() : null)
                .add("MlMemberAbilities", mlMemberAbilities()).add("DisplayName", displayName())
                .add("PaymentConfiguration", paymentConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "memberAbilities":
            return Optional.ofNullable(clazz.cast(memberAbilitiesAsStrings()));
        case "mlMemberAbilities":
            return Optional.ofNullable(clazz.cast(mlMemberAbilities()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "paymentConfiguration":
            return Optional.ofNullable(clazz.cast(paymentConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("accountId", ACCOUNT_ID_FIELD);
        map.put("memberAbilities", MEMBER_ABILITIES_FIELD);
        map.put("mlMemberAbilities", ML_MEMBER_ABILITIES_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("paymentConfiguration", PAYMENT_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MemberSpecification, T> g) {
        return obj -> g.apply((MemberSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MemberSpecification> {
        /**
         * <p>
         * The identifier used to reference members of the collaboration. Currently only supports Amazon Web Services
         * account ID.
         * </p>
         * 
         * @param accountId
         *        The identifier used to reference members of the collaboration. Currently only supports Amazon Web
         *        Services account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The abilities granted to the collaboration member.
         * </p>
         * 
         * @param memberAbilities
         *        The abilities granted to the collaboration member.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberAbilitiesWithStrings(Collection<String> memberAbilities);

        /**
         * <p>
         * The abilities granted to the collaboration member.
         * </p>
         * 
         * @param memberAbilities
         *        The abilities granted to the collaboration member.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberAbilitiesWithStrings(String... memberAbilities);

        /**
         * <p>
         * The abilities granted to the collaboration member.
         * </p>
         * 
         * @param memberAbilities
         *        The abilities granted to the collaboration member.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberAbilities(Collection<MemberAbility> memberAbilities);

        /**
         * <p>
         * The abilities granted to the collaboration member.
         * </p>
         * 
         * @param memberAbilities
         *        The abilities granted to the collaboration member.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberAbilities(MemberAbility... memberAbilities);

        /**
         * <p>
         * The ML abilities granted to the collaboration member.
         * </p>
         * <p>
         * Custom ML modeling is in beta release and is subject to change. For beta terms and conditions, see <i>Betas
         * and Previews</i> in the <a href="https://aws.amazon.com/service-terms/">Amazon Web Services Service
         * Terms</a>.
         * </p>
         * 
         * @param mlMemberAbilities
         *        The ML abilities granted to the collaboration member.</p>
         *        <p>
         *        Custom ML modeling is in beta release and is subject to change. For beta terms and conditions, see
         *        <i>Betas and Previews</i> in the <a href="https://aws.amazon.com/service-terms/">Amazon Web Services
         *        Service Terms</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mlMemberAbilities(MLMemberAbilities mlMemberAbilities);

        /**
         * <p>
         * The ML abilities granted to the collaboration member.
         * </p>
         * <p>
         * Custom ML modeling is in beta release and is subject to change. For beta terms and conditions, see <i>Betas
         * and Previews</i> in the <a href="https://aws.amazon.com/service-terms/">Amazon Web Services Service
         * Terms</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link MLMemberAbilities.Builder} avoiding the
         * need to create one manually via {@link MLMemberAbilities#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MLMemberAbilities.Builder#build()} is called immediately and its
         * result is passed to {@link #mlMemberAbilities(MLMemberAbilities)}.
         * 
         * @param mlMemberAbilities
         *        a consumer that will call methods on {@link MLMemberAbilities.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mlMemberAbilities(MLMemberAbilities)
         */
        default Builder mlMemberAbilities(Consumer<MLMemberAbilities.Builder> mlMemberAbilities) {
            return mlMemberAbilities(MLMemberAbilities.builder().applyMutation(mlMemberAbilities).build());
        }

        /**
         * <p>
         * The member's display name.
         * </p>
         * 
         * @param displayName
         *        The member's display name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The collaboration member's payment responsibilities set by the collaboration creator.
         * </p>
         * <p>
         * If the collaboration creator hasn't speciﬁed anyone as the member paying for query compute costs, then the
         * member who can query is the default payer.
         * </p>
         * 
         * @param paymentConfiguration
         *        The collaboration member's payment responsibilities set by the collaboration creator. </p>
         *        <p>
         *        If the collaboration creator hasn't speciﬁed anyone as the member paying for query compute costs, then
         *        the member who can query is the default payer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder paymentConfiguration(PaymentConfiguration paymentConfiguration);

        /**
         * <p>
         * The collaboration member's payment responsibilities set by the collaboration creator.
         * </p>
         * <p>
         * If the collaboration creator hasn't speciﬁed anyone as the member paying for query compute costs, then the
         * member who can query is the default payer.
         * </p>
         * This is a convenience method that creates an instance of the {@link PaymentConfiguration.Builder} avoiding
         * the need to create one manually via {@link PaymentConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PaymentConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #paymentConfiguration(PaymentConfiguration)}.
         * 
         * @param paymentConfiguration
         *        a consumer that will call methods on {@link PaymentConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #paymentConfiguration(PaymentConfiguration)
         */
        default Builder paymentConfiguration(Consumer<PaymentConfiguration.Builder> paymentConfiguration) {
            return paymentConfiguration(PaymentConfiguration.builder().applyMutation(paymentConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String accountId;

        private List<String> memberAbilities = DefaultSdkAutoConstructList.getInstance();

        private MLMemberAbilities mlMemberAbilities;

        private String displayName;

        private PaymentConfiguration paymentConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(MemberSpecification model) {
            accountId(model.accountId);
            memberAbilitiesWithStrings(model.memberAbilities);
            mlMemberAbilities(model.mlMemberAbilities);
            displayName(model.displayName);
            paymentConfiguration(model.paymentConfiguration);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final Collection<String> getMemberAbilities() {
            if (memberAbilities instanceof SdkAutoConstructList) {
                return null;
            }
            return memberAbilities;
        }

        public final void setMemberAbilities(Collection<String> memberAbilities) {
            this.memberAbilities = MemberAbilitiesCopier.copy(memberAbilities);
        }

        @Override
        public final Builder memberAbilitiesWithStrings(Collection<String> memberAbilities) {
            this.memberAbilities = MemberAbilitiesCopier.copy(memberAbilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder memberAbilitiesWithStrings(String... memberAbilities) {
            memberAbilitiesWithStrings(Arrays.asList(memberAbilities));
            return this;
        }

        @Override
        public final Builder memberAbilities(Collection<MemberAbility> memberAbilities) {
            this.memberAbilities = MemberAbilitiesCopier.copyEnumToString(memberAbilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder memberAbilities(MemberAbility... memberAbilities) {
            memberAbilities(Arrays.asList(memberAbilities));
            return this;
        }

        public final MLMemberAbilities.Builder getMlMemberAbilities() {
            return mlMemberAbilities != null ? mlMemberAbilities.toBuilder() : null;
        }

        public final void setMlMemberAbilities(MLMemberAbilities.BuilderImpl mlMemberAbilities) {
            this.mlMemberAbilities = mlMemberAbilities != null ? mlMemberAbilities.build() : null;
        }

        @Override
        public final Builder mlMemberAbilities(MLMemberAbilities mlMemberAbilities) {
            this.mlMemberAbilities = mlMemberAbilities;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final PaymentConfiguration.Builder getPaymentConfiguration() {
            return paymentConfiguration != null ? paymentConfiguration.toBuilder() : null;
        }

        public final void setPaymentConfiguration(PaymentConfiguration.BuilderImpl paymentConfiguration) {
            this.paymentConfiguration = paymentConfiguration != null ? paymentConfiguration.build() : null;
        }

        @Override
        public final Builder paymentConfiguration(PaymentConfiguration paymentConfiguration) {
            this.paymentConfiguration = paymentConfiguration;
            return this;
        }

        @Override
        public MemberSpecification build() {
            return new MemberSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
