/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains configurations for protected query results.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MembershipProtectedQueryResultConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<MembershipProtectedQueryResultConfiguration.Builder, MembershipProtectedQueryResultConfiguration> {
    private static final SdkField<MembershipProtectedQueryOutputConfiguration> OUTPUT_CONFIGURATION_FIELD = SdkField
            .<MembershipProtectedQueryOutputConfiguration> builder(MarshallingType.SDK_POJO).memberName("outputConfiguration")
            .getter(getter(MembershipProtectedQueryResultConfiguration::outputConfiguration))
            .setter(setter(Builder::outputConfiguration)).constructor(MembershipProtectedQueryOutputConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputConfiguration").build())
            .build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(MembershipProtectedQueryResultConfiguration::roleArn))
            .setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPUT_CONFIGURATION_FIELD,
            ROLE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final MembershipProtectedQueryOutputConfiguration outputConfiguration;

    private final String roleArn;

    private MembershipProtectedQueryResultConfiguration(BuilderImpl builder) {
        this.outputConfiguration = builder.outputConfiguration;
        this.roleArn = builder.roleArn;
    }

    /**
     * <p>
     * Configuration for protected query results.
     * </p>
     * 
     * @return Configuration for protected query results.
     */
    public final MembershipProtectedQueryOutputConfiguration outputConfiguration() {
        return outputConfiguration;
    }

    /**
     * <p>
     * The unique ARN for an IAM role that is used by Clean Rooms to write protected query results to the result
     * location, given by the member who can receive results.
     * </p>
     * 
     * @return The unique ARN for an IAM role that is used by Clean Rooms to write protected query results to the result
     *         location, given by the member who can receive results.
     */
    public final String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(outputConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MembershipProtectedQueryResultConfiguration)) {
            return false;
        }
        MembershipProtectedQueryResultConfiguration other = (MembershipProtectedQueryResultConfiguration) obj;
        return Objects.equals(outputConfiguration(), other.outputConfiguration()) && Objects.equals(roleArn(), other.roleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MembershipProtectedQueryResultConfiguration").add("OutputConfiguration", outputConfiguration())
                .add("RoleArn", roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "outputConfiguration":
            return Optional.ofNullable(clazz.cast(outputConfiguration()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("outputConfiguration", OUTPUT_CONFIGURATION_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MembershipProtectedQueryResultConfiguration, T> g) {
        return obj -> g.apply((MembershipProtectedQueryResultConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MembershipProtectedQueryResultConfiguration> {
        /**
         * <p>
         * Configuration for protected query results.
         * </p>
         * 
         * @param outputConfiguration
         *        Configuration for protected query results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputConfiguration(MembershipProtectedQueryOutputConfiguration outputConfiguration);

        /**
         * <p>
         * Configuration for protected query results.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link MembershipProtectedQueryOutputConfiguration.Builder} avoiding the need to create one manually via
         * {@link MembershipProtectedQueryOutputConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MembershipProtectedQueryOutputConfiguration.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #outputConfiguration(MembershipProtectedQueryOutputConfiguration)}.
         * 
         * @param outputConfiguration
         *        a consumer that will call methods on {@link MembershipProtectedQueryOutputConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputConfiguration(MembershipProtectedQueryOutputConfiguration)
         */
        default Builder outputConfiguration(Consumer<MembershipProtectedQueryOutputConfiguration.Builder> outputConfiguration) {
            return outputConfiguration(MembershipProtectedQueryOutputConfiguration.builder().applyMutation(outputConfiguration)
                    .build());
        }

        /**
         * <p>
         * The unique ARN for an IAM role that is used by Clean Rooms to write protected query results to the result
         * location, given by the member who can receive results.
         * </p>
         * 
         * @param roleArn
         *        The unique ARN for an IAM role that is used by Clean Rooms to write protected query results to the
         *        result location, given by the member who can receive results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);
    }

    static final class BuilderImpl implements Builder {
        private MembershipProtectedQueryOutputConfiguration outputConfiguration;

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(MembershipProtectedQueryResultConfiguration model) {
            outputConfiguration(model.outputConfiguration);
            roleArn(model.roleArn);
        }

        public final MembershipProtectedQueryOutputConfiguration.Builder getOutputConfiguration() {
            return outputConfiguration != null ? outputConfiguration.toBuilder() : null;
        }

        public final void setOutputConfiguration(MembershipProtectedQueryOutputConfiguration.BuilderImpl outputConfiguration) {
            this.outputConfiguration = outputConfiguration != null ? outputConfiguration.build() : null;
        }

        @Override
        public final Builder outputConfiguration(MembershipProtectedQueryOutputConfiguration outputConfiguration) {
            this.outputConfiguration = outputConfiguration;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Override
        public MembershipProtectedQueryResultConfiguration build() {
            return new MembershipProtectedQueryResultConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
