/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An array that summaries the specified privacy budget. This summary includes collaboration information, creation
 * information, membership information, and privacy budget information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PrivacyBudgetSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<PrivacyBudgetSummary.Builder, PrivacyBudgetSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(PrivacyBudgetSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> PRIVACY_BUDGET_TEMPLATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("privacyBudgetTemplateId").getter(getter(PrivacyBudgetSummary::privacyBudgetTemplateId))
            .setter(setter(Builder::privacyBudgetTemplateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("privacyBudgetTemplateId").build())
            .build();

    private static final SdkField<String> PRIVACY_BUDGET_TEMPLATE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("privacyBudgetTemplateArn").getter(getter(PrivacyBudgetSummary::privacyBudgetTemplateArn))
            .setter(setter(Builder::privacyBudgetTemplateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("privacyBudgetTemplateArn").build())
            .build();

    private static final SdkField<String> MEMBERSHIP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("membershipId").getter(getter(PrivacyBudgetSummary::membershipId)).setter(setter(Builder::membershipId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipId").build()).build();

    private static final SdkField<String> MEMBERSHIP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("membershipArn").getter(getter(PrivacyBudgetSummary::membershipArn))
            .setter(setter(Builder::membershipArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipArn").build()).build();

    private static final SdkField<String> COLLABORATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("collaborationId").getter(getter(PrivacyBudgetSummary::collaborationId))
            .setter(setter(Builder::collaborationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationId").build()).build();

    private static final SdkField<String> COLLABORATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("collaborationArn").getter(getter(PrivacyBudgetSummary::collaborationArn))
            .setter(setter(Builder::collaborationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationArn").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(PrivacyBudgetSummary::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createTime").getter(getter(PrivacyBudgetSummary::createTime)).setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build()).build();

    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updateTime").getter(getter(PrivacyBudgetSummary::updateTime)).setter(setter(Builder::updateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build()).build();

    private static final SdkField<PrivacyBudget> BUDGET_FIELD = SdkField.<PrivacyBudget> builder(MarshallingType.SDK_POJO)
            .memberName("budget").getter(getter(PrivacyBudgetSummary::budget)).setter(setter(Builder::budget))
            .constructor(PrivacyBudget::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("budget").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD,
            PRIVACY_BUDGET_TEMPLATE_ID_FIELD, PRIVACY_BUDGET_TEMPLATE_ARN_FIELD, MEMBERSHIP_ID_FIELD, MEMBERSHIP_ARN_FIELD,
            COLLABORATION_ID_FIELD, COLLABORATION_ARN_FIELD, TYPE_FIELD, CREATE_TIME_FIELD, UPDATE_TIME_FIELD, BUDGET_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String privacyBudgetTemplateId;

    private final String privacyBudgetTemplateArn;

    private final String membershipId;

    private final String membershipArn;

    private final String collaborationId;

    private final String collaborationArn;

    private final String type;

    private final Instant createTime;

    private final Instant updateTime;

    private final PrivacyBudget budget;

    private PrivacyBudgetSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.privacyBudgetTemplateId = builder.privacyBudgetTemplateId;
        this.privacyBudgetTemplateArn = builder.privacyBudgetTemplateArn;
        this.membershipId = builder.membershipId;
        this.membershipArn = builder.membershipArn;
        this.collaborationId = builder.collaborationId;
        this.collaborationArn = builder.collaborationArn;
        this.type = builder.type;
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
        this.budget = builder.budget;
    }

    /**
     * <p>
     * The unique identifier of the privacy budget.
     * </p>
     * 
     * @return The unique identifier of the privacy budget.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The unique identifier of the privacy budget template.
     * </p>
     * 
     * @return The unique identifier of the privacy budget template.
     */
    public final String privacyBudgetTemplateId() {
        return privacyBudgetTemplateId;
    }

    /**
     * <p>
     * The ARN of the privacy budget template.
     * </p>
     * 
     * @return The ARN of the privacy budget template.
     */
    public final String privacyBudgetTemplateArn() {
        return privacyBudgetTemplateArn;
    }

    /**
     * <p>
     * The identifier for a membership resource.
     * </p>
     * 
     * @return The identifier for a membership resource.
     */
    public final String membershipId() {
        return membershipId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the member who created the privacy budget summary.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the member who created the privacy budget summary.
     */
    public final String membershipArn() {
        return membershipArn;
    }

    /**
     * <p>
     * The unique identifier of the collaboration that contains this privacy budget.
     * </p>
     * 
     * @return The unique identifier of the collaboration that contains this privacy budget.
     */
    public final String collaborationId() {
        return collaborationId;
    }

    /**
     * <p>
     * The ARN of the collaboration that contains this privacy budget.
     * </p>
     * 
     * @return The ARN of the collaboration that contains this privacy budget.
     */
    public final String collaborationArn() {
        return collaborationArn;
    }

    /**
     * <p>
     * Specifies the type of the privacy budget.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link PrivacyBudgetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Specifies the type of the privacy budget.
     * @see PrivacyBudgetType
     */
    public final PrivacyBudgetType type() {
        return PrivacyBudgetType.fromValue(type);
    }

    /**
     * <p>
     * Specifies the type of the privacy budget.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link PrivacyBudgetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Specifies the type of the privacy budget.
     * @see PrivacyBudgetType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The time at which the privacy budget was created.
     * </p>
     * 
     * @return The time at which the privacy budget was created.
     */
    public final Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * The most recent time at which the privacy budget was updated.
     * </p>
     * 
     * @return The most recent time at which the privacy budget was updated.
     */
    public final Instant updateTime() {
        return updateTime;
    }

    /**
     * <p>
     * The provided privacy budget.
     * </p>
     * 
     * @return The provided privacy budget.
     */
    public final PrivacyBudget budget() {
        return budget;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(privacyBudgetTemplateId());
        hashCode = 31 * hashCode + Objects.hashCode(privacyBudgetTemplateArn());
        hashCode = 31 * hashCode + Objects.hashCode(membershipId());
        hashCode = 31 * hashCode + Objects.hashCode(membershipArn());
        hashCode = 31 * hashCode + Objects.hashCode(collaborationId());
        hashCode = 31 * hashCode + Objects.hashCode(collaborationArn());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(budget());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PrivacyBudgetSummary)) {
            return false;
        }
        PrivacyBudgetSummary other = (PrivacyBudgetSummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(privacyBudgetTemplateId(), other.privacyBudgetTemplateId())
                && Objects.equals(privacyBudgetTemplateArn(), other.privacyBudgetTemplateArn())
                && Objects.equals(membershipId(), other.membershipId()) && Objects.equals(membershipArn(), other.membershipArn())
                && Objects.equals(collaborationId(), other.collaborationId())
                && Objects.equals(collaborationArn(), other.collaborationArn())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(createTime(), other.createTime())
                && Objects.equals(updateTime(), other.updateTime()) && Objects.equals(budget(), other.budget());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PrivacyBudgetSummary").add("Id", id()).add("PrivacyBudgetTemplateId", privacyBudgetTemplateId())
                .add("PrivacyBudgetTemplateArn", privacyBudgetTemplateArn()).add("MembershipId", membershipId())
                .add("MembershipArn", membershipArn()).add("CollaborationId", collaborationId())
                .add("CollaborationArn", collaborationArn()).add("Type", typeAsString()).add("CreateTime", createTime())
                .add("UpdateTime", updateTime()).add("Budget", budget()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "privacyBudgetTemplateId":
            return Optional.ofNullable(clazz.cast(privacyBudgetTemplateId()));
        case "privacyBudgetTemplateArn":
            return Optional.ofNullable(clazz.cast(privacyBudgetTemplateArn()));
        case "membershipId":
            return Optional.ofNullable(clazz.cast(membershipId()));
        case "membershipArn":
            return Optional.ofNullable(clazz.cast(membershipArn()));
        case "collaborationId":
            return Optional.ofNullable(clazz.cast(collaborationId()));
        case "collaborationArn":
            return Optional.ofNullable(clazz.cast(collaborationArn()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "createTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "updateTime":
            return Optional.ofNullable(clazz.cast(updateTime()));
        case "budget":
            return Optional.ofNullable(clazz.cast(budget()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("privacyBudgetTemplateId", PRIVACY_BUDGET_TEMPLATE_ID_FIELD);
        map.put("privacyBudgetTemplateArn", PRIVACY_BUDGET_TEMPLATE_ARN_FIELD);
        map.put("membershipId", MEMBERSHIP_ID_FIELD);
        map.put("membershipArn", MEMBERSHIP_ARN_FIELD);
        map.put("collaborationId", COLLABORATION_ID_FIELD);
        map.put("collaborationArn", COLLABORATION_ARN_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("createTime", CREATE_TIME_FIELD);
        map.put("updateTime", UPDATE_TIME_FIELD);
        map.put("budget", BUDGET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PrivacyBudgetSummary, T> g) {
        return obj -> g.apply((PrivacyBudgetSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PrivacyBudgetSummary> {
        /**
         * <p>
         * The unique identifier of the privacy budget.
         * </p>
         * 
         * @param id
         *        The unique identifier of the privacy budget.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The unique identifier of the privacy budget template.
         * </p>
         * 
         * @param privacyBudgetTemplateId
         *        The unique identifier of the privacy budget template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privacyBudgetTemplateId(String privacyBudgetTemplateId);

        /**
         * <p>
         * The ARN of the privacy budget template.
         * </p>
         * 
         * @param privacyBudgetTemplateArn
         *        The ARN of the privacy budget template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privacyBudgetTemplateArn(String privacyBudgetTemplateArn);

        /**
         * <p>
         * The identifier for a membership resource.
         * </p>
         * 
         * @param membershipId
         *        The identifier for a membership resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder membershipId(String membershipId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the member who created the privacy budget summary.
         * </p>
         * 
         * @param membershipArn
         *        The Amazon Resource Name (ARN) of the member who created the privacy budget summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder membershipArn(String membershipArn);

        /**
         * <p>
         * The unique identifier of the collaboration that contains this privacy budget.
         * </p>
         * 
         * @param collaborationId
         *        The unique identifier of the collaboration that contains this privacy budget.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaborationId(String collaborationId);

        /**
         * <p>
         * The ARN of the collaboration that contains this privacy budget.
         * </p>
         * 
         * @param collaborationArn
         *        The ARN of the collaboration that contains this privacy budget.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaborationArn(String collaborationArn);

        /**
         * <p>
         * Specifies the type of the privacy budget.
         * </p>
         * 
         * @param type
         *        Specifies the type of the privacy budget.
         * @see PrivacyBudgetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PrivacyBudgetType
         */
        Builder type(String type);

        /**
         * <p>
         * Specifies the type of the privacy budget.
         * </p>
         * 
         * @param type
         *        Specifies the type of the privacy budget.
         * @see PrivacyBudgetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PrivacyBudgetType
         */
        Builder type(PrivacyBudgetType type);

        /**
         * <p>
         * The time at which the privacy budget was created.
         * </p>
         * 
         * @param createTime
         *        The time at which the privacy budget was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * The most recent time at which the privacy budget was updated.
         * </p>
         * 
         * @param updateTime
         *        The most recent time at which the privacy budget was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTime(Instant updateTime);

        /**
         * <p>
         * The provided privacy budget.
         * </p>
         * 
         * @param budget
         *        The provided privacy budget.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder budget(PrivacyBudget budget);

        /**
         * <p>
         * The provided privacy budget.
         * </p>
         * This is a convenience method that creates an instance of the {@link PrivacyBudget.Builder} avoiding the need
         * to create one manually via {@link PrivacyBudget#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PrivacyBudget.Builder#build()} is called immediately and its
         * result is passed to {@link #budget(PrivacyBudget)}.
         * 
         * @param budget
         *        a consumer that will call methods on {@link PrivacyBudget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #budget(PrivacyBudget)
         */
        default Builder budget(Consumer<PrivacyBudget.Builder> budget) {
            return budget(PrivacyBudget.builder().applyMutation(budget).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String privacyBudgetTemplateId;

        private String privacyBudgetTemplateArn;

        private String membershipId;

        private String membershipArn;

        private String collaborationId;

        private String collaborationArn;

        private String type;

        private Instant createTime;

        private Instant updateTime;

        private PrivacyBudget budget;

        private BuilderImpl() {
        }

        private BuilderImpl(PrivacyBudgetSummary model) {
            id(model.id);
            privacyBudgetTemplateId(model.privacyBudgetTemplateId);
            privacyBudgetTemplateArn(model.privacyBudgetTemplateArn);
            membershipId(model.membershipId);
            membershipArn(model.membershipArn);
            collaborationId(model.collaborationId);
            collaborationArn(model.collaborationArn);
            type(model.type);
            createTime(model.createTime);
            updateTime(model.updateTime);
            budget(model.budget);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getPrivacyBudgetTemplateId() {
            return privacyBudgetTemplateId;
        }

        public final void setPrivacyBudgetTemplateId(String privacyBudgetTemplateId) {
            this.privacyBudgetTemplateId = privacyBudgetTemplateId;
        }

        @Override
        public final Builder privacyBudgetTemplateId(String privacyBudgetTemplateId) {
            this.privacyBudgetTemplateId = privacyBudgetTemplateId;
            return this;
        }

        public final String getPrivacyBudgetTemplateArn() {
            return privacyBudgetTemplateArn;
        }

        public final void setPrivacyBudgetTemplateArn(String privacyBudgetTemplateArn) {
            this.privacyBudgetTemplateArn = privacyBudgetTemplateArn;
        }

        @Override
        public final Builder privacyBudgetTemplateArn(String privacyBudgetTemplateArn) {
            this.privacyBudgetTemplateArn = privacyBudgetTemplateArn;
            return this;
        }

        public final String getMembershipId() {
            return membershipId;
        }

        public final void setMembershipId(String membershipId) {
            this.membershipId = membershipId;
        }

        @Override
        public final Builder membershipId(String membershipId) {
            this.membershipId = membershipId;
            return this;
        }

        public final String getMembershipArn() {
            return membershipArn;
        }

        public final void setMembershipArn(String membershipArn) {
            this.membershipArn = membershipArn;
        }

        @Override
        public final Builder membershipArn(String membershipArn) {
            this.membershipArn = membershipArn;
            return this;
        }

        public final String getCollaborationId() {
            return collaborationId;
        }

        public final void setCollaborationId(String collaborationId) {
            this.collaborationId = collaborationId;
        }

        @Override
        public final Builder collaborationId(String collaborationId) {
            this.collaborationId = collaborationId;
            return this;
        }

        public final String getCollaborationArn() {
            return collaborationArn;
        }

        public final void setCollaborationArn(String collaborationArn) {
            this.collaborationArn = collaborationArn;
        }

        @Override
        public final Builder collaborationArn(String collaborationArn) {
            this.collaborationArn = collaborationArn;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(PrivacyBudgetType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final PrivacyBudget.Builder getBudget() {
            return budget != null ? budget.toBuilder() : null;
        }

        public final void setBudget(PrivacyBudget.BuilderImpl budget) {
            this.budget = budget != null ? budget.build() : null;
        }

        @Override
        public final Builder budget(PrivacyBudget budget) {
            this.budget = budget;
            return this;
        }

        @Override
        public PrivacyBudgetSummary build() {
            return new PrivacyBudgetSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
