/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The receiver configuration for a protected query.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReceiverConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ReceiverConfiguration.Builder, ReceiverConfiguration> {
    private static final SdkField<String> ANALYSIS_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("analysisType").getter(getter(ReceiverConfiguration::analysisTypeAsString))
            .setter(setter(Builder::analysisType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("analysisType").build()).build();

    private static final SdkField<ConfigurationDetails> CONFIGURATION_DETAILS_FIELD = SdkField
            .<ConfigurationDetails> builder(MarshallingType.SDK_POJO).memberName("configurationDetails")
            .getter(getter(ReceiverConfiguration::configurationDetails)).setter(setter(Builder::configurationDetails))
            .constructor(ConfigurationDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationDetails").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANALYSIS_TYPE_FIELD,
            CONFIGURATION_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String analysisType;

    private final ConfigurationDetails configurationDetails;

    private ReceiverConfiguration(BuilderImpl builder) {
        this.analysisType = builder.analysisType;
        this.configurationDetails = builder.configurationDetails;
    }

    /**
     * <p>
     * The type of analysis for the protected query. The results of the query can be analyzed directly (
     * <code>DIRECT_ANALYSIS</code>) or used as input into additional analyses (<code>ADDITIONAL_ANALYSIS</code>), such
     * as a query that is a seed for a lookalike ML model.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #analysisType} will
     * return {@link AnalysisType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #analysisTypeAsString}.
     * </p>
     * 
     * @return The type of analysis for the protected query. The results of the query can be analyzed directly (
     *         <code>DIRECT_ANALYSIS</code>) or used as input into additional analyses (<code>ADDITIONAL_ANALYSIS</code>
     *         ), such as a query that is a seed for a lookalike ML model.
     * @see AnalysisType
     */
    public final AnalysisType analysisType() {
        return AnalysisType.fromValue(analysisType);
    }

    /**
     * <p>
     * The type of analysis for the protected query. The results of the query can be analyzed directly (
     * <code>DIRECT_ANALYSIS</code>) or used as input into additional analyses (<code>ADDITIONAL_ANALYSIS</code>), such
     * as a query that is a seed for a lookalike ML model.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #analysisType} will
     * return {@link AnalysisType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #analysisTypeAsString}.
     * </p>
     * 
     * @return The type of analysis for the protected query. The results of the query can be analyzed directly (
     *         <code>DIRECT_ANALYSIS</code>) or used as input into additional analyses (<code>ADDITIONAL_ANALYSIS</code>
     *         ), such as a query that is a seed for a lookalike ML model.
     * @see AnalysisType
     */
    public final String analysisTypeAsString() {
        return analysisType;
    }

    /**
     * <p>
     * The configuration details of the receiver configuration.
     * </p>
     * 
     * @return The configuration details of the receiver configuration.
     */
    public final ConfigurationDetails configurationDetails() {
        return configurationDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(analysisTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(configurationDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReceiverConfiguration)) {
            return false;
        }
        ReceiverConfiguration other = (ReceiverConfiguration) obj;
        return Objects.equals(analysisTypeAsString(), other.analysisTypeAsString())
                && Objects.equals(configurationDetails(), other.configurationDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReceiverConfiguration").add("AnalysisType", analysisTypeAsString())
                .add("ConfigurationDetails", configurationDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "analysisType":
            return Optional.ofNullable(clazz.cast(analysisTypeAsString()));
        case "configurationDetails":
            return Optional.ofNullable(clazz.cast(configurationDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("analysisType", ANALYSIS_TYPE_FIELD);
        map.put("configurationDetails", CONFIGURATION_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReceiverConfiguration, T> g) {
        return obj -> g.apply((ReceiverConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReceiverConfiguration> {
        /**
         * <p>
         * The type of analysis for the protected query. The results of the query can be analyzed directly (
         * <code>DIRECT_ANALYSIS</code>) or used as input into additional analyses (<code>ADDITIONAL_ANALYSIS</code>),
         * such as a query that is a seed for a lookalike ML model.
         * </p>
         * 
         * @param analysisType
         *        The type of analysis for the protected query. The results of the query can be analyzed directly (
         *        <code>DIRECT_ANALYSIS</code>) or used as input into additional analyses (
         *        <code>ADDITIONAL_ANALYSIS</code>), such as a query that is a seed for a lookalike ML model.
         * @see AnalysisType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnalysisType
         */
        Builder analysisType(String analysisType);

        /**
         * <p>
         * The type of analysis for the protected query. The results of the query can be analyzed directly (
         * <code>DIRECT_ANALYSIS</code>) or used as input into additional analyses (<code>ADDITIONAL_ANALYSIS</code>),
         * such as a query that is a seed for a lookalike ML model.
         * </p>
         * 
         * @param analysisType
         *        The type of analysis for the protected query. The results of the query can be analyzed directly (
         *        <code>DIRECT_ANALYSIS</code>) or used as input into additional analyses (
         *        <code>ADDITIONAL_ANALYSIS</code>), such as a query that is a seed for a lookalike ML model.
         * @see AnalysisType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnalysisType
         */
        Builder analysisType(AnalysisType analysisType);

        /**
         * <p>
         * The configuration details of the receiver configuration.
         * </p>
         * 
         * @param configurationDetails
         *        The configuration details of the receiver configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationDetails(ConfigurationDetails configurationDetails);

        /**
         * <p>
         * The configuration details of the receiver configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConfigurationDetails.Builder} avoiding
         * the need to create one manually via {@link ConfigurationDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConfigurationDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #configurationDetails(ConfigurationDetails)}.
         * 
         * @param configurationDetails
         *        a consumer that will call methods on {@link ConfigurationDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configurationDetails(ConfigurationDetails)
         */
        default Builder configurationDetails(Consumer<ConfigurationDetails.Builder> configurationDetails) {
            return configurationDetails(ConfigurationDetails.builder().applyMutation(configurationDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String analysisType;

        private ConfigurationDetails configurationDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(ReceiverConfiguration model) {
            analysisType(model.analysisType);
            configurationDetails(model.configurationDetails);
        }

        public final String getAnalysisType() {
            return analysisType;
        }

        public final void setAnalysisType(String analysisType) {
            this.analysisType = analysisType;
        }

        @Override
        public final Builder analysisType(String analysisType) {
            this.analysisType = analysisType;
            return this;
        }

        @Override
        public final Builder analysisType(AnalysisType analysisType) {
            this.analysisType(analysisType == null ? null : analysisType.toString());
            return this;
        }

        public final ConfigurationDetails.Builder getConfigurationDetails() {
            return configurationDetails != null ? configurationDetails.toBuilder() : null;
        }

        public final void setConfigurationDetails(ConfigurationDetails.BuilderImpl configurationDetails) {
            this.configurationDetails = configurationDetails != null ? configurationDetails.build() : null;
        }

        @Override
        public final Builder configurationDetails(ConfigurationDetails configurationDetails) {
            this.configurationDetails = configurationDetails;
            return this;
        }

        @Override
        public ReceiverConfiguration build() {
            return new ReceiverConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
