/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the schema type properties.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SchemaTypeProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<SchemaTypeProperties.Builder, SchemaTypeProperties> {
    private static final SdkField<IdMappingTableSchemaTypeProperties> ID_MAPPING_TABLE_FIELD = SdkField
            .<IdMappingTableSchemaTypeProperties> builder(MarshallingType.SDK_POJO).memberName("idMappingTable")
            .getter(getter(SchemaTypeProperties::idMappingTable)).setter(setter(Builder::idMappingTable))
            .constructor(IdMappingTableSchemaTypeProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idMappingTable").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_MAPPING_TABLE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final IdMappingTableSchemaTypeProperties idMappingTable;

    private final Type type;

    private SchemaTypeProperties(BuilderImpl builder) {
        this.idMappingTable = builder.idMappingTable;
        this.type = builder.type;
    }

    /**
     * <p>
     * The ID mapping table for the schema type properties.
     * </p>
     * 
     * @return The ID mapping table for the schema type properties.
     */
    public final IdMappingTableSchemaTypeProperties idMappingTable() {
        return idMappingTable;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(idMappingTable());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SchemaTypeProperties)) {
            return false;
        }
        SchemaTypeProperties other = (SchemaTypeProperties) obj;
        return Objects.equals(idMappingTable(), other.idMappingTable());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SchemaTypeProperties").add("IdMappingTable", idMappingTable()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "idMappingTable":
            return Optional.ofNullable(clazz.cast(idMappingTable()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #idMappingTable()} initialized to the given value.
     *
     * <p>
     * The ID mapping table for the schema type properties.
     * </p>
     * 
     * @param idMappingTable
     *        The ID mapping table for the schema type properties.
     */
    public static SchemaTypeProperties fromIdMappingTable(IdMappingTableSchemaTypeProperties idMappingTable) {
        return builder().idMappingTable(idMappingTable).build();
    }

    /**
     * Create an instance of this class with {@link #idMappingTable()} initialized to the given value.
     *
     * <p>
     * The ID mapping table for the schema type properties.
     * </p>
     * 
     * @param idMappingTable
     *        The ID mapping table for the schema type properties.
     */
    public static SchemaTypeProperties fromIdMappingTable(Consumer<IdMappingTableSchemaTypeProperties.Builder> idMappingTable) {
        IdMappingTableSchemaTypeProperties.Builder builder = IdMappingTableSchemaTypeProperties.builder();
        idMappingTable.accept(builder);
        return fromIdMappingTable(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("idMappingTable", ID_MAPPING_TABLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SchemaTypeProperties, T> g) {
        return obj -> g.apply((SchemaTypeProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SchemaTypeProperties> {
        /**
         * <p>
         * The ID mapping table for the schema type properties.
         * </p>
         * 
         * @param idMappingTable
         *        The ID mapping table for the schema type properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idMappingTable(IdMappingTableSchemaTypeProperties idMappingTable);

        /**
         * <p>
         * The ID mapping table for the schema type properties.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link IdMappingTableSchemaTypeProperties.Builder} avoiding the need to create one manually via
         * {@link IdMappingTableSchemaTypeProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IdMappingTableSchemaTypeProperties.Builder#build()} is called
         * immediately and its result is passed to {@link #idMappingTable(IdMappingTableSchemaTypeProperties)}.
         * 
         * @param idMappingTable
         *        a consumer that will call methods on {@link IdMappingTableSchemaTypeProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #idMappingTable(IdMappingTableSchemaTypeProperties)
         */
        default Builder idMappingTable(Consumer<IdMappingTableSchemaTypeProperties.Builder> idMappingTable) {
            return idMappingTable(IdMappingTableSchemaTypeProperties.builder().applyMutation(idMappingTable).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private IdMappingTableSchemaTypeProperties idMappingTable;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(SchemaTypeProperties model) {
            idMappingTable(model.idMappingTable);
        }

        public final IdMappingTableSchemaTypeProperties.Builder getIdMappingTable() {
            return idMappingTable != null ? idMappingTable.toBuilder() : null;
        }

        public final void setIdMappingTable(IdMappingTableSchemaTypeProperties.BuilderImpl idMappingTable) {
            Object oldValue = this.idMappingTable;
            this.idMappingTable = idMappingTable != null ? idMappingTable.build() : null;
            handleUnionValueChange(Type.ID_MAPPING_TABLE, oldValue, this.idMappingTable);
        }

        @Override
        public final Builder idMappingTable(IdMappingTableSchemaTypeProperties idMappingTable) {
            Object oldValue = this.idMappingTable;
            this.idMappingTable = idMappingTable;
            handleUnionValueChange(Type.ID_MAPPING_TABLE, oldValue, this.idMappingTable);
            return this;
        }

        @Override
        public SchemaTypeProperties build() {
            return new SchemaTypeProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see SchemaTypeProperties#type()
     */
    public enum Type {
        ID_MAPPING_TABLE,

        UNKNOWN_TO_SDK_VERSION
    }
}
