/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Snowflake table schema.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SnowflakeTableSchemaV1 implements SdkPojo, Serializable,
        ToCopyableBuilder<SnowflakeTableSchemaV1.Builder, SnowflakeTableSchemaV1> {
    private static final SdkField<String> COLUMN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("columnName").getter(getter(SnowflakeTableSchemaV1::columnName)).setter(setter(Builder::columnName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("columnName").build()).build();

    private static final SdkField<String> COLUMN_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("columnType").getter(getter(SnowflakeTableSchemaV1::columnType)).setter(setter(Builder::columnType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("columnType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMN_NAME_FIELD,
            COLUMN_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String columnName;

    private final String columnType;

    private SnowflakeTableSchemaV1(BuilderImpl builder) {
        this.columnName = builder.columnName;
        this.columnType = builder.columnType;
    }

    /**
     * <p>
     * The column name.
     * </p>
     * 
     * @return The column name.
     */
    public final String columnName() {
        return columnName;
    }

    /**
     * <p>
     * The column's data type. Supported data types: <code>ARRAY</code>, <code>BIGINT</code>, <code>BOOLEAN</code>,
     * <code>CHAR</code>, <code>DATE</code>, <code>DECIMAL</code>, <code>DOUBLE</code>, <code>DOUBLE PRECISION</code>,
     * <code>FLOAT</code>, <code>FLOAT4</code>, <code>INT</code>, <code>INTEGER</code>, <code>MAP</code>,
     * <code>NUMERIC</code>, <code>NUMBER</code>, <code>REAL</code>, <code>SMALLINT</code>, <code>STRING</code>,
     * <code>TIMESTAMP</code>, <code>TIMESTAMP_LTZ</code>, <code>TIMESTAMP_NTZ</code>, <code>DATETIME</code>,
     * <code>TINYINT</code>, <code>VARCHAR</code>, <code>TEXT</code>, <code>CHARACTER</code>.
     * </p>
     * 
     * @return The column's data type. Supported data types: <code>ARRAY</code>, <code>BIGINT</code>,
     *         <code>BOOLEAN</code>, <code>CHAR</code>, <code>DATE</code>, <code>DECIMAL</code>, <code>DOUBLE</code>,
     *         <code>DOUBLE PRECISION</code>, <code>FLOAT</code>, <code>FLOAT4</code>, <code>INT</code>,
     *         <code>INTEGER</code>, <code>MAP</code>, <code>NUMERIC</code>, <code>NUMBER</code>, <code>REAL</code>,
     *         <code>SMALLINT</code>, <code>STRING</code>, <code>TIMESTAMP</code>, <code>TIMESTAMP_LTZ</code>,
     *         <code>TIMESTAMP_NTZ</code>, <code>DATETIME</code>, <code>TINYINT</code>, <code>VARCHAR</code>,
     *         <code>TEXT</code>, <code>CHARACTER</code>.
     */
    public final String columnType() {
        return columnType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(columnName());
        hashCode = 31 * hashCode + Objects.hashCode(columnType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnowflakeTableSchemaV1)) {
            return false;
        }
        SnowflakeTableSchemaV1 other = (SnowflakeTableSchemaV1) obj;
        return Objects.equals(columnName(), other.columnName()) && Objects.equals(columnType(), other.columnType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SnowflakeTableSchemaV1").add("ColumnName", columnName()).add("ColumnType", columnType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "columnName":
            return Optional.ofNullable(clazz.cast(columnName()));
        case "columnType":
            return Optional.ofNullable(clazz.cast(columnType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("columnName", COLUMN_NAME_FIELD);
        map.put("columnType", COLUMN_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SnowflakeTableSchemaV1, T> g) {
        return obj -> g.apply((SnowflakeTableSchemaV1) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SnowflakeTableSchemaV1> {
        /**
         * <p>
         * The column name.
         * </p>
         * 
         * @param columnName
         *        The column name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnName(String columnName);

        /**
         * <p>
         * The column's data type. Supported data types: <code>ARRAY</code>, <code>BIGINT</code>, <code>BOOLEAN</code>,
         * <code>CHAR</code>, <code>DATE</code>, <code>DECIMAL</code>, <code>DOUBLE</code>,
         * <code>DOUBLE PRECISION</code>, <code>FLOAT</code>, <code>FLOAT4</code>, <code>INT</code>,
         * <code>INTEGER</code>, <code>MAP</code>, <code>NUMERIC</code>, <code>NUMBER</code>, <code>REAL</code>,
         * <code>SMALLINT</code>, <code>STRING</code>, <code>TIMESTAMP</code>, <code>TIMESTAMP_LTZ</code>,
         * <code>TIMESTAMP_NTZ</code>, <code>DATETIME</code>, <code>TINYINT</code>, <code>VARCHAR</code>,
         * <code>TEXT</code>, <code>CHARACTER</code>.
         * </p>
         * 
         * @param columnType
         *        The column's data type. Supported data types: <code>ARRAY</code>, <code>BIGINT</code>,
         *        <code>BOOLEAN</code>, <code>CHAR</code>, <code>DATE</code>, <code>DECIMAL</code>, <code>DOUBLE</code>,
         *        <code>DOUBLE PRECISION</code>, <code>FLOAT</code>, <code>FLOAT4</code>, <code>INT</code>,
         *        <code>INTEGER</code>, <code>MAP</code>, <code>NUMERIC</code>, <code>NUMBER</code>, <code>REAL</code>,
         *        <code>SMALLINT</code>, <code>STRING</code>, <code>TIMESTAMP</code>, <code>TIMESTAMP_LTZ</code>,
         *        <code>TIMESTAMP_NTZ</code>, <code>DATETIME</code>, <code>TINYINT</code>, <code>VARCHAR</code>,
         *        <code>TEXT</code>, <code>CHARACTER</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnType(String columnType);
    }

    static final class BuilderImpl implements Builder {
        private String columnName;

        private String columnType;

        private BuilderImpl() {
        }

        private BuilderImpl(SnowflakeTableSchemaV1 model) {
            columnName(model.columnName);
            columnType(model.columnType);
        }

        public final String getColumnName() {
            return columnName;
        }

        public final void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        @Override
        public final Builder columnName(String columnName) {
            this.columnName = columnName;
            return this;
        }

        public final String getColumnType() {
            return columnType;
        }

        public final void setColumnType(String columnType) {
            this.columnType = columnType;
        }

        @Override
        public final Builder columnType(String columnType) {
            this.columnType = columnType;
            return this;
        }

        @Override
        public SnowflakeTableSchemaV1 build() {
            return new SnowflakeTableSchemaV1(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
